//
// Bitmovin Player iOS SDK
// Copyright (C) 2021, Bitmovin GmbH, All Rights Reserved
//
// This source code and its use and distribution, is subject to the terms
// and conditions of the applicable license agreement.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

FOUNDATION_EXPORT NSErrorDomain const BMPBitmovinOfflineErrorDomain NS_SWIFT_NAME(BitmovinOfflineErrorDomain);

/**
 * This enum represents the offline error codes.
 */
typedef NS_ERROR_ENUM(BMPBitmovinOfflineErrorDomain, BMPOfflineErrorCode) {
    /**
     * A general offline related error code when a more specific error code could not be determined.
     *
     * See ``BitmovinPlayerCore/OfflineErrorEvent/message`` for the error message.
     */
    BMPOfflineErrorCodeGeneral = 3001,
    /**
     * There is not enough disk space left to proceed with downloading content.
     *
     * Make sure to check the device's available storage space before starting a download.
     */
    BMPOfflineErrorCodeInsufficientStorage = 3003,
    /**
     * Failed to persist the offline content key for the DRM license.
     *
     * To recover from this error, you can try to renew the persistable offline license via  ``BitmovinPlayerCore/BMPOfflineContentManager/renewOfflineLicense``
     * or re-download the content via  ``BitmovinPlayerCore/BMPOfflineContentManager/download``.
     */
    BMPOfflineErrorCodeFailedPersistingDrmLicense = 3004,
    /**
     * The used ``BitmovinPlayerCore/SourceConfig`` is not supported for download.
     *
     * A ``BitmovinPlayerCore/SourceConfig`` is only valid for download when it's configured using an HLS asset
     * with passing ``BitmovinPlayerCore/SourceType/hls`` to ``BitmovinPlayerCore/SourceConfig/init(url:type:)``.
     */
    BMPOfflineErrorCodeUnsupportedSourceConfig = 3009,
    /**
     * Content URL migration has failed.
     *
     * This error occurs when the content URL migration process fails
     * after calling ``BitmovinPlayerCore/OfflineContentManagerTweaksApi/migrateDownload(remoteAssetUrl:resourceIdentifierCallback:)``.
     *
     * To recover from this error, you can try to re-download the content via ``BitmovinPlayerCore/BMPOfflineContentManager/download`` using the updated asset URL.
     *
     * See ``BitmovinPlayerCore/OfflineErrorEvent/message`` for the error message.
     */
    BMPOfflineErrorCodeContentUrlMigrationFailed = 3010
} NS_SWIFT_NAME(OfflineError);

NS_ASSUME_NONNULL_END
