#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 6.1.2 effective-5.10 (swiftlang-6.1.2.1.2 clang-1700.0.13.5)
#ifndef BITMOVINPLAYERCORE_SWIFT_H
#define BITMOVINPLAYERCORE_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef unsigned char char8_t;
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import AVFoundation;
@import CoreFoundation;
@import CoreMedia;
@import Dispatch;
@import Foundation;
@import ObjectiveC;
@import UIKit;
#endif

#import <BitmovinPlayerCore/BitmovinPlayerCore.h>

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="BitmovinPlayerCore",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)

enum BMPMetadataType : NSInteger;
SWIFT_PROTOCOL_NAMED("MetadataEntry")
@protocol BMPMetadataEntry
@property (nonatomic, readonly) enum BMPMetadataType metadataType;
@end

@interface AVMetadataItem (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPMetadataEntry>
@property (nonatomic, readonly) enum BMPMetadataType metadataType;
@end

@class NSString;
/// Base protocol for all event classes.
SWIFT_PROTOCOL_NAMED("Event")
@protocol BMPEvent <NSObject>
/// Name of the event.
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// Time when the event was emitted.
@property (nonatomic, readonly) NSTimeInterval timestamp;
@end

/// Base class for all <code>PlayerEvent</code> classes.
SWIFT_CLASS_NAMED("PlayerEvent")
@interface BMPPlayerEvent : NSObject <BMPEvent>
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol BMPAdBreak;
/// Base class for ad break related event classes.
SWIFT_CLASS_NAMED("AdBreakEvent")
@interface BMPAdBreakEvent : BMPPlayerEvent
/// Returns the <code>BMPAdBreak</code> this event is related to.
@property (nonatomic, readonly, strong) id <BMPAdBreak> _Nonnull adBreak;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAdBreak:(id <BMPAdBreak> _Nonnull)adBreak OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdBreakFinishedEvent")
@interface BMPAdBreakFinishedEvent : BMPAdBreakEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAdBreak:(id <BMPAdBreak> _Nonnull)adBreak OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdBreakStartedEvent")
@interface BMPAdBreakStartedEvent : BMPAdBreakEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAdBreak:(id <BMPAdBreak> _Nonnull)adBreak OBJC_DESIGNATED_INITIALIZER;
@end

@class NSURL;
/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdClickedEvent")
@interface BMPAdClickedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSURL * _Nullable clickThroughUrl;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithClickThroughUrl:(NSURL * _Nullable)clickThroughUrl OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class BMPAdItem;
@protocol BMPAdConfig;
/// See <code>PlayerListener</code> for more information on this event.
/// <h1>Using BAM</h1>
/// Possible error codes for <code>AdErrorEvent</code> when using ads with <code>AdSourceType/bitmovin</code>
/// <h2>During ad loading and parsing</h2>
/// | Code | Description |
/// | –– | ———– |
/// | 100 | The ad response was not recognized as a valid VAST ad. |
/// | 302 | The maximum number of VAST wrapper redirects has been reached. |
/// | 400 | There was an error playing the video ad. |
/// <h2>During ad playback</h2>
/// See <code>PlayerErrorEvent</code> and <code>SourceErrorEvent</code> for more information on possible error codes.
/// All other error codes are provided by OS frameworks such as <code>CoreMedia</code>, <code>AVFoundation</code>, <code>CFNetworking</code> etc.
/// These error codes can be negative values and many of them are not documented by Apple.
/// <h1>Using IMA</h1>
/// Possible error codes for <code>AdErrorEvent</code> when using ads with <code>AdSourceType/ima</code>:
/// See <a href="https://developers.google.com/interactive-media-ads/docs/sdks/ios/client-side/reference/Enums/IMAErrorCode">IMA SDK Error Codes</a>
SWIFT_CLASS_NAMED("AdErrorEvent")
@interface BMPAdErrorEvent : BMPPlayerEvent
/// The related <code>AdItem</code>, if available.
@property (nonatomic, readonly, strong) BMPAdItem * _Nullable adItem;
/// The error code.
@property (nonatomic, readonly) NSInteger code SWIFT_DEPRECATED_MSG("Use the `errorCode` property instead.", "errorCode");
/// The raw error code represented as Integer. See documentation of <code>AdErrorEvent</code> for possible error codes.
@property (nonatomic, readonly) NSInteger errorCode;
/// Message associated with the error event.
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
/// The AdConfig of the related ad.
@property (nonatomic, readonly, strong) id <BMPAdConfig> _Nullable adConfig;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAdItem:(BMPAdItem * _Nullable)adItem code:(NSInteger)code message:(NSString * _Nonnull)message adConfig:(id <BMPAdConfig> _Nullable)adConfig SWIFT_DEPRECATED_MSG("Use the `init(adItem:errorCode:message:adConfig:)` instead.", "initWithAdItem:errorCode:message:adConfig:");
- (nonnull instancetype)initWithAdItem:(BMPAdItem * _Nullable)adItem errorCode:(NSInteger)errorCode message:(NSString * _Nonnull)message adConfig:(id <BMPAdConfig> _Nullable)adConfig OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol BMPAd;
/// Base class for ad related event classes.
SWIFT_CLASS_NAMED("AdEvent")
@interface BMPAdEvent : BMPPlayerEvent
/// The <code>BMPAd</code> this event is related to.
@property (nonatomic, readonly, strong) id <BMPAd> _Nonnull ad;
- (nonnull instancetype)initWithAd:(id <BMPAd> _Nonnull)ad OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdFinishedEvent")
@interface BMPAdFinishedEvent : BMPAdEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAd:(id <BMPAd> _Nonnull)ad OBJC_DESIGNATED_INITIALIZER;
@end

@class BMPAdSource;
@class BMPLinearAdUiConfig;
/// Represents an ad break which can be scheduled for playback.
SWIFT_CLASS_NAMED("AdItem")
@interface BMPAdItem : NSObject
/// The <code>AdSource</code>s that make up this <code>AdItem</code>. The first ad source in this array is used as the main ad.
/// Subsequent ad sources act as a fallback, meaning that if the main ad source does not provide a valid response,
/// the subsequent ad sources will be utilized one after another.
@property (nonatomic, readonly, copy) NSArray<BMPAdSource *> * _Nonnull sources;
/// The playback position at which the ad break is scheduled to start. Will play as a pre-roll ad when set to <code>nil</code>.
@property (nonatomic, readonly, copy) NSString * _Nullable position;
/// Provides customisation options when the advertising UI when Bitmovin Player UI is used.
@property (nonatomic, readonly, strong) BMPLinearAdUiConfig * _Nonnull linearAdUiConfig;
/// Creates a new <code>AdItem</code> with an array of <code>AdSource</code>s as pre-roll ads.
/// \param sources The <code>AdSource</code>s that make up this <code>AdItem</code>.
/// The first ad source in this array is used as the main ad.
/// Subsequent ad sources act as a fallback, meaning that if the main ad source does not provide a valid response,
/// the subsequent ad sources will be utilized one after another.
///
- (nonnull instancetype)initWithAdSources:(NSArray<BMPAdSource *> * _Nonnull)sources;
/// Creates a new <code>AdItem</code> with an array of <code>AdSource</code>s scheduled for the given position.
/// \param sources The <code>AdSource</code>s that make up this <code>AdItem</code>.
/// The first ad source in this array is used as the main ad.
/// Subsequent ad sources act as a fallback, meaning that if the main ad source does not provide
/// a valid response,
/// the subsequent ad sources will be utilized one after another.
///
/// \param position The playback position at which the ad break is scheduled to start.
/// Will play as a pre-roll ad when set to <code>nil</code>.
/// Value of position can be:
/// <ul>
///   <li>
///     <code>"pre"</code>: pre-roll ad, played before the main content starts
///   </li>
///   <li>
///     <code>"X%"</code>: mid-roll ad, played when reaching the X% of the main content duration, e.g. <code>"15%"</code>
///   </li>
///   <li>
///     <code>"post"</code>: post-roll ad, played after the main content has finished
///   </li>
/// </ul>
///
- (nonnull instancetype)initWithAdSources:(NSArray<BMPAdSource *> * _Nonnull)sources atPosition:(NSString * _Nullable)position;
/// Creates a new <code>AdItem</code> with an array of <code>AdSource</code>s scheduled for the given position.
/// \param sources The <code>AdSource</code>s that make up this <code>AdItem</code>.
/// The first ad source in this array is used as the main ad.
/// Subsequent ad sources act as a fallback, meaning that if the main ad source does not provide
/// a valid response,
/// the subsequent ad sources will be utilized one after another.
///
/// \param position The playback position at which the ad break is scheduled to start.
/// Will play as a pre-roll ad when set to <code>nil</code>.
/// Value of position can be:
/// <ul>
///   <li>
///     <code>"pre"</code>: pre-roll ad, played before the main content starts
///   </li>
///   <li>
///     <code>"X%"</code>: mid-roll ad, played when reaching the X% of the main content duration, e.g. <code>"15%"</code>
///   </li>
///   <li>
///     <code>"post"</code>: post-roll ad, played after the main content has finished
///   </li>
/// </ul>
///
/// \param linearAdUiConfig Configuration for the advertising UI when Bitmovin Player UI is used.
/// Has no effect when not using <code>AdSourceType/bitmovin</code>.
///
- (nonnull instancetype)initWithAdSources:(NSArray<BMPAdSource *> * _Nonnull)sources atPosition:(NSString * _Nullable)position linearAdUiConfig:(BMPLinearAdUiConfig * _Nonnull)linearAdUiConfig;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdManifestLoadEvent")
@interface BMPAdManifestLoadEvent : BMPPlayerEvent
/// The <code>BMPAdConfig</code> this event is related to.
@property (nonatomic, readonly, strong) id <BMPAdConfig> _Nullable adConfig;
/// The <code>BMPAdBreak</code> this event is related to.
@property (nonatomic, readonly, strong) id <BMPAdBreak> _Nullable adBreak;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAdConfig:(id <BMPAdConfig> _Nullable)adConfig adBreak:(id <BMPAdBreak> _Nullable)adBreak OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdManifestLoadedEvent")
@interface BMPAdManifestLoadedEvent : BMPPlayerEvent
@property (nonatomic, readonly) NSTimeInterval downloadTime;
@property (nonatomic, readonly, strong) id <BMPAdConfig> _Nullable adConfig;
/// The <code>BMPAdBreak</code> this event is related to.
@property (nonatomic, readonly, strong) id <BMPAdBreak> _Nullable adBreak;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithDownloadTime:(NSTimeInterval)downloadTime adBreak:(id <BMPAdBreak> _Nullable)adBreak adConfig:(id <BMPAdConfig> _Nullable)adConfig OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdQuartileEvent")
@interface BMPAdQuartileEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) BMPAdQuartile adQuartile;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithQuartile:(BMPAdQuartile)quartile OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// Emitted when the player’s advertising schedule changes.
/// This event is emitted when:
/// seealso:
/// <code>AdvertisingApi/schedule</code> for directly accessing the player’s advertising schedule.
/// <ul>
///   <li>
///     A new <code>AdBreak</code> is scheduled.
///   </li>
///   <li>
///     An <code>AdBreak</code> finishes loading its manifest and gets populated with ads.
///   </li>
///   <li>
///     An <code>AdBreak</code> starts playback.
///   </li>
///   <li>
///     An <code>AdBreak</code> is discarded (for example, if it is seeked over or errors out).
///   </li>
/// </ul>
/// <h2>Limitation</h2>
/// The currently-playing ad break is not part of the schedule. Hence, this event is not emitted in case the active
/// break metadata gets updated.
SWIFT_CLASS_NAMED("AdScheduleChangedEvent")
@interface BMPAdScheduleChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// Snapshot of the player’s advertising schedule before the change.
/// This is a copy of the player’s <code>AdvertisingApi/schedule</code> as it existed when the previous
/// <code>AdScheduleChangedEvent</code> was fired. It contains all scheduled ad breaks at that moment, sorted by schedule
/// time and scheduling order.
/// note:
/// The player’s advertising schedule excludes the currently-playing <code>AdBreak</code>.
@property (nonatomic, readonly, copy) NSArray<id <BMPAdBreak>> * _Nonnull oldSchedule;
/// Snapshot of the player’s advertising schedule at the time this event was emitted.
/// This is a copy of the player’s <code>AdvertisingApi/schedule</code> as it existed when the
/// event was fired. It contains all scheduled ad breaks at that moment, sorted by schedule time and scheduling
/// order.
/// note:
/// The player’s advertising schedule excludes the currently-playing <code>AdBreak</code>.
@property (nonatomic, readonly, copy) NSArray<id <BMPAdBreak>> * _Nonnull newSchedule;
- (nonnull instancetype)initWithOldSchedule:(NSArray<id <BMPAdBreak>> * _Nonnull)oldSchedule newSchedule:(NSArray<id <BMPAdBreak>> * _Nonnull)newSchedule OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdScheduledEvent")
@interface BMPAdScheduledEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSUInteger numberOfAds;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithNumberOfAds:(NSUInteger)numberOfAds OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdSkippedEvent")
@interface BMPAdSkippedEvent : BMPAdEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAd:(id <BMPAd> _Nonnull)ad OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPAdSourceType : NSInteger;
/// Represents an ad source which can be assigned to an AdItem.
/// An <code>AdItem</code> can have multiple <code>AdSource</code>s as a waterfalling option.
SWIFT_CLASS_NAMED("AdSource")
@interface BMPAdSource : NSObject
/// The <code>AdSourceType</code> of this <code>AdSource</code>.
@property (nonatomic, readonly) enum BMPAdSourceType type;
/// The ad tag / url to the ad manifest.
@property (nonatomic, readonly, copy) NSURL * _Nonnull tag;
/// The amount of seconds until the VAST loading is canceled after the download request started.
/// <ul>
///   <li>
///     In case this <code>AdSource</code> is of type <code>AdSourceType/ima</code>, this is equivalent to
///     <a href="https://developers.google.com/interactive-media-ads/docs/sdks/ios/client-side/reference/Classes/IMAAdsRequest#vastloadtimeout"><code>IMAAdsRequest.setVastLoadTimeout</code></a>
///     in the IMA library.
///   </li>
///   <li>
///     Only supported for <code>AdSource</code>s of type <code>AdSourceType/ima</code>.
///   </li>
/// </ul>
/// Default value is <code>8.0</code>.
@property (nonatomic, readonly) NSTimeInterval vastLoadTimeout;
/// The amount of seconds until the video loading is canceled after the download request started.
/// <ul>
///   <li>
///     In case this <code>AdSource</code> is of type <code>AdSourceType/ima</code>, this is equivalent to setting
///     <a href="https://developers.google.com/interactive-media-ads/docs/sdks/ios/client-side/reference/Classes/IMAAdsRenderingSettings#loadvideotimeout"><code>IMAAdsRenderingSettings.loadVideoTimeout</code></a>
///     in the IMA library.
///   </li>
///   <li>
///     Only supported for <code>AdSource</code>s of type <code>AdSourceType/ima</code>.
///   </li>
/// </ul>
/// Default value is <code>8.0</code>.
@property (nonatomic, readonly) NSTimeInterval videoLoadTimeout;
/// Creates an <code>AdSource</code> instance with the given tag and type.
/// \param tag URL of the ad tag. In case of using VAST macro placeholders, square brackets have to be
/// URL-encoded.
///
/// \param type Type of the source determining which ad implementation to use.
///
- (nonnull instancetype)initWithTag:(NSURL * _Nonnull)tag ofType:(enum BMPAdSourceType)type;
/// Creates an <code>AdSource</code> instance with the given tag and type.
/// \param tag URL of the ad tag. In case of using VAST macro placeholders, square brackets have to be
/// URL-encoded.
///
/// \param type Type of the source determining which ad implementation to use.
///
/// \param vastLoadTimeout The amount of seconds until the VAST loading is canceled after it
/// started. Only supported for <code>AdSource</code>s of type <code>AdSourceType/ima</code>.
///
- (nonnull instancetype)initWithTag:(NSURL * _Nonnull)tag ofType:(enum BMPAdSourceType)type vastLoadTimeout:(NSTimeInterval)vastLoadTimeout;
/// Creates an <code>AdSource</code> instance with the given tag and type.
/// \param tag URL of the ad tag. In case of using VAST macro placeholders, square brackets have to be
/// URL-encoded.
///
/// \param type Type of the source determining which ad implementation to use.
///
/// \param vastLoadTimeout The amount of seconds until the VAST loading is canceled after it
/// started. Only supported for <code>AdSource</code>s of type <code>AdSourceType/ima</code>. Default value is <code>8.0</code>.
///
/// \param videoLoadTimeout The amount of seconds until the video loading is canceled after
/// the download request started. Only supported for <code>AdSource</code>s of type <code>AdSourceType/ima</code>.
/// Default value is <code>8.0</code>.
///
- (nonnull instancetype)initWithTag:(NSURL * _Nonnull)tag ofType:(enum BMPAdSourceType)type vastLoadTimeout:(NSTimeInterval)vastLoadTimeout videoLoadTimeout:(NSTimeInterval)videoLoadTimeout;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPAdSource (SWIFT_EXTENSION(BitmovinPlayerCore)) <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
@end

/// Type of the <code>AdSource</code>
typedef SWIFT_ENUM_NAMED(NSInteger, BMPAdSourceType, "AdSourceType", open) {
/// Missing advertising source type
  BMPAdSourceTypeNone = 0,
/// Interactive Media Ads
  BMPAdSourceTypeIma = 1,
/// Unknown advertising source type
  BMPAdSourceTypeUnknown = 2,
/// Progressive advertising source type
  BMPAdSourceTypeProgressive = 3,
/// Bitmovin Advertising Module source type
  BMPAdSourceTypeBitmovin = 4,
};

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AdStartedEvent")
@interface BMPAdStartedEvent : BMPAdEvent
@property (nonatomic, readonly, copy) NSURL * _Nullable clickThroughUrl;
@property (nonatomic, readonly) enum BMPAdSourceType clientType;
@property (nonatomic, readonly) NSUInteger indexInQueue;
@property (nonatomic, readonly) NSTimeInterval duration;
@property (nonatomic, readonly) NSTimeInterval timeOffset;
@property (nonatomic, readonly) NSTimeInterval skipOffset;
@property (nonatomic, readonly, copy) NSString * _Nullable position;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithClickThroughUrl:(NSURL * _Nullable)clickThroughUrl clientType:(enum BMPAdSourceType)clientType indexInQueue:(NSUInteger)indexInQueue duration:(NSTimeInterval)duration timeOffset:(NSTimeInterval)timeOffset skipOffset:(NSTimeInterval)skipOffset position:(NSString * _Nullable)position ad:(id <BMPAd> _Nonnull)ad OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)initWithAd:(id <BMPAd> _Nonnull)ad SWIFT_UNAVAILABLE;
@end

/// Contains config values regarding the behaviour of the bitrate adaptation.
SWIFT_CLASS_NAMED("AdaptationConfig")
@interface BMPAdaptationConfig : NSObject
/// The maximum bitrate in bits per second for network bandwidth consumption of the loaded sources.
/// Set to <code>0</code> for no limitation.
/// This value stays persistent across <code>BMPPlayer/loadSourceConfig:</code>, <code>BMPPlayer/loadSource:</code>
/// or <code>BMPPlayer/loadPlaylistConfig:</code> calls and <code>PlaylistApi/add(source:)</code> calls.
/// Default value is <code>0</code>.
/// note:
/// To setup the maximum bitrate for the current playlist’s sources only, without it staying persistent on
/// new  <code>BMPPlayer/loadSourceConfig:</code>, <code>BMPPlayer/loadSource:</code> or <code>BMPPlayer/loadPlaylistConfig:</code>
/// and <code>PlaylistApi/add(source:)</code> calls, use <code>BMPPlayer/maxSelectableBitrate</code> instead.
/// note:
/// Gets reset to the default value after calling ``BMPPlayer/unload`.
@property (nonatomic) NSUInteger maxSelectableBitrate;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class UIView;
/// Provides access to advertising functionality and ad schedule information.
/// Accessible through the player’s <code>BMPPlayer/ads</code> property.
SWIFT_PROTOCOL_NAMED("AdvertisingApi")
@protocol BMPAdvertisingApi
/// The player’s current advertising schedule.
/// This property returns the current schedule of <code>AdBreak</code>s known to the player.
/// The schedule:
/// <ul>
///   <li>
///     Includes all ad breaks that have a known schedule time.
///   </li>
///   <li>
///     Excludes the currently playing ad break.
///   </li>
///   <li>
///     Excludes ad breaks that have finished or been discarded
///     (for example, re-playable ad items such as interstitials without <code>CUE="ONCE"</code>
///     are omitted once they have already played).
///   </li>
/// </ul>
/// The returned value is a snapshot at the time of calling this property.
/// As playback progresses, the advertising schedule evolves.
/// Subscribe to <code>AdScheduleChangedEvent</code> to be notified when the schedule changes.
/// <h2>Sorting</h2>
/// Ad breaks are sorted by:
/// <ol>
///   <li>
///     Schedule time (ascending)
///   </li>
///   <li>
///     Scheduling order (ascending) - used as a tie-breaker
///   </li>
/// </ol>
/// <h2>Limitations</h2>
/// VMAP ad breaks are not supported.
/// The VMAP ad item itself appears in the schedule as a single entry at its initial schedule time.
/// However, the individual ad breaks within a VMAP response are not expanded into separate schedule entries.
/// Furthermore, VMAP ad items might feature incomplete metadata in this API.
/// note:
/// Multiple <code>AdBreak</code>s may share the same <code>AdBreak/scheduleTime</code> since distinct
/// ad breaks are not merged together.
/// note:
/// When loading a new source, ads scheduled via <code>schedule(adItem:)</code> are cleared,
/// while ads from <code>AdvertisingConfig</code> persist in the schedule across source changes.
@property (nonatomic, readonly, copy) NSArray<id <BMPAdBreak>> * _Nonnull schedule;
/// Skips the current ad. A successful skip is signaled via an <code>AdSkippedEvent</code>.
/// Has no effect if the current ad is not skippable or if no ad is being played back.
/// <h2>Limitations</h2>
/// Programmatically skipping the current ad is not supported for ads of type <code>AdSourceType/ima</code> if IMA renders
/// the ‘Skip ad’ button. In this case, ad skipping can only be initiated by clicking
/// the ‘Skip ad’ button on the UI.
/// To hide the ‘Skip ad’ button and enable programmatic skipping on supported IMA ads,
/// set <code>ImaAdvertisingConfig/preferredUiType</code> to <code>ImaUiType/disabled</code>.
- (void)skip;
/// Schedules an ad for playback for the active source.
/// note:
/// Calling this API has no effect when the player has no active source.
/// \param adItem The ad item to be scheduled.
///
- (void)scheduleAdItem:(BMPAdItem * _Nonnull)adItem;
/// Registers the container for displaying ads.
/// \param adContainer The container view which should contain the rendered ads.
///
- (void)registerAdContainer:(UIView * _Nonnull)adContainer;
@end

@protocol BMPImaAdsManager;
@class BMPImaSettings;
@class BMPImaAdvertisingConfig;
@class BMPBitmovinAdvertisingConfig;
/// Contains config values regarding the ads which should be played back by the player.
SWIFT_CLASS_NAMED("AdvertisingConfig")
@interface BMPAdvertisingConfig : NSObject
/// Contains one or more <code>AdItem</code>(s). Each <code>AdItem</code> defines when the specified ad shall be played.
@property (nonatomic, copy) NSArray<BMPAdItem *> * _Nonnull schedule;
/// Provides access to the current <code>ImaAdsManager</code> once it becomes available.
@property (nonatomic, copy) void (^ _Nullable onAdsManagerAvailable)(id <BMPImaAdsManager> _Nonnull) SWIFT_AVAILABILITY(visionos,unavailable);
/// Callback that provides access to the <code>ImaSettings</code> before any initialization happens.
@property (nonatomic, copy) void (^ _Nullable beforeInitialization)(BMPImaSettings * _Nonnull) SWIFT_AVAILABILITY(visionos,unavailable);
/// Configuration to customize Google IMA SDK integration behavior.
@property (nonatomic, strong) BMPImaAdvertisingConfig * _Nonnull ima SWIFT_AVAILABILITY(visionos,unavailable);
/// Callback that will be called once for every <code>AdItem</code> shortly before it would start loading.
/// If <code>true</code> is returned, the <code>AdItem</code> will be scheduled for loading and playback.
/// If <code>false</code> is returned, the <code>AdItem</code> will be discarded and removed from the ad schedule.
/// Default is to load all ad items.
/// <h2>Relation to other Ad-Filtering callbacks</h2>
/// <ul>
///   <li>
///     <code>shouldPlaySeekedOverAdItems</code> filters ads after seek operations.
///   </li>
///   <li>
///     <code>shouldPlayAdItem</code> filters ads immediately before playback.
///   </li>
/// </ul>
/// Together these three callbacks define the ad-filtering pipeline:
/// <ol>
///   <li>
///     Load-time (<code>shouldLoadAdItem</code>)
///   </li>
///   <li>
///     Seek-time (<code>shouldPlaySeekedOverAdItems</code>)
///   </li>
///   <li>
///     Play-time (<code>shouldPlayAdItem</code>)
///   </li>
/// </ol>
@property (nonatomic, copy) BOOL (^ _Nonnull shouldLoadAdItem)(BMPAdItem * _Nonnull);
/// Callback that will be called once for every <code>AdItem</code> shortly before it would start playing.
/// If <code>true</code> is returned, the ad item will play.
/// If <code>false</code> is returned, the ad item will be discarded and removed from the schedule.
/// <h2>Default Behavior</h2>
/// All ad items are played by default.
/// <h2>Relation to other Ad-Filtering callbacks</h2>
/// <ul>
///   <li>
///     <code>shouldPlaySeekedOverAdItems</code> filters ads after seek operations.
///   </li>
///   <li>
///     <code>shouldLoadAdItem</code> filters ads immediately before loading.
///   </li>
/// </ul>
/// Together these three callbacks define the ad-filtering pipeline:
/// <ol>
///   <li>
///     Load-time (<code>shouldLoadAdItem</code>)
///   </li>
///   <li>
///     Seek-time (<code>shouldPlaySeekedOverAdItems</code>)
///   </li>
///   <li>
///     Play-time (<code>shouldPlayAdItem</code>)
///   </li>
/// </ol>
/// <h2>Limitations</h2>
/// When seeking over multiple ad breaks in a VMAP schedule, the Google IMA SDK determines
/// which ad breaks to play. Typically, only the last ad break fires the <code>AD_BREAK_READY</code> event.
/// As a result:
/// <ul>
///   <li>
///     This callback will only be triggered for ad breaks that the IMA SDK signals as ready.
///   </li>
///   <li>
///     Earlier ad breaks are handled internally by the IMA SDK and this callback is not invoked for them.
///   </li>
///   <li>
///     The player cannot intercept or override this IMA SDK behavior.
///   </li>
/// </ul>
/// The same behavior occurs if a start offset is configured that skips ad breaks scheduled
/// before the specified start time.
@property (nonatomic, copy) BOOL (^ _Nonnull shouldPlayAdItem)(BMPAdItem * _Nonnull);
/// Called during every forward seek or timeshift operation where <code>AdItem</code>s are scheduled in
/// between the original time and the seek target time.
/// The return value decides which ad breaks will play after the seek or timeshift operation finishes.
/// <h2>Relation to other Ad-Filtering callbacks</h2>
/// <ul>
///   <li>
///     <code>shouldLoadAdItem</code> filters ads immediately before loading.
///   </li>
///   <li>
///     <code>shouldPlayAdItem</code> filters ads immediately before playback.
///   </li>
/// </ul>
/// Together these three callbacks define the ad-filtering pipeline:
/// <ol>
///   <li>
///     Load-time (<code>shouldLoadAdItem</code>)
///   </li>
///   <li>
///     Seek-time (<code>shouldPlaySeekedOverAdItems</code>)
///   </li>
///   <li>
///     Play-time (<code>shouldPlayAdItem</code>)
///     Default Behavior
///   </li>
/// </ol>
/// <hr/>
/// <code>seekedOverAdItems</code> includes <em>all</em> the <code>AdItem</code>s for the time span that was jumped over
/// (both non-Interstitial ads and HLS Interstitials):
/// <ol>
///   <li>
///     If the list contains <em>no</em> HLS Interstitials:
///     <ul>
///       <li>
///         Plays <em>all</em> seeked-over ad items.
///       </li>
///     </ul>
///   </li>
///   <li>
///     If the list contains <em>any</em> HLS Interstitials:
///     <ul>
///       <li>
///         If <em>all</em> of those interstitials are non jump-restricted, <em>no</em> ad items play.
///       </li>
///       <li>
///         Otherwise, plays <em>only the last</em> jump-restricted interstitial.
///       </li>
///       <li>
///         In either case above, non-Interstitial ads in the list are <em>not</em> played by default.
///       </li>
///     </ul>
///   </li>
/// </ol>
/// note:
/// Items you do <em>not</em> return are discarded silently (without emitting any event or status change).
/// note:
/// Discarded ad items are removed before loading.
/// However, some may already have been loaded in these cases:
/// <ul>
///   <li>
///     For non-Interstitial ad breaks: if the playhead was within a configured offset
///     of the <code>AdItem</code>’s scheduled time.
///   </li>
///   <li>
///     For HLS Interstitial ad breaks: if the forward buffer had already approached
///     the <code>AdItem</code>’s scheduled time.
///   </li>
/// </ul>
/// note:
/// Post-rolls cannot be seeked-over, and hence cannot be discarded by this callback.
/// <h2>Usage Example</h2>
/// To always play only the last item after seeking or timeshifting over ad breaks:
/// \code
/// advertisingConfig.shouldPlaySeekedOverAdItems = { seekedOverAdItems in
///     guard let lastItem = seekedOverAdItems.last else { return [] }
///     return [lastItem]
/// }
///
/// \endcode
@property (nonatomic, copy) NSArray<BMPAdItem *> * _Nonnull (^ _Nonnull shouldPlaySeekedOverAdItems)(NSArray<BMPAdItem *> * _Nonnull);
/// Configuration to customize Bitmovin Advertising Module integration behavior.
@property (nonatomic, strong) BMPBitmovinAdvertisingConfig * _Nonnull bitmovin;
/// Creates a new <code>AdvertisingConfig</code> with empty ad schedule.
- (nonnull instancetype)init;
/// Creates a new <code>AdvertisingConfig</code> with the given ad schedule.
/// \param schedule The ad schedule which will be used within this <code>AdvertisingConfig</code>.
///
- (nonnull instancetype)initWithSchedule:(NSArray<BMPAdItem *> * _Nonnull)schedule OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AirPlayAvailabilityChangedEvent")
@interface BMPAirPlayAvailabilityChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) BOOL allowsAirPlay;
- (nonnull instancetype)initWithAllowsAirPlay:(BOOL)allowsAirPlay OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AirPlayAvailableEvent") SWIFT_DEPRECATED_MSG("Use AirPlayAvailabilityChangedEvent instead.", "BMPAirPlayAvailabilityChangedEvent")
@interface BMPAirPlayAvailableEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AirPlayChangedEvent")
@interface BMPAirPlayChangedEvent : BMPPlayerEvent
/// Indicates whether AirPlay is active.
@property (nonatomic, readonly) BOOL isAirPlayActive;
/// Current playback time in seconds.
@property (nonatomic, readonly) NSTimeInterval time;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithAirPlayActive:(BOOL)airPlayActive time:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Contains analytics specific data returned from the license server.
SWIFT_CLASS_NAMED("AnalyticsLicenseData")
@interface BMPAnalyticsLicenseData : NSObject
/// The analytics license key that is bundled with the configured player license.
@property (nonatomic, readonly, copy) NSString * _Nullable key;
- (nonnull instancetype)initWithKey:(NSString * _Nullable)key OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Protocol for all <code>SourceEvent</code> classes.
SWIFT_PROTOCOL_NAMED("SourceEvent")
@protocol BMPSourceEvent <BMPEvent>
@end

@class BMPAudioTrack;
/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AudioAddedEvent")
@interface BMPAudioAddedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) BMPAudioTrack * _Nonnull audioTrack;
@property (nonatomic, readonly) NSTimeInterval time;
- (nonnull instancetype)initWithAudioTrack:(BMPAudioTrack * _Nonnull)audioTrack time:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPAudioAddedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AudioChangedEvent")
@interface BMPAudioChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) BMPAudioTrack * _Nullable audioTrackOld;
@property (nonatomic, readonly, strong) BMPAudioTrack * _Nonnull audioTrackNew;
- (nonnull instancetype)initWithNewAudioTrack:(BMPAudioTrack * _Nonnull)newAudioTrack oldAudioTrack:(BMPAudioTrack * _Nullable)oldAudioTrack OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPAudioChangedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("AudioRemovedEvent")
@interface BMPAudioRemovedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The time at which this event was fired
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// The removed <code>AudioTrack</code>
@property (nonatomic, readonly, strong) BMPAudioTrack * _Nonnull audioTrack;
/// The playback time (in seconds) when the track was removed
@property (nonatomic, readonly) NSTimeInterval time;
- (nonnull instancetype)initWithAudioTrack:(BMPAudioTrack * _Nonnull)audioTrack time:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPAudioRemovedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

enum BMPTrackType : NSInteger;
/// Base class for all available tracks.
/// note:
/// This class acts as an abstract class.
SWIFT_CLASS_NAMED("Track")
@interface BMPTrack : NSObject
/// The URL to the timed file, e.g. WebVTT file.
@property (nonatomic, readonly, copy) NSURL * _Nullable url;
/// If set to <code>true</code>, this track would be considered as default.
@property (nonatomic, readonly) BOOL isDefaultTrack;
/// The label for this track.
@property (nonatomic, readonly, copy) NSString * _Nonnull label;
/// The unique identifier for this track.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The type for this track.
@property (nonatomic, readonly) enum BMPTrackType type;
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url trackType:(enum BMPTrackType)trackType label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack OBJC_DESIGNATED_INITIALIZER;
- (void)_updateLabelTo:(NSString * _Nonnull)label;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Describes an audio track.
SWIFT_CLASS_NAMED("AudioTrack")
@interface BMPAudioTrack : BMPTrack
/// The IETF BCP 47 language tag associated with the audio track.
@property (nonatomic, readonly, copy) NSString * _Nullable language;
/// The language tag (RFC5646) associated with the <code>EXT-X-MEDIA</code> rendition.
/// Directly maps to the <code>ASSOC-LANGUAGE</code> attribute of a <code>EXT-X-MEDIA</code> entry.
@property (nonatomic, readonly, copy) NSString * _Nullable associatedLanguage;
/// The Media Characteristic Tags associated with the <code>EXT-X-MEDIA</code> rendition.
/// Directly maps to the <code>CHARACTERISTICS</code> attribute of a <code>EXT-X-MEDIA</code> entry.
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nonnull characteristics;
/// Creates a new audio track
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track
///
///
/// returns:
/// A new <code>AudioTrack</code> initialized with the provided metadata.
- (nonnull instancetype)initWithLabel:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language;
/// Creates a new audio track
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track.
///
/// \param associatedLanguage The language tag (RFC5646) associated with this track.
///
/// \param characteristics The Media Characteristic Tags associated with the EXT-X-MEDIA rendition.
///
///
/// returns:
/// A new <code>AudioTrack</code> initialized with the provided metadata.
- (nonnull instancetype)initWithLabel:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language associatedLanguage:(NSString * _Nullable)associatedLanguage characteristics:(NSArray<NSString *> * _Nonnull)characteristics OBJC_DESIGNATED_INITIALIZER;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url trackType:(enum BMPTrackType)trackType label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack SWIFT_UNAVAILABLE;
@end

/// Protocol for all <code>OfflineEvent</code> classes.
SWIFT_PROTOCOL_NAMED("OfflineEvent")
@protocol BMPOfflineEvent <BMPEvent>
@end

@class BMPOfflineTrackSelection;
/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("AvailableTracksFetchedEvent")
@protocol BMPAvailableTracksFetchedEvent <BMPOfflineEvent>
@property (nonatomic, readonly, strong) BMPOfflineTrackSelection * _Nonnull tracks;
@end

@class BMPVastMacroConfig;
/// Contains configuration options to customize behavior for Bitmovin Advertising Module integration.
SWIFT_CLASS_NAMED("BitmovinAdvertisingConfig")
@interface BMPBitmovinAdvertisingConfig : NSObject
/// Configuration for VAST macros.
@property (nonatomic, strong) BMPVastMacroConfig * _Nonnull macro;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPCastDeviceDiscoveryMode : NSInteger;
/// The options to be used for initializing <code>BitmovinCastManager</code>
SWIFT_CLASS_NAMED("BitmovinCastManagerOptions")
@interface BMPBitmovinCastManagerOptions : NSObject
/// ID of receiver application.
/// Using <code>nil</code> value will result in using the default application ID.
@property (nonatomic, copy) NSString * _Nullable applicationId;
/// Custom namespace.
/// Using <code>nil</code> value will result in using the default message namespace.
@property (nonatomic, copy) NSString * _Nullable messageNamespace;
/// Whether sessions should not be suspended when the sender application goes into the background.
/// This flag should be used in case the cast session should attempt to stay connected to the application
/// while the application moves to background.
/// This enables actions on the active cast session like <code>play</code> and <code>pause</code> when the app is in background.
/// important:
/// It is appropriate to set this to <code>true</code> in applications that are able to
/// maintain network connections indefinitely while in the background,
/// otherwise the connection to cast receiver may be lost.
/// For applications without the requirement to interact with the cast session while in background,
/// this should be set to <code>false</code> to ensure suspending and re-establishing connection
/// between the sender and receiver.
/// Default is <code>false</code>
@property (nonatomic) BOOL enableBackgroundSessions;
/// Specifies when cast devices discovery starts.
/// <ul>
///   <li>
///     Also specifies when the local network access permission prompt will be displayed.
///   </li>
///   <li>
///     See <code>CastDeviceDiscoveryMode</code> for possible values.
///   </li>
/// </ul>
/// Default is <code>CastDeviceDiscoveryMode/castManagerInitialization</code>
@property (nonatomic) enum BMPCastDeviceDiscoveryMode deviceDiscoveryMode;
/// Specifies whether the receiver application should be terminated when the user ends
/// the session via the “Stop Casting” button.
/// Default value is <code>false</code>.
@property (nonatomic) BOOL stopReceiverApplicationWhenEndingSession;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("UserInterfaceConfig")
@interface BMPUserInterfaceConfig : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class BMPCustomMessageHandler;
@class BMPBitmovinUserInterfaceMetadata;
/// Contains config values that can be used to alter the visual presentation and behaviour when the Bitmovin
/// Player Web UI is used.
SWIFT_CLASS_NAMED("BitmovinUserInterfaceConfig")
@interface BMPBitmovinUserInterfaceConfig : BMPUserInterfaceConfig
/// Handles the communication with the Bitmovin Web UI in both directions
@property (nonatomic, strong) BMPCustomMessageHandler * _Nullable customMessageHandler;
/// When set to <code>true</code> the first frame of the main content will not be rendered before playback starts.
/// Default is <code>false</code>.
/// To reliably hide the first frame before a pre-roll ad, please ensure that you are using the
/// <code>AdvertisingConfig</code> to schedule ads and not the scheduleAd API call.
@property (nonatomic) BOOL hideFirstFrame;
/// When set to <code>true</code> the Bitmovin Player Web UI forces subtitle-labels back into their respective container
/// if they overflow and are therefore cropped.
/// This flag directly maps to the <a href="https://github.com/bitmovin/bitmovin-player-ui/blob/9ab4779c093d272881d09861e40316b25f3df379/src/ts/uiconfig.ts#L102"><code>UIConfig.forceSubtitlesIntoViewContainer</code></a> of our Bitmovin Player Web UI.
/// Default is <code>true</code>.
@property (nonatomic) BOOL forceSubtitlesIntoViewContainer;
/// When set to <code>true</code> the Bitmovin Player Web UI will show the playback speed selection option
/// in the settings menu.
/// Default is <code>true</code>.
@property (nonatomic) BOOL playbackSpeedSelectionEnabled;
/// When set to <code>true</code> the Bitmovin Player Web UI will update video frames while scrubbing the seek bar.
/// Default is <code>true</code>.
@property (nonatomic) BOOL enableSeekPreview;
/// When set to <code>true</code> the <code>WKWebView</code> used for the Bitmovin Player Web UI can be inspected
/// using the Safari Web Inspector.
/// See <a href="https://webkit.org/blog/13936/enabling-the-inspection-of-web-content-in-apps/">Enabling the Inspection of Web Content in Apps</a> for details.
/// This value has no effect below iOS 16.4 where inspecting <code>WKWebView</code>s is always enabled.
/// We recommend to only enable this in <code>DEBUG</code> builds. If enabled in released Apps, everyone
/// could inspect the <code>WKWebView</code> on their devices.
/// Default is <code>false</code>.
@property (nonatomic) BOOL enableWebViewInspecting;
/// Metadata to use as fallback when currently active source has no respective value set.
@property (nonatomic, strong) BMPBitmovinUserInterfaceMetadata * _Nonnull metadata;
/// Additional options to use when creating the Bitmovin Player Web UI.
/// These will be set in the Bitmovin Player Web UI’s JavaScript context,
/// on type <code>UIConfig</code>, before passing it to <code>UIFactory</code>.
/// This can be useful when using a custom build of Bitmovin Player Web UI
/// and provide custom configuration options.
/// important:
/// Values set here replace any previously set value for the same property on <code>UIConfig</code>.
/// warning:
/// All values must be serializable via <a href="https://developer.apple.com/documentation/foundation/jsonserialization/1413636-data"><code>JSONSerialization.data(withJSONObject:options:)</code></a>.
/// This can be checked via testing with <a href="https://developer.apple.com/documentation/foundation/jsonserialization/1418461-isvalidjsonobject"><code>JSONSerialization.isValidJSONObject(_:)</code></a>.
/// In case any of the values can not be serialized, <code>customOptions</code> will be ignored.
/// Default is empty dictionary.
@property (nonatomic, copy) NSDictionary<NSString *, id> * _Nonnull customOptions;
/// Specifies the function name that will be used to initialize the <code>UIManager</code> for the the Bitmovin Player Web UI.
/// The function will be called on the <code>window</code> object with the <code>BMPPlayer</code>
/// as the first argument and the <code>UIConfig</code>
/// as the second argument.
/// Example:
/// When you added a new function or want to use a different function of our <a href="https://github.com/bitmovin/bitmovin-player-ui/blob/develop/src/ts/uifactory.ts#L60"><code>UIFactory</code></a>,
/// you can specify the full qualifier name including namespaces. See the default value for an example.
/// Notes:
/// <ul>
///   <li>
///     It’s not necessary to use our <code>UIFactory</code>. Any static function can be specified.
///   </li>
///   <li>
///     We expect that the function returns an instance of type <code>UIManager</code>.
///   </li>
/// </ul>
/// Default value is <code>bitmovin.playerui.UIFactory.buildDefaultSmallScreenUI</code>.
@property (nonatomic, copy) NSString * _Nonnull uiManagerFactoryFunction;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Contains metadata values to act as a fallback when respective values are not defined
/// for the currently active source.
/// See individual properties for details.
SWIFT_CLASS_NAMED("BitmovinUserInterfaceMetadata")
@interface BMPBitmovinUserInterfaceMetadata : NSObject
/// The default title of the video source.
/// This is only used if the current <code>Source</code>’s <code>SourceConfig/title</code> is not set.
@property (nonatomic, copy) NSString * _Nullable title;
/// The default description of the video source.
/// This is only used if the current <code>Source</code>’s <code>SourceConfig/sourceDescription</code> is not set.
@property (nonatomic, copy) NSString * _Nullable sourceDescription;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class BMPBufferMediaTypeConfig;
/// Player buffer config object to configure buffering behavior.
SWIFT_CLASS_NAMED("BufferConfig")
@interface BMPBufferConfig : NSObject
/// Configures various settings for the audio and video buffer.
@property (nonatomic, strong) BMPBufferMediaTypeConfig * _Nonnull audioAndVideo;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Holds different information about the buffer levels.
SWIFT_CLASS_NAMED("BufferLevel")
@interface BMPBufferLevel : NSObject
/// The amount of currently buffered data, e.g. audio or video buffer level.
@property (nonatomic, readonly) NSTimeInterval level;
/// The target buffer level the player tries to maintain.
@property (nonatomic, readonly) NSTimeInterval targetLevel;
/// The media type the buffer data applies to.
@property (nonatomic, readonly) enum BMPMediaType media;
/// The buffer type the buffer data applies to.
@property (nonatomic, readonly) BMPBufferType type;
- (nonnull instancetype)initWithBuffer:(BMPBufferType)buffer media:(enum BMPMediaType)media targetLevel:(NSTimeInterval)targetLevel level:(NSTimeInterval)level OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Configures buffer target levels for different <code>MediaType</code>s.
SWIFT_CLASS_NAMED("BufferMediaTypeConfig")
@interface BMPBufferMediaTypeConfig : NSObject
/// The amount of data in seconds the player tries to buffer in advance.
/// If set to 0, the player will choose an appropriate forward buffer duration suitable for most use-cases.
/// Default value is <code>0</code>.
@property (nonatomic) NSTimeInterval forwardDuration;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastAvailableEvent")
@interface BMPCastAvailableEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Specifies when cast devices discovery starts.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPCastDeviceDiscoveryMode, "CastDeviceDiscoveryMode", open) {
/// Discovery will start when the <code>BMPBitmovinCastManager/initializeCasting</code>
/// is called for the first time.
  BMPCastDeviceDiscoveryModeCastManagerInitialization = 0,
/// Discovery will start when the <code>GCKUICastButton</code> is tapped for the first time.
/// Only use this option when you use a custom UI with a <code>GCKUICastButton</code>.
/// Using this option with our Bitmovin Player UI will result in no cast button being visible.
  BMPCastDeviceDiscoveryModeCastButtonInteraction = 1,
};

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastPausedEvent")
@interface BMPCastPausedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// A class holding information for the <code>CastWaitingForDeviceEvent</code>.
SWIFT_CLASS_NAMED("CastPayload") SWIFT_AVAILABILITY(tvos,unavailable)
@interface BMPCastPayload : NSObject
/// The <code>currentTime</code> of the player at which <code>CastWaitingForDeviceEvent</code> was emitted.
@property (nonatomic, readonly) NSTimeInterval currentTime;
/// The time at which this event was fired
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// The device name
@property (nonatomic, readonly, copy) NSString * _Nonnull deviceName;
/// The type of the casting
@property (nonatomic, readonly, copy) NSString * _Nonnull type;
- (nonnull instancetype)initWithDeviceName:(NSString * _Nonnull)deviceName currentTime:(NSTimeInterval)currentTime timestamp:(NSTimeInterval)timestamp OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastPlaybackFinishedEvent")
@interface BMPCastPlaybackFinishedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastPlayingEvent")
@interface BMPCastPlayingEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastStartEvent")
@interface BMPCastStartEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastStartedEvent")
@interface BMPCastStartedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly, copy) NSString * _Nonnull deviceName;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithDeviceName:(NSString * _Nonnull)deviceName OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastStoppedEvent")
@interface BMPCastStoppedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastTimeUpdatedEvent")
@interface BMPCastTimeUpdatedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval currentTime;
@property (nonatomic, readonly) NSTimeInterval duration;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithCurrentTime:(NSTimeInterval)currentTime duration:(NSTimeInterval)duration OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CastWaitingForDeviceEvent") SWIFT_AVAILABILITY(tvos,unavailable)
@interface BMPCastWaitingForDeviceEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly, strong) BMPCastPayload * _Nonnull castPayload;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithDeviceName:(NSString * _Nonnull)deviceName currentTime:(NSTimeInterval)currentTime OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

@class NSUUID;
/// Base class for all DRM configs.
/// note:
/// This class acts as an abstract class.
SWIFT_CLASS_NAMED("DrmConfig")
@interface BMPDrmConfig : NSObject
/// The DRM license acquisition URL.
@property (nonatomic, copy) NSURL * _Nullable licenseUrl;
/// The UUID for the respective DRM system. Possible values are defined in <code>DrmSystems</code>.
@property (nonatomic, copy) NSUUID * _Nonnull uuid;
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl uuid:(NSUUID * _Nonnull)uuid OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithUUID:(NSUUID * _Nonnull)uuid;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class BMPDecryptionKey;
/// Represents a ClearKey config.
SWIFT_CLASS_NAMED("ClearKeyConfig")
@interface BMPClearKeyConfig : BMPDrmConfig
/// An array of objects representing the decryption keys.
@property (nonatomic, copy) NSArray<BMPDecryptionKey *> * _Nonnull decryptionKeys;
/// Creates a new <code>ClearKeyConfig</code> based on the given decryption keys.
/// <ul>
///   <li>
///     Parameters:
///   </li>
///   <li>
///     decryptionKeys: The decryption keys to use for the ClearKey config.
///   </li>
/// </ul>
///
/// returns:
/// A ClearKey config which contains the given decryption keys for content decryption.
- (nonnull instancetype)initWithDecryptionKeys:(NSArray<BMPDecryptionKey *> * _Nonnull)decryptionKeys OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl uuid:(NSUUID * _Nonnull)uuid SWIFT_UNAVAILABLE;
@end

@class BMPRemoteControlConfig;
@class _BMPCafDrmConfig;
SWIFT_PROTOCOL_NAMED("_CafDrmConfigConvertible")
@protocol _BMPCafDrmConfigConvertible
- (_BMPCafDrmConfig * _Nullable)toCafDrmConfigWithRemoteControlConfig:(BMPRemoteControlConfig * _Nonnull)remoteControlConfig SWIFT_WARN_UNUSED_RESULT;
@end

@interface BMPClearKeyConfig (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPCafDrmConfigConvertible>
- (_BMPCafDrmConfig * _Nullable)toCafDrmConfigWithRemoteControlConfig:(BMPRemoteControlConfig * _Nonnull)remoteControlConfig SWIFT_WARN_UNUSED_RESULT;
@end

/// Contains config values regarding Common Media Client Data (CMCD).
SWIFT_CLASS_NAMED("CmcdConfig")
@interface BMPCmcdConfig : NSObject
/// Enables sending Common Media Client Data (CMCD) on requests as HTTP Headers.
/// Please find more information about the Consumer Technology Association (CTA)
/// Specification in <a href="https://cdn.cta.tech/cta/media/media/resources/standards/pdfs/cta-5004-final.pdf">https://cdn.cta.tech/cta/media/media/resources/standards/pdfs/cta-5004-final.pdf</a>
/// Note:
/// <ul>
///   <li>
///     Common Media Client Data (CMCD) is only supported through HTTP Headers.
///   </li>
///   <li>
///     Per default, CMCD data are only sent on media (video and audio) requests. To enable them also for manifest
///     requests, <code>TweaksConfig/isCustomHlsLoadingEnabled</code> needs to be disabled.
///   </li>
///   <li>
///     Only CMCD v1 is supported for now.
///   </li>
///   <li>
///     Only available from iOS and tvOS 18 as well as visionOS 2 upwards.
///   </li>
/// </ul>
@property (nonatomic) BOOL isEnabled;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPLogLevel : NSInteger;
@class BMPLogEntry;
/// This protocol can be implemented to gather more detailed information about what is happening within the SDK
/// for all top-level entities and APIs. For example, <code>Player</code>, <code>Source</code> and <code>PlayerView</code> entities,
/// as well as Offline components.
/// It is implemented by default within the SDK to print a single log entry to the console.
/// A log entry contains details such as log level, which entity or API is sending the log, a log message,
/// the date and time the log entry was created, and if applicable,
/// a warning or error code and extra data about the warning or error.
/// See <code>LogEntry</code> for more details.
/// To create your own custom logger to receive and optionally print a log entry in your integration,
/// provide an instance that conforms to this protocol. An example custom logger is:
/// \code
/// public class CustomLogger: Logger {
///     public var level: LogLevel = .info
///
///     func log(_ logEntry: LogEntry) {
///         var logDetails: [String] = []
///         logDetails.append("[\(logEntry.sender)]")
///         logDetails.append("[\(logEntry.level)]")
///         logDetails.append("\(logEntry.message)")
///
///         if let code = logEntry.code {
///             logDetails.append("code: \(code)")
///         }
///
///         if let data = logEntry.data {
///             var dataDetails: [String] = []
///             dataDetails.append("Data code: \(data.code), message: \(data.message)")
///             dataDetails.append("underlying error: \(data.underlyingError)")
///
///             logDetails.append("[" + dataDetails.joined(separator: ", ") + "]")
///         }
///
///         print("[CustomLog] \(logDetails.joined(separator: " "))")
///     }
/// }
///
/// \endcodeTo implement your custom logger, assign it as the logger in the logging config:
/// \code
///     DebugConfig.logging.logger = CustomLogger()
///
/// \endcode
SWIFT_PROTOCOL_NAMED("Logger")
@protocol BMPLogger
/// The minimum log level that is used to filter log output.
/// Default minimum level is <code>LogLevel/warning</code>.
@property (nonatomic) enum BMPLogLevel level;
/// Will be called for every log the SDK produces
/// \param logEntry the <code>LogEntry</code> contains the details of the log
///
- (void)log:(BMPLogEntry * _Nonnull)logEntry;
@end

/// Prints a log entry to the console when logging is enabled in the SDK,
/// and the log entry level equals or is above the minimum log level that is assigned to <code>level</code> below.
/// See <code>LogEntry</code> and <code>LoggingConfig</code> for more details.
SWIFT_CLASS_NAMED("ConsoleLogger")
@interface BMPConsoleLogger : NSObject <BMPLogger>
/// The minimum log level that is used to filter log output.
/// Default minimum level is <code>LogLevel/warning</code>.
@property (nonatomic) enum BMPLogLevel level;
- (nonnull instancetype)init;
/// Prints a log entry to the console with the date and time, sender of the log, log level, and log message.
/// If applicable, the printed log entry may contain a log code and additional data.
/// \param logEntry the <code>LogEntry</code> contains the details of the log
///
- (void)log:(BMPLogEntry * _Nonnull)logEntry;
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("ContentDownloadCanceledEvent")
@protocol BMPContentDownloadCanceledEvent <BMPOfflineEvent>
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("ContentDownloadFinishedEvent")
@protocol BMPContentDownloadFinishedEvent <BMPOfflineEvent>
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("ContentDownloadProgressChangedEvent")
@protocol BMPContentDownloadProgressChangedEvent <BMPOfflineEvent>
/// Current percentage progress for the download, represented as a value between 0 and 100
@property (nonatomic, readonly) double progress;
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("ContentDownloadResumedEvent")
@protocol BMPContentDownloadResumedEvent <BMPOfflineEvent>
/// Current percentage progress for the download, represented as a value between 0 and 100
@property (nonatomic, readonly) double progress;
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("ContentDownloadSuspendedEvent")
@protocol BMPContentDownloadSuspendedEvent <BMPOfflineEvent>
@end

/// The <code>ContentOverlayApi</code> for interactions regarding the content overlay.
SWIFT_CLASS_NAMED("ContentOverlayApi")
@interface BMPContentOverlayApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("ContentUrlMigrationFinishedEvent")
@protocol BMPContentUrlMigrationFinishedEvent <BMPOfflineEvent>
/// Original remote asset URL before the migration
@property (nonatomic, readonly, copy) NSURL * _Nonnull from;
/// Target remote asset URL for the migration
@property (nonatomic, readonly, copy) NSURL * _Nonnull to;
@end

/// Base protocol for all <code>PlayerViewEvent</code> classes.
SWIFT_PROTOCOL_NAMED("PlayerViewEvent")
@protocol BMPPlayerViewEvent <BMPEvent>
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("ControlsHideEvent")
@interface BMPControlsHideEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("ControlsShowEvent")
@interface BMPControlsShowEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class NSAttributedString;
@class UIImage;
@class BMPCuePosition;
@class BMPVttProperties;
/// Describes a subtitle cue.
SWIFT_CLASS_NAMED("Cue")
@interface BMPCue : NSObject <NSCopying>
/// The start time of the cue in seconds
@property (nonatomic) NSTimeInterval startTime;
/// The end time of the cue in seconds
@property (nonatomic) NSTimeInterval endTime;
/// The cue text as HTML
@property (nonatomic, copy) NSString * _Nullable html;
/// The cue text
@property (nonatomic, copy) NSString * _Nullable text;
/// The original raw text of the cue, as written in the caption file
/// Limitations:
/// <ul>
///   <li>
///     For in-manifest subtitle tracks, it will always have the same value as <code>text</code>.
///   </li>
/// </ul>
@property (nonatomic, copy) NSString * _Nullable rawText;
/// The formatted text content of the cue.
/// This property provides the cue’s text content with attributes in the <code>UIKitAttributes</code> format,
/// making it directly usable with UIKit and SwiftUI components that support attributed strings.
/// The supported styles include:
/// <ul>
///   <li>
///     Foreground color (text color)
///   </li>
///   <li>
///     Background color (of the character)
///   </li>
///   <li>
///     Underline style
///   </li>
///   <li>
///     Italic text style
///   </li>
///   <li>
///     Bold text style
///   </li>
/// </ul>
/// <h3>Limitation:</h3>
/// <ol>
///   <li>
///     <em>Side-loaded subtitles</em>: for side-loaded subtitles, only color attributes (foreground and background)
///     are supported. Font-related attributes and underline styles are not available for these types of subtitles.
///   </li>
///   <li>
///     <em>One font-related attribute at a time</em>: having multiple font-related attributes (italic and bold styles)
///     on the same range is not supported. In this case, only one attribute will be applied.
///   </li>
/// </ol>
/// <h3>Usage Example:</h3>
/// \code
/// import SwiftUI
///
/// // Use in a SwiftUI `Text` view
///
/// guard let attributedText = cueEvent.attributedText else { return }
/// Text(AttributedString(attributedText))
///
/// \endcode<h3>Compatibility:</h3>
/// <ul>
///   <li>
///     <em>UIKit</em>: Directly use the <code>NSAttributedString</code> with <code>UILabel</code>, <code>UITextView</code>, or other UIKit components.
///   </li>
///   <li>
///     <em>SwiftUI</em>: Convert the <code>NSAttributedString</code> to <code>AttributedString</code> using SwiftUI’s built-in support with
///     <code>AttributedString(attributedText)</code>, as shown in the usage example above.
///   </li>
/// </ul>
/// <h3>Troubleshooting:</h3>
/// <ul>
///   <li>
///     <em>SwiftUI</em>: If the formatting is not working, try scoping the attributes to keep during the conversion:
///     \code
///     try AttributedString(attributedText, including: \.uiKit)
///
///     \endcode</li>
/// </ul>
@property (nonatomic, strong) NSAttributedString * _Nullable attributedText;
/// The cue image
@property (nonatomic, strong) UIImage * _Nullable image;
/// The position of the cue. Only relevant for CEA-captions, provides information about where the cue should be
/// positioned on a grid of 15 character rows times 32 columns
@property (nonatomic, strong) BMPCuePosition * _Nullable position;
/// The region of the cue
@property (nonatomic, copy) NSString * _Nullable region;
/// The region style of the cue
@property (nonatomic, copy) NSString * _Nullable regionStyle;
/// The VTT positioning properties for this cue
@property (nonatomic, strong) BMPVttProperties * _Nullable vtt;
/// \param startTime The start time of the cue in seconds
///
/// \param endTime The end time of the cue in seconds
///
/// \param html The cue text as HTML
///
/// \param text The cue text
///
/// \param rawText The original raw text of the cue, as written in the caption file
///
/// \param attributedText The formatted text content of the cue
///
/// \param image The cue image
///
/// \param position The position of the cue. Only relevant for CEA captions
///
/// \param region The region of the cue
///
/// \param regionStyle The region style of the cue
///
/// \param vttProperties The VTT positioning properties for this cue
///
///
/// returns:
/// A new subtitle cue
- (nonnull instancetype)initWithStartTime:(NSTimeInterval)startTime endTime:(NSTimeInterval)endTime html:(NSString * _Nullable)html text:(NSString * _Nullable)text rawText:(NSString * _Nullable)rawText attributedText:(NSAttributedString * _Nullable)attributedText image:(UIImage * _Nullable)image position:(BMPCuePosition * _Nullable)position region:(NSString * _Nullable)region regionStyle:(NSString * _Nullable)regionStyle vttProperties:(BMPVttProperties * _Nullable)vttProperties OBJC_DESIGNATED_INITIALIZER;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("CueEvent")
@protocol BMPCueEvent
/// The start time of the cue in seconds
@property (nonatomic, readonly) NSTimeInterval startTime;
/// The end time of the cue in seconds
@property (nonatomic, readonly) NSTimeInterval endTime;
/// The cue text
@property (nonatomic, readonly, copy) NSString * _Nullable text;
/// The original raw text of the cue, as written in the caption file
@property (nonatomic, readonly, copy) NSString * _Nullable rawText;
/// The formatted text content of the cue.
/// This property provides the cue’s text content with attributes in the <code>UIKitAttributes</code> format,
/// making it directly usable with UIKit and SwiftUI components that support attributed strings.
/// The supported styles include:
/// <ul>
///   <li>
///     Foreground color (text color)
///   </li>
///   <li>
///     Background color (of the character)
///   </li>
///   <li>
///     Underline style
///   </li>
///   <li>
///     Italic text style
///   </li>
///   <li>
///     Bold text style
///   </li>
/// </ul>
/// <h3>Limitation:</h3>
/// <ol>
///   <li>
///     <em>Side-loaded subtitles</em>: for side-loaded subtitles, only color attributes (foreground and background)
///     are supported. Font-related attributes and underline styles are not available for these types of subtitles.
///   </li>
///   <li>
///     <em>One font-related attribute at a time</em>: having multiple font-related attributes (italic and bold styles)
///     on the same range is not supported. In this case, only one attribute will be applied.
///   </li>
/// </ol>
/// <h3>Usage Example:</h3>
/// \code
/// import SwiftUI
///
/// // Use in a SwiftUI `Text` view
///
/// guard let attributedText = cueEvent.attributedText else { return }
/// Text(AttributedString(attributedText))
///
/// \endcode<h3>Compatibility:</h3>
/// <ul>
///   <li>
///     <em>UIKit</em>: Directly use the <code>NSAttributedString</code> with <code>UILabel</code>, <code>UITextView</code>, or other UIKit components.
///   </li>
///   <li>
///     <em>SwiftUI</em>: Convert the <code>NSAttributedString</code> to <code>AttributedString</code> using SwiftUI’s built-in support with
///     <code>AttributedString(attributedText)</code>, as shown in the usage example above.
///   </li>
/// </ul>
/// <h3>Troubleshooting:</h3>
/// <ul>
///   <li>
///     <em>SwiftUI</em>: If the formatting is not working, try scoping the attributes to keep during the conversion:
///     \code
///     try AttributedString(attributedText, including: \.uiKit)
///
///     \endcode</li>
/// </ul>
@property (nonatomic, readonly, strong) NSAttributedString * _Nullable attributedText;
/// The cue text as HTML
@property (nonatomic, readonly, copy) NSString * _Nullable html;
/// The cue image
@property (nonatomic, readonly, strong) UIImage * _Nullable image;
/// The position of the cue. Only relevant for CEA-captions, provides information about where the cue should be
/// positioned on a grid of 15 character rows times 32 columns
@property (nonatomic, readonly, strong) BMPCuePosition * _Nullable position;
/// The region of the cue
@property (nonatomic, readonly, copy) NSString * _Nullable region;
/// The region style of the cue
@property (nonatomic, readonly, copy) NSString * _Nullable regionStyle;
/// The VTT positioning properties for this cue
@property (nonatomic, readonly, strong) BMPVttProperties * _Nullable vtt;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CueEnterEvent")
@interface BMPCueEnterEvent : BMPPlayerEvent <BMPCueEvent>
@property (nonatomic, readonly) NSTimeInterval startTime;
@property (nonatomic, readonly) NSTimeInterval endTime;
@property (nonatomic, readonly, copy) NSString * _Nullable text;
@property (nonatomic, readonly, copy) NSString * _Nullable rawText;
@property (nonatomic, readonly, strong) NSAttributedString * _Nullable attributedText;
@property (nonatomic, readonly, copy) NSString * _Nullable html;
@property (nonatomic, readonly, strong) UIImage * _Nullable image;
@property (nonatomic, readonly, strong) BMPCuePosition * _Nullable position;
@property (nonatomic, readonly, copy) NSString * _Nullable region;
@property (nonatomic, readonly, copy) NSString * _Nullable regionStyle;
@property (nonatomic, readonly, strong) BMPVttProperties * _Nullable vtt;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CueExitEvent")
@interface BMPCueExitEvent : BMPPlayerEvent <BMPCueEvent>
@property (nonatomic, readonly) NSTimeInterval startTime;
@property (nonatomic, readonly) NSTimeInterval endTime;
@property (nonatomic, readonly, copy) NSString * _Nullable text;
@property (nonatomic, readonly, copy) NSString * _Nullable rawText;
@property (nonatomic, readonly, strong) NSAttributedString * _Nullable attributedText;
@property (nonatomic, readonly, copy) NSString * _Nullable html;
@property (nonatomic, readonly, strong) UIImage * _Nullable image;
@property (nonatomic, readonly, strong) BMPCuePosition * _Nullable position;
@property (nonatomic, readonly, copy) NSString * _Nullable region;
@property (nonatomic, readonly, copy) NSString * _Nullable regionStyle;
@property (nonatomic, readonly, strong) BMPVttProperties * _Nullable vtt;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("CueParsedEvent")
@interface BMPCueParsedEvent : NSObject <BMPCueEvent, BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) NSTimeInterval startTime;
@property (nonatomic, readonly) NSTimeInterval endTime;
@property (nonatomic, readonly, copy) NSString * _Nullable text;
@property (nonatomic, readonly, copy) NSString * _Nullable rawText;
@property (nonatomic, readonly, strong) NSAttributedString * _Nullable attributedText;
@property (nonatomic, readonly, copy) NSString * _Nullable html;
@property (nonatomic, readonly, strong) UIImage * _Nullable image;
@property (nonatomic, readonly, strong) BMPCuePosition * _Nullable position;
@property (nonatomic, readonly, copy) NSString * _Nullable region;
@property (nonatomic, readonly, copy) NSString * _Nullable regionStyle;
@property (nonatomic, readonly, strong) BMPVttProperties * _Nullable vtt;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPCueParsedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// Positioning information for CEA captions
SWIFT_CLASS_NAMED("CuePosition")
@interface BMPCuePosition : NSObject
/// Index of the column ranging from 0 to 31
@property (nonatomic, readonly) NSInteger column;
/// Index of the row ranging from 0 to 14
@property (nonatomic, readonly) NSInteger row;
/// \param column Index of the column ranging from 0 to 31
///
/// \param row Index of the row ranging from 0 to 14
///
///
/// returns:
/// A new cue position
- (nonnull instancetype)initWithColumn:(NSInteger)column row:(NSInteger)row OBJC_DESIGNATED_INITIALIZER;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPCuePosition (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

@protocol BMPCustomMessageHandlerDelegate;
/// This class handles all communication between the native environment
/// and the Bitmovin Web UI environment in one place.
SWIFT_CLASS_NAMED("CustomMessageHandler")
@interface BMPCustomMessageHandler : NSObject
/// Delegate to handle communication from Bitmovin Web UI to native.
@property (nonatomic, weak) id <BMPCustomMessageHandlerDelegate> _Nullable delegate;
/// Calls the registered callback within the NativeCommunicationHandler in the Bitmovin Web UI
/// \param message Identifier for the callback which should be called.
///
- (void)sendMessage:(NSString * _Nonnull)message;
/// Calls the registered callback within the NativeCommunicationHandler in the Bitmovin Web UI
/// \param message Identifier for the callback which should be called.
///
/// \param data Payload for the callback.
///
- (void)sendMessage:(NSString * _Nonnull)message withData:(NSString * _Nullable)data;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Methods for handling received messages from Bitmovin Web UI.
SWIFT_PROTOCOL_NAMED("CustomMessageHandlerDelegate")
@protocol BMPCustomMessageHandlerDelegate
/// Gets called when a synchronous message was received from the Bitmovin Web UI.
/// warning:
/// This should not be used for frequent messages,
/// as it blocks the Bitmovin Web UI’s thread until a response is received.
/// \param message Identifier of the message.
///
/// \param data Optional data of the message as string (can be a serialized object).
///
///
/// returns:
/// Optional return value as string which will be propagates back to the JS counterpart.
- (NSString * _Nullable)receivedSynchronousMessage:(NSString * _Nonnull)message withData:(NSString * _Nullable)data SWIFT_WARN_UNUSED_RESULT;
/// Gets called when a asynchronous message was received from the Bitmovin Web UI.
/// \param message Identifier of the message.
///
/// \param data Optional data of the message as string (can be a serialized object).
///
- (void)receivedAsynchronousMessage:(NSString * _Nonnull)message withData:(NSString * _Nullable)data;
@end

@class NSDate;
/// Represents in-playlist timed metadata.
SWIFT_CLASS_NAMED("DaterangeMetadata")
@interface BMPDaterangeMetadata : BMPMetadata
/// The unique identifier for the metadata.
/// Maps to the ‘ID’ property of the ‘EXT-X-DATERANGE’ spec.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The class associated with the metadata.
/// Maps to the ‘CLASS’ property of the ‘EXT-X-DATERANGE’ spec.
@property (nonatomic, readonly, copy) NSString * _Nullable classLabel;
/// The start date of the date range.
@property (nonatomic, readonly, copy) NSDate * _Nonnull startDate;
/// The end date of the date range. If the receiver is intended to represent information about an
/// instantaneous event, the value of <code>endDate</code> should be equal to the value of <code>startDate</code>.
/// A value of <code>nil</code> for <code>endDate</code> indicates that the <code>endDate</code> is indefinite.
@property (nonatomic, readonly, copy) NSDate * _Nullable endDate;
/// The <code>CUE</code> attribute values from an <code>#EXT-X-DATERANGE</code> tag.
/// According to the HLS specification:
/// <ul>
///   <li>
///     <code>"PRE"</code>: Triggers the <code>DATERANGE</code> tag before playback of the primary asset begins, regardless of where
///     playback starts.
///   </li>
///   <li>
///     <code>"POST"</code>: Triggers the <code>DATERANGE</code> tag after the primary asset has played to completion.
///   </li>
///   <li>
///     <code>"ONCE"</code>: Ensures the <code>DATERANGE</code> tag is triggered only once, even if the trigger point is reached again.
///   </li>
/// </ul>
/// <h2>HLS Interstitials behavior:</h2>
/// In this context, the cue itself corresponds to the interstitial opportunity.
/// note:
/// This property will be an empty array if the <code>CUE</code> attribute is not present on
/// the <code>#EXT-X-DATERANGE</code> tag.
/// <ul>
///   <li>
///     If both <code>"PRE"</code> and <code>"POST"</code> are present, the first-declared value takes precedence:
///     <code>CUE="PRE,POST"</code> is interpreted as <code>"PRE"</code>, and <code>CUE="POST,PRE"</code> as <code>"POST"</code>.
///   </li>
///   <li>
///     <code>"PRE"</code> and <code>"POST"</code> cues are re-playable by default.
///   </li>
///   <li>
///     Adding <code>"ONCE"</code> limits the interstitial to a single trigger per session. This applies
///     to all interstitial types: pre-rolls, mid-rolls, and post-rolls.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nonnull cueingOptions;
/// Initializes an instance of <code>DaterangeMetadata</code> with a collection of metadata entries.
/// \param entries An <code>Array</code> of <code>MetadataEntry</code> objects.
///
/// \param identifier The unique identifier for the metadata.
///
/// \param classLabel The class associated with the metadata.
///
/// \param startDate The start date of the date range.
///
/// \param endDate The end date of the date range. If the receiver is intended to represent information about an
/// instantaneous event, the value of <code>endDate</code> should be equal to the value of <code>startDate</code>.
/// A value of <code>nil</code> for <code>endDate</code> indicates that the <code>endDate</code> is indefinite.
///
/// \param cueingOptions The cueing options indicating when and how an interstitial should play.
///
- (nonnull instancetype)initWithEntries:(NSArray<id <BMPMetadataEntry>> * _Nonnull)entries identifier:(NSString * _Nonnull)identifier classLabel:(NSString * _Nullable)classLabel start:(NSDate * _Nonnull)startDate end:(NSDate * _Nullable)endDate cueingOptions:(NSArray<NSString *> * _Nonnull)cueingOptions OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithEntries:(NSArray<id <BMPMetadataEntry>> * _Nonnull)entries SWIFT_UNAVAILABLE;
@end

@class BMPLoggingConfig;
/// Contains config values to help debugging the SDK.
SWIFT_CLASS_NAMED("DebugConfig")
@interface BMPDebugConfig : NSObject
/// Contains global configuration settings for logging.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, strong) BMPLoggingConfig * _Nonnull logging;)
+ (BMPLoggingConfig * _Nonnull)logging SWIFT_WARN_UNUSED_RESULT;
+ (void)setLogging:(BMPLoggingConfig * _Nonnull)newValue;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Represents a decryption key for a ClearKey DRM config
SWIFT_CLASS_NAMED("DecryptionKey")
@interface BMPDecryptionKey : NSObject <NSCopying>
/// The key identifier for the decryption key in hex string format.
@property (nonatomic, copy) NSString * _Nullable kid;
/// The decryption key in hex string format.
@property (nonatomic, copy) NSString * _Nonnull key;
/// Creates a new <code>DecryptionKey</code> based on the given key identifier (KID) and key.
/// \param kid The key identifier in hex string format.
///
/// \param key The decryption key in hex string format.
///
///
/// returns:
/// A new decryption key initialized with KID and key.
- (nonnull instancetype)initWithKid:(NSString * _Nullable)kid key:(NSString * _Nonnull)key OBJC_DESIGNATED_INITIALIZER;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPDecryptionKey (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

@class NSError;
@class BMPHttpResponse;
@class _BMPError;
/// Provides additional data about a deficiency (error or warning).
SWIFT_CLASS_NAMED("DeficiencyData")
@interface BMPDeficiencyData : NSObject
/// Code for the deficiency
@property (nonatomic, readonly) NSInteger code;
/// Message associated with the deficiency
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
/// Underlying error if available
@property (nonatomic, readonly, strong) NSError * _Nonnull underlyingError;
/// The network response if an Error can be associated with it. For example, when a License Request
/// results with a non-2xx status code.
/// <h2>Limitations:</h2>
/// note:
///
/// <ul>
///   <li>
///     For successful requests, the response includes changes done via <code>NetworkConfig#preprocessHttpResponse</code>.
///   </li>
///   <li>
///     For failed requests, the response is the unmodified server response.
///   </li>
/// </ul>
/// <ul>
///   <li>
///     Only DRM requests (License and Certification) are populating the response for now
///   </li>
/// </ul>
@property (nonatomic, readonly, strong) BMPHttpResponse * _Nullable response;
- (nonnull instancetype)initWithError:(NSError * _Nonnull)error;
- (nonnull instancetype)initWithError:(NSError * _Nonnull)error code:(NSInteger)code;
- (nonnull instancetype)initWithBmpError:(_BMPError * _Nonnull)error;
- (nonnull instancetype)initWithError:(_BMPError * _Nonnull)error response:(BMPHttpResponse * _Nullable)response OBJC_DESIGNATED_INITIALIZER;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPDeficiencyData (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("DestroyEvent")
@interface BMPDestroyEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class NSNumber;
@class BMPDownloadTweaksConfig;
/// Contains config options which can be used to alter the default behaviour of content downloads.
SWIFT_CLASS_NAMED("DownloadConfig")
@interface BMPDownloadConfig : NSObject
/// The lowest media bitrate greater than or equal to this value in bps will be selected for
/// download. If no suitable media bitrate is found or if set to <code>nil</code>, the highest media bitrate will be selected.
@property (nonatomic, strong) NSNumber * _Nullable minimumBitrate;
/// Indicates whether to scan for ClearKey decryption keys and store them for offline playback.
/// Default: <code>true</code>
/// To prevent issues with playback of offline content, make sure that the <code>EXT-X-PLAYLIST-TYPE:VOD</code> tag is
/// present in all variant playlists.
@property (nonatomic) BOOL supportClearKeyContent;
/// Contains tweaks which can be used to alter the default behaviour of a source download.
/// When using one of the tweaks, be aware that they could be removed or changed in behaviour even
/// with minor version updates of the Bitmovin Player SDK. Such changes will be stated in the release
/// notes.
@property (nonatomic, strong) BMPDownloadTweaksConfig * _Nonnull tweaksConfig;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("DownloadFinishedEvent")
@interface BMPDownloadFinishedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) BMPHttpRequestType _Nonnull requestType;
@property (nonatomic, readonly, copy) NSString * _Nonnull downloadType SWIFT_DEPRECATED_MSG("Use requestType instead");
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
@property (nonatomic, readonly, copy) NSURL * _Nullable lastRedirectLocation;
/// The duration how long it took to download the resource
/// note:
///
/// <ul>
///   <li>
///     A value of <code>NAN</code> indicates an unknown duration
///   </li>
/// </ul>
@property (nonatomic, readonly) NSTimeInterval downloadTime;
/// The HTTP Status received from the download
/// note:
///
/// <ul>
///   <li>
///     A value of <code>0</code> indicates an unknown value
///   </li>
/// </ul>
@property (nonatomic, readonly) NSUInteger httpStatus;
/// The size in bytes of the loaded resource
/// note:
///
/// <ul>
///   <li>
///     A value of <code>0</code> indicates an unknown value
///   </li>
/// </ul>
@property (nonatomic, readonly) NSUInteger size;
/// The full network response of the request.
/// note:
///
/// <ul>
///   <li>
///     For successful requests, the response includes changes done via <code>NetworkConfig#preprocessHttpResponse</code>.
///   </li>
///   <li>
///     For failed requests, the response is the unmodified server response.
///   </li>
///   <li>
///     If there was a problem with sending the request, the value might be <code>nil</code>.
///   </li>
/// </ul>
@property (nonatomic, readonly, strong) BMPHttpResponse * _Nullable response;
@property (nonatomic, readonly) BOOL successful;
@property (nonatomic, readonly) BOOL wasSuccessful;
- (nonnull instancetype)initWithRequestType:(BMPHttpRequestType _Nonnull)requestType url:(NSURL * _Nonnull)url downloadTime:(NSTimeInterval)downloadTime httpStatus:(NSUInteger)httpStatus size:(NSUInteger)size success:(BOOL)success lastRedirectLocation:(NSURL * _Nullable)lastRedirectLocation;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class _BMPRequestMetadata;
@interface BMPDownloadFinishedEvent (SWIFT_EXTENSION(BitmovinPlayerCore))
- (nonnull instancetype)initWithRequestMetadata:(_BMPRequestMetadata * _Nonnull)requestMetadata;
@end

/// This config is used as an incubator for experimental features.
/// Tweaks are not officially supported and are not guaranteed to be stable, i.e.
/// their naming, functionality and API can change at any time within the tweaks
/// or when being promoted to an official feature and moved into its final
/// config namespace.
SWIFT_CLASS_NAMED("DownloadTweaksConfig")
@interface BMPDownloadTweaksConfig : NSObject
/// If enabled, tag <code>EXT-X-PLAYLIST-TYPE:VOD</code> will be inserted into downloaded playlists if <code>EXT-X-PLAYLIST-TYPE</code>
/// is missing.
/// Default: <code>false</code>
@property (nonatomic) BOOL shouldInsertPlaylistTypeTagIfMissing;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class NSData;
enum BMPDrmDataType : NSInteger;
SWIFT_CLASS_NAMED("DrmData")
@interface BMPDrmData : NSObject
@property (nonatomic, readonly, copy) NSData * _Nonnull data;
@property (nonatomic, readonly) enum BMPDrmDataType type;
- (nonnull instancetype)initWithData:(NSData * _Nonnull)data type:(enum BMPDrmDataType)type OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithSkdUri:(NSString * _Nonnull)skdUri;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, BMPDrmDataType, "DrmDataType", open) {
  BMPDrmDataTypeSkdUri = 0,
};

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("DrmDataParsedEvent")
@interface BMPDrmDataParsedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// The ‘DrmData’ representing the parsed DRM information.
@property (nonatomic, readonly, strong) BMPDrmData * _Nonnull data;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithData:(BMPDrmData * _Nonnull)data OBJC_DESIGNATED_INITIALIZER;
@end

/// Holds DRM licence information
SWIFT_CLASS_NAMED("DrmLicenseInformation")
@interface BMPDrmLicenseInformation : NSObject
/// The duration in seconds how long this DRM license is valid.
@property (nonatomic, readonly) NSTimeInterval licenseDuration;
/// The duration in seconds how long this DRM license is valid after playback was started for the first time.
@property (nonatomic, readonly) NSTimeInterval playbackDuration;
- (nonnull instancetype)initWithLicenseDuration:(NSTimeInterval)licenseDuration playbackDuration:(NSTimeInterval)playbackDuration;
/// Returns the remaining license duration in seconds
///
/// returns:
/// The remaining license duration in seconds.
- (NSTimeInterval)remainingLicenseDuration SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Provides access to DRM scheme UUIDs.
SWIFT_CLASS_NAMED("DrmSystems")
@interface BMPDrmSystems : NSObject
/// UUID for FairPlay Streaming protection system
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSUUID * _Nonnull fairplayUUID;)
+ (NSUUID * _Nonnull)fairplayUUID SWIFT_WARN_UNUSED_RESULT;
/// UUID for Widevine protection system
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSUUID * _Nonnull widevineUUID;)
+ (NSUUID * _Nonnull)widevineUUID SWIFT_WARN_UNUSED_RESULT;
/// UUID for PlayReady protection system
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSUUID * _Nonnull playReadyUUID;)
+ (NSUUID * _Nonnull)playReadyUUID SWIFT_WARN_UNUSED_RESULT;
/// UUID for ClearKey protection system
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSUUID * _Nonnull clearKeyUUID;)
+ (NSUUID * _Nonnull)clearKeyUUID SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("DurationChangedEvent")
@interface BMPDurationChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) NSTimeInterval duration;
- (nonnull instancetype)initWithDuration:(NSTimeInterval)duration;
- (nonnull instancetype)initWithDuration:(NSTimeInterval)duration timestamp:(NSTimeInterval)timestamp OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPDurationChangedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("DvrWindowExceededEvent")
@interface BMPDvrWindowExceededEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Represents a FairPlay Streaming DRM config.
SWIFT_CLASS_NAMED("FairplayConfig")
@interface BMPFairplayConfig : BMPDrmConfig
/// The URL to the FairPlay Streaming certificate of the license server.
@property (nonatomic, copy) NSURL * _Nullable certificateUrl;
/// A dictionary to specify custom HTTP headers for the license request.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nullable licenseRequestHeaders;
/// A dictionary to specify custom HTTP headers for the certificate request.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nullable certificateRequestHeaders;
/// A block to prepare the data which is sent as the body of the POST license request. As many DRM providers
/// expect different, vendor-specific messages, this can be done using this user-defined block.
@property (nonatomic, copy) NSData * _Nonnull (^ _Nullable prepareMessage)(NSData * _Nonnull, NSString * _Nonnull);
/// A block to prepare the contentId, which is sent to the FairPlay Streaming license server as request body,
/// and which is used to build the SPC data. As many DRM providers expect different, vendor-specific messages, this
/// can be done using this user-defined block. The parameter is the skd:// URI extracted from the HLS manifest
/// (m3u8) and the return value should be the contentID as string.
@property (nonatomic, copy) NSString * _Nonnull (^ _Nullable prepareContentId)(NSString * _Nonnull);
/// A block to prepare the loaded certificate before building SPC data and passing it into the system. This is
/// needed if the server responds with anything else than the certificate, e.g. if the certificate is wrapped into a
/// JSON object. The server response for the certificate request is passed as parameter “as is”.
@property (nonatomic, copy) NSData * _Nonnull (^ _Nullable prepareCertificate)(NSData * _Nonnull);
/// A block to prepare the loaded CKC Data before passing it to the system. This is needed if the server responds
/// with anything else than the license, e.g. if the license is wrapped into a JSON object.
@property (nonatomic, copy) NSData * _Nonnull (^ _Nullable prepareLicense)(NSData * _Nonnull);
/// A block to prepare the URI (without the <code>skd://</code>) from the HLS manifest before passing it to the system.
@property (nonatomic, copy) NSString * _Nonnull (^ _Nullable prepareLicenseServerUrl)(NSString * _Nonnull);
/// A block to prepare the loaded CKC data received by the Sync SPC call to the respective Key Security Module
/// (KSM). This data may contain information about the expiration dates of a DRM license.
@property (nonatomic, copy) BMPDrmLicenseInformation * _Nonnull (^ _Nullable prepareOfflineDrmLicenseInformation)(NSData * _Nonnull);
/// A block to prepare the data which is sent as the body of the POST request for syncing the DRM license
/// information.
@property (nonatomic, copy) NSData * _Nonnull (^ _Nullable prepareSyncMessage)(NSData * _Nonnull, NSString * _Nonnull);
/// A block to provide the license for the given <code>assetId</code>.
/// This should only be used when the license is stored locally.
/// If the block returns <code>nil</code> we will try to fetch the license using the available information in the same
/// <code>FairplayConfig</code> instance. If no <code>certificateUrl</code> is present at this point
/// we will emit a <code>SourceErrorEvent</code>.
/// Use this block for the following use-cases:
/// important:
/// In both use-cases, it’s required that the license is persistable on the device. Playback will fail
/// otherwise.
/// <ul>
///   <li>
///     License caching during playback or for future playback sessions.
///   </li>
///   <li>
///     Providing the license for an already locally available content which can be provided using the
///     <code>SourceType/movpkg</code>
///   </li>
/// </ul>
/// If the provided license is expired playback will fail. License duration handling has to be handled by the
/// application.
@property (nonatomic, copy) NSData * _Nullable (^ _Nullable provideLicenseData)(NSString * _Nonnull) SWIFT_AVAILABILITY(tvos,unavailable);
/// A block to enable custom persisting of license data for the given <code>assetId</code>.
/// Use this block for the following use-cases:
/// important:
/// In both use-cases, it’s required that the license is persistable on the device. Playback will fail
/// otherwise.
/// <ul>
///   <li>
///     To store the license data locally for future playback sessions.
///   </li>
///   <li>
///     To update the license during a playback session if the license requires updating.
///   </li>
/// </ul>
@property (nonatomic, copy) void (^ _Nullable persistLicenseData)(NSString * _Nonnull, NSData * _Nonnull) SWIFT_AVAILABILITY(tvos,unavailable);
/// Creates a new FairPlay Streaming config based on the given license URL and certificate URL.
/// \param licenseUrl The URL to the license server.
///
/// \param certificateURL The URL to the FairPlay Streaming certificate of the license server.
///
///
/// returns:
/// A new FairPlay Streaming config initialized with the given licenseURL and certificateURL.
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl certificateURL:(NSURL * _Nonnull)certificateURL OBJC_DESIGNATED_INITIALIZER;
/// Creates a new FairPlay Streaming config based on the given certificate URL.
/// \param certificateUrl The URL to the FairPlay Streaming certificate of the license server.
///
///
/// returns:
/// A new FairPlay Streaming config initialized with the given certificateURL. The license URL defaults
/// to nil.
- (nonnull instancetype)initWithCertificateURL:(NSURL * _Nonnull)certificateUrl;
/// Creates a new FairPlay Streaming config based on the given <code>provideLicenseData</code> callback.
/// important:
/// It’s required that the license is persistable on the device. Playback will fail otherwise.
/// \param provideLicenseDataCallback A block to provide the license for the given <code>assetId</code>.
///
///
/// returns:
/// A new FairPlay Streaming config initialized with the given provideLicenseData callback. The license
/// and certificate URL are defaulting to nil.
- (nonnull instancetype)initWithProvideLicenseDataCallback:(NSData * _Nullable (^ _Nonnull)(NSString * _Nonnull))provideLicenseDataCallback OBJC_DESIGNATED_INITIALIZER SWIFT_AVAILABILITY(tvos,unavailable);
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl uuid:(NSUUID * _Nonnull)uuid SWIFT_UNAVAILABLE;
@end

@class AVContentKeyRequest;
/// Represents a FairPlay content key request.
/// This object can be used for renewing expiring licenses
/// via <code>SourceDrmFairplayApi/renewExpiringLicense(for:)</code> on <code>Source.drm.fairplay</code> API
SWIFT_CLASS_NAMED("FairplayContentKeyRequest")
@interface BMPFairplayContentKeyRequest : NSObject
/// URI of the key
@property (nonatomic, readonly, copy) NSString * _Nonnull skdUri;
- (nonnull instancetype)initWithSkdUri:(NSString * _Nonnull)skdUri contentKeyRequest:(AVContentKeyRequest * _Nonnull)contentKeyRequest OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("FairplayLicenseAcquiredEvent")
@interface BMPFairplayLicenseAcquiredEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// FairPlay content key request to be potentially used
/// for FairPlay license renewal via <code>SourceDrmFairplayApi/renewExpiringLicense(for:)</code> API
@property (nonatomic, readonly, strong) BMPFairplayContentKeyRequest * _Nonnull contentKeyRequest;
- (nonnull instancetype)initWithContentKeyRequest:(BMPFairplayContentKeyRequest * _Nonnull)contentKeyRequest OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface NSFileManager (SWIFT_EXTENSION(BitmovinPlayerCore))
- (NSArray<NSString *> * _Nonnull)_bmp_findPlaylistsAtContentLocation:(NSURL * _Nonnull)contentLocation SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("FullscreenDisabledEvent")
@interface BMPFullscreenDisabledEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPFullscreenDisabledEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("FullscreenEnabledEvent")
@interface BMPFullscreenEnabledEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPFullscreenEnabledEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("FullscreenEnterEvent")
@interface BMPFullscreenEnterEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPFullscreenEnterEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("FullscreenExitEvent")
@interface BMPFullscreenExitEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPFullscreenExitEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// The <code>FullscreenHandler</code> implementation can be set on a <code>PlayerView</code> using
/// its <code>PlayerView/fullscreenHandler</code> property.
/// The <code>FullscreenHandler</code> acts as a delegate for handling the fullscreen related behaviour of the player view.
SWIFT_PROTOCOL_NAMED("FullscreenHandler")
@protocol BMPFullscreenHandler <NSObject>
/// Is called when the UI want’s to know the current fullscreen state of the UI.
/// Must return true if the UI is in fullscreen, otherwise false.
@property (nonatomic, readonly) BOOL isFullscreen;
/// Is called when the UI want’s to enter fullscreen.
/// This can be the result of either calling <code>PlayerView/enterFullscreen()</code>
/// on a <code>PlayerView</code> or tapping the fullscreen button in Bitmovin’s default UI. When a call to
/// <code>onFullscreenRequested()</code> was successful, <code>FullscreenHandler/isFullscreen</code> must return
/// true after the method returned.
- (void)onFullscreenRequested;
/// Is called when the UI want’s to exit fullscreen.
/// This can be the result of either calling <code>PlayerView/exitFullscreen()</code> on a
/// <code>PlayerView</code> or tapping the fullscreen button in Bitmovin’s default UI. When a call to
/// <code>onFullscreenExitRequested()</code> was successful, <code>FullscreenHandler/isFullscreen</code>
/// must return false after the method returned.
- (void)onFullscreenExitRequested;
@end

/// A config object representing an HTTP request.
SWIFT_CLASS_NAMED("HttpRequest")
@interface BMPHttpRequest : NSObject
/// URL of the request
@property (nonatomic, copy) NSURL * _Nonnull url;
/// HTTP method of the request. Can be “GET” | “POST” | “HEAD”
@property (nonatomic, copy) NSString * _Nonnull method;
/// HTTP request body to send to the server.
@property (nonatomic, copy) NSData * _Nullable body;
- (nonnull instancetype)initWithUrl:(NSURL * _Nonnull)url method:(NSString * _Nonnull)method OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class NSMutableDictionary;
@interface BMPHttpRequest (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, strong) NSMutableDictionary * _Nonnull headers;
@end

/// Represents an HTTP response.
SWIFT_CLASS_NAMED("HttpResponse")
@interface BMPHttpResponse : NSObject
/// Corresponding HTTP request object of the response.
@property (nonatomic, readonly, strong) BMPHttpRequest * _Nonnull request;
/// URL of the actual request. May differ from <code>request.url</code> when redirects have happened.
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
/// HTTP status code of the response.
@property (nonatomic) NSInteger status;
/// HTTP headers of the response.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nonnull headers;
/// HTTP response body.
@property (nonatomic, copy) NSData * _Nullable body;
/// Creates a new HTTP response.
/// \param request Corresponding HTTP request object of the response.
///
/// \param url URL of the actual request. May differ from <code>request.url</code> when redirects have happened.
///
/// \param status HTTP status code of the response.
///
/// \param headers HTTP headers of the response.
///
/// \param body HTTP response body.
///
- (nonnull instancetype)initWithRequest:(BMPHttpRequest * _Nonnull)request url:(NSURL * _Nonnull)url status:(NSInteger)status headers:(NSDictionary<NSString *, NSString *> * _Nonnull)headers body:(NSData * _Nullable)body OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines the IMA Ad attribution UI mode
SWIFT_CLASS_NAMED("ImaAdAttributionUiMode") SWIFT_AVAILABILITY(tvos,unavailable)
@interface BMPImaAdAttributionUiMode : NSObject
/// Default Google IMA SDK behavior, this might change between IMA SDK releases.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) BMPImaAdAttributionUiMode * _Nonnull imaDefault;)
+ (BMPImaAdAttributionUiMode * _Nonnull)imaDefault SWIFT_WARN_UNUSED_RESULT;
/// No attribution element displayed
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) BMPImaAdAttributionUiMode * _Nonnull noAttribution;)
+ (BMPImaAdAttributionUiMode * _Nonnull)noAttribution SWIFT_WARN_UNUSED_RESULT;
/// Attribution element displayed with optional Countdown element
+ (BMPImaAdAttributionUiMode * _Nonnull)attributionWithCountdown:(BOOL)countdown SWIFT_WARN_UNUSED_RESULT;
@property (nonatomic, readonly) BOOL _isDefault;
@property (nonatomic, readonly) BOOL _showAttribution;
@property (nonatomic, readonly) BOOL _showCountdown;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The <code>ImaAdsManager</code> protocol can be used to interact with the underlying Google IMA SDK during ad playback
SWIFT_PROTOCOL_NAMED("ImaAdsManager")
@protocol BMPImaAdsManager
/// List of content time offsets at which ad breaks are scheduled.
/// Array of values in seconds.
/// Empty <code>Array</code> for single ads or if no ad breaks are scheduled.
@property (nonatomic, readonly, copy) NSArray<NSNumber *> * _Nonnull adCuePoints;
/// Performs a clickthrough on the advertisement if the UI was successfully disabled by
/// setting <code>ImaAdvertisingConfig/preferredUiType</code> to <code>ImaUiType/disabled</code>.
- (void)clicked;
/// If an ad break is currently playing, discard it and resume content.
/// Otherwise, ignore the next scheduled ad break.
- (void)discardAdBreak;
@end

enum BMPImaUiType : NSInteger;
/// Contains configuration options to customize behavior for Google IMA SDK.
SWIFT_CLASS_NAMED("ImaAdvertisingConfig")
@interface BMPImaAdvertisingConfig : NSObject
/// Defines ad attribution UI element (e.g. “Ad”) display mode.
/// This property may be ignored for AdSense/AdX ads. For valid values, see <code>ImaAdAttributionUiMode</code>.
/// Default value is <code>ImaAdAttributionUiMode/imaDefault</code>
/// important:
/// This field is ignored on tvOS, where UI elements are unavailable.
@property (nonatomic, strong) BMPImaAdAttributionUiMode * _Nonnull adAttributionUiMode SWIFT_AVAILABILITY(tvos,unavailable);
/// The preferred UI type for IMA ads.
/// Depending on the ad, this preference might be ignored (see <code>ImaUiType/disabled</code> for more information).
/// Default value is <code>ImaUiType/ima</code>.
@property (nonatomic) enum BMPImaUiType preferredUiType SWIFT_AVAILABILITY(tvos,unavailable);
/// Whether the ad should pause when the user taps the screen.
/// If <code>false</code>, user taps are ignored and the ad keeps playing.
/// Default value is <code>true</code>.
@property (nonatomic) BOOL shouldPauseOnTap SWIFT_AVAILABILITY(tvos,unavailable);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// The ImaSettings class stores SDK wide settings.
SWIFT_CLASS_NAMED("ImaSettings")
@interface BMPImaSettings : NSObject <NSCopying>
/// Publisher Provided Identification (PPID) sent with ads request.
@property (nonatomic, copy) NSString * _Nullable ppid;
/// Language specification used for localization. Language must be formatted as
/// a canonicalized IETF BCP 47 language identifier such as would be returned by
/// <code>Locale.preferredLanguages</code>. Setting this property after it has been sent
/// to the IMAAdsLoader will be ignored and a warning will be logged.
@property (nonatomic, copy) NSString * _Nonnull language;
/// Specifies maximum number of redirects after which subsequent redirects will
/// be denied, and the ad load aborted. The number of redirects directly affects
/// latency and thus user experience. This applies to all VAST wrapper ads.
/// If the number of redirects exceeds <code>maxRedirects</code>, the ad request will fail with
/// error code 302. The default value is <code>4</code>.
@property (nonatomic) NSUInteger maxRedirects;
/// Enable background audio playback for the SDK. The default value is <code>false</code>.
@property (nonatomic) BOOL enableBackgroundPlayback;
/// Specifies whether to update the <code>MPNowPlayingInfoCenter</code> content with the
/// title “Advertisement”. If disabled, <code>MPNowPlayingInfoCenter</code> is untouched.
/// The default value is <code>false</code>.
/// note:
/// When <code>NowPlayingConfig/isNowPlayingInfoEnabled</code> is <code>true</code>, this flag is automatically
/// treated as <code>true</code>.
@property (nonatomic) BOOL disableNowPlayingInfo SWIFT_DEPRECATED_MSG("\n         To enable the Now Playing information use `NowPlayingConfig.isNowPlayingInfoEnabled`\n         ");
/// The partner specified player version that is integrating with the SDK.
@property (nonatomic, copy) NSString * _Nullable playerVersion;
/// The session ID to identify a single user session. This should be a UUID.
/// It is used exclusively for frequency capping across the user session.
@property (nonatomic, copy) NSString * _Nullable sessionId;
/// Controls whether Same App Key is enabled. The value set persists across app sessions.
/// The key is enabled by default. This property is not available on tvOS.
@property (nonatomic) BOOL sameAppKeyEnabled SWIFT_AVAILABILITY(tvos,unavailable);
+ (BMPImaSettings * _Nonnull)_createWithPpid:(NSString * _Nullable)ppid language:(NSString * _Nonnull)language maxRedirects:(NSUInteger)maxRedirects enableBackgroundPlayback:(BOOL)enableBackgroundPlayback disableNowPlayingInfo:(BOOL)disableNowPlayingInfo playerVersion:(NSString * _Nullable)playerVersion sessionId:(NSString * _Nullable)sessionId sameAppKeyEnabled:(BOOL)sameAppKeyEnabled SWIFT_WARN_UNUSED_RESULT SWIFT_AVAILABILITY(tvos,unavailable);
+ (BMPImaSettings * _Nonnull)_createWithPpid:(NSString * _Nullable)ppid language:(NSString * _Nonnull)language maxRedirects:(NSUInteger)maxRedirects enableBackgroundPlayback:(BOOL)enableBackgroundPlayback disableNowPlayingInfo:(BOOL)disableNowPlayingInfo playerVersion:(NSString * _Nullable)playerVersion sessionId:(NSString * _Nullable)sessionId SWIFT_WARN_UNUSED_RESULT SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The available UI types for IMA during ad playback, used in the <code>ImaAdvertisingConfig</code>.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPImaUiType, "ImaUiType", open) {
/// Disables all UI elements if the played ad allows hiding the UI. This can be useful when building a custom ad UI.
/// Allowing a hidden IMA UI in a VAST manifest is done via the <code>UiHideable</code> property in the <code>Extension</code> with type
/// <code>uiSettings</code>. For more information see this guide: <a href="https://developers.google.com/interactive-media-ads/docs/sdks/ios/client-side/custom-ui">https://developers.google.com/interactive-media-ads/docs/sdks/ios/client-side/custom-ui</a>
  BMPImaUiTypeDisabled = 0,
/// IMA is handling the UI elements.
/// Further customization may be done via <code>ImaAdvertisingConfig/adAttributionUiMode</code>.
  BMPImaUiTypeIma = 1,
};

/// Protocol providing access to custom attributes from interstitial metadata.
/// Custom attributes can come from:
/// <ul>
///   <li>
///     X- prefixed properties in HLS manifest <code>EXT-X-DATERANGE</code> tags
///   </li>
///   <li>
///     custom attributes from an ASSET-LIST
///   </li>
///   <li>
///     custom attributes from the asset metadata within an ASSET-LIST
///   </li>
/// </ul>
/// See <code>InterstitialsConfig/customAttributesMapping</code> for usage.
SWIFT_PROTOCOL_NAMED("InterstitialMappingData")
@protocol BMPInterstitialMappingData
/// Dictionary containing custom attributes from interstitial metadata.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nonnull customAttributes;
@end

/// Provides access to asset-level metadata and custom attributes within an ASSET-LIST.
SWIFT_CLASS_NAMED("InterstitialAssetData")
@interface BMPInterstitialAssetData : NSObject <BMPInterstitialMappingData>
/// The URL of the interstitial asset.
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
/// Custom attributes from the asset metadata.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nonnull customAttributes;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Provides access to asset list-level metadata and custom attributes.
/// Contains information from the JSON Asset List file that defines a collection of interstitial assets.
SWIFT_CLASS_NAMED("InterstitialAssetListData")
@interface BMPInterstitialAssetListData : NSObject <BMPInterstitialMappingData>
/// Custom attributes from the Asset List JSON.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nonnull customAttributes;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol BMPInterstitialTrackingRegistry;
/// Object for mapping custom attributes to interstitial related information such as tracking events.
SWIFT_PROTOCOL_NAMED("InterstitialCustomAttributesMappingRegistry")
@protocol BMPInterstitialCustomAttributesMappingRegistry
/// Object for registering tracking events.
/// URLs are automatically merged across invocations for the same interstitial asset.
@property (nonatomic, readonly, strong) id <BMPInterstitialTrackingRegistry> _Nonnull tracking;
/// The click-through URL to open when the interstitial is clicked.
/// note:
/// There can only be one click-through URL per interstitial asset
/// Default is <code>nil</code>.
@property (nonatomic, copy) NSURL * _Nullable clickThroughUrl;
@end

/// Provides access to interstitial-level metadata and custom attributes.
/// Contains information from the HLS manifest DATE-RANGE tag that defines the interstitial.
SWIFT_CLASS_NAMED("InterstitialData")
@interface BMPInterstitialData : NSObject <BMPInterstitialMappingData>
/// The unique identifier of the interstitial.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// Custom attributes from the DATE-RANGE tag (X- prefixed properties).
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nonnull customAttributes;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Represents a macro in interstitial tracking URLs that can be replaced with custom values.
/// Macros are placeholders in tracking URLs (e.g., <code>[CUSTOM_VALUE]</code>) that get replaced
/// with actual values during playback. Use <code>InterstitialsConfig/macroValueProvider</code> to provide custom values.
SWIFT_CLASS_NAMED("InterstitialMacro")
@interface BMPInterstitialMacro : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Represents a tracking event for interstitial playback.
/// Use this to register tracking URLs that should be fired when specific events occur during interstitial playback.
SWIFT_CLASS_NAMED("InterstitialTrackingEvent")
@interface BMPInterstitialTrackingEvent : NSObject
/// The tracking URIs to fire when this event occurs.
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nonnull uris;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Enumeration of supported tracking event triggers during interstitial playback.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPInterstitialTrackingEventTrigger, "InterstitialTrackingEventTrigger", open) {
/// Player was muted.
  BMPInterstitialTrackingEventTriggerMute = 0,
/// Player was unmuted.
  BMPInterstitialTrackingEventTriggerUnmute = 1,
/// Playback was paused.
  BMPInterstitialTrackingEventTriggerPause = 2,
/// Playback was resumed.
  BMPInterstitialTrackingEventTriggerResume = 3,
/// Interstitial player has buffered enough data to start playing.
  BMPInterstitialTrackingEventTriggerLoaded = 4,
/// Interstitial playback started.
  BMPInterstitialTrackingEventTriggerStart = 5,
/// Interstitial playback progressed in time.
  BMPInterstitialTrackingEventTriggerProgress = 6,
/// First quartile was reached.
  BMPInterstitialTrackingEventTriggerFirstQuartile = 7,
/// Midpoint was reached.
  BMPInterstitialTrackingEventTriggerMidpoint = 8,
/// Third quartile was reached.
  BMPInterstitialTrackingEventTriggerThirdQuartile = 9,
/// Interstitial playback finished.
  BMPInterstitialTrackingEventTriggerComplete = 10,
/// An error occurred.
  BMPInterstitialTrackingEventTriggerError = 11,
/// An impression occurred.
  BMPInterstitialTrackingEventTriggerImpression = 12,
/// Interstitial was clicked.
  BMPInterstitialTrackingEventTriggerClicked = 13,
/// Fires when the interstitial is skipped before completion.
  BMPInterstitialTrackingEventTriggerSkip = 14,
};

/// Registry for managing tracking events for interstitials.
/// Use this to register tracking URLs that should be fired when specific events occur during interstitial playback.
/// A single <code>InterstitialTrackingRegistry</code> instance exists per interstitial asset and is shared across its
/// interstitial (EXT-X-DATERANGE) and ASSET-LIST invocations. All registrations merge within that asset.
SWIFT_PROTOCOL_NAMED("InterstitialTrackingRegistry")
@protocol BMPInterstitialTrackingRegistry
/// Registers multiple tracking events for a specific trigger.
/// \param trackingEvents The tracking events to register
///
/// \param for The event trigger that will fire these tracking events
///
- (void)registerWithTrackingEvents:(NSArray<BMPInterstitialTrackingEvent *> * _Nonnull)trackingEvents for:(enum BMPInterstitialTrackingEventTrigger)for_;
/// Registers a single tracking event for a specific trigger.
/// \param trackingEvent The tracking event to register
///
/// \param for The event trigger that will fire this tracking event
///
- (void)registerWithTrackingEvent:(BMPInterstitialTrackingEvent * _Nonnull)trackingEvent for:(enum BMPInterstitialTrackingEventTrigger)for_;
/// Returns all tracking events registered for a specific trigger.
/// \param for The event trigger to query
///
///
/// returns:
/// Array of tracking events registered for the trigger
- (NSArray<BMPInterstitialTrackingEvent *> * _Nonnull)trackingEventsFor:(enum BMPInterstitialTrackingEventTrigger)for_ SWIFT_WARN_UNUSED_RESULT;
@end

/// Configuration for HLS interstitials functionality.
SWIFT_CLASS_NAMED("InterstitialsConfig")
@interface BMPInterstitialsConfig : NSObject
/// Callback to map custom attributes to interstitial relevant information such as tracking information.
/// See <code>InterstitialCustomAttributesMappingRegistry</code> for supported mappings.
/// This callback is invoked once for each level that contains custom attributes.
/// Depending on the interstitial type, it may be called multiple times per interstitial:
/// <ul>
///   <li>
///     <code>X-ASSET-URI</code>:
///     <ul>
///       <li>
///         Called <em>once</em> with <code>InterstitialData</code> containing custom attributes from the <code>EXT-X-DATERANGE</code> tag.
///       </li>
///     </ul>
///   </li>
///   <li>
///     <code>X-ASSET-LIST</code>:
///     <ul>
///       <li>
///         Called <em>up to three times</em> per interstitial asset (only when attributes are present at each level):
///         <ol>
///           <li>
///             <code>InterstitialData</code> for attributes from the <code>EXT-X-DATERANGE</code> tag
///           </li>
///           <li>
///             <code>InterstitialAssetListData</code> for attributes from the root of the Asset List JSON
///           </li>
///           <li>
///             <code>InterstitialAssetData</code> for attributes from an individual asset entry within the Asset List JSON
///           </li>
///         </ol>
///       </li>
///       <li>
///         If there are multiple Assets within an Asset List, the data for <code>InterstitialData</code>
///         and <code>InterstitialAssetListData</code> will be the same for each.
///       </li>
///     </ul>
///   </li>
/// </ul>
/// The callback is only invoked for levels that contain custom attributes. If a level has no custom attributes,
/// the callback is not invoked for that level.
/// note:
/// By default, this property is <code>nil</code>, meaning no tracking is performed. To enable tracking in accordance
/// with the SVTA <code>X-AD-CREATIVE-SIGNALING</code> specification, use
/// <code>CustomAttributesMappingPresets/adCreativeSignaling</code>.
/// You can also provide a custom handler to implement your own mapping logic or extend the SVTA preset.
/// Async resolving of tracking urls (e.g. using the <code>$remote</code> property from SVTA spec) is currently not supported.
/// Example (enable SVTA tracking):
/// \code
/// playerConfig.interstitialsConfig.customAttributesMapping = InterstitialsConfig.CustomAttributesMappingPresets
///     .adCreativeSignaling
///
/// \endcodeExample (custom tracking implementation):
/// \code
/// playerConfig.interstitialsConfig.customAttributesMapping = { mappingData, mappingRegistry in
///     guard let adCreativeSignaling = mappingData.customAttributes["X-AD-CREATIVE-SIGNALING"] as? [String: Any],
///         let payload = adCreativeSignaling["payload"] as? [[String: Any]] else {
///         return
///     }
///
///     if let clickThroughUri = payload.first?["clickThrough"] as? String {
///         mappingRegistry.clickThroughUrl = URL(string: clickThroughUri)
///     }
///
///     if let trackingData = payload.first?["tracking"] as? [[String: Any]] {
///         trackingData.forEach { tracking in
///             guard let type = tracking["type"] as? String,
///                   let urls = tracking["urls"] as? [String] else {
///                 return
///             }
///
///             switch type {
///             case "impression":
///                 mappingRegistry.tracking.register(
///                     trackingEvent: InterstitialTrackingEvent(uris: urls),
///                     for: .impression
///                 )
///             default:
///                 break
///             }
///         }
///     }
/// }
///
/// \endcode
@property (nonatomic, copy) void (^ _Nullable customAttributesMapping)(id <BMPInterstitialMappingData> _Nonnull, id <BMPInterstitialCustomAttributesMappingRegistry> _Nonnull);
/// Value provider for macros.
/// The returned values are used to replace the macros in the tracking URLs.
/// See <code>InterstitialMacroValueProvider</code> for details.
/// By default, this property is <code>nil</code>, meaning no macro replacement is performed.
/// note:
/// The value provider is called for each macro in the tracking URLs.
@property (nonatomic, copy) NSArray<NSString *> * _Nonnull (^ _Nullable macroValueProvider)(BMPInterstitialMacro * _Nonnull);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Provides default implementations for common HLS Interstitials tracking specifications.
SWIFT_CLASS_NAMED("CustomAttributesMappingPresets")
@interface BMPCustomAttributeMappingPresets : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
/// Default implementation for mapping SVTA’s <code>X-AD-CREATIVE-SIGNALING</code> specification.
/// Automatically decodes and maps tracking events and click-through URLs according to
/// the SVTA Ad Creative Signaling specification.
/// Reference: https://www.svta.org/product/svta2053-2/
/// Limitation: Async resolving of tracking urls using the <code>$remote</code> property is currently not supported.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) void (^ _Nonnull adCreativeSignaling)(id <BMPInterstitialMappingData> _Nonnull, id <BMPInterstitialCustomAttributesMappingRegistry> _Nonnull);)
+ (void (^ _Nonnull)(id <BMPInterstitialMappingData> _Nonnull, id <BMPInterstitialCustomAttributesMappingRegistry> _Nonnull))adCreativeSignaling SWIFT_WARN_UNUSED_RESULT;
@end

@class BMPSubtitleTrack;
/// Provides the possibility to overwrite the labels which are automatically
/// assigned for different types of tracks.
SWIFT_CLASS_NAMED("LabelingConfig")
@interface BMPLabelingConfig : NSObject
/// An optional block which gets a <code>SubtitleTrack</code> as parameter and returns the desired label
/// which should be used for that track.
@property (nonatomic, copy) NSString * _Nonnull (^ _Nullable subtitleLabel)(BMPSubtitleTrack * _Nonnull);
/// An optional block which gets a <code>AudioTrack</code> as parameter and returns the desired label
/// which should be used for that track.
@property (nonatomic, copy) NSString * _Nonnull (^ _Nullable audioLabel)(BMPAudioTrack * _Nonnull);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol _BMPLatencyApiDelegate;
/// Provides the means to manage latency for live-streams.
/// Accessible through player’s <code>BMPPlayer/latency</code> property.
/// note:
/// Disable <code>TweaksConfig/isCustomHlsLoadingEnabled</code>  when intending to play HLS-LL streams
/// below iOS and tvOS 17. Due to platform limitations, HLS-LL streams are not supported there while
/// this property is enabled.
/// This API is not supported during casting.
SWIFT_CLASS_NAMED("LatencyApi")
@interface BMPLatencyApi : NSObject
@property (nonatomic, weak) id <_BMPLatencyApiDelegate> _Nullable _delegate;
/// The current latency in seconds.
/// note:
/// This API is not supported during casting.
///
/// returns:
/// The current latency in seconds, or <code>.nan</code> in case the asset is either a VoD or does not have any
/// mapped date via the <code>EXT-X-PROGRAM-DATE-TIME</code> tag.
@property (nonatomic, readonly) NSTimeInterval currentLatency;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Contains additional license data returned from the license server.
SWIFT_CLASS_NAMED("LicenseData")
@interface BMPLicenseData : NSObject
/// The <code>AnalyticsLicenseData</code> part from the license call response.
@property (nonatomic, readonly, strong) BMPAnalyticsLicenseData * _Nonnull analytics;
- (nonnull instancetype)initWithAnalytics:(BMPAnalyticsLicenseData * _Nonnull)analytics OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("LicenseValidatedEvent")
@interface BMPLicenseValidatedEvent : BMPPlayerEvent
/// The additional license data that is returned from the license server.
@property (nonatomic, readonly, strong) BMPLicenseData * _Nonnull data;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithData:(BMPLicenseData * _Nonnull)data OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Configuration object for the LinearAd UI.
/// In case Bitmovin Player UI is used, message placeholders such as:
/// <code>{remainingTime}</code>, <code>{adDuration}</code> or <code>{playedTime}</code> are available to customize the ad messages.
/// When using the System UI, only <code>{remainingTime}</code> is supported.
/// Example:
/// \code
/// let linearAdUiConfig = LinearAdUiConfig()
/// linearAdUiConfig.message = "This ad will end in {remainingTime}"
/// linearAdUiConfig.untilSkippableMessage = "This ad is skippable in {remainingTime}"
/// linearAdUiConfig.skippableMessage = "You can skip this ad now."
///
/// // Create an `AdItem` with one `AdSource` of type `.bitmovin`
/// let adItem = AdItem(
///    adSources: [AdSource(tag: adTagUrl, ofType: .bitmovin)],
///    // Configure the ad as a pre-roll ad
///    atPosition: "pre",
///    // Provide a LinearAdUiConfig instance to customize the ad UI messages
///    linearAdUiConfig: linearAdUiConfig
/// )
///
/// \endcode
SWIFT_CLASS_NAMED("LinearAdUiConfig")
@interface BMPLinearAdUiConfig : NSObject
/// Specifies whether the ad needs a UI.
/// Default is <code>true</code>
@property (nonatomic) BOOL requestsUi;
/// Message that gets displayed while an ad is active.
/// Default is <code>nil</code>.
@property (nonatomic, copy) NSString * _Nullable message;
/// Message that gets displayed while a skippable ad is not yet skippable.
/// Default is <code>nil</code>.
@property (nonatomic, copy) NSString * _Nullable untilSkippableMessage;
/// Message that gets displayed after the ad becomes skippable.
/// Default is <code>nil</code>.
@property (nonatomic, copy) NSString * _Nullable skippableMessage;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPLinearAdUiConfig (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// Contains config values regarding the behaviour when playing live streams.
SWIFT_CLASS_NAMED("LiveConfig") SWIFT_DEPRECATED_MSG("\n    Configuration for live streams has moved to the source-based `SourceLiveConfig`. Use\n    `SourceConfig.liveConfig` instead.\n    ")
@interface BMPLiveConfig : NSObject
/// The minimum buffer depth of a stream needed to enable time shifting.
/// When the internal value for the maximal possible timeshift is lower than this value, timeshifting should be
/// disabled. That means Player.maxTimeShift returns 0 in that case.
/// This value should always be non-positive value, default value is -40
@property (nonatomic) NSTimeInterval minTimeshiftBufferDepth SWIFT_DEPRECATED_MSG("\n        Configuration for live streams has moved to the source-based `SourceLiveConfig`. Use\n        `SourceConfig.liveConfig.minTimeshiftBufferDepth` instead.\n        ");
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Contains the different loading states a <code>Source</code> can be in.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPLoadingState, "LoadingState", open) {
/// The source is unloaded.
  BMPLoadingStateUnloaded = 0,
/// The source is currently loading.
  BMPLoadingStateLoading = 1,
/// The source is loaded.
  BMPLoadingStateLoaded = 2,
};

/// Represents one single log entry
SWIFT_CLASS_NAMED("LogEntry")
@interface BMPLogEntry : NSObject
/// The log message
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
/// The log level
@property (nonatomic, readonly) enum BMPLogLevel level;
/// The entity or top-level API that sends the log e.g. “Player”, “Source”, “PlayerView”, “Offline”
@property (nonatomic, readonly, copy) NSString * _Nonnull sender;
/// The additional data that can be provided for a deficiency.
/// This data can only be passed for warning and error level logs.
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
/// The date when the log entry was created
@property (nonatomic, readonly, copy) NSDate * _Nonnull currentDate;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Provides the different log levels for logging an entry
typedef SWIFT_ENUM_NAMED(NSInteger, BMPLogLevel, "LogLevel", open) {
/// Provides detailed information, primarily for debugging purposes
  BMPLogLevelVerbose = -1,
/// Indicates something has happened and is purely informative
  BMPLogLevelInfo = 0,
/// Indicates something unexpected happened, however the player can continue to function
  BMPLogLevelWarning = 1,
/// Indicates an issue that disrupts proper functioning of the player
  BMPLogLevelError = 2,
};

/// This component enables configuration of logging globally in the SDK through assigning a <code>logger</code>.
/// Logging can be configured through the assigned <code>logger</code> in multiple ways.
/// By setting the <code>logger</code> to <code>nil</code> logging can be disabled. A minimum log level is also set
/// in the assigned <code>logger</code>.
/// The minimum log level is used to filter log output.
/// The default value for the <code>logger</code> is an instance of <code>ConsoleLogger</code>.
/// Instead of the <code>ConsoleLogger</code>, a custom logger can be assigned for receiving log entries.
/// A custom logger would need to apply its own filtering based on level.
/// This level-based filtering is applied by default in the <code>ConsoleLogger</code>.
/// To configure logging, access this config via <code>DebugConfig/logging</code> property on <code>DebugConfig</code>.
/// Refer to <code>Logger</code>, <code>LogLevel</code>, <code>LogEntry</code>, <code>ConsoleLogger</code> and <code>DebugConfig</code> for more details.
SWIFT_CLASS_NAMED("LoggingConfig")
@interface BMPLoggingConfig : NSObject
/// The logger that receives log entries and can optionally provide log output.
/// Default value is an instance of <code>ConsoleLogger</code> which prints log entries to the console.
/// Set the logger to <code>nil</code> to disable logging completely.
@property (nonatomic, strong) id <BMPLogger> _Nullable logger;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("MetadataEvent")
@interface BMPMetadataEvent : BMPPlayerEvent
/// The type of the associated Metadata
@property (nonatomic, readonly) enum BMPMetadataType metadataType;
/// The metadata object
/// To get the typed metadata object use a cast like:
/// \code
/// switch event.metadata {
/// case let metadata as DaterangeMetadata:
///     // Daterange Metadata
/// case let metadata as Id3Metadata:
///     // ID3 Metadata
/// case let metadata as ScteMetadata:
///     // Scte Metadata
/// }
///
/// \endcodePossible types are:
/// <ul>
///   <li>
///     <code>DaterangeMetadata</code>
///   </li>
///   <li>
///     <code>ScteMetadata</code>
///   </li>
///   <li>
///     <code>Id3Metadata</code>
///   </li>
/// </ul>
@property (nonatomic, readonly, strong) BMPMetadata * _Nonnull metadata;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithMetadata:(BMPMetadata * _Nonnull)metadata type:(enum BMPMetadataType)type OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("MetadataParsedEvent")
@interface BMPMetadataParsedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The type of the associated Metadata
@property (nonatomic, readonly) enum BMPMetadataType metadataType;
/// The metadata object
/// To get the typed metadata object use a cast like:
/// \code
/// switch event.metadata {
/// case let metadata as DaterangeMetadata:
///     // Daterange Metadata
/// case let metadata as Id3Metadata:
///     // ID3 Metadata
/// case let metadata as ScteMetadata:
///     // Scte Metadata
/// }
///
/// \endcodePossible types are:
/// <ul>
///   <li>
///     <code>DaterangeMetadata</code>
///   </li>
///   <li>
///     <code>ScteMetadata</code>
///   </li>
///   <li>
///     <code>Id3Metadata</code>
///   </li>
/// </ul>
@property (nonatomic, readonly, strong) BMPMetadata * _Nonnull metadata;
- (nonnull instancetype)initWithMetadata:(BMPMetadata * _Nonnull)metadata type:(enum BMPMetadataType)type OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, BMPMetadataType, "MetadataType", open) {
  BMPMetadataTypeNone = 0,
  BMPMetadataTypeID3 = 1,
  BMPMetadataTypeEMSG = 2,
  BMPMetadataTypeDaterange = 3,
  BMPMetadataTypeScte = 4,
};

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("MutedEvent")
@interface BMPMutedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface NSString (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, readonly, strong) NSString * _Nonnull _bmp_md5;
@end

enum BMPSourceType : NSInteger;
@interface NSURL (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, readonly) BOOL _bmp_isHlsUrl;
@property (nonatomic, readonly) BOOL _bmp_isProgressiveUrl;
@property (nonatomic, readonly) BOOL _bmp_isDashUrl;
@property (nonatomic, readonly) BOOL _bmp_isMovpkgUrl;
@property (nonatomic, readonly) enum BMPSourceType _bmp_sourceType;
@end

@interface NSURLRequest (SWIFT_EXTENSION(BitmovinPlayerCore))
- (BMPHttpRequest * _Nullable)_toBitmovinHttpRequest SWIFT_WARN_UNUSED_RESULT;
@end

@protocol BMPPreprocessHttpRequestDelegate;
/// The network config gives the ability to influence network requests.
SWIFT_CLASS_NAMED("NetworkConfig")
@interface BMPNetworkConfig : NSObject
/// Called before an HTTP request is made.
/// This delegate allows modifying the request parameters before the request is sent.
/// <h1>Limitations</h1>
/// note:
/// Implement the <code>PreprocessHttpRequestDelegate</code> protocol to customize the preprocessing of
/// supported HTTP requests.
/// <ul>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeKeyHlsAes</code> are not supported.
///   </li>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeMediaSubtitles</code> are only supported for side-loaded subtitles.
///   </li>
/// </ul>
@property (nonatomic, weak) id <BMPPreprocessHttpRequestDelegate> _Nullable preprocessHttpRequestDelegate SWIFT_DEPRECATED_MSG("Use preprocessHttpRequest instead.");
/// Called before an HTTP request is made.
/// This property can be used to modify the request parameters before the request is sent.
/// <ul>
///   <li>
///     Usage Example:
///   </li>
/// </ul>
/// \code
/// networkConfig.preprocessHttpRequest = { type, request, completionHandler in
///     var modifiedRequest = httpRequest
///
///     // Modify the request based on the type
///     switch type {
///     case .drmLicenseFairplay:
///         // Example modification for DRM requests
///         modifiedRequest.headers["Authorization"] = "Bearer someAccessToken"
///     case .manifestHlsMaster:
///         // Example modification for HLS Playlist requests
///         modifiedRequest.url = modifiedRequest.url.appendingPathComponent("modified")
///     default:
///         break
///     }
///
///     // Call the completion handler with the modified request
///     completionHandler(modifiedRequest)
/// }
///
/// \endcode<h1>Limitations</h1>
/// note:
/// Refer to the <code>PreprocessHttpRequestHandler</code> documentation for additional information.
/// <ul>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeKeyHlsAes</code> are not supported.
///   </li>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeMediaSubtitles</code> are only supported for side-loaded subtitles.
///   </li>
/// </ul>
@property (nonatomic, copy) void (^ _Nullable preprocessHttpRequest)(BMPHttpRequestType _Nonnull, BMPHttpRequest * _Nonnull, void (^ _Nonnull)(BMPHttpRequest * _Nonnull));
/// Called when an HTTP request has failed. This property allows you to override the default
/// retry behavior with a custom handler.
/// A request is considered failed if the HTTP response status code is not within the 200-299 range:
/// \code
/// let success = response.statusCode >= 200 && response.statusCode < 300
///
/// \endcode<ul>
///   <li>
///     Usage Example:
///   </li>
/// </ul>
/// \code
/// let retryHttpRequestHandler = { requestType, retryCount, response, retryHandler, abortHandler in
///     // Retry 3 times
///     guard retryCount <= 3 else {
///         // Abort retrying when threshold was reached
///         abortHandler()
///         return
///     }
///
///     // Customize delay for the next retry. For instance use exponential backoff:
///     let retryDelay: TimeInterval = exp(0.25 * Double(retryCount))
///     // Retry the original request again
///     retryHandler(retryDelay, response.request)
/// }
///
/// \endcode<em>Default Behavior</em>
/// If no custom handler is provided, the default retry logic will be applied:
/// <ul>
///   <li>
///     The request will be retried up to a maximum of 3 times.
///   </li>
///   <li>
///     The delay between retries is calculated using a custom exponential backoff formula, with a maximum
///     delay of 5 seconds:
///     <ul>
///       <li>
///         For each retry attempt, the delay is determined by the formula <code>exp(0.25 * retryCount)</code>, which produces
///         a gradually increasing delay.
///       </li>
///       <li>
///         The delay is capped at 5 seconds to ensure retries occur within a reasonable timeframe.
///       </li>
///     </ul>
///   </li>
///   <li>
///     If the retry count exceeds 3 attempts, the request will not be retried, and the <code>abortHandler</code> will be
///     called.
///   </li>
/// </ul>
/// <em>Customization</em>
/// When a custom <code>retryHttpRequest</code> handler is set, no internal retry handling is done at all. The custom handler
/// needs to manage all retries. Some considerations for implementing your own handler include:
/// <ul>
///   <li>
///     Ensure to set a maximum number of allowed retries to avoid retrying an unreasonable number of times.
///   </li>
///   <li>
///     Be aware of an underlying <code>AVFoundation</code> limit of approximately 20 seconds for performing retries. If a
///     failed request is not successfully retried within that timeframe, an error will occur. Within that 20-second
///     window, the number of retries that can be performed is unlimited.
///   </li>
/// </ul>
/// <h1>Limitations</h1>
/// note:
/// Refer to the <code>RetryHttpRequestHandler</code> documentation for detailed usage examples and
/// additional information.
/// <ul>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeKeyHlsAes</code> are not supported.
///   </li>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeMediaSubtitles</code> are only supported for side-loaded subtitles.
///   </li>
/// </ul>
@property (nonatomic, copy) void (^ _Nullable retryHttpRequest)(BMPHttpRequestType _Nonnull, NSInteger, BMPHttpResponse * _Nonnull, void (^ _Nonnull)(NSTimeInterval, BMPHttpRequest * _Nonnull), void (^ _Nonnull)(void));
/// Called after an HTTP response is received.
/// This property can be used to access or change properties of the response before it gets into the player.
/// <ul>
///   <li>
///     Usage Example:
///   </li>
/// </ul>
/// \code
/// let preprocessHttpResponseHandler: NetworkConfig.PreprocessHttpResponseHandler = { type, response, completionHandler in
///     var modifiedResponse = response
///
///     // Modify the response as needed based on the request type
///     switch type {
///     case .manifestHlsVariant:
///         modifiedResponse = modifyResponseForHlsVariantType(response)
///     case .mediaSubtitles:
///         modifiedResponse = modifyResponseForMediaPosterType(response)
///     default:
///         break
///     }
///
///     // Call the completion handler with the modified response
///     completionHandler(modifiedResponse)
/// }
///
/// \endcode<h1>Limitations</h1>
/// note:
/// Refer to the <code>PreprocessHttpResponseHandler</code> documentation for a detailed usage example
/// and additional information.
/// <ul>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeKeyHlsAes</code> are not supported.
///   </li>
///   <li>
///     Requests of type <code>BMPHttpRequestTypeMediaSubtitles</code> are only supported for side-loaded subtitles.
///   </li>
///   <li>
///     This handler is not called in case the HTTP request fails.
///   </li>
/// </ul>
@property (nonatomic, copy) void (^ _Nullable preprocessHttpResponse)(BMPHttpRequestType _Nonnull, BMPHttpResponse * _Nonnull, void (^ _Nonnull)(BMPHttpResponse * _Nonnull));
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Configures the current Now Playing information for the application. This information will be displayed
/// wherever Now Playing information typically appears, such as the lock screen
/// and inside the control center.
SWIFT_CLASS_NAMED("NowPlayingConfig")
@interface BMPNowPlayingConfig : NSObject
/// Enable the default behaviour of Now Playing information to be displayed
/// on the lock-screen and inside the control center.
/// Default is <code>false</code>.
/// For a detailed list of the supported features in the <em>default behaviour</em>,
/// check the <em>Default Supported Features</em> section.
/// note:
/// Enabling this flag will automatically treat <code>ImaSettings/disableNowPlayingInfo</code> as <code>true</code>.
/// note:
/// Enabling this flag will automatically treat <code>TweaksConfig/updatesNowPlayingInfoCenter</code> as <code>false</code>.
/// <h1>Limitations</h1>
/// <ul>
///   <li>
///     Currently the current Now Playing information is disabled during casting.
///   </li>
/// </ul>
/// <h1>Known issues</h1>
/// <ul>
///   <li>
///     There is an unexpected behaviour when using the IMA SDK. The Google IMA SDK adds its own <code>MPRemoteCommand</code>
///     for play/pause right when the ad starts loading (not when it started playing). Within this time window
///     (approximately around 10 seconds) it’s possible that the Ad and the main content are playing at the same time
///     when a user interacts with the Now Playing feature.
///   </li>
/// </ul>
/// <h1>Customization</h1>
/// It is possible to customize or add additional information. Please ensure that your code is executed
/// after the <code>BMPPlayer</code> instance has been created.
/// <h2>Adding a Command</h2>
/// To add an additional command to the <code>MPRemoteCommandCenter</code>, simply add a new target to the
/// command you want to show. In this example we add a <code>likeCommand</code>:
/// \code
/// // Get the shared MPRemoteCommandCenter
/// let commandCenter = MPRemoteCommandCenter.shared()
///
/// // Add handler for the new Command
/// commandCenter.likeCommand.addTarget { event in
///     // React to the like button interaction
///     return .success
/// }
///
/// \endcode<h2>Removing a Command</h2>
/// It is possible to remove one of the commands we add per default by removing all targets from a command.
/// \code
/// // Get the shared MPRemoteCommandCenter
/// let commandCenter = MPRemoteCommandCenter.shared()
///
/// // Remove all registered targets
/// commandCenter.skipBackwardCommand.removeTarget(nil)
///
/// \endcodeThe list of supported commands per default can be found at the
/// <em>Default Supported Features</em> section.
/// <h2>Customizing a Command</h2>
/// Some commands, such as the <code>skipBackwardsCommand</code>, have additional customization options.
/// For example it’s possible to change the skip interval to a custom value:
/// \code
/// // Get the shared MPRemoteCommandCenter
/// let commandCenter = MPRemoteCommandCenter.shared()
///
/// // Customize the Command
/// commandCenter.skipBackwardCommand.preferredIntervals = [5]
///
/// \endcode<h2>Overriding a Command</h2>
/// In case you want to have a custom implementation for one of the commands we add per default,
/// you can do so by first removing it and adding your own command.
/// \code
/// // Get the shared MPRemoteCommandCenter
/// let commandCenter = MPRemoteCommandCenter.shared()
///
/// // Remove all registered targets
/// commandCenter.skipBackwardCommand.removeTarget(nil)
///
/// // Add a new handler for the Command
/// commandCenter.skipBackwardCommand.addTarget { [weak player] _ in
///     guard let player else { return .commandFailed }
///     // React to the skip backward button interaction
///     return .success
/// }
///
/// \endcode<h1>Default Supported Features</h1>
/// Here is the list of supported features in the default behavior.
/// <h2>Populated Metadata</h2>
/// <ul>
///   <li>
///     <code>MPNowPlayingInfoPropertyAssetURL</code>
///   </li>
///   <li>
///     <code>MPMediaItemPropertyTitle</code>
///   </li>
///   <li>
///     <code>MPMediaItemPropertyArtwork</code>
///   </li>
///   <li>
///     <code>MPNowPlayingInfoPropertyIsLiveStream</code>
///   </li>
///   <li>
///     <code>MPNowPlayingInfoPropertyPlaybackRate</code>
///   </li>
///   <li>
///     <code>MPNowPlayingInfoPropertyDefaultPlaybackRate</code>
///   </li>
///   <li>
///     <code>MPNowPlayingInfoPropertyElapsedPlaybackTime</code>
///   </li>
///   <li>
///     <code>MPMediaItemPropertyPlaybackDuration</code>
///   </li>
/// </ul>
/// <h2>Registered Commands</h2>
/// <ul>
///   <li>
///     togglePlayPauseCommand
///   </li>
///   <li>
///     playCommand
///   </li>
///   <li>
///     pauseCommand
///   </li>
///   <li>
///     changePlaybackPositionCommand
///   </li>
///   <li>
///     skipForwardCommand
///   </li>
///   <li>
///     skipBackwardCommand
///   </li>
/// </ul>
/// The skip interval is specified by the <code>MPSkipIntervalCommand.preferredIntervals</code> and can be configured
/// for the <code>.skipForwardCommand</code> and <code>.skipBackwardCommand</code> on the <code>MPRemoteCommandCenter.shared()</code> individually.
@property (nonatomic) BOOL isNowPlayingInfoEnabled;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPOfflineTrackAction : NSInteger;
/// Superclass of tracks which can be selected to download for offline playback
SWIFT_CLASS_NAMED("OfflineTrack")
@interface BMPOfflineTrack : NSObject
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) enum BMPOfflineTrackAction _defaultAction;)
+ (enum BMPOfflineTrackAction)_defaultAction SWIFT_WARN_UNUSED_RESULT;
@property (nonatomic, readonly, copy) NSString * _Nonnull _identifier;
/// Represents the action for this <code>OfflineTrack</code>. See <code>OfflineTrackAction</code> for available values.
@property (nonatomic) enum BMPOfflineTrackAction action;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("OfflineAudioTrack")
@interface BMPOfflineAudioTrack : BMPOfflineTrack
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) enum BMPOfflineTrackAction _defaultAction;)
+ (enum BMPOfflineTrackAction)_defaultAction SWIFT_WARN_UNUSED_RESULT;
/// The label for this track.
@property (nonatomic, readonly, copy) NSString * _Nonnull label;
/// The IETF BCP 47 language tag associated with the text track.
@property (nonatomic, readonly, copy) NSString * _Nullable language;
/// If set to <code>true</code>, this track would be considered as default,
/// i.e. it will be enabled automatically once the source has loaded.
@property (nonatomic, readonly) BOOL isDefault;
+ (BMPOfflineAudioTrack * _Nonnull)_createWithIdentifier:(NSString * _Nonnull)identifier label:(NSString * _Nonnull)label language:(NSString * _Nullable)language isDefault:(BOOL)isDefault SWIFT_WARN_UNUSED_RESULT;
@end

/// Configures the offline functionality
SWIFT_CLASS_NAMED("OfflineConfig")
@interface BMPOfflineConfig : NSObject
/// Specifies if an active WiFi connection is required for downloading media for offline playback
/// Default value is <code>false</code>
@property (nonatomic, readonly) BOOL restrictMediaDownloadsToWiFi;
- (nonnull instancetype)init;
/// Initialize a new OfflineConfig instance.
/// \param restrictMediaDownloadsToWiFi specifies if an active WiFi connection is required
/// for downloading media for offline playback.
///
- (nonnull instancetype)initWithRestrictMediaDownloadsToWiFi:(BOOL)restrictMediaDownloadsToWiFi OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("OfflineContentLicenseExpiredEvent")
@protocol BMPOfflineContentLicenseExpiredEvent <BMPOfflineEvent>
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
SWIFT_PROTOCOL_NAMED("OfflineContentLicenseRenewedEvent")
@protocol BMPOfflineContentLicenseRenewedEvent <BMPOfflineEvent>
@end

@protocol BMPOfflineErrorEvent;
@protocol BMPOfflineContentManager;
/// Protocol for listeners for the <code>BMPOfflineContentManager</code>.
SWIFT_PROTOCOL_NAMED("OfflineContentManagerListener")
@protocol BMPOfflineContentManagerListener <NSObject>
@optional
/// Is called when the download of the media content failed. Downloaded content may have been stored to disk.
/// It is possible to retry the download by first checking the state of the source config
/// using <code>BMPOfflineContentManager/offlineState</code> and then taking one of the actions allowed in
/// the current state as documented in OfflineContentManager.h
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onOfflineError:(id <BMPOfflineErrorEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when the download of the media content was successful.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onContentDownloadFinished:(id <BMPContentDownloadFinishedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when the download of the media content progressed to a new percentage value.
/// The method is only called when the according <code>SourceConfig</code> is in state <code>OfflineState/downloading</code>.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onContentDownloadProgressChanged:(id <BMPContentDownloadProgressChangedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when the download of the media content was suspended. This could be the result of a call to
/// <code>BMPOfflineContentManager/suspendDownload</code> or if the app was terminated by the user
/// while downloads were running.
/// In the latter case, this listener method is called upon first application startup after termination.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onContentDownloadSuspended:(id <BMPContentDownloadSuspendedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when the download of the media content was resumed after it was suspended.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onContentDownloadResumed:(id <BMPContentDownloadResumedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when the download of the media content was cancelled by the user
/// and all partially downloaded content has been deleted from disk.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onContentDownloadCanceled:(id <BMPContentDownloadCanceledEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when the offline license was successfully renewed and written to disk.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onOfflineContentLicenseRenewed:(id <BMPOfflineContentLicenseRenewedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called on every call to <code>BMPOfflineContentManager/createOfflineSourceConfig:</code>
/// if it is DRM protected
/// and the offline DRM license has expired.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onOfflineContentLicenseExpired:(id <BMPOfflineContentLicenseExpiredEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when information on available tracks is available.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onAvailableTracksFetched:(id <BMPAvailableTracksFetchedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called when content migration triggered via
/// <code>OfflineContentManagerTweaksApi/migrateDownload(remoteAssetUrl:resourceIdentifierCallback:)</code> has finished.
/// \param event An object holding specific event data.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event
///
- (void)onContentUrlMigrationFinished:(id <BMPContentUrlMigrationFinishedEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
/// Is called for each occurring offline event.
/// \param event The offline event. Use <code>Event/name</code> or <code>event.isKind(of:)</code> to check the specific event type.
///
/// \param offlineContentManager The <code>BMPOfflineContentManager</code> which is associated with the emitted event.
///
- (void)onEvent:(id <BMPOfflineEvent> _Nonnull)event offlineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager;
@end

/// This API is used as an incubator for experimental features.
/// Tweaks are not officially supported and are not guaranteed to be stable, i.e.
/// their naming, functionality and API can change at any time within the tweaks
/// or when being promoted to an official feature and moved into its final
/// configuration namespace.
SWIFT_PROTOCOL_NAMED("OfflineContentManagerTweaksApi")
@protocol BMPOfflineContentManagerTweaksApi
/// Migrates <code>BMPOfflineContentManager</code> to use a new remote asset URL for downloads.
/// Affects completed, ongoing and future downloads.
/// A <code>ContentUrlMigrationFinishedEvent</code> will be emitted once the migration has finished
/// or an <code>OfflineErrorEvent</code> in case of any error.
/// Calling this method when content is not downloaded affects future downloads
/// and results in <code>ContentUrlMigrationFinishedEvent</code> being emitted.
/// Resuming download after migration will continue using the new remote asset URL.
/// In case the download is in-progress at the time this method is called, it will be suspended.
/// Suspension just happens if a <code>remoteAssetUrl</code> other than the currently downloading one is passed.
/// Passing the same <code>remoteAssetUrl</code> as the one which is currently used, does not have any effect.
/// Suspended downloads have to be resumed explicitly.
/// Subsequent downloads will use the URL provided here.
/// note:
/// <code>id</code> parameter must be passed to <code>OfflineManager/offlineContentManager(for:id:)</code>
/// in order to enable this feature. Using it without may result in unexpected behavior.
/// \param remoteAssetUrl new remote asset URL for the download
///
/// \param resourceIdentifierCallback A callback used to provide an identifier for a resource located at a given URL.
/// Resource in this case refers to all downloaded objects of the source, including e.g. the manifest or segments.
/// The returned identifier has to be unique within the current source and must not change throughout
/// the lifecycle of the downloaded content.
/// This callback has to be provided to ensure resources stay available even if the URL of the asset
/// and URLs within the manifest of the asset change.
///
- (void)migrateDownloadWithRemoteAssetUrl:(NSURL * _Nonnull)remoteAssetUrl resourceIdentifierCallback:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
@end

/// See <code>OfflineContentManagerListener</code> for more information on this event.
/// Possible error codes for <code>OfflineErrorEvent</code>:
/// | Code | Description |
/// | — | — |
/// | 3001 | A general offline related error code when a more specific error code could not be determined. |
/// | 3003 | There is not enough disk space left to proceed with downloading content. |
/// | 3004 | Failed to obtain a persistable content key for the DRM license. |
/// | 3009 | The used <code>SourceConfig</code> is not supported for download. A <code>SourceConfig</code> is only valid for download when it’s configured using an HLS asset. |
/// | 3010 | Content URL migration has failed. |
/// All other error codes are provided by OS frameworks such as <code>CoreMedia</code>, <code>AVFoundation</code>, <code>CFNetworking</code> etc.
/// These error codes can be negative values and many of them are not documented by Apple.
SWIFT_PROTOCOL_NAMED("OfflineErrorEvent")
@protocol BMPOfflineErrorEvent <BMPOfflineEvent>
/// The error code represented as enum value.
@property (nonatomic, readonly) enum BMPOfflineErrorCode code SWIFT_DEPRECATED_MSG("Use errorCode instead to have a more detailed error code", "errorCode");
/// The raw error code represented as Integer. See documentation of <code>OfflineErrorEvent</code> for possible error codes.
@property (nonatomic, readonly) NSInteger errorCode;
/// Message associated with the error event.
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
/// Additional deficiency data if any.
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
@end

@protocol BMPOfflineManagerDelegate;
@class BMPSourceConfig;
SWIFT_CLASS_NAMED("OfflineManager") SWIFT_AVAILABILITY(tvos,unavailable) SWIFT_AVAILABILITY(ios,introduced=14.0)
@interface BMPOfflineManager : NSObject
/// Value in megabytes for minimum system free space available before suspending active downloads.
/// Default is <code>500</code>.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) NSUInteger minimumAvailableSpaceThreshold;)
+ (NSUInteger)minimumAvailableSpaceThreshold SWIFT_WARN_UNUSED_RESULT;
+ (void)setMinimumAvailableSpaceThreshold:(NSUInteger)value;
/// Indicates if the <code>OfflineManager</code> is initialized.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL isOfflineManagerInitialized;)
+ (BOOL)isOfflineManagerInitialized SWIFT_WARN_UNUSED_RESULT;
/// Specifies if an active WiFi connection is required for downloading media for offline playback.
/// Default is <code>false</code>.
@property (nonatomic) BOOL restrictMediaDownloadsToWiFi;
/// Indicates if the <code>OfflineManager</code> has finished restoring suspended downloads.
/// Any <code>resume</code> or <code>cancel</code> actions triggered before this returns <code>true</code> are not guaranteed
/// and might result in unexpected behaviour.
@property (nonatomic, readonly) BOOL areSuspendedDownloadsRestored;
/// The delegate for the <code>OfflineManager</code>
@property (nonatomic, weak) id <BMPOfflineManagerDelegate> _Nullable delegate;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
/// The singleton instance of the <code>OfflineManager</code>.
+ (BMPOfflineManager * _Nonnull)sharedInstance SWIFT_WARN_UNUSED_RESULT;
/// Has to be called in your <code>AppDelegate</code>’s <code>application(application:didFinishLaunchingWithOptions:)</code>
/// method to initialize handling of offline content.
/// If the shared instance is already initialized, this method will not have any effect.
+ (void)initializeOfflineManager;
/// Has to be called in your <code>AppDelegate</code>’s <code>application(application:didFinishLaunchingWithOptions:)</code>
/// method to initialize handling of offline content.
/// Initializes the shared instance with a given <code>OfflineConfig</code>.
/// If the shared instance is already initialized, this method will not have any effect.
/// \param offlineConfig The <code>OfflineConfig</code>
///
+ (void)initializeOfflineManagerWithOfflineConfig:(BMPOfflineConfig * _Nonnull)offlineConfig;
/// Returns an <code>BMPOfflineContentManager</code> instance which can be used to manage offline content and offline
/// DRM related tasks for the provided <code>SourceConfig</code>.
/// The instance returned by this method will always be the same for the same <code>SourceConfig</code>.
/// This method will throw an error in case a <code>SourceConfig</code> is passed that is not supported for being downloaded.
/// A <code>SourceConfig</code> is only valid for download when it’s configured using an HLS asset.
/// It is possible to update parts of the <code>SourceConfig</code> between calls if no download or license related task is
/// in progress. E.g it is possible to update the <code>FairplayConfig</code> for a subsequent download attempt.
/// \param sourceConfig A <code>SourceConfig</code> for which the <code>BMPOfflineContentManager</code> is requested.
///
///
/// returns:
/// <code>BMPOfflineContentManager</code> instance for the provided <code>SourceConfig</code>
- (id <BMPOfflineContentManager> _Nullable)offlineContentManagerForSourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Returns an <code>BMPOfflineContentManager</code> instance which can be used to manage offline content and offline
/// DRM related tasks for the provided <code>SourceConfig</code>.
/// The provided <code>identifier</code> will be used to create a folder containing needed resources for the offline content.
/// The instance returned by this method will always be the same for the same <code>identifier</code>.
/// This method will throw an error in case a <code>SourceConfig</code> is passed that is not supported for being downloaded.
/// A <code>SourceConfig</code> is only valid for download when it’s configured using an HLS asset.
/// It is possible to update parts of the <code>SourceConfig</code> between calls if no download or license related task is
/// in progress. E.g it is possible to update the <code>FairplayConfig</code> for a subsequent download attempt.
/// \param sourceConfig A <code>SourceConfig</code> for which the <code>BMPOfflineContentManager</code> is requested.
///
/// \param identifier A unique identifier for the given <code>SourceConfig</code> which must not change once provided.
///
///
/// returns:
/// OfflineContentManager` instance for the provided <code>SourceConfig</code>
- (id <BMPOfflineContentManager> _Nullable)offlineContentManagerForSourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig identifier:(NSString * _Nonnull)identifier error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Has to be called in your <code>AppDelegate</code>’s <code>application(application:didFinishLaunchingWithOptions:)</code>
/// Needs to be called from the main thread.
/// \param completionHandler The completion handler which is provided by the system.
///
/// \param identifier The identifier which is provided by the system.
///
- (void)addCompletionHandler:(void (^ _Nonnull)(void))completionHandler forIdentifier:(NSString * _Nonnull)identifier;
@end

/// Protocol for delegate for the OfflineManager.
SWIFT_PROTOCOL_NAMED("OfflineManagerDelegate")
@protocol BMPOfflineManagerDelegate <NSObject>
@optional
/// Is called when the <code>OfflineManager</code> finishes restoring all suspended downloads.
/// Restoring is triggered when initializing the <code>OfflineManager</code> in case some downloads are still pending.
/// warning:
/// Any <code>BMPOfflineContentManager/resumeDownload</code> or
/// <code>BMPOfflineContentManager/cancelDownload</code> actions triggered before this method gets called are not
/// guaranteed and might result in unexpected behaviour.
/// \param offlineManager The <code>OfflineManager</code> calling the delegate.
///
- (void)offlineManagerDidRestoreSuspendedDownloads:(BMPOfflineManager * _Nonnull)offlineManager;
@end

@class BMPThumbnailTrack;
@class BMPSourceOptions;
@protocol BMPTimelineMarker;
@class BMPSourceLiveConfig;
/// Represents a source config which can be played back in a player instance.
SWIFT_CLASS_NAMED("SourceConfig")
@interface BMPSourceConfig : NSObject
/// The url for this source config.
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
/// The <code>SourceType</code> for this config
@property (nonatomic, readonly) enum BMPSourceType type;
/// The title of the video source.
@property (nonatomic, copy) NSString * _Nullable title;
/// The description of the video source.
@property (nonatomic, copy) NSString * _Nullable sourceDescription;
/// The URL to a preview image displayed until the video starts.
@property (nonatomic, copy) NSURL * _Nullable posterSource;
/// Indicates whether to show the poster image during playback.
/// Useful, for example, for audio-only streams.
/// Default is false.
@property (nonatomic) BOOL isPosterPersistent;
/// Config for audio and subtitle track labels.
@property (nonatomic, strong) BMPLabelingConfig * _Nonnull labelingConfig;
/// The DRM config for the source.
@property (nonatomic, strong) BMPDrmConfig * _Nullable drmConfig;
/// An array of track data, such as subtitle tracks.
@property (nonatomic, readonly, copy) NSArray<BMPTrack *> * _Nonnull tracks;
/// The thumbnail track for this source config.
@property (nonatomic, strong) BMPThumbnailTrack * _Nullable thumbnailTrack;
/// An object specifying advanced source specific options.
@property (nonatomic, strong) BMPSourceOptions * _Nonnull options;
/// A list of <code>TimelineMarker</code>. Currently, the only type of supported marker is <code>InterstitialMarker</code>.
/// See the documentation of <code>InterstitialMarker</code> for more information.
/// When a <code>TimelineMarker</code> is entered during playback, a <code>TimelineMarkerEnterEvent</code> is emitted.
/// When a <code>TimelineMarker</code> is exited during playback, a <code>TimelineMarkerExitEvent</code> is emitted.
@property (nonatomic, copy) NSArray<id <BMPTimelineMarker>> * _Nonnull markers SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
/// Configures behaviour when playing live content.
/// A default <code>SourceLiveConfig</code> is set initially.
@property (nonatomic, strong) BMPSourceLiveConfig * _Nonnull liveConfig;
/// Config regarding Common Media Client Data (CMCD).
@property (nonatomic, readonly, strong) BMPCmcdConfig * _Nonnull cmcdConfig SWIFT_AVAILABILITY(visionos,introduced=2) SWIFT_AVAILABILITY(tvos,introduced=18) SWIFT_AVAILABILITY(ios,introduced=18);
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
/// Creates a new <code>SourceConfig</code> based on the given source URL.
/// \param url The URL for the media source.
///
///
/// returns:
/// A new source config initialized with the given URL, or nil on failure.
- (nullable instancetype)initWithUrl:(NSURL * _Nonnull)url;
/// Creates a new <code>SourceConfig</code> based on the given source URL for the provide <code>SourceType</code>.
/// Passing <code>SourceType/none</code> to this initializer is not supported.
/// \param url The URL for the media source.
///
/// \param type The <code>SourceType</code> for the media source.
///
///
/// returns:
/// A new source config initialized with the given URL.
- (nonnull instancetype)initWithUrl:(NSURL * _Nonnull)url type:(enum BMPSourceType)type;
/// Can be used to add external subtitles to this source config.
/// Subtitles which are added using this method are only supported
/// in combination with our Bitmovin UI or for source configs
/// which are loaded into a Chromecast session.
/// \param subtitleTrack The subtitle track to add.
///
- (void)addSubtitleTrack:(BMPSubtitleTrack * _Nonnull)subtitleTrack;
@end

@class AVURLAsset;
@protocol _BMPOfflineFairplayLicenseStorage;
/// Represents a <code>SourceConfig</code> which references already downloaded or currently downloading offline content. It can
/// passed to a <code>BMPPlayer</code> instance for playback. Do not create instances of this class on your own, instead
/// use <code>BMPOfflineContentManager/createOfflineSourceConfig:</code>.
SWIFT_CLASS_NAMED("OfflineSourceConfig")
@interface BMPOfflineSourceConfig : BMPSourceConfig
/// Defines if the player is restricted to the usage of completely offline stored media renditions.
@property (nonatomic, readonly) BOOL isRestrictedToAssetCache;
+ (BMPOfflineSourceConfig * _Nonnull)_createWithUrlAsset:(AVURLAsset * _Nonnull)urlAsset sourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig restrictedToAssetCache:(BOOL)restrictedToAssetCache fairplayLicenseStorage:(id <_BMPOfflineFairplayLicenseStorage> _Nullable)fairplayLicenseStorage SWIFT_WARN_UNUSED_RESULT;
@end

/// Represents a text track which can be selected to download for offline playback
SWIFT_CLASS_NAMED("OfflineTextTrack")
@interface BMPOfflineTextTrack : BMPOfflineTrack
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) enum BMPOfflineTrackAction _defaultAction;)
+ (enum BMPOfflineTrackAction)_defaultAction SWIFT_WARN_UNUSED_RESULT;
/// The label for this track.
@property (nonatomic, readonly, copy) NSString * _Nonnull label;
/// The IETF BCP 47 language tag associated with the text track.
@property (nonatomic, readonly, copy) NSString * _Nullable language;
/// Tells if a text track is forced. If set to true it means that the player should automatically select and switch
/// this text track according to the selected audio language.
@property (nonatomic, readonly) BOOL isForced;
/// If set to <code>true</code>, this track would be considered as default,
/// i.e. it will be enabled automatically once the source has loaded.
@property (nonatomic, readonly) BOOL isDefault;
+ (BMPOfflineTextTrack * _Nonnull)_createWithIdentifier:(NSString * _Nonnull)identifier language:(NSString * _Nullable)language label:(NSString * _Nonnull)label isForced:(BOOL)isForced isDefault:(BOOL)isDefault SWIFT_WARN_UNUSED_RESULT;
@end

/// Represenets the desired action of an OfflineTrack
typedef SWIFT_ENUM_NAMED(NSInteger, BMPOfflineTrackAction, "OfflineTrackAction", open) {
/// The track will not be selected for downloading
/// If already downloaded the track will not be modified
  BMPOfflineTrackActionNone = 0,
/// The track will be selected for downloading
  BMPOfflineTrackActionDownload = 1,
};

/// Represents the information which tracks to download for offline playback
SWIFT_CLASS_NAMED("OfflineTrackSelection")
@interface BMPOfflineTrackSelection : NSObject
/// Specifies which text tracks to download for offline playback
@property (nonatomic, readonly, copy) NSArray<BMPOfflineTextTrack *> * _Nonnull textTracks;
/// Specifies which audio tracks to download for offline playback
@property (nonatomic, readonly, copy) NSArray<BMPOfflineAudioTrack *> * _Nonnull audioTracks;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
+ (BMPOfflineTrackSelection * _Nonnull)_createWithTextTracks:(NSArray<BMPOfflineTextTrack *> * _Nonnull)textTracks audioTracks:(NSArray<BMPOfflineAudioTrack *> * _Nonnull)audioTracks SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("OutputObscuredEvent")
@interface BMPOutputObscuredEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("OutputUnobscuredEvent")
@interface BMPOutputUnobscuredEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PausedEvent")
@interface BMPPausedEvent : BMPPlayerEvent
/// Current playback time in seconds.
@property (nonatomic, readonly) NSTimeInterval time;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithTime:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The <code>PictureInPictureApi</code> for interactions regarding Picture-in-Picture feature.
SWIFT_PROTOCOL_NAMED("PictureInPictureApi")
@protocol BMPPictureInPictureApi
/// Defines whether the skip-backward and skip-forward buttons should be visible when Picture-in-Picture is active.
@property (nonatomic) BOOL showSkipControls SWIFT_AVAILABILITY(tvos,unavailable);
/// Whether Picture-in-Picture is enabled for this PlayerView instance.
/// The initial state can be configured via <code>PictureInPictureConfig/isEnabled</code>.
/// Changing this value will:
/// <ul>
///   <li>
///     Emit a <code>PictureInPictureAvailabilityChangedEvent</code>
///   </li>
///   <li>
///     Update the UI: when set to <code>false</code>, the PiP button is removed from the UI;
///     when set back to <code>true</code>, the button is shown again
///   </li>
///   <li>
///     If Picture-in-Picture is currently active and this property gets set to <code>false</code>,
///     the active PiP session is exited immediately and playback continues in the player view
///   </li>
/// </ul>
@property (nonatomic) BOOL isEnabled;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PictureInPictureAvailabilityChangedEvent")
@interface BMPPictureInPictureAvailabilityChangedEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// Indicates whether Picture-in-Picture is available.
@property (nonatomic, readonly) BOOL isPictureInPictureAvailable;
- (nonnull instancetype)initWithIsPictureInPictureAvailable:(BOOL)isPictureInPictureAvailable OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPPictureInPictureAvailabilityChangedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// Provides options to configure Picture-in-Picture playback.
SWIFT_CLASS_NAMED("PictureInPictureConfig")
@interface BMPPictureInPictureConfig : NSObject
/// Whether Picture-in-Picture feature is enabled or not.
/// Default is <code>false</code>.
@property (nonatomic) BOOL isEnabled;
/// Defines whether the skip-backward and skip-forward buttons should be visible when Picture-in-Picture is active.
/// Default is <code>true</code>.
@property (nonatomic) BOOL showSkipControls SWIFT_AVAILABILITY(tvos,unavailable);
/// Defines whether Picture-in-Picture should start automatically when the app transitions to background.
/// Does not have any affect when Picture-in-Picture is disabled.
/// Default is <code>false</code>.
@property (nonatomic) BOOL shouldEnterOnBackground SWIFT_AVAILABILITY(tvos,unavailable) SWIFT_AVAILABILITY(ios,introduced=14.2);
/// Closure which will be called just before Picture-in-Picture stops.
/// Can be used to restore the user interface. Call the completion handler once done.
/// he system will wait up to one second for the completion handler before Picture-in-Picture is stopped.
/// If the completion handler is not called in time, Picture-in-Picture will be stopped regardless.
@property (nonatomic, copy) void (^ _Nullable restoreUserInterfaceHandler)(void (^ _Nonnull)(BOOL));
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS("_TtC18BitmovinPlayerCore26PictureInPictureEnterEvent")
@interface PictureInPictureEnterEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface PictureInPictureEnterEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS("_TtC18BitmovinPlayerCore28PictureInPictureEnteredEvent")
@interface PictureInPictureEnteredEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface PictureInPictureEnteredEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS("_TtC18BitmovinPlayerCore25PictureInPictureExitEvent")
@interface PictureInPictureExitEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface PictureInPictureExitEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS("_TtC18BitmovinPlayerCore27PictureInPictureExitedEvent")
@interface PictureInPictureExitedEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface PictureInPictureExitedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlayEvent")
@interface BMPPlayEvent : BMPPlayerEvent
@property (nonatomic, readonly) NSTimeInterval time;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithTime:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// Represents a PlayReady DRM config.
SWIFT_CLASS_NAMED("PlayReadyConfig")
@interface BMPPlayReadyConfig : BMPDrmConfig
/// A dictionary to specify custom HTTP headers for the license request.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nonnull licenseRequestHeaders;
/// Specifies how long in milliseconds should be waited before a license request should be retried. Default is 0.
@property (nonatomic) NSUInteger licenseRequestRetryDelay;
/// Specifies how often a license request should be retried
/// if it was not successful (e.g. the license server was not reachable).
/// Default is 1. Assigning 0 disables retries.
@property (nonatomic) NSUInteger maxLicenseRequestRetries;
/// A JSON string which allows to specify config options of the DRM key system, such as
/// distinctiveIdentifier or persistentState.
@property (nonatomic, copy) NSString * _Nullable mediaKeySystemConfig;
/// Creates a new <code>PlayReadyConfig</code> based on the given license URL.
/// \param licenseUrl The URL to the license server.
///
///
/// returns:
/// A new PlayReady config initialized with the given license URL.
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl uuid:(NSUUID * _Nonnull)uuid SWIFT_UNAVAILABLE;
@end

@interface BMPPlayReadyConfig (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPCafDrmConfigConvertible>
- (_BMPCafDrmConfig * _Nullable)toCafDrmConfigWithRemoteControlConfig:(BMPRemoteControlConfig * _Nonnull)remoteControlConfig SWIFT_WARN_UNUSED_RESULT;
@end

/// Contains config values that can be used to alter the playback behaviour of the player.
SWIFT_CLASS_NAMED("PlaybackConfig")
@interface BMPPlaybackConfig : NSObject
/// Whether the player starts playing automatically after loading a source or not.
/// Default value is <code>false</code>.
@property (nonatomic) BOOL isAutoplayEnabled;
/// Whether the sound is muted on startup or not.
/// Default value is <code>false</code>.
@property (nonatomic) BOOL isMuted;
/// Whether time shift / DVR for live streams is enabled or not.
/// Default is <code>true</code>.
@property (nonatomic) BOOL isTimeShiftEnabled;
/// Whether background playback is enabled or not.
/// Default is <code>false</code>.
/// When set to <code>true</code>, playback is not automatically paused
/// anymore when the app moves to the background.
/// When set to <code>true</code>, also make sure to properly configure your app to allow
/// background playback.
/// On tvOS, background playback is only supported for audio-only content.
@property (nonatomic) BOOL isBackgroundPlaybackEnabled;
/// Whether Picture-in-Picture option is enabled or not.
/// Default is <code>false</code>.
@property (nonatomic) BOOL isPictureInPictureEnabled SWIFT_DEPRECATED_MSG("Use PlayerViewConfig.PictureInPictureConfig.isEnabled instead");
/// Determines if the subtitle should be selected by the player per default and
/// kept in sync with the selected audio language.
/// The subtitle will not appear in availableSubtitles and can’t be deactivated or activated through the API.
/// In case of HLS these are subtitles with the attribute <code>FORCED=YES</code>.
@property (nonatomic, copy) BOOL (^ _Nullable isForcedSubtitleCallback)(BMPSubtitleTrack * _Nonnull);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlaybackFinishedEvent")
@interface BMPPlaybackFinishedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlaybackSpeedChangedEvent")
@interface BMPPlaybackSpeedChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The playback speed before the change happened.
@property (nonatomic, readonly) float from;
/// The playback speed after the change happened.
@property (nonatomic, readonly) float to;
- (nonnull instancetype)initFrom:(float)from to:(float)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Specifies the player behaviour when <code>BMPPlayer/play</code> is called.
typedef SWIFT_ENUM_NAMED(NSUInteger, BMPPlaybackStartBehaviour, "PlaybackStartBehaviour", open) {
/// Starts playback when enough media data is buffered and continuous playback without stalling can be ensured.
/// If insufficient media data is buffered for playback to start, the player will act as if the buffer
/// became empty during playback.
  BMPPlaybackStartBehaviourRelaxed = 0,
/// When the buffer is not empty, this setting will cause the player to start playback of
/// available media immediately.
/// If insufficient media data is buffered for playback to start, the player will act as if the buffer
/// became empty during playback.
  BMPPlaybackStartBehaviourAggressive = 1,
};

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlayerActiveEvent")
@interface BMPPlayerActiveEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class BMPStyleConfig;
@class BMPTweaksConfig;
/// Configures a new <code>BMPPlayer</code> instance.
/// Must not be modified after it was used to create a <code>BMPPlayer</code> instance.
SWIFT_CLASS_NAMED("PlayerConfig")
@interface BMPPlayerConfig : NSObject
/// A Bitmovin license key that can be found in the Bitmovin portal. If a license key is set here, it will be used
/// instead of the license key found in the Info.plist
@property (nonatomic, copy) NSString * _Nullable key;
/// Configures visual presentation and behaviour of the Player UI.
/// A default <code>StyleConfig</code> is set initially
@property (nonatomic, strong) BMPStyleConfig * _Nonnull styleConfig;
/// Configures playback behaviour.
/// A default <code>PlaybackConfig</code> is set initially
@property (nonatomic, strong) BMPPlaybackConfig * _Nonnull playbackConfig;
/// Configures advertising functionality.
/// A default <code>AdvertisingConfig</code> is set initially
@property (nonatomic, strong) BMPAdvertisingConfig * _Nonnull advertisingConfig;
/// Configures remote playback functionality.
/// A default <code>RemoteControlConfig</code> is set initially
@property (nonatomic, strong) BMPRemoteControlConfig * _Nonnull remoteControlConfig SWIFT_AVAILABILITY(visionos,unavailable) SWIFT_AVAILABILITY(tvos,unavailable);
/// Configures adaptation logic.
/// A default <code>AdaptationConfig</code> is set initially
@property (nonatomic, strong) BMPAdaptationConfig * _Nonnull adaptationConfig;
/// Configures network request manipulation functionality.
/// A default <code>NetworkConfig</code> is set initially
@property (nonatomic, strong) BMPNetworkConfig * _Nonnull networkConfig;
/// Configures experimental features.
/// A default <code>TweaksConfig</code> is set initially
@property (nonatomic, strong) BMPTweaksConfig * _Nonnull tweaksConfig;
/// Configures buffer settings.
/// A default <code>BufferConfig</code> is set initially
@property (nonatomic, strong) BMPBufferConfig * _Nonnull bufferConfig;
/// Configures behaviour when playing live content.
/// A default <code>LiveConfig</code> is set initially
@property (nonatomic, strong) BMPLiveConfig * _Nonnull liveConfig SWIFT_DEPRECATED_MSG("\n        Configuration for live streams has moved to the source-based ``SourceLiveConfig``. Use\n        `SourceConfig.liveConfig` instead.\"\n        ");
/// Configures the Now Playing information.
/// A default <code>NowPlayingConfig</code> is set initially.
@property (nonatomic, strong) BMPNowPlayingConfig * _Nonnull nowPlayingConfig;
/// Configuration for HLS interstitials functionality.
/// A default <code>InterstitialsConfig</code> is set initially.
@property (nonatomic, strong) BMPInterstitialsConfig * _Nonnull interstitialsConfig;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
/// Possible error codes for <code>PlayerErrorEvent</code>:
/// | Code | Description |
/// | –– | ———– |
/// | 1002 | Verification of the player license key failed. A valid license must be provided in the <code>Info.plist</code> file or via <code>PlayerConfig/key</code>. |
/// | 1003 | The license request failed or was denied by the server. One possible reason is that the Bundle ID of the app is not authorized for the specified player license key. Make sure that the Bundle ID of the application is registered for the license key provided in the Info.plist file or in the <code>PlayerConfig</code>. This can be done in the <a href="https://dashboard.bitmovin.com">Bitmovin dashboard</a>. |
/// | 1004 | A general error code for Advertising errors. |
/// | 1200 | A general error code for network errors. |
/// All other error codes are provided by OS frameworks such as <code>CoreMedia</code>, <code>AVFoundation</code>, <code>CFNetworking</code> etc.
/// These error codes can be negative values and many of them are not documented by Apple.
SWIFT_CLASS_NAMED("PlayerErrorEvent")
@interface BMPPlayerErrorEvent : BMPPlayerEvent
/// The error code represented as enum value.
@property (nonatomic, readonly) enum BMPPlayerErrorCode code SWIFT_DEPRECATED_MSG("Use errorCode instead to have a more detailed error code", "errorCode");
/// The raw error code represented as Integer. See documentation of <code>PlayerErrorEvent</code> for possible error codes.
@property (nonatomic, readonly) NSInteger errorCode;
/// Message associated with the error event.
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
/// Additional deficiency data if any.
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithCode:(enum BMPPlayerErrorCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data SWIFT_DEPRECATED_MSG("Use init(code:errorCode:message:data:) instead");
- (nonnull instancetype)initWithCode:(enum BMPPlayerErrorCode)code errorCode:(NSInteger)errorCode message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPPlayerEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// Namespace for using Combine like event subscription.
/// Note: Only available for Swift.
SWIFT_CLASS_NAMED("PlayerEventsApi")
@interface BMPPlayerEventsApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlayerInactiveEvent")
@interface BMPPlayerInactiveEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class BMPReadyEvent;
@protocol BMPPlayer;
@class BMPPlayingEvent;
@class BMPTimeChangedEvent;
@class BMPSeekEvent;
@class BMPSeekedEvent;
@class BMPTimeShiftEvent;
@class BMPTimeShiftedEvent;
@class BMPStallStartedEvent;
@class BMPStallEndedEvent;
@class BMPVideoSizeChangedEvent;
@class BMPSourceErrorEvent;
@class BMPPlayerWarningEvent;
@class BMPSourceWarningEvent;
@class BMPSourceLoadEvent;
@class BMPSourceLoadedEvent;
@class BMPSourceUnloadEvent;
@class BMPSourceUnloadedEvent;
@class BMPSubtitleAddedEvent;
@class BMPSubtitleRemovedEvent;
@class BMPSubtitleChangedEvent;
@class BMPUnmutedEvent;
@class BMPVideoDownloadQualityChangedEvent;
@class BMPVideoPlaybackQualityChangedEvent;
@class BMPSourceMetadataChangedEvent;
@class BMPPlaylistTransitionEvent;
@class BMPSourceAddedEvent;
@class BMPSourceRemovedEvent;
@class BMPSharePlayStartedEvent;
@class BMPSharePlayEndedEvent;
@class BMPSharePlaySuspensionStartedEvent;
@class BMPSharePlaySuspensionEndedEvent;
/// Defines listener methods for all events available for the Player.
SWIFT_PROTOCOL_NAMED("PlayerListener")
@protocol BMPPlayerListener <NSObject>
@optional
/// Called when the player is ready for immediate playback, because initial audio/video has been downloaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onReady:(BMPReadyEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player received an intention to start/resume playback.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlay:(BMPPlayEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when playback has been started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlaying:(BMPPlayingEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player enters the pause state.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPaused:(BMPPausedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the current playback time has changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onTimeChanged:(BMPTimeChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the duration of the current played media has changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onDurationChanged:(BMPDurationChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is about to seek to a new position.
/// Only applies to VoD streams.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSeek:(BMPSeekEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when seeking has been finished and data is available to continue playback.
/// Only applies to VoD streams.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSeeked:(BMPSeekedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is about to time-shift to a new position.
/// Only applies to Live streams.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onTimeShift:(BMPTimeShiftEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when time shifting has been finished and data is available to continue playback.
/// Only applies to live streams, please refer to onSeeked for VoD streams.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onTimeShifted:(BMPTimeShiftedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is paused or in buffering state and the timeShift offset
/// has exceeded the available timeShift window.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onDvrWindowExceeded:(BMPDvrWindowExceededEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player begins to stall and to buffer due to an empty buffer.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onStallStarted:(BMPStallStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player ends stalling, due to enough data in the buffer.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onStallEnded:(BMPStallEndedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the current size of the video content has been changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onVideoSizeChanged:(BMPVideoSizeChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_DEPRECATED_MSG("This event is not available anymore.");
/// Called when the playback of the current media has finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlaybackFinished:(BMPPlaybackFinishedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a player error is encountered.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlayerError:(BMPPlayerErrorEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a source error is encountered.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceError:(BMPSourceErrorEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a player warning occurs.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlayerWarning:(BMPPlayerWarningEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_DEPRECATED_MSG("\n        Warnings are now communicated through logs with level `.warning`. These logs are printed to the console\n        by default. You can also access them by providing your own logger to `DebugConfig.logging.logger`.\"\n        ");
/// Called when a source warning occurs.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceWarning:(BMPSourceWarningEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_DEPRECATED_MSG("\n        Warnings are now communicated through logs with level `.warning`. These logs are printed to the console\n        by default. You can also access them by providing your own logger to `DebugConfig.logging.logger`.\"\n        ");
/// Called when loading of a new source started.
/// This does not mean that loading of the new manifest has been finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceLoad:(BMPSourceLoadEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a new source is loaded. This does not mean that loading of the new manifest has been finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceLoaded:(BMPSourceLoadedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the current source will be unloaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceUnload:(BMPSourceUnloadEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the current source has been unloaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceUnloaded:(BMPSourceUnloadedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player was destroyed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onDestroy:(BMPDestroyEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when metadata (i.e. ID3 tags in HLS and EMSG in DASH) are encountered.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onMetadata:(BMPMetadataEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when metadata is parsed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onMetadataParsed:(BMPMetadataParsedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when casting to another device, such as a ChromeCast, is available.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastAvailable:(BMPCastAvailableEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback on a cast device has been paused.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastPaused:(BMPCastPausedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback on a cast device has been finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastPlaybackFinished:(BMPCastPlaybackFinishedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when playback on a cast device has been started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastPlaying:(BMPCastPlayingEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the cast app is launched successfully.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastStarted:(BMPCastStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when casting is initiated, but the user still needs to choose which device should be used.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastStart:(BMPCastStartEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when casting to a device is stopped.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastStopped:(BMPCastStoppedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the time update from the currently used cast device is received.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastTimeUpdated:(BMPCastTimeUpdatedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a cast device has been chosen and player is waiting for the device to get ready for playback.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCastWaitingForDevice:(BMPCastWaitingForDeviceEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,unavailable);
/// Called when a sideloaded subtitle cue has been parsed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCueParsed:(BMPCueParsedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a subtitle entry transitions into the active status.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCueEnter:(BMPCueEnterEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when an active subtitle entry transitions into the inactive status.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onCueExit:(BMPCueExitEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a new <code>SubtitleTrack</code> is added.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSubtitleAdded:(BMPSubtitleAddedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when an external <code>SubtitleTrack</code> has been removed so it is possible to update the controls accordingly.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSubtitleRemoved:(BMPSubtitleRemovedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the active <code>SubtitleTrack</code> is changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSubtitleChanged:(BMPSubtitleChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is muted.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onMuted:(BMPMutedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is unmuted.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onUnmuted:(BMPUnmutedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when an audio track is added.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAudioAdded:(BMPAudioAddedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when an audio track is removed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAudioRemoved:(BMPAudioRemovedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the audio track is changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAudioChanged:(BMPAudioChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback of an ad has been started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdStarted:(BMPAdStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback of an ad has been finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdFinished:(BMPAdFinishedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback of an ad has progressed over a quartile boundary.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdQuartile:(BMPAdQuartileEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback of an ad break has been started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdBreakStarted:(BMPAdBreakStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback of an ad break has been finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdBreakFinished:(BMPAdBreakFinishedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when an ad manifest was successfully downloaded and parsed and the ad has been added onto the queue.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdScheduled:(BMPAdScheduledEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when an ad has been skipped.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdSkipped:(BMPAdSkippedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the user clicks on the ad.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdClicked:(BMPAdClickedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when ad playback fails.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdError:(BMPAdErrorEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the download of an ad manifest is starting.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdManifestLoad:(BMPAdManifestLoadEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the ad manifest has been successfully loaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdManifestLoaded:(BMPAdManifestLoadedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player’s advertising schedule changes.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAdScheduleChanged:(BMPAdScheduleChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the current video download quality has changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onVideoDownloadQualityChanged:(BMPVideoDownloadQualityChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the current video playback quality has changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onVideoPlaybackQualityChanged:(BMPVideoPlaybackQualityChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a web download request has finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onDownloadFinished:(BMPDownloadFinishedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when AirPlay playback starts or stops.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAirPlayChanged:(BMPAirPlayChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when AirPlay is available.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAirPlayAvailable:(BMPAirPlayAvailableEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_DEPRECATED_MSG("Use onAirPlayAvailabilityChanged(event:player:) instead.", "onAirPlayAvailabilityChanged(event:player:)");
/// Called when availability of AirPlay changed. Check the <code>allowsAirPlay</code> property of the event to get the new
/// value. This event mirrors the state of the player’s <code>BMPPlayer/allowsAirPlay</code> and <code>RemoteControlConfig</code>’s
/// <code>RemoteControlConfig/allowsAirPlay</code>.
/// <ul>
///   <li>
///     It is emitted:
///     <ul>
///       <li>
///         when the value is changed using <code>BMPPlayer/allowsAirPlay</code>
///       </li>
///       <li>
///         initially when the first <code>Source</code> gets loaded and the value was not yet changed
///         using <code>BMPPlayer/allowsAirPlay</code>
///       </li>
///     </ul>
///   </li>
///   <li>
///     It is not emitted for subsequent <code>Source</code> loads.
///   </li>
/// </ul>
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onAirPlayAvailabilityChanged:(BMPAirPlayAvailabilityChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a source config is loaded which has metadata attached
/// or when <code>metadata</code> is set on the active <code>Source</code>.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceMetadataChanged:(BMPSourceMetadataChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a source was loaded into the <code>BMPPlayer</code>.
/// Seeking and time shifting is allowed as soon as this event is seen.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlayerActive:(BMPPlayerActiveEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when DRM data is found in a downloaded manifest file.
/// TweaksConfig.nativeHlsParsingEnabled needs to be set to <code>true</code> to receive those events.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onDrmDataParsed:(BMPDrmDataParsedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the <code>BMPPlayer</code> was unloaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlayerInactive:(BMPPlayerInactiveEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player transitions between two sources in a playlist.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlaylistTransition:(BMPPlaylistTransitionEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player transitions from one playback speed to another.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onPlaybackSpeedChanged:(BMPPlaybackSpeedChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a new <code>Source</code> was added to a playlist.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceAdded:(BMPSourceAddedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a <code>Source</code> was removed from a playlist.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onSourceRemoved:(BMPSourceRemovedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a SharePlay session is started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event
///
- (void)onSharePlayStarted:(BMPSharePlayStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,introduced=15) SWIFT_AVAILABILITY(ios,introduced=15);
/// Called when a SharePlay session is ended.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event
///
- (void)onSharePlayEnded:(BMPSharePlayEndedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,introduced=15) SWIFT_AVAILABILITY(ios,introduced=15);
/// Called when a <code>SharePlaySuspension</code> is started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event
///
- (void)onSharePlaySuspensionStarted:(BMPSharePlaySuspensionStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,introduced=15) SWIFT_AVAILABILITY(ios,introduced=15);
/// Called when a <code>SharePlaySuspension</code> is ended.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event
///
- (void)onSharePlaySuspensionEnded:(BMPSharePlaySuspensionEndedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,introduced=15) SWIFT_AVAILABILITY(ios,introduced=15);
/// Called for each occurring player event.
/// \param event The player event. Use  the event’s <code>Event/name</code> or <code>event is Type</code>
/// to check the specific event type.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onEvent:(id <BMPEvent> _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when visual output is obscured by the <code>BMPPlayer</code> due to insufficient external protection provided
/// by the current device configuration.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onOutputObscured:(BMPOutputObscuredEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when visual output is no longer obscured by the <code>BMPPlayer</code> due to sufficient
/// external protection provided by the current device configuration.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onOutputUnobscured:(BMPOutputUnobscuredEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when FairPlay license was successfully acquired.
/// The object held by property <code>FairplayLicenseAcquiredEvent/contentKeyRequest</code> on the event can be used
/// for renewing expiring licenses
/// by <code>SourceDrmFairplayApi/renewExpiringLicense(for:)</code> via <code>Source.drm.fairplay</code> API.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onFairplayLicenseAcquired:(BMPFairplayLicenseAcquiredEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a licensing call succeeded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onLicenseValidated:(BMPLicenseValidatedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
@end

@protocol BMPSystemUiApi;
@protocol BMPPlayerViewTweaksApi;
@class BMPPlayerViewEventsApi;
@class BMPPlayerViewConfig;
@class NSCoder;
/// A view that provides the Bitmovin Player UI and default UI handling to an attached <code>BMPPlayer</code> instance.
/// This view needs a <code>BMPPlayer</code> instance to work properly. This Player can be passed to the initializer.
/// If a custom UI is preferred, an <code>AVPlayerLayer</code> or an <code>AVPlayerViewController</code> can be registered via
/// <code>BMPPlayer/registerPlayerLayer:</code> or <code>BMPPlayer/registerPlayerViewController:</code>.
/// See <code>PlayerView</code> for more details.
/// \code
/// // Create a subclass of UIView
/// class CustomView: UIView {
///     init(player: Player, frame: CGRect) {
///         super.init(frame: frame)
///
///         // register the AVPlayerLayer of this view to the Player
///         player.register(playerLayer)
///     }
///
///     var playerLayer: AVPlayerLayer {
///         layer as! AVPlayerLayer
///     }
///
///     override class var layerClass: AnyClass {
///         AVPlayerLayer.self
///     }
/// }
///
/// \endcode
SWIFT_CLASS_NAMED("PlayerView") SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,introduced=14.0)
@interface BMPPlayerView : UIView
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) Class _Nonnull layerClass;)
+ (Class _Nonnull)layerClass SWIFT_WARN_UNUSED_RESULT;
@property (nonatomic, strong) id <BMPPlayer> _Nullable player;
/// Get/set a fullscreen handler for this <code>PlayerView</code>. See the documentation of the <code>FullscreenHandler</code> for
/// more information.
@property (nonatomic, weak) id <BMPFullscreenHandler> _Nullable fullscreenHandler;
/// The <code>ContentOverlayApi</code> for interactions regarding the content overlay.
@property (nonatomic, readonly, strong) BMPContentOverlayApi * _Nonnull contentOverlay;
/// The <code>SystemUiApi</code> for interactions regarding the system UI. Using this API just has an effect if
/// <code>StyleConfig/userInterfaceType</code> in <code>StyleConfig</code> is set to <code>UserInterfaceType/system</code>.
/// This is the default value on tvOS, on iOS it has to be set specifically.
@property (nonatomic, readonly, strong) id <BMPSystemUiApi> _Nullable systemUi;
/// The <code>PictureInPictureApi</code> for interactions regarding Picture-in-Picture feature.
/// This API provides dynamic control over Picture-in-Picture functionality.
/// The initial state is determined by <code>PictureInPictureConfig/isEnabled</code>,
/// but can be modified at runtime using <code>PictureInPictureApi/isEnabled</code>.
@property (nonatomic, readonly, strong) id <BMPPictureInPictureApi> _Nonnull pictureInPicture;
/// The <code>PlayerViewTweaksApi</code> for experimental PlayerView interactions.
@property (nonatomic, readonly, strong) id <BMPPlayerViewTweaksApi> _Nonnull tweaks;
/// The <code>PlayerViewEventsApi</code> for interactions regarding event publishers.
/// This API is only available for usage from Swift.
@property (nonatomic, readonly, strong) BMPPlayerViewEventsApi * _Nonnull events;
/// Bounds of the video content inside the player view.
/// Returns the bounds of the video content inside the player view
/// or <code>CGRect.zero</code> if the video bounds are not available.
@property (nonatomic, readonly) CGRect videoBounds SWIFT_AVAILABILITY(tvos,unavailable);
/// Creates a new instance of the <code>PlayerView</code>.
/// \param player The <code>BMPPlayer</code> instance which will be associated with this <code>PlayerView</code> instance
///
/// \param frame The <code>CGRect</code> which will be passed to the <code>UIView</code> initializer
///
- (nonnull instancetype)initWithPlayer:(id <BMPPlayer> _Nonnull)player frame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
/// Creates a new instance of the <code>PlayerView</code>.
/// \param player The <code>BMPPlayer</code> instance which will be associated with this <code>PlayerView</code> instance
///
/// \param frame The <code>CGRect</code> which will be passed to the <code>UIView</code> initializer
///
/// \param playerViewConfig A configuration object for the <code>PlayerView</code> instance
///
- (nonnull instancetype)initWithPlayer:(id <BMPPlayer> _Nonnull)player frame:(CGRect)frame playerViewConfig:(BMPPlayerViewConfig * _Nonnull)playerViewConfig OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
- (void)didMoveToSuperview;
- (void)layoutSubviews;
/// When the hosting App supports more <code>UIDeviceOrientation</code>s this
/// method should be called before the view will rotate.
/// This can be implemented inside the <code>viewWillTransition</code> method.
/// \code
/// override func viewWillTransition(
///     to size: CGSize,
///     with coordinator: UIViewControllerTransitionCoordinator
/// ) {
///     playerView.willRotate()
///     coordinator.animate(
///         alongsideTransition: { _ in
///             // ...
///         },
///         completion: { _ in
///             playerView.didRotate()
///         }
///     )
///
///     super.viewWillTransition(to: size, with: coordinator)
/// }
///
/// \endcode
- (void)willRotate;
/// When the hosting App supports more <code>UIDeviceOrientation</code>s this method should be called after the view rotated.
/// This can be implemented inside the <code>viewWillTransition</code> method.
/// \code
/// override func viewWillTransition(
///     to size: CGSize,
///     with coordinator: UIViewControllerTransitionCoordinator
/// ) {
///     playerView.willRotate()
///     coordinator.animate(
///         alongsideTransition: { _ in
///             // ...
///         },
///         completion: { _ in
///             playerView.didRotate()
///         }
///     )
///
///     super.viewWillTransition(to: size, with: coordinator)
/// }
///
/// \endcode
- (void)didRotate;
@end

@class UIScrollView;
@interface BMPPlayerView (SWIFT_EXTENSION(BitmovinPlayerCore)) <UIScrollViewDelegate>
- (UIView * _Nullable)viewForZoomingInScrollView:(UIScrollView * _Nonnull)scrollView SWIFT_WARN_UNUSED_RESULT;
- (BOOL)scrollViewShouldScrollToTop:(UIScrollView * _Nonnull)scrollView SWIFT_WARN_UNUSED_RESULT;
@end

@protocol BMPUserInterfaceListener;
/// Handles adding and removing of event listeners.
SWIFT_PROTOCOL_NAMED("UserInterfaceEventHandler")
@protocol BMPUserInterfaceEventHandler <NSObject>
/// Adds an event listener.
/// \param listener The event listener to be added.
///
- (void)addUserInterfaceListener:(id <BMPUserInterfaceListener> _Nonnull)listener;
/// Removes an event listener.
/// \param listener The event listener to be removed.
///
- (void)removeUserInterfaceListener:(id <BMPUserInterfaceListener> _Nonnull)listener;
@end

@interface BMPPlayerView (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPUserInterfaceEventHandler>
- (void)addUserInterfaceListener:(id <BMPUserInterfaceListener> _Nonnull)listener;
- (void)removeUserInterfaceListener:(id <BMPUserInterfaceListener> _Nonnull)listener;
@end

@class _BMPInternalMasterPlaylistLoadedEvent;
@class _BMPInternalVariantPlaylistLoadedEvent;
@class _BMPInternalTimeChangedEvent;
@class _BMPInternalReadyEvent;
@class _BMPInternalPlaybackInitiatedEvent;
@class _BMPInternalPlaybackIntentionEvent;
@class _BMPInternalTimeShiftEvent;
@class _BMPInternalTimeShiftedEvent;
@class _BMPInternalActiveSourceChangedEvent;
@class _BMPInternalCastReadyEvent;
@class _BMPInternalCastActiveSourceChangedEvent;
@class _BMPInternalCastStopEvent;
@class _BMPInternalCastPlayerActiveEvent;
@class _BMPInternalBufferLevelChangedEvent;
@class _BMPInternalPlaylistTransitionEvent;
@class _BMPInternalCastPlaylistTransitionEvent;
@class _BMPInternalPlayingEvent;
@class _BMPInternalPlayerLoadEvent;
@class _BMPInternalPlayerUnloadEvent;
@class _BMPInternalSourcePlaybackFinishedEvent;
@class _BMPInternalSourceAddedEvent;
@class _BMPInternalCastSourceAddedEvent;
@class _BMPInternalSourceRemovedEvent;
@class _BMPInternalCastSourceRemovedEvent;
@class _BMPInternalAdPlaybackDidRequestContentPauseEvent;
@class _BMPInternalAdPlaybackDidRequestContentResumeEvent;
@class _BMPInternalSeekEvent;
@class _BMPInternalSeekedEvent;
@class _BMPInternalCanStartPlaybackImmediatelyEvent;
@class _BMPInternalStallStartedEvent;
@class _BMPInternalStallEndedEvent;
@class _BMPInternalSharePlayStartedEvent;
@class _BMPInternalSharePlayEndedEvent;
@class _BMPInternalMetadataChangedEvent;
/// Private protocol for internal events
SWIFT_PROTOCOL_NAMED("_PlayerListenerInternal")
@protocol _BMPPlayerListenerInternal <BMPPlayerListener>
@optional
/// Is called once after a new <code>PlayerListener</code> was added to the event system.
/// \param unseenEvents Contains all events which were already fired prior to adding the listener.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onUnseen:(NSArray<id <BMPEvent>> * _Nonnull)unseenEvents player:(id <BMPPlayer> _Nonnull)player;
/// Is called when master playlist data has been loaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalMasterPlaylistLoaded:(_BMPInternalMasterPlaylistLoadedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when variant playlist data has been loaded.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalVariantPlaylistLoaded:(_BMPInternalVariantPlaylistLoadedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when the current playback time has changed. Will be fired every 0.2 seconds.
/// Public config of the firing interval for time changed events is not affecting this event.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalTimeChanged:(_BMPInternalTimeChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is fired as soon as the <code>AVPlayerItem</code> enters the <code>AVPlayerItemStatusReadyToPlay</code> state
/// for the first time after the source was loaded. This event is always fired before <code>onReady</code>.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalReady:(_BMPInternalReadyEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is fired when start/resume of playback is initiated for main content (non-ad)
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalPlaybackInitiated:(_BMPInternalPlaybackInitiatedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is fired on intention to start/resume playback for main content (non-ad)
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalPlaybackIntention:(_BMPInternalPlaybackIntentionEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called periodically during time shifting.
/// Only applies to live streams, please refer to <code>onSeek</code> for VoD streams.
/// This event is always triggered even for internal TimeShifts e.g. when applying a startOffset.
/// \param event An object holding specific event data.
///
- (void)onInternalTimeShift:(_BMPInternalTimeShiftEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when time shifting has been finished and data is available to continue playback.
/// Only applies to live streams, please refer to onSeeked for VoD streams.
/// This event is always triggered even for internal TimeShifts e.g. when applying a startOffset.
/// \param event An object holding specific event data.
///
- (void)onInternalTimeShifted:(_BMPInternalTimeShiftedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when the active source of the player changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalActiveSourceChanged:(_BMPInternalActiveSourceChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when the cast receiver is ready for immediate playback.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastReady:(_BMPInternalCastReadyEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when the active source of the player changed while casting.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastActiveSourceChanged:(_BMPInternalCastActiveSourceChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Is called when casting to a device is stopping.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastStop:(_BMPInternalCastStopEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a source was loaded into the cast controller.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastPlayerActive:(_BMPInternalCastPlayerActiveEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the <code>BufferLevel</code> changed.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalBufferLevelChanged:(_BMPInternalBufferLevelChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when internal PlaylistTransition of the local player finished.
/// It will be called after all listeners of the <code>onInternalActiveSourceChanged</code> returned.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalPlaylistTransition:(_BMPInternalPlaylistTransitionEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when internal PlaylistTransition of the cast player finished.
/// It will be called after all listeners of the <code>onInternalCastActiveSourceChanged</code> returned.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastPlaylistTransition:(_BMPInternalCastPlaylistTransitionEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when player status changed to playing.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalPlaying:(_BMPInternalPlayingEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when sources are about to be loaded into the player.
/// This event is fired before <code>onPlayerActive</code> is fired.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalPlayerLoad:(_BMPInternalPlayerLoadEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is about to be unloaded.
/// This event is fired before <code>onPlayerInactive</code> is fired.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalPlayerUnload:(_BMPInternalPlayerUnloadEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the playback of the current source has finished.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSourcePlaybackFinished:(_BMPInternalSourcePlaybackFinishedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a new source has been added to the player.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSourceAdded:(_BMPInternalSourceAddedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a new source has been added to the cast player.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastSourceAdded:(_BMPInternalCastSourceAddedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a <code>Source</code> was removed from the player.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSourceRemoved:(_BMPInternalSourceRemovedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a <code>Source</code> was removed from the cast player.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCastSourceRemoved:(_BMPInternalCastSourceRemovedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when ad playback requests main content to be paused
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalAdPlaybackDidRequestContentPause:(_BMPInternalAdPlaybackDidRequestContentPauseEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when ad playback requests main content to be resumed
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalAdPlaybackDidRequestContentResume:(_BMPInternalAdPlaybackDidRequestContentResumeEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player is about to seek to a new position.
/// Only applies to VoD streams.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSeek:(_BMPInternalSeekEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when seeking has been finished and data is available to continue playback.
/// Only applies to VoD streams.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSeeked:(_BMPInternalSeekedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when playback can start immediately without buffering or stalling
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalCanStartPlaybackImmediately:(_BMPInternalCanStartPlaybackImmediatelyEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player begins to stall and to buffer due to an empty buffer.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalStallStarted:(_BMPInternalStallStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when the player ends stalling, due to enough data in the buffer.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalStallEnded:(_BMPInternalStallEndedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
/// Called when a SharePlay session is started.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSharePlayStarted:(_BMPInternalSharePlayStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,introduced=15) SWIFT_AVAILABILITY(ios,introduced=15);
/// Called when a SharePlay session is ended.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalSharePlayEnded:(_BMPInternalSharePlayEndedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player SWIFT_AVAILABILITY(tvos,introduced=15) SWIFT_AVAILABILITY(ios,introduced=15);
/// Called when metadata is updated.
/// For HLS Interstitials, only additions of new attributes to an existing <code>#EXT-X-DATERANGE</code> tag
/// are treated as valid updates.
/// Modifications or removals are ignored and have no effect on interstitial behavior.
/// \param event An object holding specific event data.
///
/// \param player The player instance which is associated with the emitted event.
///
- (void)onInternalMetadataChanged:(_BMPInternalMetadataChangedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
@end

@interface BMPPlayerView (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPPlayerListenerInternal>
- (void)onCastWaitingForDevice:(BMPCastWaitingForDeviceEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
- (void)onInternalAdPlaybackDidRequestContentPause:(_BMPInternalAdPlaybackDidRequestContentPauseEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
- (void)onInternalAdPlaybackDidRequestContentResume:(_BMPInternalAdPlaybackDidRequestContentResumeEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
- (void)onStallStarted:(BMPStallStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
- (void)onStallEnded:(BMPStallEndedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
- (void)onPlayerInactive:(BMPPlayerInactiveEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
- (void)onAdStarted:(BMPAdStartedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
@end

@class AVTextStyleRule;
/// API methods related to the user interface.
SWIFT_PROTOCOL_NAMED("UserInterfaceApi")
@protocol BMPUserInterfaceApi <NSObject>
/// Returns true if the player is currently in fullscreen mode.
@property (nonatomic, readonly) BOOL isFullscreen;
/// Returns true if the players playback controls are currently shown, false if they are hidden.
@property (nonatomic, readonly) BOOL areControlsShown;
/// Returns whether Picture-in-Picture is available.
/// Picture-in-Picture is available when ALL of the following conditions are met:
/// note:
/// The <code>PictureInPictureApi/isEnabled</code> property is initially set from
/// <code>PictureInPictureConfig/isEnabled</code> but can be dynamically changed at runtime to control
/// Picture-in-Picture availability independently of the initial configuration.
/// <ul>
///   <li>
///     System support: on iOS 14.2 and above, or on tvOS 14 and above.
///     (We disabled PiP on iOS 14.0 and 14.1 due to an underlying iOS bug)
///   </li>
///   <li>
///     Dynamic availability: <code>PictureInPictureApi/isEnabled</code> is set to true
///   </li>
/// </ul>
///
/// returns:
/// true if Picture-in-Picture is available.
@property (nonatomic, readonly) BOOL isPictureInPictureAvailable;
/// Returns true if player is currently in Picture-in-Picture (PiP) mode.
@property (nonatomic, readonly) BOOL isPictureInPicture;
/// A value defining how the video is displayed within the parent container’s bounds.
/// Possible values are defined in <code>ScalingMode</code>.
/// When a value was set before the <code>BMPPlayer</code> was added to the view,
/// it will have precedence over the value configured in <code>StyleConfig/scalingMode</code>.
@property (nonatomic) enum BMPScalingMode scalingMode;
/// The player enters Picture-in-Picture mode. Has no effects if already in Picture-in-Picture.
/// <ul>
///   <li>
///     Starting Picture-in-Picture during casting is not supported and will result in a no-op.
///   </li>
///   <li>
///     This has no effect when using system UI.
///   </li>
/// </ul>
- (void)enterPictureInPicture;
/// The player exits Picture-in-Picture mode. Has no effect if not in Picture-in-Picture mode.
/// This has no effect when using system UI.
- (void)exitPictureInPicture;
/// The player enters fullscreen mode. Has no effect if in fullscreen.
- (void)enterFullscreen;
/// The player exits fullscreen mode. Has no effect if not in fullscreen.
- (void)exitFullscreen;
/// Sets a poster image which will be displayed before playback starts.
/// \param url The URL to the poster image.
///
/// \param keepPersistent Flag to set the poster image persistent so it is also displayed during playback.
///
- (void)setPosterImage:(NSURL * _Nonnull)url keepPersistent:(BOOL)keepPersistent;
/// Set the subtitle styles which should be applied to WebVTT subtitles and other legible text.
/// Setting subtitle styles using this method completely replaces all previously set subtitle styles.
/// Setting subtitle styles is only supported when the <code>userInterfaceType</code> in the <code>StyleConfig</code> is set to
/// <code>UserInterfaceType/system</code> or <code>UserInterfaceType/subtitle</code>.
/// \param subtitleStyles The subtitle styles which should be applied.
///
- (void)setSubtitleStyles:(NSArray<AVTextStyleRule *> * _Nullable)subtitleStyles;
@end

@interface BMPPlayerView (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPUserInterfaceApi>
@property (nonatomic, readonly) BOOL isFullscreen;
@property (nonatomic, readonly) BOOL areControlsShown;
@property (nonatomic, readonly) BOOL isPictureInPictureAvailable;
@property (nonatomic, readonly) BOOL isPictureInPicture;
@property (nonatomic) enum BMPScalingMode scalingMode;
- (void)enterPictureInPicture;
- (void)exitPictureInPicture;
- (void)enterFullscreen;
- (void)exitFullscreen;
- (void)setPosterImage:(NSURL * _Nonnull)url keepPersistent:(BOOL)keepPersistent;
- (void)setSubtitleStyles:(NSArray<AVTextStyleRule *> * _Nullable)subtitleStyles;
@end

@class BMPPlayerViewTweaksConfig;
/// Configures a new <code>PlayerView</code> instance.
SWIFT_CLASS_NAMED("PlayerViewConfig")
@interface BMPPlayerViewConfig : NSObject
/// Provides options to configure Picture-in-Picture playback.
/// A default <code>PictureInPictureConfig</code> is set initially.
@property (nonatomic, strong) BMPPictureInPictureConfig * _Nonnull pictureInPictureConfig;
/// Provides options to configure experimental <code>PlayerView</code> features.
@property (nonatomic, strong) BMPPlayerViewTweaksConfig * _Nonnull tweaksConfig;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// The Obj-C version of the player view events API.
/// It is empty on purpose as Combine-based event subscriptions can only be used from Swift.
SWIFT_CLASS_NAMED("PlayerViewEventsApi")
@interface BMPPlayerViewEventsApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// The <code>PlayerViewTweaksApi</code> for experimental <code>PlayerView</code> interactions.
SWIFT_PROTOCOL_NAMED("PlayerViewTweaksApi")
@protocol BMPPlayerViewTweaksApi
/// Hides the playback controls (seek and play/pause buttons) along with the seek bar in Picture-in-Picture.
/// The initial value is configured via <code>PlayerViewTweaksConfig/hidePlaybackControlsInPictureInPicture</code>.
/// When set to <code>true</code>, <code>PictureInPictureConfig/showSkipControls</code> and
/// <code>PictureInPictureApi/showSkipControls</code> have no effect.
/// Note:
/// <ul>
///   <li>
///     When using the <code>UserInterfaceType/system</code>, this property is only supported on iOS 17 and above.
///   </li>
/// </ul>
@property (nonatomic) BOOL hidePlaybackControlsInPictureInPicture SWIFT_AVAILABILITY(visionos,unavailable) SWIFT_AVAILABILITY(tvos,unavailable);
@end

/// This configuration is used as an incubator for experimental <code>PlayerView</code> features.
/// Tweaks are not officially supported and can change at any time.
SWIFT_CLASS_NAMED("PlayerViewTweaksConfig")
@interface BMPPlayerViewTweaksConfig : NSObject
/// Hides the playback controls (seek and play/pause buttons) along with the seek bar in Picture-in-Picture.
/// Default is <code>false</code>.
/// When set to <code>true</code>, <code>PictureInPictureConfig/showSkipControls</code> and
/// <code>PictureInPictureApi/showSkipControls</code> have no effect.
/// Note:
/// <ul>
///   <li>
///     When using the <code>UserInterfaceType/system</code>, this property is only supported on iOS 17 and above.
///   </li>
/// </ul>
@property (nonatomic) BOOL hidePlaybackControlsInPictureInPicture SWIFT_AVAILABILITY(visionos,unavailable) SWIFT_AVAILABILITY(tvos,unavailable);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlayerWarningEvent") SWIFT_DEPRECATED_MSG("\n    Warnings are now communicated through logs with level `.warning`. These logs are printed to the console\n    by default. You can also access them by providing your own logger to `DebugConfig.logging.logger`\"\n    ")
@interface BMPPlayerWarningEvent : BMPPlayerEvent
@property (nonatomic, readonly) enum BMPPlayerWarningCode code;
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithCode:(enum BMPPlayerWarningCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlayingEvent")
@interface BMPPlayingEvent : BMPPlayerEvent
/// Current playback time in seconds.
@property (nonatomic, readonly) NSTimeInterval time;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithTime:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol BMPSource;
/// Provides the means to manage the playlist.
/// When the player transitions from one source in the playlist to another (either by normal playback or by
/// seeking), a <code>PlaylistTransitionEvent</code> event is emitted and the new <code>Source</code> becomes active while the old
/// one becomes inactive.
/// Accessible through player’s <code>BMPPlayer/playlist</code> property.
SWIFT_PROTOCOL_NAMED("PlaylistApi")
@protocol BMPPlaylistApi
/// The list of <code>Source</code>s currently in the playlist. Exactly one source is always active in a
/// playlist.
@property (nonatomic, readonly, copy) NSArray<id <BMPSource>> * _Nonnull sources;
/// Seeks to the specified time in the specified Source. The <code>Source</code> must be part of the playlist.
/// Will always emit Seek/Seeked events regardless of the current and the target Source type.
/// Limitations:
/// <ul>
///   <li>
///     When seeking into a VOD, the <code>time</code> attribute will always override a configured <code>SourceOptions.startOffset</code>.
///     Workaround: use the <code>SourceOptions.startOffset</code> as input for the seek method.
///   </li>
///   <li>
///     Calling this method to seek to another source while casting will start playback automatically after the
///     seek operation finished even if the player was paused previously. This is due to limitations on the
///     CAF receiver.
///   </li>
///   <li>
///     Live streams within a playlist are not fully supported yet. Therefore the <code>time</code> property has no effect
///     when seeking into a live stream.
///   </li>
/// </ul>
- (void)seekWithSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time;
/// Adds the given <code>Source</code> to the playlist at the specified index.
/// The <code>Source</code> is added before the <code>Source</code> that currently resides at the specified index.
/// Limitations:
/// <ul>
///   <li>
///     Adding the same <code>Source</code> instance more than once is not supported and will result in a no-op.
///   </li>
///   <li>
///     Adding a <code>Source</code> before a <code>load</code> or after an <code>unload</code> call will result in a no-op.
///   </li>
///   <li>
///     Adding a <code>Source</code> after playback has finished will result in a no-op.
///   </li>
/// </ul>
/// \param source The <code>Source</code> that will be added to the playlist.
///
/// \param index The index at which to add the new <code>Source</code>.
/// <code>index</code> must be greater than or equal to zero and must not exceed the
/// number of <code>Source</code>s in the playlist.
///
- (void)addWithSource:(id <BMPSource> _Nonnull)source at:(NSInteger)index;
/// Adds the given <code>Source</code> to the end of the playlist
/// Limitations:
/// <ul>
///   <li>
///     Adding the same <code>Source</code> instance more than once is not supported and will result in a no-op.
///   </li>
///   <li>
///     Adding a <code>Source</code> before a <code>load</code> or after an <code>unload</code> call will result in a no-op.
///   </li>
///   <li>
///     Adding a <code>Source</code> after playback has finished will result in a no-op.
///   </li>
/// </ul>
/// \param source The <code>Source</code> that will be added to the playlist.
///
- (void)addWithSource:(id <BMPSource> _Nonnull)source;
/// Removes a <code>Source</code> from the playlist at the specified index.
/// Limitations:
/// <ul>
///   <li>
///     Removing the currently active <code>Source</code> is not possible. If the index that
///     corresponds to the active source’s index is passed it will result in a no-op.
///   </li>
/// </ul>
/// \param index The index from which to remove the <code>Source</code>.
/// <code>index</code> must be greater than or equal to zero and must be less than
/// the number of <code>Source</code>s in the playlist.
///
- (void)removeWithSourceAt:(NSInteger)index;
@end

@class BMPPlaylistOptions;
/// Configures a playlist that can be loaded into a <code>BMPPlayer</code>.
SWIFT_CLASS_NAMED("PlaylistConfig")
@interface BMPPlaylistConfig : NSObject
/// The <code>Source</code>s that are part of the configured playlist.
@property (nonatomic, readonly, copy) NSArray<id <BMPSource>> * _Nonnull sources;
/// Additional configuration options for the playlist.
@property (nonatomic, readonly, strong) BMPPlaylistOptions * _Nonnull options;
/// Configures a playlist that can be loaded into a <code>BMPPlayer</code>.
/// Will use default <code>PlaylistOptions</code>.
/// \param sources The <code>Source</code>s that are part of the configured playlist.
///
- (nonnull instancetype)initWithSources:(NSArray<id <BMPSource>> * _Nonnull)sources;
/// Configures a playlist that can be loaded into a <code>BMPPlayer</code>.
/// \param sources The <code>Source</code>s that are part of the configured playlist.
///
/// \param options Additional configuration options for the playlist.
///
- (nonnull instancetype)initWithSources:(NSArray<id <BMPSource>> * _Nonnull)sources options:(BMPPlaylistOptions * _Nonnull)options OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum BMPReplayMode : NSInteger;
/// Contains additional configuration options for setting up a playlist.
SWIFT_CLASS_NAMED("PlaylistOptions")
@interface BMPPlaylistOptions : NSObject
/// Specifies whether all <code>Source</code>s in the playlist immediately start preloading when the playlist is loaded into
/// a <code>BMPPlayer</code>.
/// Default value is <code>false</code>.
/// Progressive sources can not be preloaded as part of this setting, although they will naturally be preloaded
/// before a playlist transition.
@property (nonatomic, readonly) BOOL preloadAllSources;
/// Defines whether replay starts at the beginning of the playlist or at the beginning of the last source.
/// Default value is <code>ReplayMode/playlist</code>.
/// note:
/// the value of this property is ignored when the System UI is used. The System UI
/// always replays the last source.
@property (nonatomic, readonly) enum BMPReplayMode replayMode;
/// Contains additional configuration options for setting up a playlist.
/// \param preloadAllSources Specifies whether all <code>Source</code>s in the playlist immediately start
/// preloading when the playlist is loaded into a <code>BMPPlayer</code>.
///
/// \param replayMode Specifies the replay behaviour of a playlist.
///
- (nonnull instancetype)initWithPreloadAllSources:(BOOL)preloadAllSources replayMode:(enum BMPReplayMode)replayMode OBJC_DESIGNATED_INITIALIZER;
/// Inits the class with default values.
- (nonnull instancetype)init;
/// Contains additional configuration options for setting up a playlist.
/// \param preloadAllSources Specifies whether all <code>Source</code>s in the playlist immediately start
/// preloading when the playlist is loaded into a <code>BMPPlayer</code>.
///
- (nonnull instancetype)initWithPreloadAllSources:(BOOL)preloadAllSources;
/// Contains additional configuration options for setting up a playlist.
/// \param replayMode Specifies the replay behaviour of a playlist.
///
- (nonnull instancetype)initWithReplayMode:(enum BMPReplayMode)replayMode;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("PlaylistTransitionEvent")
@interface BMPPlaylistTransitionEvent : BMPPlayerEvent
/// The <code>Source</code> from which a transition happened.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull from;
/// The <code>Source</code> to which a transition happened.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initFrom:(id <BMPSource> _Nonnull)from to:(id <BMPSource> _Nonnull)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A delegate protocol that can be used to change request parameters before a request is made.
/// <ul>
///   <li>
///     Example implementation of <code>PreprocessHttpRequestDelegate</code>.
///   </li>
/// </ul>
/// \code
/// class MyPreprocessHttpRequestDelegate: PreprocessHttpRequestDelegate {
///     func preprocessHttpRequest(
///         _ type: String,
///         httpRequest: HttpRequest,
///         completionHandler: @escaping (_ httpRequest: HttpRequest) -> Void
///     ) {
///         var modifiedRequest = httpRequest
///
///         // Modify the request based on the type
///         switch type {
///         case HttpRequestType.drmLicenseFairplay.rawValue:
///             // Example modification for DRM requests
///             modifiedRequest.headers["Authorization"] = "Bearer someAccessToken"
///         case HttpRequestType.manifestHlsMaster.rawValue:
///             // Example modification for HLS Playlist requests
///             modifiedRequest.url = modifiedRequest.url.appendingPathComponent("modified")
///         default:
///             break
///         }
///
///         // Call the completion handler with the modified request
///         completionHandler(modifiedRequest)
///     }
/// }
///
/// \endcode
SWIFT_PROTOCOL_NAMED("PreprocessHttpRequestDelegate") SWIFT_DEPRECATED_MSG("Use NetworkConfig.preprocessHttpRequest instead.")
@protocol BMPPreprocessHttpRequestDelegate
/// Can be used to change request parameters before a request is made.
/// <h1>Limitations</h1>
/// <ul>
///   <li>
///     Requests of type <code>HttpRequestType.keyHlsAes</code> are not supported.
///   </li>
///   <li>
///     Requests of type <code>HttpRequestType.mediaSubtitles</code> are only supported in case the subtitles are side-loaded.
///   </li>
/// </ul>
/// \param type The type of the request to be made. Possible values are defined in <code>HttpRequestType</code>.
///
/// \param httpRequest The configuration object of the request.
///
/// \param completionHandler A completion handler that must be called with the modified <code>HttpRequest</code>.
/// Not calling the completion handler prevents the HTTP request from being sent and blocks the player.
///
- (void)preprocessHttpRequest:(NSString * _Nonnull)type httpRequest:(BMPHttpRequest * _Nonnull)httpRequest completionHandler:(void (^ _Nonnull)(BMPHttpRequest * _Nonnull))completionHandler;
@end

/// Quality definition of a media representation.
/// Note: This class acts as an abstract class.
SWIFT_CLASS_NAMED("Quality")
@interface BMPQuality : NSObject
/// The unique identifier of the media representation.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The label of the media representation that should be exposed to the user (e.g. in the UI).
@property (nonatomic, readonly, copy) NSString * _Nonnull label;
/// The bitrate of the media representation in bits per second (bps).
@property (nonatomic, readonly) NSUInteger bitrate;
/// The codec of the media representation.
@property (nonatomic, readonly, copy) NSString * _Nullable codec;
- (nonnull instancetype)initWithIdentifier:(NSString * _Nonnull)identifier label:(NSString * _Nonnull)label bitrate:(NSUInteger)bitrate codec:(NSString * _Nullable)codec OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPQuality (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("ReadyEvent")
@interface BMPReadyEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPRemoteControlType : NSInteger;
/// Contains config values which can be used to alter the behaviour of the player when it comes to remote playback.
SWIFT_CLASS_NAMED("RemoteControlConfig") SWIFT_AVAILABILITY(visionos,unavailable)
@interface BMPRemoteControlConfig : NSObject
/// A URL to a CSS file the Chromecast receiver app loads. Can be used to style the receiver app.
@property (nonatomic, copy) NSURL * _Nullable receiverStylesheetUrl;
/// Arbitrary config values that are sent to the remote control receiver.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nonnull customReceiverConfig;
/// This block can be used to prepare a different <code>SourceConfig</code> to be used for remote playback than for local
/// playback. This can be useful when the remote playback
/// device supports different streaming formats,  DRM systems, etc. than the local device.
/// Returning <code>nil</code> from the block will result in the the same <code>SourceConfig</code> being used for remote playback
/// as for local playback.
@property (nonatomic, copy) BMPSourceConfig * _Nullable (^ _Nullable prepareSource)(enum BMPRemoteControlType, BMPSourceConfig * _Nonnull);
/// Indicates whether the player should automatically switch to “external playback” mode while the “external
/// screen” mode is active in order to play video content and switch back to “external screen” mode as soon
/// as playback is done.
/// Brief transition may be visible on the external display when automatically switching between the two modes.
/// Default value is <code>false</code>.
/// note:
/// This is only supported with AirPlay.
@property (nonatomic) BOOL usesExternalPlaybackWhileExternalScreenIsActive;
/// Indicates whether cookies and credentials will be sent along manifest requests on the Cast receiver
/// Default value is <code>false</code>.
/// note:
/// This is only supported with CAF (v3) receivers.
@property (nonatomic) BOOL sendManifestRequestsWithCredentials;
/// Indicates whether cookies and credentials will be sent along segment requests on the Cast receiver
/// Default value is <code>false</code>.
/// note:
/// This is only supported with CAF (v3) receivers.
@property (nonatomic) BOOL sendSegmentRequestsWithCredentials;
/// Indicates whether cookies and credentials will be sent along DRM licence requests on the Cast receiver
/// Default value is <code>false</code>.
/// note:
/// This is only supported with CAF (v3) receivers.
@property (nonatomic) BOOL sendDrmLicenseRequestsWithCredentials;
/// Whether the AirPlay option is enabled or not.
/// Default value is <code>true</code>.
/// note:
///
/// <ul>
///   <li>
///     Calling <code>showAirPlayTargetPicker</code> when the value is <code>false</code> will not have any effect.
///   </li>
///   <li>
///     Only available on iOS. Does not have any effect on tvOS.
///   </li>
/// </ul>
@property (nonatomic) BOOL isAirPlayEnabled SWIFT_DEPRECATED_MSG("Use allowsAirPlay instead.", "allowsAirPlay");
/// Whether AirPlay is allowed.
/// Default value is <code>true</code>.
/// note:
///
/// <ul>
///   <li>
///     Calling <code>showAirPlayTargetPicker</code> when the value is <code>false</code> will not have any effect.
///   </li>
///   <li>
///     Only supported on iOS. Does not have any effect on tvOS.
///   </li>
/// </ul>
@property (nonatomic) BOOL allowsAirPlay;
/// Whether casting is enabled.
/// Default value is <code>true</code>.
/// Has no effect if the <code>BitmovinCastManager</code> is not initialized.
/// note:
///
/// <ul>
///   <li>
///     Only available on iOS. Does not have any effect on tvOS.
///   </li>
/// </ul>
@property (nonatomic) BOOL isCastEnabled;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Enumerates the different available remote device types.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPRemoteControlType, "RemoteControlType", open) {
/// The remote device is a GoogleCast compatible device.
  BMPRemoteControlTypeCast = 0,
};

/// Defines the replay behaviour of a playlist.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPReplayMode, "ReplayMode", open) {
/// Replays only the last source.
  BMPReplayModeLastSource = 0,
/// Replays the whole playlist.
  BMPReplayModePlaylist = 1,
};

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("ScalingModeChangedEvent")
@interface BMPScalingModeChangedEvent : NSObject <BMPPlayerViewEvent>
/// The old scaling mode value
@property (nonatomic, readonly) enum BMPScalingMode from;
/// The new scaling mode value
@property (nonatomic, readonly) enum BMPScalingMode to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)initFrom:(enum BMPScalingMode)from to:(enum BMPScalingMode)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Describes default properties of the custom SCTE35 tag from the playlist.
SWIFT_CLASS_NAMED("ScteMetadataEntry")
@interface BMPScteMetadataEntry : NSObject <BMPMetadataEntry>
/// Key of the SCTE35 attribute.
@property (nonatomic, readonly, copy) NSString * _Nonnull key;
/// Value of the SCTE35 attribute.
@property (nonatomic, readonly, copy) NSString * _Nullable value;
@property (nonatomic, readonly) enum BMPMetadataType metadataType;
- (nonnull instancetype)initWithKey:(NSString * _Nonnull)key value:(NSString * _Nullable)value OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class BMPSeekPosition;
/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SeekEvent")
@interface BMPSeekEvent : BMPPlayerEvent
/// The current position.
@property (nonatomic, readonly, strong) BMPSeekPosition * _Nonnull from;
/// The target position.
@property (nonatomic, readonly, strong) BMPSeekPosition * _Nonnull to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithFrom:(BMPSeekPosition * _Nonnull)from to:(BMPSeekPosition * _Nonnull)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Class represent seeking position
SWIFT_CLASS_NAMED("SeekPosition")
@interface BMPSeekPosition : NSObject
/// The relevant <code>Source</code>.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The position within the <code>source</code> in seconds.
@property (nonatomic, readonly) NSTimeInterval time;
- (nonnull instancetype)initWithSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SeekedEvent")
@interface BMPSeekedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// The Obj-C version of the SharePlay API. It is empty on purpose as SharePlay can only be used from Swift.
SWIFT_CLASS_NAMED("SharePlayApi")
@interface BMPSharePlayApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SharePlayEndedEvent") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@interface BMPSharePlayEndedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SharePlayStartedEvent") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@interface BMPSharePlayStartedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// A representation of a temporary break in participation.
/// See <code>SharePlayApi/beginSuspension(for:)</code> method for details on use.
SWIFT_PROTOCOL_NAMED("SharePlaySuspension") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@protocol BMPSharePlaySuspension
/// The reason for the suspension. This will be communicated to other participants while coordination is suspended.
@property (nonatomic, readonly) AVCoordinatedPlaybackSuspensionReason _Nonnull reason;
/// The begin date of the suspension.
@property (nonatomic, readonly, copy) NSDate * _Nonnull beginDate;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SharePlaySuspensionEndedEvent") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@interface BMPSharePlaySuspensionEndedEvent : BMPPlayerEvent
/// The suspension that was ended.
@property (nonatomic, readonly, strong) id <BMPSharePlaySuspension> _Nonnull suspension;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SharePlaySuspensionStartedEvent") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@interface BMPSharePlaySuspensionStartedEvent : BMPPlayerEvent
/// The suspension that was started.
@property (nonatomic, readonly, strong) id <BMPSharePlaySuspension> _Nonnull suspension;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol BMPSourceListener;
/// Manages listeners to specific <code>SourceEvent</code> and notifies those listeners when such an event is being
/// emitted.
/// Listeners need to conform to the <code>SourceListener</code> protocol.
/// See <code>SourceListener</code> about possible event method implementations.
SWIFT_PROTOCOL_NAMED("SourceEventHandler")
@protocol BMPSourceEventHandler
/// Adds a <code>SourceListener</code> to a handler.
/// \param listener A instance to a class conforming to <code>SourceListener</code> protocol.
///
- (void)addListener:(id <BMPSourceListener> _Nonnull)listener;
/// Removes a <code>SourceListener</code> to handle <code>SourceEvent</code>s.
/// \param listener A instance to a class conforming to <code>SourceListener</code> protocol.
///
- (void)removeListener:(id <BMPSourceListener> _Nonnull)listener;
@end

@class _BMPSourceModulesApi;
@class BMPSourceEventsApi;
@class BMPSourceDrmApi;
@class BMPSourceLatencyApi;
@class BMPThumbnail;
/// Represents audio and video content that can be loaded into a <code>BMPPlayer</code>. A Source instance can be created via the
/// <code>SourceFactory/create(from:)</code> or <code>SourceFactory/createSource(from:)</code> function
/// and will idle until it is loaded into a player. After loading the source into a player,
/// <code>isAttachedToPlayer</code> is <code>true</code> and the same source can not be loaded into a different player until unloaded.
/// Multiple sources can be loaded into a player as part of a <code>PlaylistConfig</code>, where the first source in the playlist
/// immediately becomes active. When the player transitions to another source in the playlist, that source
/// becomes active. More information on how to manage multiple sources can be found on the <code>PlaylistApi</code>.
/// The source starts out <code>LoadingState/unloaded</code>, transitions to <code>LoadingState/loading</code> once the source starts
/// loading and finally transitions to <code>LoadingState/loaded</code> when it finished loading.
/// When unloaded from a player, the source reverts to being <code>LoadingState/unloaded</code> and detached.
/// After this, the source can be loaded again into a (different) player.
/// The source emits events while it is attached to a player. See <code>SourceEventHandler</code> on how to subscribe to events.
/// The source only emits events of type <code>SourceEvent</code>, and events that are emitted while the source is active
/// are also emitted through the player it is attached to.
/// <h3>Current event-related limitations</h3>
/// Only a few events are currently emitted from the source. This is a temporary limitation until
/// all source events are emitted correctly from the source.
/// See <code>SourceListener</code> for more information about events emitted from the source.
SWIFT_PROTOCOL_NAMED("Source")
@protocol BMPSource <BMPSourceEventHandler>
/// The SourceConfig that was used to configure the source.
@property (nonatomic, readonly, strong) BMPSourceConfig * _Nonnull sourceConfig;
/// Whether the source is currently attached to a player instance (i.e if the source was loaded into a player or
/// it is part of a <code>PlaylistConfig</code> that was loaded into a player).
@property (nonatomic, readonly) BOOL isAttachedToPlayer;
/// Whether the source is currently active in a <code>BMPPlayer</code> (i.e. playing back or paused).
/// Only one source can be active in the same player instance at any time.
@property (nonatomic, readonly) BOOL isActive;
/// The duration of the source in seconds if it’s a VoD or <code>Double.infinity</code> if it’s a live stream.
/// Default value is <code>0</code> if the duration is not available or not known.
@property (nonatomic, readonly) NSTimeInterval duration;
/// The current <code>LoadingState</code> of the source.
@property (nonatomic, readonly) enum BMPLoadingState loadingState;
/// Metadata for the currently loaded source. All existing metadata will be completely replaced by the provided
/// metadata when the setter is called. For example, if sourceMetadata is an empty object, all existing source
/// metadata will be deleted.
/// Setting new metadata results in a <code>SourceMetadataChangedEvent</code> event to be emitted.
/// The initial value can be set via <code>SourceConfig/metadata</code>.
@property (nonatomic, copy) NSDictionary<NSString *, id> * _Nullable metadata;
/// A list of <code>TimelineMarker</code>. Currently, the only type of supported marker is <code>InterstitialMarker</code>.
/// See documentation of <code>InterstitialMarker</code> for more information.
/// When a <code>TimelineMarker</code> is entered during playback, a <code>TimelineMarkerEnterEvent</code> is emitted.
/// When a <code>TimelineMarker</code> is exited during playback, a <code>TimelineMarkerExitEvent</code> is emitted.
/// The initial value can be set via <code>SourceConfig/markers</code>.
@property (nonatomic, copy) NSArray<id <BMPTimelineMarker>> * _Nonnull markers SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
/// The <code>_SourceModulesApi</code> for interactions regarding modules.
@property (nonatomic, readonly, strong) _BMPSourceModulesApi * _Nonnull _modules;
/// The <code>SourceEventsApi</code> for interactions regarding event publishers.
/// This API is only available for usage from Swift.
@property (nonatomic, readonly, strong) BMPSourceEventsApi * _Nonnull events;
/// The <code>SourceDrmApi</code> for interactions regarding DRM specific APIs.
@property (nonatomic, readonly, strong) BMPSourceDrmApi * _Nonnull drm;
/// The <code>SourceLatencyApi</code> for interactions regarding latency specific APIs for live-streams.
@property (nonatomic, readonly, strong) BMPSourceLatencyApi * _Nonnull latency;
/// Returns the thumbnail image for a certain time.
/// Requires a configured <code>ThumbnailTrack</code> in the corresponding <code>SourceConfig</code>.
/// note:
/// This function returns <code>nil</code>
/// <ul>
///   <li>
///     If the thumbnails were not loaded yet
///   </li>
///   <li>
///     If there are no <code>ThumbnailTrack</code> provided in the corresponding <code>SourceConfig</code>
///   </li>
///   <li>
///     If there is no thumbnail available at the provided time
///   </li>
/// </ul>
/// \param time The time for which the thumbnail should be returned.
///
///
/// returns:
/// An instance of <code>BMPThumbnail</code> for the given time, or <code>nil</code>.
- (BMPThumbnail * _Nullable)thumbnailForTime:(NSTimeInterval)time SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceAddedEvent")
@interface BMPSourceAddedEvent : BMPPlayerEvent
/// The <code>Source</code> that was added to the playlist.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The index at which the <code>Source</code> was added to the playlist.
/// The value is greater than or equal to zero and does not exceed the
/// number of <code>Source</code>s in the playlist before addition.
@property (nonatomic, readonly) NSInteger index;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPSourceConfig (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, strong) NSMutableDictionary * _Nonnull metadata;
@end

@interface BMPSourceConfig (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, readonly, copy) NSString * _Nullable _bmp_uniqueIdentifier;
@property (nonatomic, readonly, copy) NSURL * _Nullable _bmp_sourceUrlForDownload;
@property (nonatomic, readonly) BOOL _bmp_canBeDownloaded;
@property (nonatomic, readonly, copy) NSString * _Nullable _bmp_legacyUniqueIdentifier;
@end

@class BMPSourceDrmFairplayApi;
/// Provides the means to manage DRM on a <code>Source</code>.
/// Accessible through <code>Source/drm</code> property on <code>Source</code>.
SWIFT_CLASS_NAMED("SourceDrmApi")
@interface BMPSourceDrmApi : NSObject
/// The <code>SourceDrmFairplayApi</code> for interactions regarding FairPlay DRM specific APIs.
@property (nonatomic, readonly, strong) BMPSourceDrmFairplayApi * _Nonnull fairplay;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Provides the means to manage FairPlay DRM on a <code>Source</code>.
/// Accessible through <code>SourceDrmApi/fairplay</code> property on <code>SourceDrmApi</code> via <code>source.drm</code>.
SWIFT_CLASS_NAMED("SourceDrmFairplayApi")
@interface BMPSourceDrmFairplayApi : NSObject
/// Triggers FairPlay license renewal based on <code>FairplayContentKeyRequest</code>,
/// which can be acquired via listening to <code>FairplayLicenseAcquiredEvent</code> event
/// and taking the value of <code>contentKeyRequest</code> property.
/// \param contentKeyRequest content key request for a single key.
///
- (void)renewExpiringLicenseFor:(BMPFairplayContentKeyRequest * _Nonnull)contentKeyRequest;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>SourceListener</code> for more information on this event.
/// Possible error codes for <code>SourceErrorEvent</code>:
/// | Code | Description |
/// | — | — |
/// | 2001 | A general source error code when a more specific error code could not be determined. |
/// | 2101 | Failed to start playing the source. |
/// | 2202 | Failed to download playlist. |
/// | 2301 | A general error indicating that the current DRM session failed for some reason. The message of the according <code>SourceErrorEvent</code> provides more information. |
/// | 2302 | The required DRM configuration is missing. |
/// | 2303 | No DRM license URL provided. |
/// | 2306 | The response to the DRM license request failed with an invalid HTTP response code. The message of the according <code>SourceErrorEvent</code> provides more information. |
/// | 2307 | The response to the DRM certificate request failed with an invalid HTTP response code. The message of the according <code>SourceErrorEvent</code> provides more information. |
/// | 2309 | No DRM certificate URL provided. |
/// All other error codes are provided by OS frameworks such as <code>CoreMedia</code>, <code>AVFoundation</code>, <code>CFNetworking</code> etc.
/// These error codes can be negative values and many of them are not documented by Apple.
SWIFT_CLASS_NAMED("SourceErrorEvent")
@interface BMPSourceErrorEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The error code represented as enum value.
@property (nonatomic, readonly) enum BMPSourceErrorCode code SWIFT_DEPRECATED_MSG("Use errorCode instead to have a more detailed error code", "errorCode");
/// The raw error code represented as Integer. See documentation of <code>SourceErrorEvent</code> for possible error codes.
@property (nonatomic, readonly) NSInteger errorCode;
/// Message associated with the error event.
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
/// The time at which this event was emitted.
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// Additional deficiency data if any.
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
- (nonnull instancetype)initWithCode:(enum BMPSourceErrorCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data SWIFT_DEPRECATED_MSG("Use init(code:errorCode:message:data:) instead");
- (nonnull instancetype)initWithCode:(enum BMPSourceErrorCode)code errorCode:(NSInteger)errorCode message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPSourceErrorEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// The Obj-C version of the source events API.
/// It is empty on purpose as Combine-based event subscriptions can only be used from Swift.
SWIFT_CLASS_NAMED("SourceEventsApi")
@interface BMPSourceEventsApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Factory to create <code>Source</code>s which can be loaded into a Player.
SWIFT_CLASS_NAMED("SourceFactory") SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,introduced=14.0)
@interface BMPSourceFactory : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
/// Creates a source configured via the provided SourceConfig.
+ (id <BMPSource> _Nonnull)createFrom:(BMPSourceConfig * _Nonnull)sourceConfig SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use createSource(from:) instead.", "createSourceFrom:");
/// Creates a source configured via the provided <code>SourceConfig</code>.
+ (id <BMPSource> _Nonnull)createSourceFrom:(BMPSourceConfig * _Nonnull)sourceConfig SWIFT_WARN_UNUSED_RESULT;
@end

/// Action to take when a <code>Source</code> fails to finish playback.
/// Failures during (pre-)loading or during playback are handled.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPSourceFailureAction, "SourceFailureAction", open) {
/// The <code>BMPPlayer</code> doesn’t take any actions when a <code>Source</code> emits an error.
/// The error is propagated to the Player. The <code>BMPPlayer</code> unloads and stops playback.
  BMPSourceFailureActionNone = 0,
/// Drops the failed <code>Source</code> from the playlist.
/// <ul>
///   <li>
///     If a <code>Source</code> fails while it’s inactive:
///     <ul>
///       <li>
///         It is removed from the Playlist. This is indicated by a <code>SourceRemovedEvent</code>.
///       </li>
///     </ul>
///   </li>
///   <li>
///     If a <code>Source</code> fails while it’s active:
///     <ul>
///       <li>
///         When there is another <code>Source</code> afterwards:
///         <ul>
///           <li>
///             The <code>BMPPlayer</code> skips to the next source and removes the failed <code>Source</code> from the playlist.
///             This is indicated by a <code>PlaylistTransitionEvent</code> followed by a <code>SourceRemovedEvent</code>.
///           </li>
///         </ul>
///       </li>
///       <li>
///         When there is no source afterwards or if it’s the only source within the playlist:
///         <ul>
///           <li>
///             The error is propagated to the Player. The <code>BMPPlayer</code> unloads and stops playback.
///             A <code>SourceErrorEvent</code> is emitted followed by a <code>PlayerInactiveEvent</code>.
///           </li>
///         </ul>
///       </li>
///     </ul>
///   </li>
/// </ul>
/// In all cases, a <code>SourceErrorEvent</code> is emitted through the Sources event system.
  BMPSourceFailureActionDrop = 1,
};

/// Provides the means to manage latency for a live-stream on a <code>Source</code>.
/// Accessible through source’s <code>Source/latency</code> property.
/// note:
/// Disable <code>TweaksConfig/isCustomHlsLoadingEnabled</code> when intending to play HLS-LL streams
/// below iOS and tvOS 17. Due to platform limitations, HLS-LL streams are not supported there while
/// this property is enabled.
SWIFT_CLASS_NAMED("SourceLatencyApi")
@interface BMPSourceLatencyApi : NSObject
/// Specifies if the player should try to automatically restore the previous playback position after a stall.
/// Setting a new value requires that the <code>Source</code> is attached to a <code>BMPPlayer</code> to take effect.
/// Set the initial value using <code>SourceLiveConfig/automaticallyPreservesLatency</code> instead.
/// If set to <code>true</code>, the player will time shift to the last playback position after a stall ended (does not
/// have to be the configured <code>targetLatency</code>). For example, when the player stalls after
/// calling <code>player.timeShift = -10</code>, it will try to restore the <code>-10</code> seconds time shift automatically.
/// note:
/// If the network cannot deliver media quickly enough playback may stall endlessly.
/// Does not have any effect for VOD assets.
@property (nonatomic) BOOL automaticallyPreservesLatency;
/// Provides the system’s recommended latency.
/// Returns the <a href="https://datatracker.ietf.org/doc/html/draft-pantos-hls-rfc8216bis"><code>PART-HOLD-BACK</code></a> value from the manifest if present.
/// If there is no <code>PART-HOLD-BACK</code> value found, if returns an appropriate value. E.g. three times the segment
/// duration.
/// Returns <code>.nan</code> for VOD assets.
@property (nonatomic, readonly) NSTimeInterval recommendedLatency;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Includes all possible methods that an implementation of this protocol can implement.
/// The corresponding method will be called when an event is emitted (if implemented).
SWIFT_PROTOCOL_NAMED("SourceListener")
@protocol BMPSourceListener <NSObject>
@optional
/// Called when the <code>Source</code> duration has changed. Not emitted for the initial duration.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onDurationChanged:(BMPDurationChangedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the <code>Source</code> that started loading.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSourceLoad:(BMPSourceLoadEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when a <code>Source</code> was loaded. This does not mean that the source is immediately ready for playback.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSourceLoaded:(BMPSourceLoadedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the <code>Source</code> started unloading.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSourceUnload:(BMPSourceUnloadEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when a <code>Source</code> was unloaded.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSourceUnloaded:(BMPSourceUnloadedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when a <code>Source</code> warning occurred.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSourceWarning:(BMPSourceWarningEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source SWIFT_DEPRECATED_MSG("\n        Warnings are now communicated through logs with level `.warning`. These logs are printed to the console\n        by default. You can also access them by providing your own logger to `DebugConfig.logging.logger`\"\n        ");
/// Called when a source error occurred.
/// Faulty <code>Source</code>s in a playlist can be removed from this event listener using
/// <code>PlaylistApi/remove(sourceAt:)</code>.
/// Limitation: The active <code>Source</code> cannot be removed.
/// Important: The <code>Source</code> has to be removed synchronously.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSourceError:(BMPSourceErrorEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when metadata is parsed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onMetadataParsed:(BMPMetadataParsedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called for each occurring player event.
/// \param event An event object holding specific event data.
/// Use  the event’s <code>Event/name</code> or <code>event is Type</code> to check the specific event type.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onEvent:(id <BMPSourceEvent> _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the drm data was parsed for the specific source.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onDrmDataParsed:(BMPDrmDataParsedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when an audio track is added.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onAudioAdded:(BMPAudioAddedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when an audio track is removed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onAudioRemoved:(BMPAudioRemovedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the audio track is changed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onAudioChanged:(BMPAudioChangedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when a side-loaded subtitle cue has been parsed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onCueParsed:(BMPCueParsedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when a new <code>SubtitleTrack</code> is added, for example using the <code>BMPPlayer/addSubtitle:</code> call.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSubtitleAdded:(BMPSubtitleAddedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when an external <code>SubtitleTrack</code> has been removed so it is possible to update the controls accordingly.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSubtitleRemoved:(BMPSubtitleRemovedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the active <code>SubtitleTrack</code> is changed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onSubtitleChanged:(BMPSubtitleChangedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the current video download quality has changed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onVideoDownloadQualityChanged:(BMPVideoDownloadQualityChangedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when the current video playback quality has changed.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onVideoPlaybackQualityChanged:(BMPVideoPlaybackQualityChangedEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
/// Called when FairPlay license was successfully acquired.
/// The object held by property <code>FairplayLicenseAcquiredEvent/contentKeyRequest</code> on the event can be used
/// for renewing expiring licenses
/// by <code>SourceDrmFairplayApi/renewExpiringLicense(for:)</code> via <code>Source.drm.fairplay</code> API.
/// \param event An object holding specific event data.
///
/// \param source The source instance which is associated with the emitted event.
///
- (void)onFairplayLicenseAcquired:(BMPFairplayLicenseAcquiredEvent * _Nonnull)event source:(id <BMPSource> _Nonnull)source;
@end

/// Contains config values regarding the behaviour when playing live streams.
/// note:
/// Disable <code>TweaksConfig/isCustomHlsLoadingEnabled</code> when intending to play HLS-LL streams
/// below iOS and tvOS 17. Due to platform limitations, HLS-LL streams are not supported there while
/// this property is enabled.
SWIFT_CLASS_NAMED("SourceLiveConfig")
@interface BMPSourceLiveConfig : NSObject
/// The minimum buffer depth of a stream needed to enable time shifting.
/// When the internal value for the maximal possible timeshift is lower than this value, timeshifting should be
/// disabled. That means <code>BMPPlayer/maxTimeShift</code> returns <code>0</code> in that case.
/// This value should always be non-positive value.
/// Default value is <code>-40</code>.
@property (nonatomic) NSTimeInterval minTimeshiftBufferDepth;
/// The target latency in seconds, i.e. the distance from the stream’s real live edge to be
/// maintained by the player during playback.
/// This defines the live edge as seen by the player, e.g. a <code>BMPPlayer/timeShift</code> to <code>0</code>
/// will end up at the player’s live edge, which is <code>targetLatency</code> away from the stream’s real
/// live edge. This value should always be positive.
/// Related APIs:
/// note:
/// The system works on a best effort basis but there is no guarantee that the target latency
/// will be always reached exactly. This is especially the case for lower values.
/// <ul>
///   <li>
///     To automatically preserve the configured latency set <code>automaticallyPreservesLatency</code> to <code>true</code>.
///   </li>
///   <li>
///     We recommend enabling <code>PlaybackConfig/isAutoplayEnabled</code> to achieve the best possible latency on stream
///     startup.
///   </li>
/// </ul>
/// Default value is <code>nan</code>, meaning that the default system behaviour is maintained.
@property (nonatomic) NSTimeInterval targetLatency;
/// Specifies if the player should try to automatically restore the previous playback position after a stall.
/// If set to <code>true</code>, the player will time shift to the last playback position after a stall ended (does not
/// have to be the configured <code>targetLatency</code>). For example, when the player stalls after
/// calling <code>player.timeShift = -10</code>, it will try to restore the <code>-10</code> seconds time shift automatically.
/// warning:
/// If the network cannot deliver media quickly enough, playback may be repeatedly interrupted
/// while the player attempts to catch up to the target latency.
/// Does not have any effect for VOD assets.
/// Default value is <code>false</code>
@property (nonatomic) BOOL automaticallyPreservesLatency;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceLoadEvent")
@interface BMPSourceLoadEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
- (nonnull instancetype)initWithSource:(id <BMPSource> _Nonnull)source OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceLoadedEvent")
@interface BMPSourceLoadedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
- (nonnull instancetype)initWithSource:(id <BMPSource> _Nonnull)source OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPSourceLoadedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceMetadataChangedEvent")
@interface BMPSourceMetadataChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// Contains metadata which was removed
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nullable from;
/// Contains metadata which was added
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nullable to;
- (nonnull instancetype)initWithOldMetadata:(NSDictionary<NSString *, id> * _Nullable)oldMetadata newMetadata:(NSDictionary<NSString *, id> * _Nullable)newMetadata;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceRemovedEvent")
@interface BMPSourceRemovedEvent : BMPPlayerEvent
/// The <code>Source</code> that was removed from the playlist.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The index at which the <code>Source</code> was removed from the playlist.
/// The value is greater than or equal to zero and is less than
/// the number of <code>Source</code>s in the playlist before removal.
@property (nonatomic, readonly) NSInteger index;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Types of media which can be handled by the Bitmovin Player.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPSourceType, "SourceType", open) {
/// Indicates a missing source type.
  BMPSourceTypeNone = 0,
/// Indicates media of type HLS.
  BMPSourceTypeHls = 1,
/// Indicates media of type DASH.
  BMPSourceTypeDash = 2,
/// Indicates media of type Progressive MP4.
  BMPSourceTypeProgressive = 3,
/// Indicates already downloaded media in Apple’s <code>movpkg</code> format.
/// This type could be used to playback a locally stored asset.
/// E.g. an asset that was not downloaded using our <code>OfflineManager</code>.
/// The <code>url</code> provided to the <code>SourceConfig</code> has to be a file url starting with <code>file://</code>.
/// Serving a <code>movpkg</code> via HTTP is not supported. If a HTTP url (starting with <code>http(s)://</code>)
/// is provided the initializer will fail and throw an exception.
/// AirPlay of a movpkg is supported when the device has an active network connection.
/// Limitations:
/// <ul>
///   <li>
///     Casting a source of type <code>movpkg</code> is not supported.
///   </li>
///   <li>
///     Playback of a partially downloaded <code>movpkg</code>, e.g. playback while still downloading, is not supported.
///   </li>
/// </ul>
  BMPSourceTypeMovpkg = 4,
};

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceUnloadEvent")
@interface BMPSourceUnloadEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
- (nonnull instancetype)initWithSource:(id <BMPSource> _Nonnull)source OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceUnloadedEvent")
@interface BMPSourceUnloadedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
- (nonnull instancetype)initWithSource:(id <BMPSource> _Nonnull)source OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SourceWarningEvent") SWIFT_DEPRECATED_MSG("\n    Warnings are now communicated through logs with level `.warning`. These logs are printed to the console\n    by default. You can also access them by providing your own logger to `DebugConfig.logging.logger`\"\n    ")
@interface BMPSourceWarningEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) enum BMPSourceWarningCode code;
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
- (nonnull instancetype)initWithCode:(enum BMPSourceWarningCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPSourceWarningEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("StallEndedEvent")
@interface BMPStallEndedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("StallStartedEvent")
@interface BMPStallStartedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPUserInterfaceType : NSInteger;
/// Contains config values which can be used to alter the visual presentation and behaviour of the player UI.
SWIFT_CLASS_NAMED("StyleConfig")
@interface BMPStyleConfig : NSObject
/// Sets if the the UI should be enabled or not.
/// Default value is <code>true</code>.
@property (nonatomic) BOOL isUiEnabled;
/// Set which user interface type should be used.
/// Default values are:
/// <ul>
///   <li>
///     <code>UserInterfaceType/bitmovin</code> on <code>iOS</code>
///   </li>
///   <li>
///     <code>UserInterfaceType/system</code> on <code>tvOS</code> and <code>visionOS</code>
///     This setting only applies if <code>StyleConfig/isUiEnabled</code> is set to <code>true</code>.
///   </li>
/// </ul>
@property (nonatomic) enum BMPUserInterfaceType userInterfaceType;
/// Set the CSS file that will be used for the UI. The default CSS file will be completely replaced by the CSS file
/// set with this property.
@property (nonatomic, copy) NSURL * _Nonnull playerUiCss SWIFT_AVAILABILITY(tvos,unavailable);
/// Set a CSS file which contains supplemental styles for the player UI.
/// These styles will be added to the default CSS
/// file or the CSS file set with StyleConfig#playerUiCss.
@property (nonatomic, copy) NSURL * _Nullable supplementalPlayerUiCss SWIFT_AVAILABILITY(tvos,unavailable);
/// Sets the JS file that will be used for the UI. The default JS file will be completely replaced by the JS file
/// set with this property.
@property (nonatomic, copy) NSURL * _Nonnull playerUiJs SWIFT_AVAILABILITY(tvos,unavailable);
/// Determines how the video content is scaled or stretched within the parent container’s bounds.
/// Possible values are defined in ScalingMode.
/// Default value is <code>ScalingMode/fit</code>.
@property (nonatomic) enum BMPScalingMode scalingMode;
/// An optional config object, containing config values which apply to
/// the selected user interface type.
/// <ul>
///   <li>
///     When <code>UserInterfaceType/system</code> is selected, a <code>SystemUserInterfaceConfig</code> can be set.
///   </li>
///   <li>
///     When <code>UserInterfaceType/subtitle</code> is selected, a <code>SubtitleUserInterfaceConfig</code> can be set.
///   </li>
/// </ul>
@property (nonatomic, strong) BMPUserInterfaceConfig * _Nullable userInterfaceConfig;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SubtitleAddedEvent")
@interface BMPSubtitleAddedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// The track that has been added.
@property (nonatomic, readonly, strong) BMPSubtitleTrack * _Nonnull subtitleTrack;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithSubtitleTrack:(BMPSubtitleTrack * _Nonnull)subtitleTrack OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPSubtitleAddedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SubtitleChangedEvent")
@interface BMPSubtitleChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// The track that was previously selected.
@property (nonatomic, readonly, strong) BMPSubtitleTrack * _Nullable subtitleTrackOld;
/// The track that is selected now
@property (nonatomic, readonly, strong) BMPSubtitleTrack * _Nullable subtitleTrackNew;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithNewSubtitleTrack:(BMPSubtitleTrack * _Nullable)newSubtitleTrack oldSubtitleTrack:(BMPSubtitleTrack * _Nullable)oldSubtitleTrack OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPSubtitleChangedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// This enum defines different subtitle formats supported by the player.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPSubtitleFormat, "SubtitleFormat", open) {
/// Web Video Text Tracks Format (WebVTT) subtitle format.
  BMPSubtitleFormatWebVtt = 0,
/// Timed Text Markup Language (TTML) subtitle format.
  BMPSubtitleFormatTtml = 1,
/// Closed Captioning (CEA) subtitle format.
  BMPSubtitleFormatCea = 2,
/// SubRip (SRT) subtitle format.
  BMPSubtitleFormatSrt = 3,
};

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("SubtitleRemovedEvent")
@interface BMPSubtitleRemovedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// The track that has been removed.
@property (nonatomic, readonly, strong) BMPSubtitleTrack * _Nonnull subtitleTrack;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithSubtitleTrack:(BMPSubtitleTrack * _Nonnull)subtitleTrack OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPSubtitleRemovedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

@protocol BMPSubtitleTrackController;
/// Describes a subtitle track.
SWIFT_CLASS_NAMED("SubtitleTrack")
@interface BMPSubtitleTrack : BMPTrack
/// Type of the SubtitleTrack.
/// Default is WebVTT.
@property (nonatomic, readonly) enum BMPSubtitleFormat format;
/// The IETF BCP 47 language tag associated with the subtitle track.
@property (nonatomic, readonly, copy) NSString * _Nullable language;
/// The language tag (RFC5646) associated with the <code>EXT-X-MEDIA</code> rendition.
/// Directly maps to the <code>ASSOC-LANGUAGE</code> attribute of a <code>EXT-X-MEDIA</code> entry.
@property (nonatomic, readonly, copy) NSString * _Nullable associatedLanguage;
/// The Media Characteristic Tags associated with the <code>EXT-X-MEDIA</code> rendition.
/// Directly maps to the <code>CHARACTERISTICS</code> attribute of a <code>EXT-X-MEDIA</code> entry.
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nonnull characteristics;
/// The subtitle track controller for this track.
@property (nonatomic, readonly, strong) id <BMPSubtitleTrackController> _Nonnull controller;
/// Tells if a subtitle track is forced. If set to true it means that the player should automatically select
/// and switch this subtitle according to the selected audio language.
/// Forced subtitles do not appear in <code>BMPPlayer/availableSubtitles</code>.
@property (nonatomic, readonly) BOOL isForced;
/// Creates a new subtitle track based on the given URL and provided metadata.
/// \param url The URL to the timed file, e.g. WebVTT file.
///
/// \param format Type of the subtitle track file, WebVTT or TTML.
///
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track
///
/// \param forced If set to <code>true</code>, this track would be considered as forced subtitle track.
///
///
/// returns:
/// A new subtitle track initialized with the given subtitle URL and the provided metadata.
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url format:(enum BMPSubtitleFormat)format label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language forced:(BOOL)forced;
/// Creates a new subtitle track based on the given URL and provided metadata.
/// \param url The URL to the timed file, e.g. WebVTT file.
///
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track
///
///
/// returns:
/// A new subtitle track initialized with the given subtitle URL and the provided metadata.
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language;
/// Creates a new subtitle track based on the given URL and provided metadata.
/// \param url The URL to the timed file, e.g. WebVTT file.
///
/// \param format Type of the subtitle track file, WebVTT or TTML.
///
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track
///
///
/// returns:
/// A new subtitle track initialized with the given subtitle URL and the provided metadata.
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url format:(enum BMPSubtitleFormat)format label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language;
/// Creates a new subtitle track based on the given URL and provided metadata.
/// \param url The URL to the timed file, e.g. WebVTT file.
///
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track
///
/// \param forced If set to <code>true</code>, this track would be considered as forced subtitle track.
///
///
/// returns:
/// A new subtitle track initialized with the given subtitle URL and the provided metadata.
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language forced:(BOOL)forced;
/// Creates a new subtitle track based on the given URL and provided metadata.
/// \param url The URL to the timed file, e.g. WebVTT file.
///
/// \param format Type of the subtitle track file, WebVTT or TTML.
///
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
/// \param language The IETF BCP 47 language tag associated with this track
///
/// \param forced If set to <code>true</code>, this track would be considered as forced subtitle track.
///
/// \param associatedLanguage The language tag (RFC5646) associated with this track.
///
/// \param characteristics The Media Characteristic Tags associated with the EXT-X-MEDIA rendition.
///
///
/// returns:
/// A new subtitle track initialized with the given subtitle URL and the provided metadata.
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url format:(enum BMPSubtitleFormat)format label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack language:(NSString * _Nullable)language forced:(BOOL)forced associatedLanguage:(NSString * _Nullable)associatedLanguage characteristics:(NSArray<NSString *> * _Nonnull)characteristics OBJC_DESIGNATED_INITIALIZER;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url trackType:(enum BMPTrackType)trackType label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack SWIFT_UNAVAILABLE;
@end

/// Enables external control over the associated BMPSubtitleTrack
SWIFT_PROTOCOL_NAMED("SubtitleTrackController")
@protocol BMPSubtitleTrackController <NSObject>
/// Triggers a <code>CueEnterEvent</code>.
/// <ul>
///   <li>
///     Parameters
///   </li>
///   <li>
///     cue: The <code>Cue</code> that should enter.
///   </li>
/// </ul>
- (void)cueEnter:(BMPCue * _Nonnull)cue;
/// Triggers a <code>CueExitEvent</code>.
/// <ul>
///   <li>
///     Parameters
///   </li>
///   <li>
///     cue: The <code>Cue</code> that should exit.
///   </li>
/// </ul>
- (void)cueExit:(BMPCue * _Nonnull)cue;
@end

/// Contains config values that can be used to alter the visual presentation and behaviour when the subtitle
/// only UI is used.
SWIFT_CLASS_NAMED("SubtitleUserInterfaceConfig")
@interface BMPSubtitleUserInterfaceConfig : BMPUserInterfaceConfig
/// An array of text style rules to apply to WebVTT subtitles and other legible text.
@property (nonatomic, copy) NSArray<AVTextStyleRule *> * _Nullable subtitleStyles;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class UIMenuElement;
@class UIAction;
@class UIViewController;
/// The <code>SystemUiApi</code> for interactions regarding the system UI.
/// Using this API just has an effect if <code>StyleConfig/userInterfaceType</code>
/// in <code>StyleConfig</code> is set to <code>UserInterfaceType/system</code>.
/// This is the default value on tvOS, on iOS it has to be set specifically.
SWIFT_PROTOCOL_NAMED("SystemUiApi")
@protocol BMPSystemUiApi
/// An array of actions and menus to display with the default player controls.
/// Contains the currently displayed items. Items can be added and removed dynamically at any time.
/// The initial state can be configured using <code>SystemUserInterfaceConfig/transportBarCustomMenuItems</code>
/// Use this property to display custom pop-up menus in transport bar. This property only supports menu elements of
/// type <code>UIAction</code> and <code>UIMenu</code>, and supports displaying inline one level of submenus.
@property (nonatomic, copy) NSArray<UIMenuElement *> * _Nonnull transportBarCustomMenuItems SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,unavailable);
/// An array of action controls to present contextually during playback. To dismiss the controls,
/// set this property value back to an empty array.
/// Default value is an empty array.
/// Use this property to present action controls for a specific time in the presentation, such as showing a
/// Skip Intro button during a title sequence.
/// Have your app observe the player’s timing, and when playback reaches a point at which to present controls,
/// set the property value to one or more custom actions.
/// note:
/// The player view presents contextual actions only when the transport bar isn’t visible.
@property (nonatomic, copy) NSArray<UIAction *> * _Nonnull contextualActions SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,unavailable);
/// An array of actions to present in the Info content view.
/// Default value is a single action that plays the current media from the beginning when tapped.
/// The Info content view can display up to two custom action controls along its trailing edge.
/// Contains the currently presented actions.
/// The default value (if present) can be replaced, an additional action can be added, or set this property
/// value to an empty array to display no actions.
@property (nonatomic, copy) NSArray<UIAction *> * _Nonnull infoViewActions SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,unavailable);
/// An array of view controllers to display as content tabs in the player user interface.
/// A default Info tab is displayed as the first content tab if <code>SourceConfig/title</code>
/// and <code>SourceConfig/sourceDescription</code> are not <code>nil</code>. This default tab cannot be modified.
/// If <code>SystemUserInterfaceConfig/showInfoViews</code> is set to <code>false</code>, no content tabs are displayed.
/// Custom tabs can be defined by creating subclasses of <code>UIViewController</code> and appending them to this array.
/// important:
/// Initialize the custom view controller’s <code>title</code> property value before setting it on this property.
/// The system uses the custom view controller’s <code>title</code> as the tab title.
/// important:
/// The view controller whose view has the greatest height determines the height for all
/// tab’s content views. Set the height of content views consistently using <code>preferredContentSize</code> to
/// simplify layout, or define appropriate auto layout constraints on their views.
@property (nonatomic, copy) NSArray<UIViewController *> * _Nonnull customInfoViewControllers SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,unavailable);
@end

/// Contains config values that can be used to alter the visual presentation and behaviour when the System
/// UI is used.
SWIFT_CLASS_NAMED("SystemUserInterfaceConfig")
@interface BMPSystemUserInterfaceConfig : BMPUserInterfaceConfig
/// An array of text style rules to apply to WebVTT subtitles and other legible text.
@property (nonatomic, copy) NSArray<AVTextStyleRule *> * _Nullable subtitleStyles;
/// When set to true the first frame of the main content will not be rendered before playback starts.
/// Default is <code>false</code>.
/// To reliably hide the first frame before a pre-roll ad, please ensure that you are using the
/// <code>AdvertisingConfig</code> to schedule ads and not the scheduleAd API call.
@property (nonatomic) BOOL hideFirstFrame;
/// Indicates whether to show the ‘Auto’ option when choosing subtitles or not.
/// Defaults to <code>true</code>.
/// This property is only available on tvOS.
@property (nonatomic) BOOL showAutoSubtitleOption SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
/// Indicates whether to show the seek bar and related controls during user interaction.
/// Default is <code>true</code>.
/// Depending on the tvOS version this property has a different behaviour:
/// <ul>
///   <li>
///     On tvOS 14 it controls the seek bar visibility.
///     Set this property to <code>false</code> to selectively prevent the seek bar from being displayed during user interaction.
///   </li>
///   <li>
///     On tvOS 15 and above it controls the seek bar and audio/subtitle track selection views visibility.
///     Set this property to <code>false</code> to selectively prevent the seek bar and audio/subtitle track selection views from
///     being displayed during user interaction.
///   </li>
/// </ul>
/// This property is only available on tvOS.
/// The new tvOS 15 System UI is only used when the app is built using Xcode 13.
@property (nonatomic) BOOL showSeekBar SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
/// Indicates whether to show the views for video metadata, navigation markers and playback settings when requested
/// by the user.
/// Default is <code>true</code>.
/// Depending on the tvOS version this property has a different behaviour:
/// <ul>
///   <li>
///     On tvOS 14 it controls the visibility of the info views which contains the media information and
///     audio/subtitle track selection.
///     If no <code>AVNavigationMarkersGroup</code>s or <code>AVMetadataItem</code>s are set, only the audio/subtitle selection view is shown.
///   </li>
///   <li>
///     On tvOS 15 and above it controls the visibility of the info views which contains the media information and
///     chapters if <code>AVNavigationMarkersGroup</code>s are configured. (The audio/subtitle selected was removed
///     from the info view)
///     If no <code>AVNavigationMarkersGroup</code>s or <code>AVMetadataItem</code>s are set, the info view isn’t shown.
///   </li>
/// </ul>
/// Set this property to <code>false</code> to selectively prevent the info views from being displayed during user interaction.
/// This property is only available on tvOS.
/// The new tvOS 15 System UI is only used when the app is built using Xcode 13.
@property (nonatomic) BOOL showInfoViews SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
/// Indicates whether the title is shown above the seek bar.
/// Default is <code>true</code>.
/// Set this property to <code>false</code> to selectively prevent the title from being displayed.
/// If <code>showSeekBar</code> is <code>false</code>, this property won’t have an effect.
/// This property is only available on tvOS 15 and above.
@property (nonatomic) BOOL showTitleInSeekBar SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,unavailable);
/// An array of actions and menus to display with the default player controls.
/// Empty by default.
/// Use this property to display custom pop-up menus in transport bar. This property only supports menu elements of
/// type <code>UIAction</code> and <code>UIMenu</code>, and supports displaying inline one level of submenus.
@property (nonatomic, copy) NSArray<UIMenuElement *> * _Nonnull transportBarCustomMenuItems SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,unavailable);
/// Called whenever the user is seeking in a VOD or time shifting in a Live source in the system UI. Can be used
/// to override the target time of the seek or time shift operation, for instance to prevent the user from
/// skipping over ads.
@property (nonatomic, copy) NSTimeInterval (^ _Nullable timeToSeekAfterUserSeeked)(NSTimeInterval, NSTimeInterval) SWIFT_AVAILABILITY(tvos,introduced=14.0) SWIFT_AVAILABILITY(ios,unavailable);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Describes a thumbnail track.
SWIFT_CLASS_NAMED("ThumbnailTrack")
@interface BMPThumbnailTrack : BMPTrack
/// Creates a new thumbnail track based on the given URL and provided metadata.
/// \param url The URL to the timed file, i.e. WebVTT file.
///
/// \param label The label for this track.
///
/// \param identifier The unique identifier for this track.
///
/// \param isDefaultTrack If set to <code>true</code>, this track would be considered as default.
///
///
/// returns:
/// A new <code>ThumbnailTrack</code> initialized with the given thumbnail URL and the provided metadata.
- (nonnull instancetype)initWithUrl:(NSURL * _Nonnull)url label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithUrl:(NSURL * _Nullable)url trackType:(enum BMPTrackType)trackType label:(NSString * _Nonnull)label identifier:(NSString * _Nonnull)identifier isDefaultTrack:(BOOL)isDefaultTrack SWIFT_UNAVAILABLE;
@end

@protocol _BMPThumbnailsApiDelegate;
/// Provides the means to interact and manage thumbnails.
/// Accessible through player’s <code>BMPPlayer/thumbnails</code> property.
/// This API is not supported during casting.
SWIFT_CLASS_NAMED("ThumbnailsApi")
@interface BMPThumbnailsApi : NSObject
@property (nonatomic, weak) id <_BMPThumbnailsApiDelegate> _Nullable _delegate;
/// Container view for the thumbnails to be rendered in.
/// All subviews of the assigned container will be managed by the SDK.
/// The SDK will not retain the container.
/// Assign <code>nil</code> to stop rendering thumbnails in the container, if desired.
/// For the best rendering performance:
/// important:
/// The visibility of the container has to be managed by the application. Don’t assign
/// a value of <code>nil</code> to this property to manage visibility.
/// note:
/// To trigger the rendering of a thumbnail for a specific time,
/// use <code>renderThumbnail(forTime:toleranceBefore:toleranceAfter:)</code>
/// or <code>renderThumbnail(for:time:toleranceBefore:toleranceAfter:)</code>.
/// <ul>
///   <li>
///     Call this before loading a <code>Source</code> or <code>SourceConfig</code> into the player.
///     This allows the thumbnails to be pre-warmed before the first render request.
///   </li>
///   <li>
///     To cancel any pending thumbnail rendering requests, instead of assigning <code>nil</code>,
///     call <code>cancelPendingRenderRequests()</code> for best results.
///   </li>
/// </ul>
@property (nonatomic, strong) UIView * _Nullable container;
/// Cancels any pending thumbnail rendering requests.
/// For best performance, do not call this method between calls to
/// <code>renderThumbnail(forTime:toleranceBefore:toleranceAfter:)</code>
/// or <code>renderThumbnail(for:time:toleranceBefore:toleranceAfter:)</code>.
/// Call this method only when all pending thumbnail rendering requests should be cut short immediately.
- (void)cancelPendingRenderRequests;
/// Returns the thumbnail image for the active <code>Source</code> at a certain time.
/// Requires a configured <code>ThumbnailTrack</code> in the corresponding <code>SourceConfig</code>.
/// This function returns <code>nil</code> in the following cases:
/// <ul>
///   <li>
///     If there is no active source.
///   </li>
///   <li>
///     If the thumbnails were not loaded yet.
///   </li>
///   <li>
///     If there are no <code>ThumbnailTrack</code>s provided in the corresponding <code>SourceConfig</code>s.
///   </li>
///   <li>
///     If there is no thumbnail available at the provided time.
///   </li>
/// </ul>
/// \param time The time for which the thumbnail should be returned.
///
///
/// returns:
/// An instance of <code>BMPThumbnail</code> for the given time, or <code>nil</code>.
- (BMPThumbnail * _Nullable)thumbnailForTime:(NSTimeInterval)time SWIFT_WARN_UNUSED_RESULT;
/// Renders a thumbnail for a specific time in the assigned thumbnail container
/// utilizing the media data instead of an optionally configured <code>ThumbnailTrack</code>.
/// For the best performance, it is recommended to be used with HLS streams,
/// that have <code>EXT-X-I-FRAME-STREAM-INF</code> tags with I-Frame playlists.
/// There is no need to throttle calls on the application side, see behavior on multiple calls below.
/// important:
/// A container must be assigned using <code>container</code> before calling this method.
/// If no container is registered, this method will be no-op.
/// <h2>When called:</h2>
/// <ul>
///   <li>
///     The thumbnail for the specified time will be rendered and displayed in the registered container.
///   </li>
/// </ul>
/// <h2>Behavior on Multiple Calls:</h2>
/// <ul>
///   <li>
///     If this method is called while thumbnail rendering is still in progress,
///     the rendering for the new time will be scheduled and performed
///     after the previous thumbnail rendering has finished.
///   </li>
///   <li>
///     If there is already an in-progress and pending rendering when called,
///     the previously pending call will be omitted and only the most recent call will be executed
///     after the in-progress rendering has finished.
///   </li>
/// </ul>
/// \param time The time for which the thumbnail should be rendered.
///
/// \param toleranceBefore The allowed time tolerance before the specified <code>time</code>.
/// Passing 0 will request frame accurate seeking, which may incur additional decoding delay.
/// Default value is 10 seconds.
///
/// \param toleranceAfter The allowed time tolerance after the specified <code>time</code>.
/// Passing 0 will request frame accurate seeking, which may incur additional decoding delay.
/// Default value is 10 seconds.
///
- (void)renderThumbnailForTime:(NSTimeInterval)time toleranceBefore:(NSTimeInterval)toleranceBefore toleranceAfter:(NSTimeInterval)toleranceAfter;
/// Renders a thumbnail for a specific time in the assigned thumbnail container
/// utilizing the media data instead of an optionally configured <code>ThumbnailTrack</code>.
/// For the best performance, it is recommended to be used with HLS streams,
/// that have <code>EXT-X-I-FRAME-STREAM-INF</code> tags with I-Frame playlists.
/// There is no need to throttle calls on the application side, see behavior on multiple calls below.
/// important:
/// A container must be assigned using <code>container</code> before calling this method.
/// If no container is registered, this method will be no-op.
/// <h2>When called:</h2>
/// <ul>
///   <li>
///     The thumbnail for the specified time will be rendered and displayed in the registered container.
///   </li>
/// </ul>
/// <h2>Behavior on Multiple Calls:</h2>
/// <ul>
///   <li>
///     If this method is called while thumbnail rendering is still in progress,
///     the rendering for the new time will be scheduled and performed
///     after the previous thumbnail rendering has finished.
///   </li>
///   <li>
///     If there is already an in-progress and pending rendering when called,
///     the previously pending call will be omitted and only the most recent call will be executed
///     after the in-progress rendering has finished.
///   </li>
/// </ul>
/// \param source The source for which the thumbnail should be rendered from.
/// This source has to be part of the playlist already.
///
/// \param time The time for which the thumbnail should be rendered.
///
/// \param toleranceBefore The allowed time tolerance before the specified <code>time</code>.
/// Passing 0 will request frame accurate seeking, which may incur additional decoding delay.
/// Default value is 10 seconds.
///
/// \param toleranceAfter The allowed time tolerance after the specified <code>time</code>.
/// Passing 0 will request frame accurate seeking, which may incur additional decoding delay.
/// Default value is 10 seconds.
///
- (void)renderThumbnailFor:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time toleranceBefore:(NSTimeInterval)toleranceBefore toleranceAfter:(NSTimeInterval)toleranceAfter;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("TimeChangedEvent")
@interface BMPTimeChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The <code>currentTime</code> of the player at which this event was emitted.
@property (nonatomic, readonly) NSTimeInterval currentTime;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithCurrentTime:(NSTimeInterval)currentTime OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("TimeShiftEvent")
@interface BMPTimeShiftEvent : BMPPlayerEvent
/// The absolute playback position as a Unix timestamp in seconds (<code>player.currentTime</code>) where the time-shift
/// started.
@property (nonatomic, readonly) NSTimeInterval position;
/// The desired playback position after the time-shift, as relative time in seconds. It is relative to
/// the beginning of the live (DVR) window at the point in time where playback of the stream started.
@property (nonatomic, readonly) NSTimeInterval target;
/// The desired playback position after the time-shift, as a time-shift value in seconds.
/// <ul>
///   <li>
///     A value of <code>0</code> indicates playback at the live edge.
///   </li>
///   <li>
///     A negative value indicates playback behind the live edge.
///   </li>
/// </ul>
@property (nonatomic, readonly) NSTimeInterval timeShift;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithPosition:(NSTimeInterval)position target:(NSTimeInterval)target timeShift:(NSTimeInterval)timeShift OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("TimeShiftedEvent")
@interface BMPTimeShiftedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Represents a timeline marker that can be visualized in the player UI.
/// It can represent a point in time or a time range.
SWIFT_PROTOCOL_NAMED("TimelineMarker")
@protocol BMPTimelineMarker
/// The start time of the marker.
@property (nonatomic) NSTimeInterval time;
/// The duration of the marker. Can be set to 0 if the marker depicts a point in time and not a time-range.
@property (nonatomic) NSTimeInterval duration;
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("TimelineMarkerEnterEvent")
@interface BMPTimelineMarkerEnterEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) id <BMPTimelineMarker> _Nonnull timelineMarker;
- (nonnull instancetype)initWithTimelineMarker:(id <BMPTimelineMarker> _Nonnull)timelineMarker OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("TimelineMarkerExitEvent")
@interface BMPTimelineMarkerExitEvent : NSObject <BMPPlayerViewEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) id <BMPTimelineMarker> _Nonnull timelineMarker;
- (nonnull instancetype)initWithTimelineMarker:(id <BMPTimelineMarker> _Nonnull)timelineMarker OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPTrack (SWIFT_EXTENSION(BitmovinPlayerCore)) <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
@end

@interface BMPTrack (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// The type of a track object.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPTrackType, "TrackType", open) {
/// Indicates a missing type
  BMPTrackTypeNone = 0,
/// Indicates a track containing textual data like the <code>SubtitleTrack</code>
  BMPTrackTypeText = 1,
/// Indicates a track containing thumbnail data like the <code>ThumbnailTrack</code>
  BMPTrackTypeThumbnail = 2,
/// Indicates a track containing audio data like the <code>AudioTrack</code>
  BMPTrackTypeAudio = 3,
};

enum BMPUnstallingBehaviour : NSUInteger;
/// This configuration is used as an incubator for experimental features.
/// Tweaks are not officially supported and are not guaranteed to be stable, i.e.
/// their naming, functionality and API can change at any time within the tweaks
/// or when being promoted to an official feature and moved into its final
/// configuration namespace.
SWIFT_CLASS_NAMED("TweaksConfig")
@interface BMPTweaksConfig : NSObject
/// If enabled, HLS playlists will be parsed and additional features and events are enabled.
/// This includes:
/// <ul>
///   <li>
///     <code>MetadataEvent</code>s carrying segment-specific metadata for custom HLS tags, like <code>#EXT-X-SCTE35</code>
///   </li>
///   <li>
///     <code>MetadataParsedEvent</code>s carrying segment-specific metadata for custom HLS tags, like <code>#EXT-X-SCTE35</code>
///   </li>
///   <li>
///     <code>DrmDataParsedEvent</code>s when a #EXT-X-KEY is found
///   </li>
///   <li>
///     <code>BMPPlayer/availableVideoQualities</code> includes additional information
///   </li>
/// </ul>
/// Default is <code>false</code>.
@property (nonatomic) BOOL isNativeHlsParsingEnabled;
/// If enabled, playlists will be downloaded by the Bitmovin Player SDK instead of <code>AVFoundation</code>.
/// This enables additional features and events, like <code>DownloadFinishedEvent</code>s for playlist downloads.
/// If set to <code>false</code>, enabling <code>nativeHlsParsingEnabled</code> won’t have any effect.
/// note:
/// Due to platform limitations, HLS Low Latency streams are not supported below iOS and tvOS 17 while this
/// property is enabled. Disable custom HLS loading when intending to play HLS-LL streams below iOS and tvOS 17.
/// Default is <code>true</code>.
@property (nonatomic) BOOL isCustomHlsLoadingEnabled;
/// The frequency in seconds <code>PlayerListener/onTimeChanged(_:player:)</code> is called with <code>TimeChangedEvent</code>s.
/// Limitations:
/// <ul>
///   <li>
///     Due to a system limitation, the minimum frequency during AirPlay of a Live stream with an
///     <code>EXT-X-PROGRAM-DATE-TIME</code> tag is 1.
///   </li>
/// </ul>
/// Default is 1. Minimum is 0.025.
@property (nonatomic) NSTimeInterval timeChangedInterval;
/// The threshold which will be applied when seeking to the end in seconds.
/// In a VOD this value will be used to calculate the maximum seekable time when calling <code>BMPPlayer/seek:</code> or
/// <code>PlaylistApi/seek(source:time:)</code>, so the maximum value will be <code>duration - seekToEndThreshold</code>.
/// In a Live Stream this value will be used to calculate the minimum seekable time when seeking to the beginning
/// of the DVR window via <code>BMPPlayer/timeShift</code>. The Value will be <code>maxTimeShift + seekToEndThreshold</code>.
/// <em>Time-shifting to the live edge is not affected by this.</em>
/// This is useful if the duration of the segments does not match the duration specified in the manifest.
/// In this case, if we try to seek to the end, <code>AVPlayer</code> could get stuck and might stall forever
/// Therefore increasing this value could help.
/// Default is <code>0.5</code>.
@property (nonatomic) NSTimeInterval seekToEndThreshold;
/// Specifies the player behaviour when <code>BMPPlayer/play</code> is called.
/// Default is <code>PlaybackStartBehaviour/relaxed</code>.
@property (nonatomic) enum BMPPlaybackStartBehaviour playbackStartBehaviour;
/// Specifies the player behaviour when stalling should be exited.
/// Default is <code>UnstallingBehaviour/relaxed</code>.
@property (nonatomic) enum BMPUnstallingBehaviour unstallingBehaviour;
/// If set to <code>true</code>, the timing of initial subtitle handling will be delayed until the <code>Source</code> is ready to start
/// playback. This can be helpful when having a live stream with a growing DVR window and a default subtitle track.
/// In this case, there might be an <code>AVPlayer</code> race-condition that happens occasionally which results in <code>AVPlayer</code>
/// starting playback at the beginning of the DVR window instead if at the live-edge.
/// In other cases, setting this to <code>true</code> does not have any positive effect.
/// Default is <code>false</code>.
@property (nonatomic) BOOL delayInitialSubtitleSelection;
/// Specify the behaviour for Ads when casting.
/// <ul>
///   <li>
///     If set to <code>false</code>, the player will delay advertisements playback while casting
///     and play them play them once casting has stopped.
///     In case of VMAP ads, only the last missed ad break will be played by the Google IMA SDK.
///     In case of playback finishing during casting, no advertisements will be played when stopping casting.
///   </li>
///   <li>
///     If set to <code>true</code>, the player will discard advertisements played-over or skipped-over while casting.
///   </li>
/// </ul>
/// In-progress advertisement when casting starts is always skipped.
/// Default is <code>false</code>.
@property (nonatomic) BOOL discardAdsWhileCasting SWIFT_AVAILABILITY(tvos,unavailable);
/// Determines whether <code>AVKit</code> should update Now Playing information automatically when using System UI.
/// note:
/// When <code>NowPlayingConfig/isNowPlayingInfoEnabled</code> is <code>true</code>, this flag is automatically
/// treated as <code>false</code>.
/// <ul>
///   <li>
///     If set to <code>false</code>, the automatic updates of Now Playing Info sent by <code>AVKit</code> are disabled.
///     This prevents interference with manual updates you may want to perform.
///   </li>
///   <li>
///     If set to <code>true</code>, the default behaviour is maintained, allowing <code>AVKit</code> to handle Now Playing updates.
///   </li>
/// </ul>
/// Default is <code>true</code>.
@property (nonatomic) BOOL updatesNowPlayingInfoCenter SWIFT_DEPRECATED_MSG("\n        To enable the Now Playing information use `NowPlayingConfig.isNowPlayingInfoEnabled`\n        ") SWIFT_AVAILABILITY(tvos,unavailable);
/// Minimum buffer level, in seconds, required for transitioning into the playing state.
/// Has to be set to a value greater or equal to <code>0</code>.
/// note:
/// This tweak can be useful to fix an eventual continuous flickering of stall events (getting
/// <code>StallStartedEvent</code> and <code>StallEndedEvent</code> rapidly one after each other), which may be caused by AVPlayer
/// switching states abruptly for some reason (for example when losing network and reaching an
/// empty buffer on progressive audio-only streams).
/// <ul>
///   <li>
///     If set to <code>0</code>, this tweak is disabled and no minimum buffer level is enforced.
///   </li>
///   <li>
///     If set to a value greater than <code>0</code>, the playback will change to the playing state only when the
///     forward buffer reaches a level greater than the set value.
///   </li>
/// </ul>
/// Default is <code>0</code> (disabled).
@property (nonatomic) NSTimeInterval enforcedMinimumBufferLevelForPlayback;
/// If enabled, the player will use date-based time shifting for HLS Live streams
/// where <code>#EXT-X-PROGRAM-DATE-TIME</code> is available and <code>SourceLiveConfig/targetLatency</code> is set.
/// This improves reaching target latency for HLS Low Latency streams.
/// Default is <code>false</code>.
@property (nonatomic) BOOL dateBasedTimeShiftingForLiveStreams SWIFT_DEPRECATED_MSG("\n        This property has no effect anymore and will be removed in a future release.\n        When setting SourceLiveConfig.targetLatency to any other value than .nan, then\n        date-based time shifting is automatically enabled.\n        ");
/// If enabled, the player will restore the playback position of the sender when AirPlay is started with a stream
/// where no <code>#EXT-X-PROGRAM-DATE-TIME</code> is available.
/// Has no effects on HLS Live streams with <code>#EXT-X-PROGRAM-DATE-TIME</code> where the sender’s playback position
/// is always restored.
/// <h2>Limitations:</h2>
/// <ul>
///   <li>
///     The live edge frame will be visible on the AirPlay receiver until the playback position is restored.
///   </li>
/// </ul>
/// Default is <code>true</code>.
@property (nonatomic) BOOL restoreAirPlayPlaybackPosition SWIFT_AVAILABILITY(tvos,unavailable);
/// If enabled, the player will populate additional attributes for the <code>EXT-X-MEDIA</code> rendition
/// from the HLS manifest.
/// For now this includes the <code>ASSOC-LANGUAGE</code> and <code>CHARACTERISTICS</code> attributes.
/// See <code>SubtitleTrack</code> and <code>AudioTrack</code> for available attributes.
/// Default is <code>true</code>.
@property (nonatomic) BOOL parseAdditionalMediaAttributes;
/// Specifies the action to take when a <code>Source</code> fails.
/// Failures during (pre-)loading or during playback are handled.
/// Default is <code>SourceFailureAction/none</code>.
@property (nonatomic) enum BMPSourceFailureAction sourceFailureAction;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("UnmutedEvent")
@interface BMPUnmutedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Specifies the player behaviour when stalling should be exited.
typedef SWIFT_ENUM_NAMED(NSUInteger, BMPUnstallingBehaviour, "UnstallingBehaviour", open) {
/// The player will wait until the buffer is filled that it can, most likely,
/// ensure continuous playback without another stalling right after playback continued.
  BMPUnstallingBehaviourRelaxed = 0,
/// The player will try to unstall as soon as some media data became available and will
/// start playback of this media immediately.
  BMPUnstallingBehaviourAggressive = 1,
};

/// Indicates which type of UI should be used.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPUserInterfaceType, "UserInterfaceType", open) {
/// Indicates that Bitmovin’s customizable UI should be used.
  BMPUserInterfaceTypeBitmovin = 0,
/// Indicates that the system UI should be used.
  BMPUserInterfaceTypeSystem = 1,
/// Indicates that only subtitles should be displayed along with the video content
  BMPUserInterfaceTypeSubtitle = 2,
};

/// Represents a VAST macro for <code>VastMacroConfig/VastMacroValueProvider</code>.
SWIFT_CLASS_NAMED("VastMacro")
@interface BMPVastMacro : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class BMPVastMacroContext;
/// Contains configuration options for VAST macros.
SWIFT_CLASS_NAMED("VastMacroConfig")
@interface BMPVastMacroConfig : NSObject
/// Value provider for VAST macros.
/// The returned values are used to replace the VAST macros in the ad tag and tracking URLs.
/// See <code>VastMacroValueProvider</code> for details.
/// note:
/// The value provider is called for each VAST macro in the ad tag and tracking URLs.
@property (nonatomic, copy) NSArray<NSString *> * _Nonnull (^ _Nullable valueProvider)(BMPVastMacro * _Nonnull, BMPVastMacroContext * _Nonnull);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum BMPVastMacroScope : NSInteger;
/// Context for VAST macro replacement.
SWIFT_CLASS_NAMED("VastMacroContext")
@interface BMPVastMacroContext : NSObject
/// The kind for macro replacement.
@property (nonatomic, readonly) enum BMPVastMacroScope scope;
/// Initialize macro replacement context.
/// \param scope kind of macro replacement.
///
- (nonnull instancetype)initWithScope:(enum BMPVastMacroScope)scope OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Context kind for VAST macro replacement.
typedef SWIFT_ENUM_NAMED(NSInteger, BMPVastMacroScope, "VastMacroScope", open) {
/// Value is used for resolving ad tag request URI macro placeholders.
  BMPVastMacroScopeRequestUri = 0,
/// Value is used for resolving tracking URL macro placeholders.
  BMPVastMacroScopeTracking = 1,
};

/// See <code>BMPUserInterfaceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("VideoBoundsChangedEvent") SWIFT_AVAILABILITY(tvos,unavailable)
@interface BMPVideoBoundsChangedEvent : NSObject <BMPPlayerViewEvent>
/// The old video bounds.
@property (nonatomic, readonly) CGRect from;
/// The new video bounds.
@property (nonatomic, readonly) CGRect to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)initFrom:(CGRect)from to:(CGRect)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class BMPVideoQuality;
/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("VideoDownloadQualityChangedEvent")
@interface BMPVideoDownloadQualityChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// Previous video quality
@property (nonatomic, readonly, strong) BMPVideoQuality * _Nullable videoQualityOld;
/// New video quality
@property (nonatomic, readonly, strong) BMPVideoQuality * _Nullable videoQualityNew;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithNewVideoQuality:(BMPVideoQuality * _Nullable)newVideoQuality oldVideoQuality:(BMPVideoQuality * _Nullable)oldVideoQuality OBJC_DESIGNATED_INITIALIZER;
@end

@interface BMPVideoDownloadQualityChangedEvent (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>SourceListener</code> for more information on this event.
SWIFT_CLASS_NAMED("VideoPlaybackQualityChangedEvent")
@interface BMPVideoPlaybackQualityChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
/// Previous video quality. It is <code>nil</code> when the event is fired for the initial change to a video quality.
@property (nonatomic, readonly, strong) BMPVideoQuality * _Nullable videoQualityOld;
/// New video quality.
@property (nonatomic, readonly, strong) BMPVideoQuality * _Nonnull videoQualityNew;
- (nonnull instancetype)initWithVideoQualityOld:(BMPVideoQuality * _Nullable)videoQualityOld videoQualityNew:(BMPVideoQuality * _Nonnull)videoQualityNew OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Quality definition of a video representation.
SWIFT_CLASS_NAMED("VideoQuality")
@interface BMPVideoQuality : BMPQuality
/// The width of the video representation.
@property (nonatomic, readonly) NSUInteger width;
/// The height of the video representation.
@property (nonatomic, readonly) NSUInteger height;
/// Creates a quality definition for a video representation based on the provided data.
/// \param identifier The unique identifier of the video representation.
///
/// \param label The label of the video representation that should be exposed to the user (e.g. in the UI).
///
/// \param bitrate The bitrate of the video representation.
///
/// \param codec The codec of the video representation.
///
/// \param width The width of the video representation.
///
/// \param height The height of the video representation.
///
- (nonnull instancetype)initWithIdentifier:(NSString * _Nonnull)identifier label:(NSString * _Nonnull)label bitrate:(NSUInteger)bitrate codec:(NSString * _Nullable)codec width:(NSUInteger)width height:(NSUInteger)height OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithIdentifier:(NSString * _Nonnull)identifier label:(NSString * _Nonnull)label bitrate:(NSUInteger)bitrate codec:(NSString * _Nullable)codec SWIFT_UNAVAILABLE;
@end

@interface BMPVideoQuality (SWIFT_EXTENSION(BitmovinPlayerCore))
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("VideoSizeChangedEvent") SWIFT_DEPRECATED_MSG("This event is not available anymore.")
@interface BMPVideoSizeChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("VttLine")
@interface BMPVttLine : NSObject
/// Defines the type of the <code>VttLine</code> value, set to auto or to an actual numeric value
/// Default: VttLineValueTypeAuto
@property (nonatomic, readonly) enum BMPVttLineValueType type;
/// The actual value for the line property
/// note:
/// When type is set to <code>VttLineValueType/auto</code> the value should be ignored
@property (nonatomic, readonly) double value;
+ (BMPVttLine * _Nonnull)_createWithType:(enum BMPVttLineValueType)type value:(double)value SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPVttLine (SWIFT_EXTENSION(BitmovinPlayerCore)) <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("VttPosition")
@interface BMPVttPosition : NSObject
/// Defines the type of the <code>VttPosition</code> value, set to auto or to an actual numeric value
/// Default: VttPositionValueTypeAuto
@property (nonatomic, readonly) enum BMPVttPositionValueType type;
/// The actual value for the position property
/// note:
/// When type is set to <code>VttLineValueType/auto</code> the value should be ignored
@property (nonatomic, readonly) double value;
+ (BMPVttPosition * _Nonnull)_createWithType:(enum BMPVttPositionValueType)type value:(double)value SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface BMPVttPosition (SWIFT_EXTENSION(BitmovinPlayerCore)) <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("VttProperties")
@interface BMPVttProperties : NSObject
/// Returns the writing direction
/// Default: VttVerticalUnset
/// note:
/// <code>BMPVttVerticalUnset</code> means the writing direction should be horizontal
@property (nonatomic, readonly) BMPVttVertical _Nonnull vertical;
/// Returns the vertical position of the cue box
@property (nonatomic, readonly, strong) BMPVttLine * _Nonnull line;
/// Returns the alignment of the line property
/// note:
/// See <code>VttLineAlign</code> for more information
@property (nonatomic, readonly) BMPVttLineAlign _Nonnull lineAlign;
/// Returns whether the line attribute should be interpreted as absolute line number or as relative position
@property (nonatomic, readonly) BOOL snapToLines;
/// Returns the size of the cue box relative to the video dimensions
/// Default: 100
/// note:
/// If the writing direction is horizontal, then the size percentages are relative
/// to the width of the video, otherwise to the height of the video
@property (nonatomic, readonly) double size;
/// Returns the text alignment inside the cue box
@property (nonatomic, readonly) BMPVttAlign _Nonnull align;
/// Returns the horizontal position of the cue box
@property (nonatomic, readonly, strong) BMPVttPosition * _Nonnull position;
/// Returns the alignment of the line property
/// Default: VttPositionAlignAuto
/// note:
/// See <code>VttPositionAlign</code> for more information
@property (nonatomic, readonly) BMPVttPositionAlign _Nonnull positionAlign;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
+ (BMPVttProperties * _Nonnull)_createWithVertical:(BMPVttVertical _Nonnull)vertical line:(BMPVttLine * _Nonnull)line lineAlign:(BMPVttLineAlign _Nonnull)lineAlign snapToLines:(BOOL)snapToLines size:(double)size align:(BMPVttAlign _Nonnull)align position:(BMPVttPosition * _Nonnull)position positionAlign:(BMPVttPositionAlign _Nonnull)positionAlign SWIFT_WARN_UNUSED_RESULT;
@end

@interface BMPVttProperties (SWIFT_EXTENSION(BitmovinPlayerCore)) <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
@end

@interface BMPVttProperties (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

/// Represents a Widevine DRM config.
SWIFT_CLASS_NAMED("WidevineConfig")
@interface BMPWidevineConfig : BMPDrmConfig
/// A dictionary to specify custom HTTP headers for the license request.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nonnull licenseRequestHeaders;
/// Specifies how long in milliseconds should be waited before a license request should be retried. Default is 0.
@property (nonatomic) NSUInteger licenseRequestRetryDelay;
/// Specifies how often a license request should be retried
/// if it was not successful (e.g. the license server was not reachable).
/// Default is 1. Assigning 0 disables retries.
@property (nonatomic) NSUInteger maxLicenseRequestRetries;
/// A JSON string which allows to specify config options of the DRM key system, such as
/// distinctiveIdentifier or persistentState.
@property (nonatomic, copy) NSString * _Nullable mediaKeySystemConfig;
/// Creates a new <code>WidevineConfig</code> based on the given license URL.
/// \param licenseUrl The URL to the license server.
///
///
/// returns:
/// A new Widevine config initialized with the given license URL.
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithLicenseUrl:(NSURL * _Nullable)licenseUrl uuid:(NSUUID * _Nonnull)uuid SWIFT_UNAVAILABLE;
@end

@interface BMPWidevineConfig (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPCafDrmConfigConvertible>
- (_BMPCafDrmConfig * _Nullable)toCafDrmConfigWithRemoteControlConfig:(BMPRemoteControlConfig * _Nonnull)remoteControlConfig SWIFT_WARN_UNUSED_RESULT;
@end

@protocol _BMPAdLoader;
@class _BMPScheduledAdItem;
SWIFT_PROTOCOL_NAMED("_AdLoaderDelegate")
@protocol _BMPAdLoaderDelegate
- (void)adLoader:(id <_BMPAdLoader> _Nonnull)adLoader willStartLoadingScheduledAdItem:(_BMPScheduledAdItem * _Nonnull)willStartLoading;
- (void)adLoader:(id <_BMPAdLoader> _Nonnull)adLoader didFinishLoadingScheduledAdItem:(_BMPScheduledAdItem * _Nonnull)didFinishLoading downloadDuration:(NSTimeInterval)downloadDuration;
- (void)adLoader:(id <_BMPAdLoader> _Nonnull)adLoader didFailLoadingScheduledAdItem:(_BMPScheduledAdItem * _Nullable)didFailLoading adConfig:(id <BMPAdConfig> _Nullable)adConfig error:(NSError * _Nonnull)error;
@end

@protocol _BMPAdQuartileHandlerDelegate;
SWIFT_CLASS_NAMED("_AdQuartileHandler")
@interface _BMPAdQuartileHandler : NSObject
@property (nonatomic, weak) id <_BMPAdQuartileHandlerDelegate> _Nullable delegate;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (void)reset;
- (void)timeChangedTo:(NSTimeInterval)currentTime duration:(NSTimeInterval)duration;
@end

SWIFT_PROTOCOL_NAMED("_AdQuartileHandlerDelegate")
@protocol _BMPAdQuartileHandlerDelegate
- (void)adQuartileHandler:(_BMPAdQuartileHandler * _Nonnull)adQuartileHandler didReach:(BMPAdQuartile)adQuartile;
@end

SWIFT_PROTOCOL_NAMED("_AdvertisingApiDelegate")
@protocol _BMPAdvertisingApiDelegate
@property (nonatomic, readonly, copy) NSArray<id <BMPAdBreak>> * _Nonnull advertisingApi_schedule;
- (void)advertisingApi_skip;
- (void)advertisingApi_scheduleAdItem:(BMPAdItem * _Nonnull)adItem;
- (void)advertisingApi_registerAdContainer:(UIView * _Nonnull)adContainer;
@end

SWIFT_PROTOCOL_NAMED("_AdvertisingService")
@protocol _BMPAdvertisingService <NSObject>
@property (nonatomic, readonly) BOOL isAd;
@property (nonatomic, readonly) BOOL isMuted;
@property (nonatomic, readonly) BOOL isPlaying;
@property (nonatomic, readonly) BOOL isPaused;
@property (nonatomic, readonly) NSTimeInterval currentTime;
@property (nonatomic, readonly) NSTimeInterval duration;
@property (nonatomic, readonly, copy) NSArray<id <BMPAdBreak>> * _Nonnull schedule;
- (void)skipAd;
- (void)skipAdBreak;
- (_BMPScheduledAdItem * _Nullable)scheduleWithAdItem:(BMPAdItem * _Nonnull)adItem;
- (void)registerWithAdContainer:(UIView * _Nonnull)adContainer;
- (void)play;
- (void)pause;
- (void)mute;
- (void)unmute;
- (void)setWithVolume:(NSInteger)volume;
- (BOOL)hasAdsAfterDiscardingAdsThatShouldNotBeLoadedWithPlaybackTime:(NSTimeInterval)playbackTime forwardBufferLevel:(NSTimeInterval)forwardBufferLevel SWIFT_WARN_UNUSED_RESULT;
@end

@protocol _BMPPersistentArchive;
/// Handles the interaction with the archive where we store metadata about the offline content.
/// In addition it provides URLs which are needed from time to time.
SWIFT_PROTOCOL_NAMED("_ArchiveHelper")
@protocol _BMPArchiveHelper
/// Unique identifier of the source
@property (nonatomic, readonly, copy) NSString * _Nullable sourceIdentifier;
/// The archive storing all offline related custom metadata
@property (nonatomic, readonly, strong) id <_BMPPersistentArchive> _Nullable archive;
/// The URL to the directory where the archive / plist file is stored
@property (nonatomic, readonly, copy) NSURL * _Nullable offlineContentDirectoryUrl;
/// The URL to the MOVPKG aka the downloaded video / content
@property (nonatomic, readonly, copy) NSURL * _Nullable offlineContentUrl;
/// Convenience method to check if we have stored content
@property (nonatomic, readonly) BOOL isStored;
@end

@class _BMPHashedIdentifier;
@class _BMPPersistenceManager;
@protocol _BMPObjCLoggerService;
SWIFT_CLASS_NAMED("_ArchiveHelperFactory")
@interface _BMPArchiveHelperFactory : NSObject
+ (id <_BMPArchiveHelper> _Nonnull)createForSourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig withIdentifier:(_BMPHashedIdentifier * _Nonnull)id persistenceManager:(_BMPPersistenceManager * _Nonnull)persistenceManager loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class _BMPAVPlayerItem;
@class AVPlayerItem;
SWIFT_CLASS("_TtC18BitmovinPlayerCore12_BMPAVPlayer")
@interface _BMPAVPlayer : AVQueuePlayer
@property (nonatomic, readonly, strong) _BMPAVPlayerItem * _Nullable currentItem;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (void)observeValueForKeyPath:(NSString * _Nullable)keyPath ofObject:(id _Nullable)object change:(NSDictionary<NSKeyValueChangeKey, id> * _Nullable)change context:(void * _Nullable)context;
- (nonnull instancetype)initWithItems:(NSArray<AVPlayerItem *> * _Nonnull)items SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithURL:(NSURL * _Nonnull)URL SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithPlayerItem:(AVPlayerItem * _Nullable)item SWIFT_UNAVAILABLE;
@end

@class AVAsset;
SWIFT_CLASS("_TtC18BitmovinPlayerCore16_BMPAVPlayerItem")
@interface _BMPAVPlayerItem : AVPlayerItem
- (void)observeValueForKeyPath:(NSString * _Nullable)keyPath ofObject:(id _Nullable)object change:(NSDictionary<NSKeyValueChangeKey, id> * _Nullable)change context:(void * _Nullable)context;
- (nonnull instancetype)initWithAsset:(AVAsset * _Nonnull)asset automaticallyLoadedAssetKeys:(NSArray<NSString *> * _Nullable)automaticallyLoadedAssetKeys SWIFT_UNAVAILABLE;
@end

@interface _BMPAVPlayerItem (SWIFT_EXTENSION(BitmovinPlayerCore))
- (void)seekToTime:(CMTime)time toleranceBefore:(CMTime)toleranceBefore toleranceAfter:(CMTime)toleranceAfter completionHandler:(void (^ _Nullable)(BOOL))completionHandler;
- (BOOL)seekToDate:(NSDate * _Nonnull)date completionHandler:(void (^ _Nullable)(BOOL))completionHandler SWIFT_WARN_UNUSED_RESULT;
@end

@interface _BMPAVPlayerItem (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, readonly) float timebaseEffectiveRate;
@end

@class _BMPDataResponse;
/// Obj-C compatible version of <code>DataRequest</code>.
SWIFT_CLASS("_TtC18BitmovinPlayerCore15_BMPDataRequest")
@interface _BMPDataRequest : NSObject
@property (nonatomic, readonly) BOOL isCancelled;
- (void)responseWithCompletionHandler:(void (^ _Nonnull)(_BMPDataResponse * _Nonnull))completionHandler;
- (void)cancel;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class NSHTTPURLResponse;
@class _BMPRequestMetrics;
/// Obj-C compatible version of <code>DataResponse</code>.
SWIFT_CLASS("_TtC18BitmovinPlayerCore16_BMPDataResponse")
@interface _BMPDataResponse : NSObject
@property (nonatomic, readonly, copy) NSURLRequest * _Nullable request;
@property (nonatomic, readonly, strong) NSHTTPURLResponse * _Nullable response;
@property (nonatomic, readonly, copy) NSData * _Nullable data;
@property (nonatomic, readonly) NSError * _Nullable error;
@property (nonatomic, readonly, strong) _BMPRequestMetrics * _Nullable metrics;
- (nonnull instancetype)initWithRequest:(NSURLRequest * _Nullable)request response:(NSHTTPURLResponse * _Nullable)response data:(NSData * _Nullable)data error:(NSError * _Nullable)error metrics:(_BMPRequestMetrics * _Nullable)metrics OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC18BitmovinPlayerCore9_BMPError")
@interface _BMPError : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull domain;
@property (nonatomic, readonly) NSError * _Nonnull error;
@property (nonatomic, readonly) NSInteger code;
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
@property (nonatomic, readonly, copy) NSString * _Nonnull localizedDescription;
- (nonnull instancetype)initWithError:(NSError * _Nonnull)error;
- (nonnull instancetype)initWithError:(NSError * _Nonnull)error errorMessagePrefix:(NSString * _Nullable)errorMessagePrefix supplementalErrorCodesForMessageLookup:(NSArray<NSNumber *> * _Nullable)supplementalErrorCodesForMessageLookup;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (_BMPError * _Nonnull)copyWithMessage:(NSString * _Nonnull)message SWIFT_WARN_UNUSED_RESULT;
- (_BMPError * _Nonnull)copyWithCode:(NSInteger)code SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Obj-C compatible version of <code>RequestConfig</code>.
SWIFT_CLASS("_TtC18BitmovinPlayerCore17_BMPRequestConfig")
@interface _BMPRequestConfig : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol _BMPSourceEventEmitter;
SWIFT_CLASS("_TtC18BitmovinPlayerCore24_BMPRequestConfigFactory")
@interface _BMPRequestConfigFactory : NSObject
- (nonnull instancetype)initWithLoggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService;
- (_BMPRequestConfig * _Nonnull)createWithUrl:(NSURL * _Nonnull)url type:(BMPHttpRequestType _Nonnull)type networkConfig:(BMPNetworkConfig * _Nonnull)networkConfig eventEmitter:(id <_BMPSourceEventEmitter> _Nonnull)eventEmitter enableFallbackRetryHandling:(BOOL)enableFallbackRetryHandling SWIFT_WARN_UNUSED_RESULT;
- (_BMPRequestConfig * _Nonnull)createWithRequest:(NSURLRequest * _Nonnull)request type:(BMPHttpRequestType _Nonnull)type networkConfig:(BMPNetworkConfig * _Nonnull)networkConfig onDownloadFinished:(void (^ _Nonnull)(_BMPRequestMetrics * _Nonnull))onDownloadFinished SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Obj-C compatible version of <code>RequestMetrics</code>.
SWIFT_CLASS("_TtC18BitmovinPlayerCore18_BMPRequestMetrics")
@interface _BMPRequestMetrics : NSObject
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
@property (nonatomic, readonly, copy) NSURL * _Nullable redirectUrl;
@property (nonatomic, readonly) NSTimeInterval downloadTime;
@property (nonatomic, readonly) NSInteger httpStatus;
@property (nonatomic, readonly) NSInteger responseSize;
@property (nonatomic, readonly) BOOL validationSuccessful;
@property (nonatomic, readonly) NSError * _Nullable error;
@property (nonatomic, readonly) NSInteger retries;
@property (nonatomic, readonly, strong) BMPHttpResponse * _Nullable httpResponse;
- (nonnull instancetype)initWithUrl:(NSURL * _Nonnull)url redirectUrl:(NSURL * _Nullable)redirectUrl downloadTime:(NSTimeInterval)downloadTime httpStatus:(NSInteger)httpStatus responseSize:(NSInteger)responseSize validationSuccessful:(BOOL)validationSuccessful error:(NSError * _Nullable)error retries:(NSInteger)retries httpResponse:(BMPHttpResponse * _Nullable)httpResponse OBJC_DESIGNATED_INITIALIZER;
- (_BMPRequestMetadata * _Nonnull)toRequestMetadataWith:(BMPHttpRequestType _Nonnull)type SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Obj-C compatible version of <code>RetryResult</code>.
SWIFT_CLASS("_TtC18BitmovinPlayerCore15_BMPRetryResult")
@interface _BMPRetryResult : NSObject
/// Whether retry should be attempted.
@property (nonatomic, readonly) BOOL retry;
/// The delay in seconds for the retry.
@property (nonatomic, readonly) NSTimeInterval delay;
/// The modified request that should be used for the retry.
@property (nonatomic, readonly, copy) NSURLRequest * _Nullable modifiedRequest;
- (nonnull instancetype)initWithDelay:(NSTimeInterval)delay;
- (nonnull instancetype)initWithRetry:(BOOL)retry;
- (nonnull instancetype)initWithModifiedRequest:(NSURLRequest * _Nonnull)modifiedRequest;
- (nonnull instancetype)initWithDelay:(NSTimeInterval)delay modifiedRequest:(NSURLRequest * _Nonnull)modifiedRequest;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class NSURLSessionConfiguration;
SWIFT_CLASS("_TtC18BitmovinPlayerCore11_BMPSession")
@interface _BMPSession : NSObject
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) _BMPSession * _Nonnull shared;)
+ (_BMPSession * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) _BMPSession * _Nonnull sharedEphemeral;)
+ (_BMPSession * _Nonnull)sharedEphemeral SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)initWithConfiguration:(NSURLSessionConfiguration * _Nonnull)configuration;
- (_BMPDataRequest * _Nonnull)request:(_BMPRequestConfig * _Nonnull)requestConfig SWIFT_WARN_UNUSED_RESULT;
- (void)cancelAll;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPSession (SWIFT_EXTENSION(BitmovinPlayerCore))
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) _BMPSession * _Nonnull playlistLoaderSession;)
+ (_BMPSession * _Nonnull)playlistLoaderSession SWIFT_WARN_UNUSED_RESULT;
@end

/// Obj-C compatible version of <code>UrlRequestResult</code>.
SWIFT_CLASS("_TtC18BitmovinPlayerCore20_BMPUrlRequestResult")
@interface _BMPUrlRequestResult : NSObject
/// The data returned by the server.
@property (nonatomic, readonly, copy) NSData * _Nonnull data;
/// The server’s response to the URL request.
@property (nonatomic, readonly, strong) NSHTTPURLResponse * _Nonnull response;
/// The URL request sent to the server.
@property (nonatomic, readonly, copy) NSURLRequest * _Nonnull request;
- (nonnull instancetype)initWithData:(NSData * _Nonnull)data response:(NSHTTPURLResponse * _Nonnull)response request:(NSURLRequest * _Nonnull)request OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_BufferApiDelegate")
@protocol _BMPBufferApiDelegate
/// Returns the buffer level of specified type.
/// \param type The type of buffer to return the level for.
///
- (BMPBufferLevel * _Nonnull)bufferApi_getLevel:(BMPBufferType)type SWIFT_WARN_UNUSED_RESULT;
/// Sets the target level for the forward buffer.
/// \param value The value to set.
///
- (void)bufferApi_setTargetLevel:(NSTimeInterval)value;
@end

SWIFT_PROTOCOL_NAMED("_BufferService")
@protocol _BMPBufferService <_BMPService>
- (BMPBufferLevel * _Nonnull)getLevel:(BMPBufferType)type SWIFT_WARN_UNUSED_RESULT;
- (void)setTargetLevel:(NSTimeInterval)value;
@end

SWIFT_CLASS_NAMED("_CafDrmConfig")
@interface _BMPCafDrmConfig : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPCafDrmConfig (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPJsonEncodable>
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_CafSourceOptions")
@interface _BMPCafSourceOptions : NSObject <_BMPJsonEncodable>
- (nonnull instancetype)initWithSendManifestRequestsWithCredentials:(BOOL)sendManifestRequestsWithCredentials sendSegmentRequestsWithCredentials:(BOOL)sendSegmentRequestsWithCredentials OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_ConfigService")
@protocol _BMPConfigService
/// The Bitmovin Player license key, as defined in PlayerConfig.key or if not, in the Info.plist file of
/// the application which is using the SDK.
@property (nonatomic, readonly, copy) NSString * _Nullable licenseKey;
/// The Bitmovin SDK Version.
@property (nonatomic, readonly, copy) NSString * _Nonnull sdkVersion;
/// The package name of the Application.
@property (nonatomic, readonly, copy) NSString * _Nullable packageName;
/// Holds a reference to the current player config.
@property (nonatomic, readonly, strong) BMPPlayerConfig * _Nonnull playerConfig;
/// Returns <code>true</code> if AVPlayer should not render captions on its own, the captions need to be rendered manually by
/// listening to cue events. If <code>false</code> is returned, the captions are rendered by AVPlayer, cue events are
/// additionally fired.
@property (nonatomic, readonly) BOOL suppressDefaultCaptionRendering;
@end

@protocol _BMPContentLoader;
SWIFT_PROTOCOL_NAMED("_ContentLoaderDelegate")
@protocol _BMPContentLoaderDelegate
/// Is called when the _BMPContentLoader has finished downloading successfully.
/// \param loader The <code>ContentLoader</code> which is calling the delegate method.
///
/// \param requestMetadata The <code>_RequestMetadata</code> containing data about the request.
///
/// \param data The content data of the requested file.
///
- (void)contentLoader:(id <_BMPContentLoader> _Nonnull)loader didSucceedWithMetadata:(_BMPRequestMetadata * _Nonnull)requestMetadata data:(NSData * _Nonnull)data;
/// Is called when the _BMPContentLoader has finished downloading with an error.
/// \param loader The <code>ContentLoader</code> which is calling the delegate method.
///
/// \param requestMetadata The <code>_RequestMetadata</code> containing data about the request.
///
/// \param error The <code>Error</code> which occurred.
///
- (void)contentLoader:(id <_BMPContentLoader> _Nonnull)loader didFailWithMetadata:(_BMPRequestMetadata * _Nonnull)requestMetadata error:(NSError * _Nonnull)error;
@end

@protocol _BMPLegacySourceInternal;
/// Provides the current active <code>Source</code> within the configured playlist
SWIFT_PROTOCOL_NAMED("_CurrentSourceProvider")
@protocol _BMPCurrentSourceProvider
@property (nonatomic, readonly, strong) id <_BMPLegacySourceInternal> _Nullable currentSource;
@end

/// Allows reading data from the disk
SWIFT_PROTOCOL_NAMED("_DataReader")
@protocol _BMPDataReader
/// Read <code>Data</code> with the contents of a <code>URL</code>.
/// \param url The <code>URL</code> to read.
///
///
/// throws:
/// An error in the Cocoa domain, if <code>url</code> cannot be read.
///
/// returns:
/// The <code>Data</code> read at the given url
- (NSData * _Nullable)readWithContentsOf:(NSURL * _Nonnull)url error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// Allows writing data to the disk
SWIFT_PROTOCOL_NAMED("_DataWriter")
@protocol _BMPDataWriter
/// Write the contents of the <code>Data</code> to a location.
/// \param data Data to write
///
/// \param url The location to write the data into.
///
/// \param options Options for writing the data.
///
///
/// throws:
/// An error in the Cocoa domain, if there is an error writing to the <code>URL</code>.
- (BOOL)writeWithData:(NSData * _Nonnull)data to:(NSURL * _Nonnull)url options:(NSDataWritingOptions)options error:(NSError * _Nullable * _Nullable)error;
@end

/// Purpose of this protocol is to abstract away the query of current date,
/// and discourage the usage of <code>Date()</code>
/// Benefit of this that by employing this protocol, any current date specific
/// functionality can be unit tested effortlessly
SWIFT_PROTOCOL_NAMED("_DateTimeProvider")
@protocol _BMPDateTimeProvider
@property (nonatomic, readonly, copy) NSDate * _Nonnull currentDate;
@end

SWIFT_CLASS_NAMED("_DefaultAudioService")
@interface _BMPDefaultAudioService : _BMPDefaultService
@property (nonatomic, readonly) _BMPServiceType type;
- (nonnull instancetype)initWithCurrentSourceProvider:(id <_BMPCurrentSourceProvider> _Nonnull)currentSourceProvider OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPDefaultAudioService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPAudioService>
@property (nonatomic, readonly, copy) NSArray<BMPAudioTrack *> * _Nonnull availableAudio;
@property (nonatomic, readonly, strong) BMPAudioTrack * _Nullable audio;
- (void)setAudioWithIdentifier:(NSString * _Nonnull)audioTrackID;
@end

SWIFT_CLASS_NAMED("_DefaultAvailableTracksFetchedEvent")
@interface _BMPDefaultAvailableTracksFetchedEvent : NSObject <BMPAvailableTracksFetchedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) BMPOfflineTrackSelection * _Nonnull tracks;
- (nonnull instancetype)initWithTracks:(BMPOfflineTrackSelection * _Nonnull)tracks OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_DefaultContentDownloadCanceledEvent")
@interface _BMPDefaultContentDownloadCanceledEvent : NSObject <BMPContentDownloadCanceledEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_DefaultContentDownloadFinishedEvent")
@interface _BMPDefaultContentDownloadFinishedEvent : NSObject <BMPContentDownloadFinishedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_DefaultContentDownloadProgressChangedEvent")
@interface _BMPDefaultContentDownloadProgressChangedEvent : NSObject <BMPContentDownloadProgressChangedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) double progress;
- (nonnull instancetype)initWithProgress:(double)progress OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_DefaultContentDownloadResumedEvent")
@interface _BMPDefaultContentDownloadResumedEvent : NSObject <BMPContentDownloadResumedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) double progress;
- (nonnull instancetype)initWithProgress:(double)progress OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_DefaultContentDownloadSuspendedEvent")
@interface _BMPDefaultContentDownloadSuspendedEvent : NSObject <BMPContentDownloadSuspendedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_DefaultContentUrlMigrationFinishedEvent")
@interface _BMPDefaultContentUrlMigrationFinishedEvent : NSObject <BMPContentUrlMigrationFinishedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, copy) NSURL * _Nonnull from;
@property (nonatomic, readonly, copy) NSURL * _Nonnull to;
- (nonnull instancetype)initFrom:(NSURL * _Nonnull)from to:(NSURL * _Nonnull)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_DefaultDataReader")
@interface _BMPDefaultDataReader : NSObject <_BMPDataReader>
- (NSData * _Nullable)readWithContentsOf:(NSURL * _Nonnull)url error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_DefaultDataWriter")
@interface _BMPDefaultDataWriter : NSObject <_BMPDataWriter>
- (BOOL)writeWithData:(NSData * _Nonnull)data to:(NSURL * _Nonnull)url options:(NSDataWritingOptions)options error:(NSError * _Nullable * _Nullable)error;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_PROTOCOL_NAMED("_DeficiencyService")
@protocol _BMPDeficiencyService
- (void)throwError:(enum BMPPlayerErrorCode)code data:(BMPDeficiencyData * _Nullable)data;
- (void)throwErrorWithCode:(enum BMPPlayerErrorCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data;
- (void)throwError:(enum BMPPlayerErrorCode)code replacements:(NSArray<NSString *> * _Nullable)replacements data:(BMPDeficiencyData * _Nullable)data;
- (NSString * _Nullable)buildWarningMessageWithCode:(enum BMPPlayerWarningCode)code replacements:(NSArray<NSString *> * _Nullable)replacements SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultDeficiencyService")
@interface _BMPDefaultDeficiencyService : _BMPDefaultService <_BMPDeficiencyService>
@property (nonatomic, readonly) _BMPServiceType type;
- (void)throwError:(enum BMPPlayerErrorCode)code data:(BMPDeficiencyData * _Nullable)data;
- (void)throwErrorWithCode:(enum BMPPlayerErrorCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data;
- (void)throwError:(enum BMPPlayerErrorCode)code replacements:(NSArray<NSString *> * _Nullable)replacements data:(BMPDeficiencyData * _Nullable)data;
- (NSString * _Nullable)buildWarningMessageWithCode:(enum BMPPlayerWarningCode)code replacements:(NSArray<NSString *> * _Nullable)replacements SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol _BMPAssetDownloadTask;
SWIFT_PROTOCOL_NAMED("_DownloadService")
@protocol _BMPDownloadService
@property (nonatomic, strong) id <_BMPAssetDownloadTask> _Nullable activeDownload;
- (void)startDownloadTask:(id <_BMPAssetDownloadTask> _Nonnull)downloadTask;
- (void)reset;
@end

@protocol _BMPOfflineDownloadsHandler;
SWIFT_CLASS_NAMED("_DefaultDownloadService")
@interface _BMPDefaultDownloadService : NSObject <_BMPDownloadService>
@property (nonatomic, strong) id <_BMPAssetDownloadTask> _Nullable activeDownload;
- (nonnull instancetype)initWithIdentifier:(_BMPHashedIdentifier * _Nonnull)identifier downloadHandler:(id <_BMPOfflineDownloadsHandler> _Nonnull)downloadHandler OBJC_DESIGNATED_INITIALIZER;
- (void)startDownloadTask:(id <_BMPAssetDownloadTask> _Nonnull)downloadTask;
- (void)reset;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol _BMPEventSuppressor;
SWIFT_CLASS_NAMED("_DefaultEventEmitter")
@interface _BMPDefaultEventEmitter : _BMPDefaultService
@property (nonatomic, readonly, strong) id <_BMPEventSuppressor> _Nonnull eventSuppressor;
@property (nonatomic, readonly) _BMPServiceType type;
- (void)emitPlayerEvent:(BMPPlayerEvent * _Nonnull)event;
- (void)addPlayerListener:(id <BMPPlayerListener> _Nonnull)listener;
- (void)removePlayerListener:(id <BMPPlayerListener> _Nonnull)listener;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_SourceEventEmitter")
@protocol _BMPSourceEventEmitter
- (void)emitWithEvent:(id <BMPSourceEvent> _Nonnull)event isInternal:(BOOL)isInternal;
@end

@interface _BMPDefaultEventEmitter (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPSourceEventEmitter>
- (void)emitWithEvent:(id <BMPSourceEvent> _Nonnull)event isInternal:(BOOL)isInternal;
@end

/// Component to suppress public events
SWIFT_PROTOCOL_NAMED("_EventSuppressor")
@protocol _BMPEventSuppressor
/// Registers the given event type to the suppressed event collection
/// This will produce an exception when an internal event type is passed
- (void)suppressWithEventType:(Class <BMPEvent> _Nonnull)eventType;
/// Unregisters the given event type from the suppressed event collection
- (void)removeSuppressionWithEventType:(Class <BMPEvent> _Nonnull)eventType;
/// Checks if the given event type should currently be suppressed.
- (BOOL)isSuppressedWithEventType:(Class <BMPEvent> _Nonnull)eventType SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultEventSuppressor")
@interface _BMPDefaultEventSuppressor : NSObject <_BMPEventSuppressor>
- (void)suppressWithEventType:(Class <BMPEvent> _Nonnull)eventType;
- (void)removeSuppressionWithEventType:(Class <BMPEvent> _Nonnull)eventType;
- (BOOL)isSuppressedWithEventType:(Class <BMPEvent> _Nonnull)eventType SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol _BMPFairplayHandler;
SWIFT_PROTOCOL_NAMED("_FairplayHandlerFactory")
@protocol _BMPFairplayHandlerFactory
- (id <_BMPFairplayHandler> _Nonnull)createWithFairplayConfig:(BMPFairplayConfig * _Nonnull)fairplayConfig networkConfig:(BMPNetworkConfig * _Nullable)networkConfig offlineLicenseStorage:(id <_BMPOfflineFairplayLicenseStorage> _Nullable)offlineLicenseStorage loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService sourceEventEmitter:(id <_BMPSourceEventEmitter> _Nullable)sourceEventEmitter SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultFairplayHandlerFactory")
@interface _BMPDefaultFairplayHandlerFactory : NSObject <_BMPFairplayHandlerFactory>
- (id <_BMPFairplayHandler> _Nonnull)createWithFairplayConfig:(BMPFairplayConfig * _Nonnull)fairplayConfig networkConfig:(BMPNetworkConfig * _Nullable)networkConfig offlineLicenseStorage:(id <_BMPOfflineFairplayLicenseStorage> _Nullable)offlineLicenseStorage loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService sourceEventEmitter:(id <_BMPSourceEventEmitter> _Nullable)sourceEventEmitter SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Helper to access the file system
SWIFT_PROTOCOL_NAMED("_FileSystemHelper")
@protocol _BMPFileSystemHelper
/// Returns the total size of the folder at given path in bytes
/// \param path path to the folder
///
///
/// returns:
/// the total size in bytes, wrapped in <code>NSNumber</code> in order to support Objective-C interop
- (NSNumber * _Nullable)calculateTotalSizeOfFolderAt:(NSURL * _Nonnull)path error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultFileSystemHelper")
@interface _BMPDefaultFileSystemHelper : NSObject <_BMPFileSystemHelper>
- (nonnull instancetype)init;
- (NSNumber * _Nullable)calculateTotalSizeOfFolderAt:(NSURL * _Nonnull)path error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_PROTOCOL_NAMED("_HttpResponseFactory")
@protocol _BMPHttpResponseFactory
- (BMPHttpResponse * _Nonnull)createWithResponse:(NSHTTPURLResponse * _Nonnull)response request:(BMPHttpRequest * _Nonnull)request body:(NSData * _Nullable)body SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultHttpResponseFactory")
@interface _BMPDefaultHttpResponseFactory : NSObject <_BMPHttpResponseFactory>
- (BMPHttpResponse * _Nonnull)createWithResponse:(NSHTTPURLResponse * _Nonnull)response request:(BMPHttpRequest * _Nonnull)request body:(NSData * _Nullable)body SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_PROTOCOL_NAMED("_InitializationService")
@protocol _BMPInitializationService <_BMPService>
- (void)setup:(BMPPlayerConfig * _Nonnull)playerConfig;
@end

SWIFT_CLASS_NAMED("_DefaultInitializationService")
@interface _BMPDefaultInitializationService : _BMPDefaultService <_BMPInitializationService>
- (nonnull instancetype)initWithPlayer:(_BMPAVPlayer * _Nonnull)player OBJC_DESIGNATED_INITIALIZER;
- (void)setup:(BMPPlayerConfig * _Nonnull)playerConfig;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPDefaultInitializationService (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, readonly) _BMPServiceType type;
@end

@class AVMediaSelectionOption;
@class AVMediaSelection;
SWIFT_PROTOCOL_NAMED("_MediaSelectionHelper")
@protocol _BMPMediaSelectionHelper
- (void)optionsToDownloadFrom:(NSArray<AVMediaSelectionOption *> * _Nonnull)options using:(BMPOfflineTrackSelection * _Nullable)trackSelection completionHandler:(void (^ _Nonnull)(NSArray<AVMediaSelectionOption *> * _Nullable, NSError * _Nullable))completionHandler;
- (void)mediaSelectionsToDownloadForAsset:(AVURLAsset * _Nonnull)asset usingTrackSelection:(BMPOfflineTrackSelection * _Nullable)trackSelection completionHandler:(void (^ _Nonnull)(NSArray<AVMediaSelection *> * _Nullable, NSError * _Nullable))completionHandler;
@end

SWIFT_CLASS_NAMED("_DefaultMediaSelectionHelper")
@interface _BMPDefaultMediaSelectionHelper : NSObject <_BMPMediaSelectionHelper>
- (nonnull instancetype)init;
- (void)optionsToDownloadFrom:(NSArray<AVMediaSelectionOption *> * _Nonnull)options using:(BMPOfflineTrackSelection * _Nullable)trackSelection completionHandler:(void (^ _Nonnull)(NSArray<AVMediaSelectionOption *> * _Nullable, NSError * _Nullable))completionHandler;
- (void)mediaSelectionsToDownloadForAsset:(AVURLAsset * _Nonnull)asset usingTrackSelection:(BMPOfflineTrackSelection * _Nullable)trackSelection completionHandler:(void (^ _Nonnull)(NSArray<AVMediaSelection *> * _Nullable, NSError * _Nullable))completionHandler;
@end

/// Provides API to migrate MOVPKG resources
SWIFT_PROTOCOL_NAMED("_MovPkgResourceMigrator")
@protocol _BMPMovPkgResourceMigrator
- (BOOL)needsMigrationAtLocation:(NSURL * _Nonnull)contentLocation toSourceUrl:(NSURL * _Nonnull)sourceUrl SWIFT_WARN_UNUSED_RESULT;
- (void)prepareOfflineContentMigrationAtLocation:(NSURL * _Nonnull)contentLocation toSourceUrl:(NSURL * _Nonnull)sourceUrl using:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
- (BOOL)migrateAndReturnError:(NSError * _Nullable * _Nullable)error;
@end

SWIFT_CLASS_NAMED("_DefaultMovPkgResourceMigrator")
@interface _BMPDefaultMovPkgResourceMigrator : NSObject <_BMPMovPkgResourceMigrator>
- (nonnull instancetype)initWithLoggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService;
- (BOOL)needsMigrationAtLocation:(NSURL * _Nonnull)contentLocation toSourceUrl:(NSURL * _Nonnull)sourceUrl SWIFT_WARN_UNUSED_RESULT;
- (void)prepareOfflineContentMigrationAtLocation:(NSURL * _Nonnull)contentLocation toSourceUrl:(NSURL * _Nonnull)sourceUrl using:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
- (BOOL)migrateAndReturnError:(NSError * _Nullable * _Nullable)error;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_DefaultOfflineContentLicenseExpiredEvent")
@interface _BMPDefaultOfflineContentLicenseExpiredEvent : NSObject <BMPOfflineContentLicenseExpiredEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineContentLicenseRenewedEvent")
@interface _BMPDefaultOfflineContentLicenseRenewedEvent : NSObject <BMPOfflineContentLicenseRenewedEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// This protocol emits <code>OfflineEvent</code>s to <code>OfflineContentManagerListener</code>s
SWIFT_PROTOCOL_NAMED("_OfflineContentManagerEventEmitter")
@protocol _BMPOfflineContentManagerEventEmitter <BMPOfflineContentManagerEventHandler>
- (void)emitOfflineEvent:(id <BMPOfflineEvent> _Nonnull)event;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineContentManagerEventEmitter")
@interface _BMPDefaultOfflineContentManagerEventEmitter : NSObject <_BMPOfflineContentManagerEventEmitter>
- (nonnull instancetype)initWithOfflineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService OBJC_DESIGNATED_INITIALIZER;
- (void)emitOfflineEvent:(id <BMPOfflineEvent> _Nonnull)event;
- (void)addListener:(id <BMPOfflineContentManagerListener> _Nonnull)listener;
- (void)removeListener:(id <BMPOfflineContentManagerListener> _Nonnull)listener;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_OfflineContentManagerEventEmitterFactory")
@protocol _BMPOfflineContentManagerEventEmitterFactory
- (id <_BMPOfflineContentManagerEventEmitter> _Nonnull)createWithOfflineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineContentManagerEventEmitterFactory")
@interface _BMPDefaultOfflineContentManagerEventEmitterFactory : NSObject <_BMPOfflineContentManagerEventEmitterFactory>
- (id <_BMPOfflineContentManagerEventEmitter> _Nonnull)createWithOfflineContentManager:(id <BMPOfflineContentManager> _Nonnull)offlineContentManager loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol _BMPOfflineContentManagerTweaksApiDelegate;
SWIFT_CLASS_NAMED("_DefaultOfflineContentManagerTweaksApi")
@interface _BMPDefaultOfflineContentManagerTweaksApi : NSObject
- (nonnull instancetype)initWithDelegate:(id <_BMPOfflineContentManagerTweaksApiDelegate> _Nonnull)delegate OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPDefaultOfflineContentManagerTweaksApi (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPOfflineContentManagerTweaksApi>
- (void)migrateDownloadWithRemoteAssetUrl:(NSURL * _Nonnull)remoteAssetUrl resourceIdentifierCallback:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
@end

@protocol _BMPOfflineContentUrlMigrationHandlerDelegate;
SWIFT_CLASS_NAMED("_DefaultOfflineContentUrlMigrationHandler")
@interface _BMPDefaultOfflineContentUrlMigrationHandler : NSObject
@property (nonatomic, weak) id <_BMPOfflineContentUrlMigrationHandlerDelegate> _Nullable delegate;
- (nonnull instancetype)initWithMigrator:(id <_BMPMovPkgResourceMigrator> _Nonnull)migrator archiveHelper:(id <_BMPArchiveHelper> _Nonnull)archiveHelper OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol _BMPDownloadTask;
/// Provides API to handle Offline Content URL migration
SWIFT_PROTOCOL_NAMED("_OfflineContentUrlMigrationHandler")
@protocol _BMPOfflineContentUrlMigrationHandler
@property (nonatomic, strong) id <_BMPOfflineContentUrlMigrationHandlerDelegate> _Nullable delegate;
@property (nonatomic, readonly) BOOL isMigrationInProgress;
- (void)migrateFromUrl:(NSURL * _Nonnull)originalRemoteAssetUrl toUrl:(NSURL * _Nonnull)targetRemoteAssetUrl activeDownloadTask:(id <_BMPDownloadTask> _Nullable)activeDownloadTask resourceIdentifierCallback:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
- (void)handleRestorationOfDownloadTask:(id <_BMPDownloadTask> _Nonnull)downloadTask;
- (void)maybeFinishMigration;
@end

@interface _BMPDefaultOfflineContentUrlMigrationHandler (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPOfflineContentUrlMigrationHandler>
@property (nonatomic, readonly) BOOL isMigrationInProgress;
- (void)migrateFromUrl:(NSURL * _Nonnull)originalRemoteAssetUrl toUrl:(NSURL * _Nonnull)targetRemoteAssetUrl activeDownloadTask:(id <_BMPDownloadTask> _Nullable)activeDownloadTask resourceIdentifierCallback:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
- (void)handleRestorationOfDownloadTask:(id <_BMPDownloadTask> _Nonnull)downloadTask;
- (void)maybeFinishMigration;
@end

@protocol _BMPOfflineManagerStateProvider;
@protocol _BMPOfflineDownloadProgressService;
SWIFT_PROTOCOL_NAMED("_OfflineDownloadProgressServiceFactory")
@protocol _BMPOfflineDownloadProgressServiceFactory
- (id <_BMPOfflineDownloadProgressService> _Nonnull)createWithOfflineManagerStateProvider:(id <_BMPOfflineManagerStateProvider> _Nonnull)offlineManagerStateProvider eventEmitter:(id <_BMPOfflineContentManagerEventEmitter> _Nonnull)eventEmitter sourceConfigArchiveHelper:(id <_BMPArchiveHelper> _Nonnull)sourceConfigArchiveHelper SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineDownloadProgressServiceFactory")
@interface _BMPDefaultOfflineDownloadProgressServiceFactory : NSObject <_BMPOfflineDownloadProgressServiceFactory>
- (id <_BMPOfflineDownloadProgressService> _Nonnull)createWithOfflineManagerStateProvider:(id <_BMPOfflineManagerStateProvider> _Nonnull)offlineManagerStateProvider eventEmitter:(id <_BMPOfflineContentManagerEventEmitter> _Nonnull)eventEmitter sourceConfigArchiveHelper:(id <_BMPArchiveHelper> _Nonnull)sourceConfigArchiveHelper SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol _BMPOfflineDownloadStorageService;
SWIFT_PROTOCOL_NAMED("_OfflineDownloadStorageServiceFactory")
@protocol _BMPOfflineDownloadStorageServiceFactory
- (id <_BMPOfflineDownloadStorageService> _Nonnull)createWithEventEmitter:(id <_BMPOfflineContentManagerEventEmitter> _Nonnull)eventEmitter archiveHelper:(id <_BMPArchiveHelper> _Nonnull)archiveHelper loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService minimumAvailableSpaceThresholdProvider:(NSUInteger (^ _Nonnull)(void))minimumAvailableSpaceThresholdProvider SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineDownloadStorageServiceFactory")
@interface _BMPDefaultOfflineDownloadStorageServiceFactory : NSObject <_BMPOfflineDownloadStorageServiceFactory>
- (id <_BMPOfflineDownloadStorageService> _Nonnull)createWithEventEmitter:(id <_BMPOfflineContentManagerEventEmitter> _Nonnull)eventEmitter archiveHelper:(id <_BMPArchiveHelper> _Nonnull)archiveHelper loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService minimumAvailableSpaceThresholdProvider:(NSUInteger (^ _Nonnull)(void))minimumAvailableSpaceThresholdProvider SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol _BMPObjCOfflineInitializationService;
@protocol _BMPOfflineDrmService;
SWIFT_PROTOCOL_NAMED("_OfflineDrmServiceFactory")
@protocol _BMPOfflineDrmServiceFactory
- (id <_BMPOfflineDrmService> _Nonnull)createWithOfflineInitializationService:(id <_BMPObjCOfflineInitializationService> _Nonnull)offlineInitializationService fairPlayLicenseStorage:(id <_BMPOfflineFairplayLicenseStorage> _Nonnull)fairPlayLicenseStorage eventEmitter:(id <_BMPOfflineContentManagerEventEmitter> _Nonnull)eventEmitter loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineDrmServiceFactory")
@interface _BMPDefaultOfflineDrmServiceFactory : NSObject <_BMPOfflineDrmServiceFactory>
- (id <_BMPOfflineDrmService> _Nonnull)createWithOfflineInitializationService:(id <_BMPObjCOfflineInitializationService> _Nonnull)offlineInitializationService fairPlayLicenseStorage:(id <_BMPOfflineFairplayLicenseStorage> _Nonnull)fairPlayLicenseStorage eventEmitter:(id <_BMPOfflineContentManagerEventEmitter> _Nonnull)eventEmitter loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineErrorEvent")
@interface _BMPDefaultOfflineErrorEvent : NSObject <BMPOfflineErrorEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly) enum BMPOfflineErrorCode code SWIFT_DEPRECATED_MSG("Use errorCode instead to have a more detailed error code", "errorCode");
@property (nonatomic, readonly) NSInteger errorCode;
@property (nonatomic, readonly, copy) NSString * _Nonnull message;
@property (nonatomic, readonly, strong) BMPDeficiencyData * _Nullable data;
- (nonnull instancetype)initWithCode:(enum BMPOfflineErrorCode)code message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data;
- (nonnull instancetype)initWithCode:(enum BMPOfflineErrorCode)code errorCode:(NSInteger)errorCode message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPDefaultOfflineErrorEvent (SWIFT_EXTENSION(BitmovinPlayerCore))
- (nonnull instancetype)initWithError:(NSError * _Nonnull)error;
- (nonnull instancetype)initWithBmpError:(_BMPError * _Nonnull)error;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineFairplayLicenseStorage")
@interface _BMPDefaultOfflineFairplayLicenseStorage : NSObject
- (nonnull instancetype)initWithSourceConfigArchiveHelper:(id <_BMPArchiveHelper> _Nonnull)sourceConfigArchiveHelper loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Provides API for underlying storage providing offline FairPlay licenses
SWIFT_PROTOCOL_NAMED("_OfflineFairplayLicenseStorage")
@protocol _BMPOfflineFairplayLicenseStorage
/// Provides license data for given identifier
/// \param assetId identifier for the license
///
///
/// returns:
/// data for license when found
- (NSData * _Nullable)licenseForAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
/// Stores license data for given identifier
/// \param licenseData data for the license to be stored
///
/// \param assetId identifier for the license
///
///
/// throws:
/// an error in case storing the license has failed
- (BOOL)persistWithLicense:(NSData * _Nonnull)licenseData forAssetId:(NSString * _Nonnull)assetId isRenewing:(BOOL)isRenewing error:(NSError * _Nullable * _Nullable)error;
/// Provides the stored license information for the given identifier if any
/// <ul>
///   <li>
///     Parameters
///     <ul>
///       <li>
///         assetId: identifier for the license
///       </li>
///     </ul>
///   </li>
/// </ul>
///
/// returns:
/// stored DRM license information, if not found returns nil
- (BMPDrmLicenseInformation * _Nullable)licenseInformationForAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
/// Stores the license information for given identifier
/// \param licenseInformation DRM license information to store
///
/// \param assetId identifier for the license
///
///
/// returns:
/// <code>true</code> if the DRM license information was persisted successfully, <code>false</code> otherwise
- (BOOL)persistWithLicenseInformation:(BMPDrmLicenseInformation * _Nonnull)licenseInformation forAssetId:(NSString * _Nonnull)assetId;
@end

@interface _BMPDefaultOfflineFairplayLicenseStorage (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPOfflineFairplayLicenseStorage>
- (NSData * _Nullable)licenseForAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
- (BOOL)persistWithLicense:(NSData * _Nonnull)licenseData forAssetId:(NSString * _Nonnull)assetId isRenewing:(BOOL)isRenewing error:(NSError * _Nullable * _Nullable)error;
- (BMPDrmLicenseInformation * _Nullable)licenseInformationForAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
- (BOOL)persistWithLicenseInformation:(BMPDrmLicenseInformation * _Nonnull)licenseInformation forAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineFairplayPlaylistHelper")
@interface _BMPDefaultOfflineFairplayPlaylistHelper : NSObject
- (nonnull instancetype)init;
@end

SWIFT_PROTOCOL_NAMED("_OfflineFairplayPlaylistHelper")
@protocol _BMPOfflineFairplayPlaylistHelper
- (NSSet<NSString *> * _Nonnull)extractSessionKeyUrisAtLocation:(NSURL * _Nonnull)contentLocation SWIFT_WARN_UNUSED_RESULT;
@end

@interface _BMPDefaultOfflineFairplayPlaylistHelper (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPOfflineFairplayPlaylistHelper>
- (NSSet<NSString *> * _Nonnull)extractSessionKeyUrisAtLocation:(NSURL * _Nonnull)contentLocation SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_PROTOCOL_NAMED("_OfflineInitializationServiceFactory")
@protocol _BMPOfflineInitializationServiceFactory
- (id <_BMPObjCOfflineInitializationService> _Nonnull)createWithSourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig sourceConfigArchiveHelper:(id <_BMPArchiveHelper> _Nonnull)sourceConfigArchiveHelper loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineInitializationServiceFactory")
@interface _BMPDefaultOfflineInitializationServiceFactory : NSObject <_BMPOfflineInitializationServiceFactory>
- (id <_BMPObjCOfflineInitializationService> _Nonnull)createWithSourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig sourceConfigArchiveHelper:(id <_BMPArchiveHelper> _Nonnull)sourceConfigArchiveHelper loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_PROTOCOL_NAMED("_OfflineTrackExtractor")
@protocol _BMPOfflineTrackExtractor
- (void)fetchAvailableTracksForAsset:(AVURLAsset * _Nonnull)asset completionHandler:(void (^ _Nonnull)(BMPOfflineTrackSelection * _Nullable, NSError * _Nullable))completionHandler;
@end

SWIFT_CLASS_NAMED("_DefaultOfflineTrackExtractor")
@interface _BMPDefaultOfflineTrackExtractor : NSObject <_BMPOfflineTrackExtractor>
- (nonnull instancetype)initWithLoggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService;
- (void)fetchAvailableTracksForAsset:(AVURLAsset * _Nonnull)asset completionHandler:(void (^ _Nonnull)(BMPOfflineTrackSelection * _Nullable, NSError * _Nullable))completionHandler;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// This class provides an abstraction to access the persistent data stored as key/value pairs in a single file on disk.
/// Each instance of a <code>_DefaultPersistentArchive</code> is associated with a single archive file
/// and can be used to read and write its data.
/// The <code>_DefaultPersistentArchive</code> takes care of reading from and writing to disk internally and transparent to the
/// object which is using the <code>_DefaultPersistentArchive</code>.
SWIFT_CLASS_NAMED("_DefaultPersistentArchive")
@interface _BMPDefaultPersistentArchive : NSObject
- (nonnull instancetype)initWithUrl:(NSURL * _Nonnull)url;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_PersistentArchive")
@protocol _BMPPersistentArchive <NSObject>
- (BOOL)storeStringValue:(NSString * _Nonnull)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeBoolValue:(BOOL)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeDoubleValue:(double)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeDateValue:(NSDate * _Nonnull)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeNumberValue:(NSNumber * _Nonnull)value forKey:(NSString * _Nonnull)key;
- (NSString * _Nullable)stringValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (BOOL)valueExistsForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (NSNumber * _Nullable)numberValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (double)doubleValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (NSDate * _Nullable)dateValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (BOOL)boolValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (BOOL)removeValueForKey:(NSString * _Nonnull)key;
- (void)clear;
- (void)overwriteFrom:(id <_BMPPersistentArchive> _Nonnull)archive;
@end

@interface _BMPDefaultPersistentArchive (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPPersistentArchive>
- (BOOL)storeStringValue:(NSString * _Nonnull)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeBoolValue:(BOOL)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeDoubleValue:(double)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeDateValue:(NSDate * _Nonnull)value forKey:(NSString * _Nonnull)key;
- (BOOL)storeNumberValue:(NSNumber * _Nonnull)value forKey:(NSString * _Nonnull)key;
- (NSString * _Nullable)stringValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (BOOL)valueExistsForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (NSNumber * _Nullable)numberValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (double)doubleValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (NSDate * _Nullable)dateValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (BOOL)boolValueForKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
- (BOOL)removeValueForKey:(NSString * _Nonnull)key;
- (void)clear;
- (void)overwriteFrom:(id <_BMPPersistentArchive> _Nonnull)archive;
@end

@protocol _BMPPlaylistDecryptionKeyStoreStrategy;
SWIFT_PROTOCOL_NAMED("_PlaylistManipulator")
@protocol _BMPPlaylistManipulator
- (NSString * _Nonnull)replaceWithDecryptionKeyUrl:(NSString * _Nonnull)keyUrl with:(NSData * _Nonnull)keyData in:(NSString * _Nonnull)playlist decryptionKeyStoreStrategy:(id <_BMPPlaylistDecryptionKeyStoreStrategy> _Nonnull)keyStoreStrategy SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nonnull)replaceManifestUrl:(NSString * _Nonnull)url withCustomUrl:(NSString * _Nonnull)customUrl in:(NSString * _Nonnull)playlist SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultPlaylistManipulator")
@interface _BMPDefaultPlaylistManipulator : NSObject <_BMPPlaylistManipulator>
- (NSString * _Nonnull)replaceWithDecryptionKeyUrl:(NSString * _Nonnull)keyUrl with:(NSData * _Nonnull)keyData in:(NSString * _Nonnull)playlist decryptionKeyStoreStrategy:(id <_BMPPlaylistDecryptionKeyStoreStrategy> _Nonnull)keyStoreStrategy SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nonnull)replaceManifestUrl:(NSString * _Nonnull)url withCustomUrl:(NSString * _Nonnull)customUrl in:(NSString * _Nonnull)playlist SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// The <code>PlaylistUrlTracker</code> can be used to register a Playlist URL with a type once known.
/// This is useful in order to know before loading the Playlist which type of Playlist we are loading.
/// Example:
/// When loading a variant only live-stream there is no way to know that beforehand.
/// After requesting the Playlist for the first time, the type can be detected and registered.
/// On the next Playlist update triggered by <code>AVPlayer</code> we now know that the URL will be loading
/// a variant playlist.
/// The type can then be used to properly pass it to e.g. the <code>preprocessHttpRequest</code> callback.
SWIFT_PROTOCOL_NAMED("_PlaylistUrlTracker")
@protocol _BMPPlaylistUrlTracker
- (void)registerUrl:(NSURL * _Nonnull)url type:(BMPHttpRequestType _Nonnull)type;
- (BMPHttpRequestType _Nonnull)typeForUrl:(NSURL * _Nonnull)url SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultPlaylistUrlTracker")
@interface _BMPDefaultPlaylistUrlTracker : NSObject <_BMPPlaylistUrlTracker>
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (void)registerUrl:(NSURL * _Nonnull)url type:(BMPHttpRequestType _Nonnull)type;
- (BMPHttpRequestType _Nonnull)typeForUrl:(NSURL * _Nonnull)url SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultStopwatch")
@interface _BMPDefaultStopwatch : NSObject
- (nonnull instancetype)init;
@end

SWIFT_PROTOCOL_NAMED("_Stopwatch")
@protocol _BMPStopwatch
/// Starts a new time measurement.
- (void)start;
/// Stops the stopwatch and returns the elapsed time for the last lap.
/// After this call no more calls to ‘lap’ should be made.
/// @return The elapsed time in seconds, or 0 if ‘start’ was never called.
- (NSTimeInterval)stop SWIFT_WARN_UNUSED_RESULT;
@end

@interface _BMPDefaultStopwatch (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPStopwatch>
- (void)start;
- (NSTimeInterval)stop SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_PROTOCOL_NAMED("_SubtitleParser")
@protocol _BMPSubtitleParser
- (NSArray<BMPCue *> * _Nullable)parseWithContent:(NSString * _Nonnull)content subtitleFormat:(enum BMPSubtitleFormat)subtitleFormat error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultSubtitleParser")
@interface _BMPDefaultSubtitleParser : NSObject <_BMPSubtitleParser>
- (nonnull instancetype)init;
- (NSArray<BMPCue *> * _Nullable)parseWithContent:(NSString * _Nonnull)content subtitleFormat:(enum BMPSubtitleFormat)subtitleFormat error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// Use this _Timer implementation instead of the built-in NSTimer/Timer type in order to avoid
/// blocking the main thread
SWIFT_CLASS_NAMED("_DefaultTimer")
@interface _BMPDefaultTimer : NSObject
@property (nonatomic, copy) void (^ _Nullable eventHandler)(void);
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// This protocol is abstracting the usage of a timer
/// which makes timers easily testable from unit tests
SWIFT_PROTOCOL_NAMED("_Timer")
@protocol _BMPTimer
/// Returns <code>true</code> if the timer is running
@property (nonatomic, readonly) BOOL isRunning;
/// Returns <code>true</code> if the timer was permanently canceled
@property (nonatomic, readonly) BOOL isCanceled;
/// Returns <code>true</code> if the timer was suspended
@property (nonatomic, readonly) BOOL isSuspended;
/// Closure to call on timer ticks
@property (nonatomic, copy) void (^ _Nullable eventHandler)(void);
/// Resume a suspended timer
- (void)resume;
/// Temporarily suspend a timer, which can be later resumed by calling <code>resume()</code>
- (void)suspend;
/// Permanently cancel a timer, which will free up its resources and can not be resumed
- (void)cancel;
@end

@interface _BMPDefaultTimer (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPTimer>
@property (nonatomic, readonly) BOOL isRunning;
@property (nonatomic, readonly) BOOL isCanceled;
@property (nonatomic, readonly) BOOL isSuspended;
- (void)resume;
- (void)suspend;
- (void)cancel;
@end

SWIFT_PROTOCOL_NAMED("_TimerFactory")
@protocol _BMPTimerFactory
- (id <_BMPTimer> _Nonnull)createWithTimeInterval:(NSTimeInterval)timeInterval eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPTimer> _Nonnull)createWithTimeInterval:(NSTimeInterval)timeInterval timerQueue:(dispatch_queue_t _Nonnull)timerQueue eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPTimer> _Nonnull)createAndStartWithTimeInterval:(NSTimeInterval)timeInterval repeats:(BOOL)repeats eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue eventHandler:(void (^ _Nonnull)(void))eventHandler SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPTimer> _Nonnull)createAndStartWithTimeInterval:(NSTimeInterval)timeInterval repeats:(BOOL)repeats timerQueue:(dispatch_queue_t _Nonnull)timerQueue eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue eventHandler:(void (^ _Nonnull)(void))eventHandler SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_DefaultTimerFactory")
@interface _BMPDefaultTimerFactory : NSObject <_BMPTimerFactory>
- (id <_BMPTimer> _Nonnull)createWithTimeInterval:(NSTimeInterval)timeInterval eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPTimer> _Nonnull)createWithTimeInterval:(NSTimeInterval)timeInterval timerQueue:(dispatch_queue_t _Nonnull)timerQueue eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPTimer> _Nonnull)createAndStartWithTimeInterval:(NSTimeInterval)timeInterval repeats:(BOOL)repeats eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue eventHandler:(void (^ _Nonnull)(void))eventHandler SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPTimer> _Nonnull)createAndStartWithTimeInterval:(NSTimeInterval)timeInterval repeats:(BOOL)repeats timerQueue:(dispatch_queue_t _Nonnull)timerQueue eventHandlerQueue:(dispatch_queue_t _Nonnull)eventHandlerQueue eventHandler:(void (^ _Nonnull)(void))eventHandler SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_EnumHelper")
@interface _BMPEnumHelper : NSObject
+ (NSString * _Nonnull)adSourceTypeToString:(enum BMPAdSourceType)type SWIFT_WARN_UNUSED_RESULT;
+ (NSString * _Nonnull)sourceTypeToString:(enum BMPSourceType)sourceType SWIFT_WARN_UNUSED_RESULT;
+ (NSString * _Nonnull)timelineReferencePointToString:(BMPTimelineReferencePoint)timelineReference SWIFT_WARN_UNUSED_RESULT;
+ (double)adQuartileToPercentage:(BMPAdQuartile)quartile SWIFT_WARN_UNUSED_RESULT;
+ (NSString * _Nonnull)adTagTypeToString:(enum BMPAdTagType)type SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Holds the NSError and additional optional information
SWIFT_CLASS_NAMED("_ErrorMetadata")
@interface _BMPErrorMetadata : NSObject
@property (nonatomic, readonly, strong) _BMPError * _Nonnull error;
@property (nonatomic, readonly, strong) _BMPRequestMetadata * _Nullable requestMetadata;
- (nonnull instancetype)initWithBmpError:(_BMPError * _Nonnull)error requestMetadata:(_BMPRequestMetadata * _Nullable)requestMetadata OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithError:(NSError * _Nonnull)error requestMetadata:(_BMPRequestMetadata * _Nullable)requestMetadata OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol _BMPFairplayHandlerDelegate;
@protocol _BMPFairplayHandlerOfflineContentDelegate;
@protocol AVContentKeyRecipient;
/// FairplayHandler is responsible for all FairPlay related operations to serve
/// content key responses for assets
SWIFT_PROTOCOL_NAMED("_FairplayHandler")
@protocol _BMPFairplayHandler
@property (nonatomic, strong) BMPFairplayConfig * _Nonnull fairplayConfig;
/// Delegate for the handler
@property (nonatomic, weak) id <_BMPFairplayHandlerDelegate> _Nullable fairplayHandlerDelegate;
@property (nonatomic, weak) id <_BMPFairplayHandlerOfflineContentDelegate> _Nullable offlineContentDelegate SWIFT_AVAILABILITY(tvos,unavailable);
/// Adds a recipient to the handler, so FairPlay requests for the recipient will be resolved by the handler
/// \param recipient <code>AVContentKeyRecipient</code> instance that needs FairPlay keys served
/// Note: <code>AVURLAsset</code> conforms to <code>AVContentKeyRecipient</code>
///
- (void)addRecipient:(id <AVContentKeyRecipient> _Nonnull)recipient;
/// Triggers license information synchronization for the given content key
/// \param skdUri URI of the content key
///
- (void)syncLicenseForSkdUri:(NSString * _Nonnull)skdUri SWIFT_AVAILABILITY(tvos,unavailable);
/// Triggers license renewal for given content key URI
/// \param skdUri URI of the content key
///
- (void)renewLicenseForSkdUri:(NSString * _Nonnull)skdUri SWIFT_AVAILABILITY(tvos,unavailable);
/// Triggers license renewal for given content key request
/// \param contentKeyRequest content key request
/// acquired via <code>FairplayLicenseAcquiredEvent/contentKeyRequest</code>
///
- (void)renewLicenseFor:(BMPFairplayContentKeyRequest * _Nonnull)contentKeyRequest;
@end

SWIFT_PROTOCOL_NAMED("_FairplayHandlerDelegate")
@protocol _BMPFairplayHandlerDelegate
@optional
/// Is called when the FairplayHandler has finished a DRM license request.
/// \param sender The <code>_FairplayHandler</code> which is calling the delegate method.
///
- (void)fairplayHandlerDidFinishLicenseRequest:(id <_BMPFairplayHandler> _Nonnull)sender;
/// Is called when the FairplayHandler has finished a DRM certificate request.
/// \param sender The <code>_FairplayHandler</code> which is calling the delegate method.
///
- (void)fairplayHandlerDidFinishCertificateRequest:(id <_BMPFairplayHandler> _Nonnull)sender;
/// Is called when the FairplayHandler has finished with an error.
/// \param sender The <code>_FairplayHandler</code> which is calling the delegate method.
///
/// \param errorMetadata The <code>_ErrorMetadata</code> of the error that has occurred.
///
- (void)fairplayHandler:(id <_BMPFairplayHandler> _Nonnull)sender didFinishWithErrorMetadata:(_BMPErrorMetadata * _Nonnull)errorMetadata;
/// Is called when the FairplayHandler has acquired a DRM license.
/// \param sender The <code>_FairplayHandler</code> which is calling the delegate method.
///
/// \param skdUri The original SKD URI for the key.
///
/// \param contentKeyRequest The related <code>AVContentKeyRequest</code> instance.
///
- (void)fairplayHandler:(id <_BMPFairplayHandler> _Nonnull)sender didAcquireLicenseForSkdUri:(NSString * _Nonnull)skdUri contentKeyRequest:(AVContentKeyRequest * _Nonnull)contentKeyRequest;
@end

SWIFT_PROTOCOL_NAMED("_FairplayHandlerOfflineContentDelegate") SWIFT_AVAILABILITY(tvos,unavailable)
@protocol _BMPFairplayHandlerOfflineContentDelegate
/// Is called when the FairplayHandler wants to know if a persistable offline DRM license
/// should be requested from the license server.
/// If <code>true</code> is returned, the sender calls <code>fairplayHandler(_:persistOfflineLicense:)</code> as soon as the
/// offline license is loaded and persistable data is available.
/// \param sender The FairplayHandler which is calling the delegate method.
///
/// \param assetId Asset ID that the key belongs to
///
///
/// returns:
/// <code>true</code> if a persistable license should be downloaded,
/// <code>false</code> if just a common DRM license should be loaded.
- (BOOL)fairplayHandler:(id <_BMPFairplayHandler> _Nonnull)sender shouldPersistOfflineLicenseForAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
/// Is called when the FairplayHandler wants to know if renewing is in progress.
/// \param sender The FairplayHandler which is calling the delegate method.
///
/// \param assetId Asset ID that the key belongs to
///
///
/// returns:
/// <code>true</code> when renewing is in progress, <code>false</code> otherwise
- (BOOL)fairplayHandler:(id <_BMPFairplayHandler> _Nonnull)sender isRenewingOfflineLicenseForAssetId:(NSString * _Nonnull)assetId SWIFT_WARN_UNUSED_RESULT;
/// Is called when the FairplayHandler has persisted the received offline license information.
/// \param sender The FairplayHandler which is calling the delegate method.
///
- (void)fairplayHandlerDidFinishPersistingOfflineLicenseInformation:(id <_BMPFairplayHandler> _Nonnull)sender;
/// Is called when the FairplayHandler successfully persisted the downloaded offline DRM license.
/// <ul>
///   <li>
///     Parameters
///     <ul>
///       <li>
///         sender: The FairplayHandler which is calling the delegate method.
///       </li>
///     </ul>
///   </li>
/// </ul>
- (void)fairplayHandlerDidPersistOfflineLicense:(id <_BMPFairplayHandler> _Nonnull)sender;
/// Is called when the FairplayHandler failed to persist the downloaded offline DRM license.
/// \param sender The FairplayHandler which is calling the delegate method.
///
/// \param error Error that happened while trying to persist the license
///
- (void)fairplayHandler:(id <_BMPFairplayHandler> _Nonnull)sender failedToPersistOfflineLicenseWithError:(NSError * _Nonnull)error;
@end

SWIFT_CLASS_NAMED("_GetAvailableAudioEvent")
@interface _BMPGetAvailableAudioEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly, copy) NSArray<BMPAudioTrack *> * _Nonnull audioTracks;
- (nonnull instancetype)initWithAudioTracks:(NSArray<BMPAudioTrack *> * _Nullable)audioTracks OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_GetAvailableSubtitlesEvent")
@interface _BMPGetAvailableSubtitlesEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly, copy) NSArray<BMPSubtitleTrack *> * _Nonnull subtitleTracks;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithSubtitleTracks:(NSArray<BMPSubtitleTrack *> * _Nullable)subtitleTracks OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_GoogleCastBufferService")
@interface _BMPGoogleCastBufferService : _BMPDefaultService
@property (nonatomic, readonly) _BMPServiceType type;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface _BMPGoogleCastBufferService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPBufferService>
- (BMPBufferLevel * _Nonnull)getLevel:(BMPBufferType)type SWIFT_WARN_UNUSED_RESULT;
- (void)setTargetLevel:(NSTimeInterval)value;
@end

/// Can be used to receive the playback finished state
SWIFT_PROTOCOL_NAMED("_PlaybackFinishedService")
@protocol _BMPPlaybackFinishedService
@property (nonatomic, readonly) BOOL isPlaybackFinished;
@end

@protocol _BMPCastMessagingService;
@protocol _BMPObjCPlayerEventEmitter;
SWIFT_CLASS_NAMED("_GoogleCastPlaybackFinishedService")
@interface _BMPGoogleCastPlaybackFinishedService : _BMPDefaultService <_BMPPlaybackFinishedService>
@property (nonatomic) BOOL isPlaybackFinished;
@property (nonatomic, readonly) _BMPServiceType type;
- (nonnull instancetype)initWithCastMessagingService:(id <_BMPCastMessagingService> _Nonnull)castMessagingService playerEventEmitter:(id <_BMPObjCPlayerEventEmitter> _Nonnull)playerEventEmitter OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class _BMPRemotePlayerStateEvent;
@interface _BMPGoogleCastPlaybackFinishedService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPCastMessagesListener>
- (void)onRemotePlayerState:(_BMPRemotePlayerStateEvent * _Nonnull)event;
@end

@interface _BMPGoogleCastPlaybackFinishedService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPPlayerListenerInternal>
- (void)onInternalPlaybackInitiated:(_BMPInternalPlaybackInitiatedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
@end

@interface _BMPGoogleCastPlaybackFinishedService (SWIFT_EXTENSION(BitmovinPlayerCore))
- (void)start;
- (void)stop;
@end

@class BMPBitmovinCastManager;
@protocol _BMPCastPlaylistQueueManipulator;
SWIFT_CLASS_NAMED("_GoogleCastPlaylistService")
@interface _BMPGoogleCastPlaylistService : _BMPDefaultService
@property (nonatomic, readonly) _BMPServiceType type;
- (nonnull instancetype)initWithCastManager:(BMPBitmovinCastManager * _Nonnull)castManager playerEventEmitter:(id <_BMPObjCPlayerEventEmitter> _Nonnull)playerEventEmitter playbackFinishedService:(id <_BMPPlaybackFinishedService> _Nonnull)playbackFinishedService playlistQueueManipulator:(id <_BMPCastPlaylistQueueManipulator> _Nonnull)playlistQueueManipulator loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPGoogleCastPlaylistService (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPBitmovinCastManagerListener>
- (void)queueDidUpdateActiveItemIndex:(NSInteger)activeItemIndex;
@end

@interface _BMPGoogleCastPlaylistService (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPPlayerListener>
- (void)onCastStopped:(BMPCastStoppedEvent * _Nonnull)event player:(id <BMPPlayer> _Nonnull)player;
@end

@interface _BMPGoogleCastPlaylistService (SWIFT_EXTENSION(BitmovinPlayerCore))
- (void)start;
- (void)stop;
@end

@interface _BMPGoogleCastPlaylistService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPCurrentSourceProvider>
@property (nonatomic, readonly, strong) id <_BMPLegacySourceInternal> _Nullable currentSource;
@end

/// Provides the sources within the configured playlist
SWIFT_PROTOCOL_NAMED("_PlaylistSourcesProvider")
@protocol _BMPPlaylistSourcesProvider
@property (nonatomic, readonly, copy) NSArray<id <_BMPLegacySourceInternal>> * _Nonnull sources;
- (BOOL)isLastSource:(id <_BMPLegacySourceInternal> _Nonnull)source SWIFT_WARN_UNUSED_RESULT;
@end

@interface _BMPGoogleCastPlaylistService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPPlaylistSourcesProvider>
@property (nonatomic, readonly, copy) NSArray<id <_BMPLegacySourceInternal>> * _Nonnull sources;
- (BOOL)isLastSource:(id <_BMPLegacySourceInternal> _Nonnull)source SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_PROTOCOL_NAMED("_PlaylistService")
@protocol _BMPPlaylistService
- (void)loadPlaylistConfig:(BMPPlaylistConfig * _Nonnull)playlistConfig;
- (void)addWithSource:(id <BMPSource> _Nonnull)source at:(NSInteger)index;
- (void)addWithSource:(id <BMPSource> _Nonnull)source;
- (void)removeWithSourceAt:(NSInteger)index;
- (void)unload;
- (void)transitionAndPreloadWithSource:(id <_BMPLegacySourceInternal> _Nonnull)source completionHandler:(void (^ _Nonnull)(NSError * _Nullable))completionHandler;
@end

@interface _BMPGoogleCastPlaylistService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPPlaylistService>
- (void)loadPlaylistConfig:(BMPPlaylistConfig * _Nonnull)playlistConfig;
- (void)addWithSource:(id <BMPSource> _Nonnull)source at:(NSInteger)index;
- (void)addWithSource:(id <BMPSource> _Nonnull)source;
- (void)removeWithSourceAt:(NSInteger)index;
- (void)unload;
- (void)transitionAndPreloadWithSource:(id <_BMPLegacySourceInternal> _Nonnull)source completionHandler:(void (^ _Nonnull)(NSError * _Nullable))completionHandler;
@end

SWIFT_PROTOCOL_NAMED("_SeekingService")
@protocol _BMPSeekingService
@property (nonatomic, readonly) BOOL isSeekingBackToStart;
@property (nonatomic, readonly) BOOL isSeeking;
- (void)seekToTime:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents;
- (void)timeShiftToTime:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents;
- (void)seekToSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents;
- (void)seekToSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents completionHandler:(void (^ _Nullable)(BOOL))completionHandler;
- (void)seekBackToStartIfNeededWithCompletion:(void (^ _Nullable)(void))completion;
- (void)timeShiftBackToStartIfNeededWithCompletion:(void (^ _Nullable)(void))completion;
- (void)setReplayMode:(enum BMPReplayMode)replayMode;
@end

@protocol _BMPTimeService;
SWIFT_CLASS_NAMED("_GoogleCastSeekingService")
@interface _BMPGoogleCastSeekingService : _BMPDefaultService <_BMPSeekingService>
@property (nonatomic, readonly) BOOL isSeeking;
@property (nonatomic, readonly) _BMPServiceType type;
- (nonnull instancetype)initWithCastManager:(BMPBitmovinCastManager * _Nonnull)castManager castMessagingService:(id <_BMPCastMessagingService> _Nonnull)castMessagingService currentSourceProvider:(id <_BMPCurrentSourceProvider> _Nonnull)currentSourceProvider playlistSourcesProvider:(id <_BMPPlaylistSourcesProvider> _Nonnull)playlistSourcesProvider timeService:(id <_BMPTimeService> _Nonnull)timeService playerEventEmitter:(id <_BMPObjCPlayerEventEmitter> _Nonnull)playerEventEmitter loggerService:(id <_BMPObjCLoggerService> _Nonnull)loggerService OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPGoogleCastSeekingService (SWIFT_EXTENSION(BitmovinPlayerCore))
@property (nonatomic, readonly) BOOL isSeekingBackToStart;
@property (nonatomic, readonly) BOOL wasTimeChangeCommandCalled;
- (void)seekToTime:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents;
- (void)seekToSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents;
- (void)seekToSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents completionHandler:(void (^ _Nullable)(BOOL))completionHandler;
- (void)timeShiftToTime:(NSTimeInterval)time suppressEvents:(BOOL)suppressEvents;
- (void)seekBackToStartIfNeededWithCompletion:(void (^ _Nullable)(void))completion;
- (void)timeShiftBackToStartIfNeededWithCompletion:(void (^ _Nullable)(void))completion;
- (void)adjustToTargetStartTime:(NSTimeInterval)startTime completionHandler:(void (^ _Nullable)(BOOL))completionHandler;
- (void)setReplayMode:(enum BMPReplayMode)replayMode;
@end

@protocol _BMPNamespacedServiceLocator;
SWIFT_CLASS_NAMED("_GoogleCastTimeService")
@interface _BMPGoogleCastTimeService : _BMPDefaultService
@property (nonatomic, readonly) _BMPServiceType type;
- (nonnull instancetype)initWithServiceLocator:(id <_BMPNamespacedServiceLocator> _Nonnull)serviceLocator OBJC_DESIGNATED_INITIALIZER;
- (void)start;
- (void)stop;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface _BMPGoogleCastTimeService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPCastMessagesListener>
- (void)onRemotePlayerState:(_BMPRemotePlayerStateEvent * _Nonnull)event;
- (void)onCurrentTimeApproximation:(NSTimeInterval)currentTime;
@end

SWIFT_PROTOCOL_NAMED("_TimeService")
@protocol _BMPTimeService
/// Returns the total duration in seconds of the current video or <code>infinity</code> if it’s a live stream.
@property (nonatomic, readonly) NSTimeInterval duration;
/// Returns the limit in seconds for time shift. Is either negative or 0. Is applicable for live streams only.
@property (nonatomic, readonly) NSTimeInterval maxTimeShift;
/// Returns The current time shift position in seconds. Is applicable for live streams only.
@property (nonatomic, readonly) NSTimeInterval timeShift;
/// Returns the live edge in seconds. Is applicable for live streams only.
@property (nonatomic, readonly) NSTimeInterval liveEdge;
/// Returns the current playback time of the asset. It never returns <code>nan</code> as a value.
/// In case of invalid time values 0 is returned.
/// For VoD streams the returned time ranges between 0 and the duration of the asset.
/// For live streams it can be specified if a Unix timestamp denoting the current playback
/// position or an relative to the playback start value is returned.
/// \param timeMode to specify if an absolute unix timestamp or an relative time should be returned.
///
///
/// returns:
/// The current playback time.
- (NSTimeInterval)currentTime:(BMPTimeMode)timeMode SWIFT_WARN_UNUSED_RESULT;
@end

@interface _BMPGoogleCastTimeService (SWIFT_EXTENSION(BitmovinPlayerCore)) <_BMPTimeService>
@property (nonatomic, readonly) NSTimeInterval duration;
@property (nonatomic, readonly) NSTimeInterval maxTimeShift;
@property (nonatomic, readonly) NSTimeInterval timeShift;
@property (nonatomic, readonly) NSTimeInterval liveEdge;
- (NSTimeInterval)currentTime:(BMPTimeMode)timeMode SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_HashedIdentifier")
@interface _BMPHashedIdentifier : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull md5;
- (nonnull instancetype)initWithString:(NSString * _Nonnull)string OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Data class which holds IMA Log entry values
SWIFT_CLASS_NAMED("_ImaAdLogEvent")
@interface _BMPImaAdLogEvent : NSObject
@property (nonatomic, readonly) NSInteger errorCode;
@property (nonatomic, readonly, copy) NSString * _Nonnull errorMessage;
@property (nonatomic, readonly, copy) NSString * _Nonnull type;
- (nonnull instancetype)initWithErrorCode:(NSInteger)errorCode errorMessage:(NSString * _Nonnull)errorMessage type:(NSString * _Nonnull)type OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_PlaylistDecryptionKeyStoreStrategy")
@protocol _BMPPlaylistDecryptionKeyStoreStrategy <NSObject>
- (NSString * _Nullable)uriFor:(NSString * _Nonnull)keyUrl decryptionKeyData:(NSData * _Nonnull)keyData SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_InlinePlaylistDecryptionKeyStoreStrategy")
@interface _BMPInlinePlaylistDecryptionKeyStoreStrategy : NSObject <_BMPPlaylistDecryptionKeyStoreStrategy>
- (NSString * _Nullable)uriFor:(NSString * _Nonnull)keyUrl decryptionKeyData:(NSData * _Nonnull)keyData SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalActiveSourceChangedEvent")
@interface _BMPInternalActiveSourceChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, strong) id <_BMPLegacySourceInternal> _Nullable from;
@property (nonatomic, readonly, strong) id <_BMPLegacySourceInternal> _Nullable to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalAdPlaybackDidRequestContentPauseEvent")
@interface _BMPInternalAdPlaybackDidRequestContentPauseEvent : BMPPlayerEvent
/// Whether the upcoming ad will need Bitmovin Ad UI
@property (nonatomic, readonly) BOOL requestsUi;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithRequestsUi:(BOOL)requestsUi OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalAdPlaybackDidRequestContentResumeEvent")
@interface _BMPInternalAdPlaybackDidRequestContentResumeEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListenerInternal</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalBufferLevelChangedEvent")
@interface _BMPInternalBufferLevelChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, strong) BMPBufferLevel * _Nonnull forwardBufferLevel;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalCanStartPlaybackImmediatelyEvent")
@interface _BMPInternalCanStartPlaybackImmediatelyEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalCastActiveSourceChangedEvent")
@interface _BMPInternalCastActiveSourceChangedEvent : BMPPlayerEvent
@property (nonatomic, readonly, strong) id <_BMPLegacySourceInternal> _Nullable from;
@property (nonatomic, readonly, strong) id <_BMPLegacySourceInternal> _Nullable to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalCastPlayerActiveEvent")
@interface _BMPInternalCastPlayerActiveEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalCastPlaylistTransitionEvent")
@interface _BMPInternalCastPlaylistTransitionEvent : BMPPlayerEvent
@property (nonatomic, readonly, strong) id <BMPSource> _Nullable from;
@property (nonatomic, readonly, strong) id <BMPSource> _Nullable to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalCastReadyEvent")
@interface _BMPInternalCastReadyEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalCastSourceAddedEvent")
@interface _BMPInternalCastSourceAddedEvent : BMPPlayerEvent
/// The <code>Source</code> that was added to the playlist.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The index at which the <code>Source</code> was added to the playlist.
/// The value is greater than or equal to zero and does not exceed the
/// number of <code>Source</code>s in the playlist before addition.
@property (nonatomic, readonly) NSInteger index;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalCastSourceRemovedEvent")
@interface _BMPInternalCastSourceRemovedEvent : BMPPlayerEvent
/// The <code>Source</code> that was removed from the playlist.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The index at which the <code>Source</code> was removed from the playlist.
/// The value is greater than or equal to zero and is less than
/// the number of <code>Source</code>s in the playlist before removal.
@property (nonatomic, readonly) NSInteger index;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalCastStopEvent")
@interface _BMPInternalCastStopEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalMasterPlaylistLoadedEvent")
@interface _BMPInternalMasterPlaylistLoadedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, copy) NSData * _Nonnull data;
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalMetadataChangedEvent")
@interface _BMPInternalMetadataChangedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The type of the associated Metadata
@property (nonatomic, readonly) enum BMPMetadataType metadataType;
/// The metadata object
/// To get the typed metadata object use a cast like:
/// \code
/// switch event.metadata {
/// case let metadata as DaterangeMetadata:
///     // Daterange Metadata
/// case let metadata as Id3Metadata:
///     // ID3 Metadata
/// case let metadata as ScteMetadata:
///     // Scte Metadata
/// }
///
/// \endcodePossible types are:
/// <ul>
///   <li>
///     <code>DaterangeMetadata</code>
///   </li>
///   <li>
///     <code>ScteMetadata</code>
///   </li>
///   <li>
///     <code>Id3Metadata</code>
///   </li>
/// </ul>
@property (nonatomic, readonly, strong) BMPMetadata * _Nonnull metadata;
- (nonnull instancetype)initWithMetadata:(BMPMetadata * _Nonnull)metadata type:(enum BMPMetadataType)type OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalPlaybackInitiatedEvent")
@interface _BMPInternalPlaybackInitiatedEvent : BMPPlayerEvent
@property (nonatomic, readonly) NSTimeInterval time;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithTime:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_InternalPlaybackIntentionEvent")
@interface _BMPInternalPlaybackIntentionEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalPlayerFactory")
@interface _BMPInternalPlayerFactory : NSObject
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull sdkVersion;)
+ (NSString * _Nonnull)sdkVersion SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init;
- (id <BMPPlayer> _Nonnull)createWithIntegrationLanguage:(_BMPIntegrationLanguage _Nonnull)integrationLanguage config:(BMPPlayerConfig * _Nonnull)config SWIFT_WARN_UNUSED_RESULT;
- (id <BMPPlayer> _Nonnull)createWithIntegrationLanguage:(_BMPIntegrationLanguage _Nonnull)integrationLanguage SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_InternalPlayerLoadEvent")
@interface _BMPInternalPlayerLoadEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalPlayerUnloadEvent")
@interface _BMPInternalPlayerUnloadEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalPlayingEvent")
@interface _BMPInternalPlayingEvent : BMPPlayerEvent
/// Current playback time in seconds.
@property (nonatomic, readonly) NSTimeInterval time;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithTime:(NSTimeInterval)time OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalPlaylistTransitionEvent")
@interface _BMPInternalPlaylistTransitionEvent : BMPPlayerEvent
@property (nonatomic, readonly, strong) id <BMPSource> _Nullable from;
@property (nonatomic, readonly, strong) id <BMPSource> _Nullable to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListenerInternal</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalReadyEvent")
@interface _BMPInternalReadyEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalSeekEvent")
@interface _BMPInternalSeekEvent : BMPPlayerEvent
/// The current position.
@property (nonatomic, readonly, strong) BMPSeekPosition * _Nonnull from;
/// The target position.
@property (nonatomic, readonly, strong) BMPSeekPosition * _Nonnull to;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initFrom:(BMPSeekPosition * _Nonnull)from to:(BMPSeekPosition * _Nonnull)to OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalSeekedEvent")
@interface _BMPInternalSeekedEvent : BMPPlayerEvent
/// Indicates whether the seek operation was canceled or completed successfully.
/// <h1>Limitations</h1>
/// <ul>
///   <li>
///     Not supported when casting. It will always be <code>false</code> in that case.
///   </li>
/// </ul>
@property (nonatomic, readonly) BOOL canceled;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithCanceled:(BOOL)canceled OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalSharePlayEndedEvent") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@interface _BMPInternalSharePlayEndedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalSharePlayStartedEvent") SWIFT_AVAILABILITY(tvos,introduced=15.0) SWIFT_AVAILABILITY(ios,introduced=15.0)
@interface _BMPInternalSharePlayStartedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalSourceAddedEvent")
@interface _BMPInternalSourceAddedEvent : BMPPlayerEvent
/// The <code>Source</code> that was added to the playlist.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The index at which the <code>Source</code> was added to the playlist.
/// The value is greater than or equal to zero and does not exceed the
/// number of <code>Source</code>s in the playlist before addition.
@property (nonatomic, readonly) NSInteger index;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalSourcePlaybackFinishedEvent")
@interface _BMPInternalSourcePlaybackFinishedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalSourceRemovedEvent")
@interface _BMPInternalSourceRemovedEvent : BMPPlayerEvent
/// The <code>Source</code> that was removed from the playlist.
@property (nonatomic, readonly, strong) id <BMPSource> _Nonnull source;
/// The index at which the <code>Source</code> was removed from the playlist.
/// The value is greater than or equal to zero and is less than
/// the number of <code>Source</code>s in the playlist before removal.
@property (nonatomic, readonly) NSInteger index;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalStallEndedEvent")
@interface _BMPInternalStallEndedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// See <code>PlayerListener</code> for more information on this event.
SWIFT_CLASS_NAMED("_InternalStallStartedEvent")
@interface _BMPInternalStallStartedEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Used for internal time updates where we need a higher and not modifiable update rate.
SWIFT_CLASS_NAMED("_InternalTimeChangedEvent")
@interface _BMPInternalTimeChangedEvent : BMPTimeChangedEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithCurrentTime:(NSTimeInterval)currentTime OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_InternalTimeShiftEvent")
@interface _BMPInternalTimeShiftEvent : BMPPlayerEvent
/// The absolute playback position as a Unix timestamp in seconds (<code>player.currentTime</code>) where the time-shift
/// started.
@property (nonatomic, readonly) NSTimeInterval position;
/// The desired playback position after the time-shift, as relative time in seconds. It is relative to
/// the beginning of the live (DVR) window at the point in time where playback of the stream started.
@property (nonatomic, readonly) NSTimeInterval target;
/// The desired playback position after the time-shift, as a time-shift value in seconds.
/// <ul>
///   <li>
///     A value of <code>0</code> indicates playback at the live edge.
///   </li>
///   <li>
///     A negative value indicates playback behind the live edge.
///   </li>
/// </ul>
@property (nonatomic, readonly) NSTimeInterval timeShift;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithPosition:(NSTimeInterval)position target:(NSTimeInterval)target timeShift:(NSTimeInterval)timeShift OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalTimeShiftedEvent")
@interface _BMPInternalTimeShiftedEvent : BMPPlayerEvent
/// Indicates whether the time-shift operation was canceled or completed successfully.
/// <h1>Limitations</h1>
/// <ul>
///   <li>
///     Not supported when casting. It will always be <code>false</code> in that case.
///   </li>
/// </ul>
@property (nonatomic, readonly) BOOL canceled;
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
- (nonnull instancetype)initWithCanceled:(BOOL)canceled OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_InternalVariantPlaylistLoadedEvent")
@interface _BMPInternalVariantPlaylistLoadedEvent : NSObject <BMPSourceEvent>
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly) NSTimeInterval timestamp;
@property (nonatomic, readonly, copy) NSData * _Nonnull data;
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
- (nonnull instancetype)initWithData:(NSData * _Nonnull)data requestUrl:(NSURL * _Nonnull)requestUrl;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_LatencyApiDelegate")
@protocol _BMPLatencyApiDelegate
@property (nonatomic, readonly) NSTimeInterval latencyApi_currentLatency;
@end

SWIFT_CLASS_NAMED("_LegacyAssetDownloadTask")
@interface _BMPLegacyAssetDownloadTask : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
@property (nonatomic, readonly, copy) NSString * _Nonnull offlineContentRelativePath;
- (nonnull instancetype)initWithIdentifier:(NSString * _Nonnull)identifier offlineContentRelativePath:(NSString * _Nonnull)offlineContentRelativePath OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// This is a temporarily workaround for Obj-C usage of the <code>Source</code> as we use Swift only types in SourceInternal
SWIFT_PROTOCOL_NAMED("_LegacySourceInternal")
@protocol _BMPLegacySourceInternal <BMPSource>
@property (nonatomic, readonly) BOOL isActive;
@property (nonatomic, readonly, strong) AVURLAsset * _Nullable urlAsset;
@property (nonatomic, readonly, strong) _BMPAVPlayerItem * _Nullable playerItem;
/// Contains all already parsed embedded metadata
@property (nonatomic, readonly, copy) NSArray<BMPMetadata *> * _Nonnull embeddedMetadata;
/// Returns <code>true</code> if the source is a live stream
@property (nonatomic, readonly) BOOL isLive;
/// Returns <code>true</code> if the source has a <code>EXT-X-PROGRAM-DATE-TIME</code> tag in the manifest
@property (nonatomic, readonly) BOOL hasProgramDateTime;
/// List of available <code>AudioTrack</code>
@property (nonatomic, readonly, copy) NSArray<BMPAudioTrack *> * _Nonnull availableAudio;
/// Selected <code>AudioTrack</code>
@property (nonatomic, readonly, strong) BMPAudioTrack * _Nullable audio;
/// The upper bitrate boundary in bits per second for network bandwidth consumption of the currently
/// played source. Can be set to 0 for no limitation. The value set here is only valid for the currently
/// played source and will not be carried over to subsequently loaded sources.
/// Use <code>AdaptationConfig/maxSelectableBitrate</code> to set a value which is persistent for all
/// loaded sources of one <code>BitmovinPlayer</code> instance.
/// Default value is 0.
@property (nonatomic, readonly) NSTimeInterval maxTimeShift;
/// Desired limit of network bandwidth consumption for this source
@property (nonatomic) NSUInteger maxSelectableBitrate;
/// Returns the currently playing video frame rate in units of frames per second.
@property (nonatomic, readonly) float currentVideoFrameRate;
/// Returns an array containing all available video qualities the player can adapt between
@property (nonatomic, readonly, copy) NSArray<BMPVideoQuality *> * _Nonnull availableVideoQualities;
/// Returns the currently played video quality.
@property (nonatomic, readonly, strong) BMPVideoQuality * _Nullable videoPlaybackQuality;
/// Returns the currently downloading video quality.
@property (nonatomic, readonly, strong) BMPVideoQuality * _Nullable videoDownloadQuality;
/// Returns an array containing <code>SubtitleTrack</code> objects for all available subtitle tracks.
@property (nonatomic, readonly, copy) NSArray<BMPSubtitleTrack *> * _Nonnull availableSubtitles;
/// Returns the currently used <code>SubtitleTrack</code>.
@property (nonatomic, readonly, strong) BMPSubtitleTrack * _Nonnull subtitle;
/// The <code>Cue</code>s for the currently selected subtitle
@property (nonatomic, readonly, copy) NSArray<BMPCue *> * _Nonnull subtitleCues;
/// Adds a new external subtitle file. The <code>SubtitleTrack</code> is only added to the available tracks,
/// but is not set active. Use <code>Source/setSubtitleTrack(identifier:)</code> to active it.
/// If the identifier already exists, the existing <code>SubtitleTrack</code> is overwritten with the new one.
/// \param track The <code>SubtitleTrack</code> to be added to the available subtitles.
///
- (void)addSubtitleTrack:(BMPSubtitleTrack * _Nonnull)track;
/// Removes the existing <code>SubtitleTrack</code> with the track identifier specified by <code>Track/identifier</code>.
/// If the track is currently active, it will be deactivated and then removed.
/// If no <code>SubtitleTrack</code> with the given identifier exists, the call will be ignored.
/// The <code>SubtitleTrack</code> is removed from the available tracks, use <code>Source/setSubtitleTrack(identifier:nil)</code>
/// to disable an active <code>SubtitleTrack</code>.
/// \param identifier The identifier of the <code>SubtitleTrack</code> to be removed.
///
- (void)removeSubtitleTrackWithIdentifier:(NSString * _Nonnull)identifier;
/// Sets the subtitle track to the ID specified by <code>identifier</code>. A list can be retrieved by
/// calling <code>Source/availableSubtitles</code>.
/// Using nil as <code>identifier</code> disables subtitles.
/// \param identifier The identifier of the <code>SubtitleTrack</code> which should be set.
///
- (void)setSubtitleTrackWithIdentifier:(NSString * _Nullable)identifier;
/// Sets subtitle styles on the <code>AVPlayerItem</code>.
/// \param subtitleStyles The subtitle styles which should be set
///
- (void)setSubtitleStyles:(NSArray<AVTextStyleRule *> * _Nullable)subtitleStyles;
/// Set audio with identifier
/// \param identifier The <code>AudioTrack</code> identifier
///
- (void)setAudioWith:(NSString * _Nonnull)identifier;
/// Checks the possibility to play the media at specified playback speed.
/// \param playbackSpeed The playback speed to check.
///
- (BOOL)canApplyPlaybackSpeed:(float)playbackSpeed SWIFT_WARN_UNUSED_RESULT;
/// Clamp the provided playback speed if it’s needed.
/// \param playbackSpeed The playback speed to clamp.
///
- (float)clampPlaybackSpeedIfNeeded:(float)playbackSpeed SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_LoggerServiceFactory")
@interface _BMPLoggerServiceFactory : NSObject
- (id <_BMPObjCLoggerService> _Nonnull)createObjCForOffline SWIFT_WARN_UNUSED_RESULT;
- (id <_BMPObjCLoggerService> _Nonnull)createObjCForCastManager SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_M3U8ExtXSessionData")
@interface _M3U8ExtXSessionData : NSObject
@property (nonatomic, readonly, copy) NSString * _Nullable dataId;
@property (nonatomic, readonly, copy) NSString * _Nullable value;
@property (nonatomic, readonly, copy) NSURL * _Nullable URI;
@property (nonatomic, readonly, copy) NSString * _Nullable format;
@property (nonatomic, readonly, copy) NSString * _Nullable language;
- (nonnull instancetype)initWithAttributeDictionary:(NSDictionary<NSString *, id> * _Nonnull)attributeDictionary;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_M3U8ExtXSessionDataList")
@interface _M3U8ExtXSessionDataList : NSObject
- (void)addWithExtXSessionData:(_M3U8ExtXSessionData * _Nonnull)extXSessionData;
- (NSArray<_M3U8ExtXSessionData *> * _Nonnull)toArray SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_MediaInfoCustomData")
@interface _BMPMediaInfoCustomData : NSObject <_BMPJsonEncodable>
- (nonnull instancetype)initWithDrm:(_BMPCafDrmConfig * _Nullable)drm metadata:(NSDictionary<NSString *, NSString *> * _Nullable)metadata options:(_BMPCafSourceOptions * _Nonnull)options streamStartDate:(NSDate * _Nullable)streamStart OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class AVMediaSelectionGroup;
SWIFT_CLASS_NAMED("_MediaSelectionGroupStore")
@interface _BMPMediaSelectionGroupStore : NSObject
@property (nonatomic, readonly, strong) AVMediaSelectionGroup * _Nullable legibleGroup;
@property (nonatomic, readonly, strong) AVMediaSelectionGroup * _Nullable audioGroup;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_MetadataMessage")
@interface _BMPMetadataMessage : NSObject <_BMPJsonEncodable>
- (nonnull instancetype)initWithData:(NSDictionary * _Nonnull)data OBJC_DESIGNATED_INITIALIZER;
- (NSDictionary * _Nonnull)_toJsonData SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)_toJsonString:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_ObjCLoggerService")
@protocol _BMPObjCLoggerService
- (void)logWithLevel:(enum BMPLogLevel)level prefix:(NSString * _Nullable)prefix message:(NSString * _Nonnull)message code:(NSInteger)code data:(BMPDeficiencyData * _Nullable)data;
- (void)logWithLevel:(enum BMPLogLevel)level prefix:(NSString * _Nullable)prefix message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data;
- (void)logInternalWithLevel:(enum BMPLogLevel)level prefix:(NSString * _Nullable)prefix message:(NSString * _Nonnull)message code:(NSInteger)code data:(BMPDeficiencyData * _Nullable)data;
- (void)logInternalWithLevel:(enum BMPLogLevel)level prefix:(NSString * _Nullable)prefix message:(NSString * _Nonnull)message data:(BMPDeficiencyData * _Nullable)data;
- (void)logEvent:(id <BMPEvent> _Nonnull)event;
@end

SWIFT_PROTOCOL_NAMED("_ObjCOfflineInitializationService")
@protocol _BMPObjCOfflineInitializationService
/// We update the <code>SourceConfig</code> when the OCM is accessed through the OM
/// with the same identifier for convenience.
/// See <code>OfflineManager/offlineContentManager(for:)</code> for details
@property (nonatomic, strong) BMPSourceConfig * _Nonnull sourceConfig;
/// Creates an <code>AVURLAsset</code> using the URL from the provided <code>SourceConfig</code>.
- (AVURLAsset * _Nonnull)createRemoteAsset SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AVURLAsset</code> using the offline content url if present.
/// Returns <code>nil</code> if no offline content URL is present.
- (AVURLAsset * _Nullable)createLocalAsset SWIFT_WARN_UNUSED_RESULT;
/// Migrates the download URL to the provided URL.
/// See <code>OfflineContentManagerTweaksApi</code> for details
/// \param newUrl The new download URL for consecutive download interactions
///
- (void)migrateDownloadUrlTo:(NSURL * _Nonnull)newUrl;
@end

SWIFT_PROTOCOL_NAMED("_ObjCPlayerEventEmitter")
@protocol _BMPObjCPlayerEventEmitter <BMPPlayerEventHandler, _BMPService>
@property (nonatomic, readonly, strong) id <_BMPEventSuppressor> _Nonnull eventSuppressor;
- (void)emitPlayerEvent:(BMPPlayerEvent * _Nonnull)event;
@end

SWIFT_PROTOCOL_NAMED("_OfflineContentManagerTweaksApiDelegate")
@protocol _BMPOfflineContentManagerTweaksApiDelegate
- (void)offlineContentManagerTweaksApi_migrateDownloadWithRemoteAssetUrl:(NSURL * _Nonnull)remoteAssetUrl resourceIdentifierCallback:(NSString * _Nonnull (^ _Nonnull)(NSString * _Nonnull))resourceIdentifierCallback;
@end

SWIFT_PROTOCOL_NAMED("_OfflineContentUrlMigrationHandlerDelegate")
@protocol _BMPOfflineContentUrlMigrationHandlerDelegate
- (void)offlineContentUrlMigrationHandlerWillPerformContentMigration:(id <_BMPOfflineContentUrlMigrationHandler> _Nonnull)handler;
- (BOOL)offlineContentUrlMigrationHandler:(id <_BMPOfflineContentUrlMigrationHandler> _Nonnull)handler shouldCancelDownloadTask:(id <_BMPDownloadTask> _Nonnull)downloadTask SWIFT_WARN_UNUSED_RESULT;
- (void)offlineContentUrlMigrationHandler:(id <_BMPOfflineContentUrlMigrationHandler> _Nonnull)handler didCompleteMigrationFromUrl:(NSURL * _Nonnull)originalAssetUrl toUrl:(NSURL * _Nonnull)targetAssetUrl;
- (void)offlineContentUrlMigrationHandler:(id <_BMPOfflineContentUrlMigrationHandler> _Nonnull)handler didFailMigrationWithError:(NSError * _Nonnull)error;
@end

SWIFT_PROTOCOL_NAMED("_OfflineDownloadProgressService")
@protocol _BMPOfflineDownloadProgressService
@property (nonatomic, readonly) double lastKnownProgress;
- (void)didUpdateProgress:(double)progress ofMediaSelection:(AVMediaSelection * _Nonnull)mediaSelection forAsset:(AVURLAsset * _Nonnull)asset usingOfflineTrackSelection:(BMPOfflineTrackSelection * _Nullable)trackSelection completionHandler:(void (^ _Nonnull)(NSError * _Nullable))completionHandler;
- (void)didFinishDownloadingMediaSelection:(AVMediaSelection * _Nonnull)mediaSelection forAsset:(AVURLAsset * _Nonnull)asset usingOfflineTrackSelection:(BMPOfflineTrackSelection * _Nullable)trackSelection completionHandler:(void (^ _Nonnull)(NSError * _Nullable))completionHandler;
- (void)reset;
@end

SWIFT_PROTOCOL_NAMED("_OfflineDownloadStorageService")
@protocol _BMPOfflineDownloadStorageService
@property (nonatomic, readonly) NSInteger usedStorage;
- (BOOL)checkSystemFreeSpaceThresholdReached SWIFT_WARN_UNUSED_RESULT;
- (BOOL)deleteOfflineDataAndReturnError:(NSError * _Nullable * _Nullable)error;
@end

SWIFT_PROTOCOL_NAMED("_OfflineDrmService")
@protocol _BMPOfflineDrmService
@property (nonatomic, readonly) BOOL isRenewingLicense;
@property (nonatomic, readonly) BOOL isSynchingDrmInformation;
@property (nonatomic, readonly, strong) id <_BMPFairplayHandler> _Nullable fairPlayHandler;
- (void)renewLicenseWithSkdUri:(NSString * _Nonnull)skdUri;
- (void)syncLicenseWithSkdUri:(NSString * _Nonnull)skdUri;
- (void)reset;
@end

SWIFT_PROTOCOL_NAMED("_OfflineManagerStateProvider")
@protocol _BMPOfflineManagerStateProvider
@property (nonatomic, readonly) enum BMPOfflineState offlineState;
@end

SWIFT_CLASS_NAMED("_OfflineThumbnailHelper")
@interface _BMPOfflineThumbnailHelper : NSObject
- (nonnull instancetype)init;
/// Prepares an array of thumbnails for offline usage. For each thumbnail, it loads the local thumbnail image from
/// disk, encodes the content as base64 and creates a data URI which is set as the new url for the returned
/// thumbnail.
/// \param thumbnails The list of thumbnail objects to prepare for offline playback.
///
///
/// returns:
/// A list of thumbnail objects which can be used for offline playback.
- (NSArray<BMPThumbnail *> * _Nonnull)prepareThumbnailsForOfflineUsage:(NSArray<BMPThumbnail *> * _Nonnull)thumbnails SWIFT_WARN_UNUSED_RESULT;
/// Changes the original URLs of the provided thumbnails to point to the local thumbnail image stored on disk.
/// \param urls The dictionary containing the mapping from original URL strings to local URLs.
///
/// \param thumbnails The thumbnails whose URLs should be swapped.
///
///
/// returns:
/// An array containing thumbnails with their URLs set to the according local image URL.
- (NSArray<BMPThumbnail *> * _Nonnull)swapUrls:(NSDictionary<NSString *, NSURL *> * _Nonnull)urls for:(NSArray<BMPThumbnail *> * _Nonnull)thumbnails SWIFT_WARN_UNUSED_RESULT;
/// Returns a dictionary of distinct image URLs and their according local file URLs (relative to a given directory)
/// for a given array of thumbnails.
/// \param thumbnails The thumbnails to create local file URLs for.
///
/// \param offlineDirectory The offline thumbnails directory where the images will be stored.
///
///
/// returns:
/// A dictionary containing a mapping of distinct image URLs to their local equivalent.
- (NSDictionary<NSString *, NSURL *> * _Nonnull)distinctImageUrlsAndTheirLocalEquivalentFor:(NSArray<BMPThumbnail *> * _Nonnull)thumbnails offlineDirectory:(NSURL * _Nonnull)offlineDirectory SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_PlayerAdvertisingApi")
@interface _BMPPlayerAdvertisingApi : NSObject <BMPAdvertisingApi>
@property (nonatomic, weak) id <_BMPAdvertisingApiDelegate> _Nullable delegate;
@property (nonatomic, readonly, copy) NSArray<id <BMPAdBreak>> * _Nonnull schedule;
- (void)skip;
- (void)scheduleAdItem:(BMPAdItem * _Nonnull)adItem;
- (void)registerAdContainer:(UIView * _Nonnull)adContainer;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_PlayerBufferApi")
@interface _BMPPlayerBufferApi : NSObject
@property (nonatomic, weak) id <_BMPBufferApiDelegate> _Nullable delegate;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@interface _BMPPlayerBufferApi (SWIFT_EXTENSION(BitmovinPlayerCore)) <BMPBufferApi>
- (BMPBufferLevel * _Nonnull)getLevel:(BMPBufferType)type SWIFT_WARN_UNUSED_RESULT;
- (void)setTargetLevel:(NSTimeInterval)value;
@end

SWIFT_PROTOCOL_NAMED("_PlayerModule")
@protocol _BMPPlayerModule
@end

SWIFT_CLASS_NAMED("_PlayerModulesApi")
@interface _BMPPlayerModulesApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@protocol _BMPPlaylistApiDelegate;
SWIFT_CLASS_NAMED("_PlayerPlaylistApi")
@interface _BMPPlayerPlaylistApi : NSObject <BMPPlaylistApi>
@property (nonatomic, weak) id <_BMPPlaylistApiDelegate> _Nullable delegate;
@property (nonatomic, readonly, copy) NSArray<id <BMPSource>> * _Nonnull sources;
- (void)seekWithSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time;
- (void)addWithSource:(id <BMPSource> _Nonnull)source at:(NSInteger)index;
- (void)addWithSource:(id <BMPSource> _Nonnull)source;
- (void)removeWithSourceAt:(NSInteger)index;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("_PlaylistLoaderErrorTranslator")
@interface _BMPPlaylistLoaderErrorTranslator : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (_BMPError * _Nonnull)translateError:(NSError * _Nonnull)error SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_PlaylistLoaderRetryHandler")
@interface _BMPPlaylistLoaderRetryHandler : NSObject
@property (nonatomic, readonly, copy) void (^ _Nonnull retryHttpRequestHandler)(BMPHttpRequestType _Nonnull, NSInteger, BMPHttpResponse * _Nonnull, void (^ _Nonnull)(NSTimeInterval, BMPHttpRequest * _Nonnull), void (^ _Nonnull)(void));
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class _BMPRemotePlayerState;
SWIFT_CLASS_NAMED("_RemotePlayerStateEvent")
@interface _BMPRemotePlayerStateEvent : BMPPlayerEvent
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
@property (nonatomic, readonly, strong) _BMPRemotePlayerState * _Nonnull remotePlayerState;
- (nonnull instancetype)initWithRemotePlayerState:(_BMPRemotePlayerState * _Nonnull)remotePlayerState OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_RequestMetadata")
@interface _BMPRequestMetadata : NSObject
@property (nonatomic) BMPHttpRequestType _Nonnull downloadType;
@property (nonatomic, readonly, copy) NSURL * _Nonnull url;
@property (nonatomic, copy) NSURL * _Nullable redirectUrl;
@property (nonatomic) NSTimeInterval downloadTime;
@property (nonatomic) NSInteger httpStatus;
@property (nonatomic) NSInteger size;
@property (nonatomic) BOOL wasSuccessful;
@property (nonatomic, strong) BMPHttpResponse * _Nullable response;
@property (nonatomic, readonly) BOOL isLocalResource;
- (nonnull instancetype)initWithDownloadType:(BMPHttpRequestType _Nonnull)downloadType url:(NSURL * _Nonnull)url OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("_ResourceLoaderService")
@protocol _BMPResourceLoaderService
- (void)setupResourceLoadersWithSourceConfig:(BMPSourceConfig * _Nonnull)sourceConfig asset:(AVURLAsset * _Nonnull)asset;
- (void)renewExpiringFairplayLicenseFor:(BMPFairplayContentKeyRequest * _Nonnull)contentKeyRequest;
@end

enum _BMPScheduledAdItemStatus : NSInteger;
@protocol _BMPMutableAdBreak;
@protocol _BMPScheduledAdItemStatusListener;
SWIFT_CLASS_NAMED("_ScheduledAdItem")
@interface _BMPScheduledAdItem : NSObject
@property (nonatomic, readonly, strong) BMPAdItem * _Nonnull adItem;
/// Holds all received <code>_ImaAdLogEvent</code> from IMA
@property (nonatomic, readonly, copy) NSArray<_BMPImaAdLogEvent *> * _Nonnull eventLog;
@property (nonatomic, readonly) NSInteger waterfallingIndex;
@property (nonatomic) enum _BMPScheduledAdItemStatus currentStatus;
@property (nonatomic) BOOL vmapAdBreakReady;
@property (nonatomic) BOOL vmapAdBreakError;
@property (nonatomic) NSUInteger numberOfAdsInAdBreak;
@property (nonatomic) NSUInteger adIndexInAdBreak;
/// The order in which this ad item was scheduled. Used for sorting ad breaks having the same schedule time.
@property (nonatomic) NSInteger scheduleOrder;
@property (nonatomic, readonly) NSTimeInterval scheduleTimeOrNaN;
@property (nonatomic, readonly) NSTimeInterval mainContentDurationOrNaN;
@property (nonatomic, strong) id <_BMPMutableAdBreak> _Nullable adBreak;
@property (nonatomic, strong) id <BMPAdConfig> _Nullable adConfig;
@property (nonatomic, readonly, strong) BMPAdSource * _Nonnull currentAdSource;
- (nonnull instancetype)initWithAdItem:(BMPAdItem * _Nonnull)adItem;
- (void)addStatusListener:(id <_BMPScheduledAdItemStatusListener> _Nonnull)listener;
- (void)removeStatusListener:(id <_BMPScheduledAdItemStatusListener> _Nonnull)listener;
- (void)addEventLog:(_BMPImaAdLogEvent * _Nonnull)imaAdLogEvent;
- (void)notifyAdBreakMetadataChanged;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, _BMPScheduledAdItemStatus, "_ScheduledAdItemStatus", open) {
  _BMPScheduledAdItemStatusNotLoaded = 0,
  _BMPScheduledAdItemStatusLoading = 1,
  _BMPScheduledAdItemStatusLoaded = 2,
  _BMPScheduledAdItemStatusError = 3,
  _BMPScheduledAdItemStatusFinished = 4,
  _BMPScheduledAdItemStatusUnloaded = 5,
};

SWIFT_PROTOCOL_NAMED("_ScheduledAdItemStatusListener")
@protocol _BMPScheduledAdItemStatusListener
- (void)scheduledAdItem:(_BMPScheduledAdItem * _Nonnull)scheduledAdItem didChangeToNewStatus:(enum _BMPScheduledAdItemStatus)newStatus oldStatus:(enum _BMPScheduledAdItemStatus)oldStatus;
@end

SWIFT_PROTOCOL_NAMED("_SourceModule")
@protocol _BMPSourceModule
@end

SWIFT_CLASS_NAMED("_SourceModulesApi")
@interface _BMPSourceModulesApi : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// This service is responsible for handling the stalling state and stalling events
SWIFT_PROTOCOL_NAMED("_StallingService")
@protocol _BMPStallingService
/// Returns current stalling state, true if the player is currently in stalling state
@property (nonatomic, readonly) BOOL isStalling;
@end

SWIFT_PROTOCOL_NAMED("_ThumbnailsApiDelegate")
@protocol _BMPThumbnailsApiDelegate
@property (nonatomic, strong) UIView * _Nullable thumbnailsApi_container;
- (void)thumbnailsApi_cancelPendingRenderRequests;
- (BMPThumbnail * _Nullable)thumbnailsApi_thumbnailForTime:(NSTimeInterval)time SWIFT_WARN_UNUSED_RESULT;
- (void)thumbnailsApi_renderThumbnailForTime:(NSTimeInterval)time toleranceBefore:(NSTimeInterval)toleranceBefore toleranceAfter:(NSTimeInterval)toleranceAfter;
- (void)thumbnailsApi_renderThumbnailForSource:(id <BMPSource> _Nonnull)source time:(NSTimeInterval)time toleranceBefore:(NSTimeInterval)toleranceBefore toleranceAfter:(NSTimeInterval)toleranceAfter;
@end

SWIFT_CLASS_NAMED("_UIDeviceVersionHelper")
@interface _BMPUIDeviceVersionHelper : NSObject
- (nonnull instancetype)init;
- (BOOL)isSystemVersionGreaterThanOrEqual:(double)versionToCheck SWIFT_WARN_UNUSED_RESULT;
- (BOOL)isSystemVersionLessThan:(double)versionToCheck SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_CLASS_NAMED("_VttCue")
@interface _BMPVttCue : NSObject
/// The Index of the cue
@property (nonatomic, readonly) NSInteger index;
/// The start time of the cue
@property (nonatomic, readonly) NSTimeInterval start;
/// The end time of the cue
@property (nonatomic, readonly) NSTimeInterval end;
/// The formatted text content of the cue. Contains Bitmovin-specific attributes.
@property (nonatomic, readonly, strong) NSAttributedString * _Nonnull bitmovinAttributedText;
@property (nonatomic, readonly, strong) NSAttributedString * _Nonnull uiKitAttributedText;
/// The original raw text of the cue, as written in the caption file
@property (nonatomic, readonly, copy) NSString * _Nonnull rawText;
/// The settings - e.g. positioning information - of the cue.
@property (nonatomic, readonly, copy) NSString * _Nullable settings;
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)initWithIndex:(NSInteger)index start:(NSTimeInterval)start end:(NSTimeInterval)end bitmovinAttributedText:(NSAttributedString * _Nonnull)bitmovinAttributedText uiKitAttributedText:(NSAttributedString * _Nonnull)uiKitAttributedText rawText:(NSString * _Nonnull)rawText settings:(NSString * _Nullable)settings OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("_WebVttParser")
@interface _BMPWebVttParser : NSObject
- (nonnull instancetype)init;
- (NSArray<_BMPVttCue *> * _Nullable)parseFromContent:(NSString * _Nonnull)content error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
