//
// Bitmovin Player iOS SDK
// Copyright (C) 2018, Bitmovin GmbH, All Rights Reserved
//
// This source code and its use and distribution, is subject to the terms
// and conditions of the applicable license agreement.
//

#import <Foundation/Foundation.h>
@class _BMPError;

NS_ASSUME_NONNULL_BEGIN

NS_SWIFT_NAME(_ErrorFactory)
@interface _BMPErrorFactory : NSObject
- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;
+ (_BMPError *)createGeneralPlayerErrorWithMessage:(nullable NSString *)message;
+ (_BMPError *)createGeneralSourceDrmErrorWithMessage:(nullable NSString *)message;
+ (_BMPError *)createGeneralSourceDrmErrorWithError:(nullable NSError *)underlyingError;
+ (_BMPError *)createSourceDrmCertificateRequestFailedErrorWithError:(nullable NSError *)underlyingError NS_SWIFT_NAME(createSourceDrmCertificateRequestFailedError(underlyingError:));
+ (_BMPError *)createSourceDrmLicenseRequestFailedErrorWithError:(nullable NSError *)underlyingError NS_SWIFT_NAME(createSourceDrmLicenseRequestFailedError(underlyingError:));
+ (_BMPError *)createSourceDrmNoLicenseServerUrlProvidedError;
+ (_BMPError *)createSourceDrmNoCertificateServerUrlProvidedError;
+ (_BMPError *)createOfflineInsufficientStorageError;
+ (_BMPError *)createOfflineFailedPersistingContentKeyError;
+ (_BMPError *)createOfflineFailedPostProcessingError;
+ (_BMPError *)createUnsupportedSourceConfigForDownloadError;
+ (_BMPError *)createPlayerGeneralNetworkErrorWithMessage:(nullable NSString *)message;
+ (_BMPError *)createPlayerGeneralNetworkErrorWithError:(nullable NSError *)underlyingError;
+ (_BMPError *)createOfflineFailedContentUrlMigrationErrorWithMessage:(NSString *)message;
+ (_BMPError *)createOfflineFailedSourceConfigArtworkDataExtraction;
@end

NS_ASSUME_NONNULL_END
