//
// Bitmovin Player iOS SDK
// Copyright (C) 2017, Bitmovin GmbH, All Rights Reserved
//
// This source code and its use and distribution, is subject to the terms
// and conditions of the applicable license agreement.
//

#import <Foundation/Foundation.h>
#import <BitmovinPlayerCore/BMPPlayer.h>
#import "_BMPAdPlayer.h"

@class _BMPAdQuartileHandler;

NS_ASSUME_NONNULL_BEGIN

NS_SWIFT_NAME(_ProgressiveAdPlayer)
@interface _BMPProgressiveAdPlayer : NSObject <_BMPAdPlayer>
@property (nonatomic, weak) id<_BMPAdPlayerDelegate> delegate;
- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;
- (instancetype)initWithBitmovinAdPlayer:(id<BMPPlayer>)bitmovinAdPlayer loggerService:(id<_BMPObjCLoggerService>)loggerService;
- (instancetype)initWithBitmovinAdPlayer:(id<BMPPlayer>)bitmovinAdPlayer loggerService:(id<_BMPObjCLoggerService>)loggerService adQuartileHandler:(_BMPAdQuartileHandler *)adQuartileHandler NS_DESIGNATED_INITIALIZER;
@end

NS_ASSUME_NONNULL_END
