//
// Bitmovin Player iOS SDK
// Copyright (C) 2019, Bitmovin GmbH, All Rights Reserved
//
// This source code and its use and distribution, is subject to the terms
// and conditions of the applicable license agreement.
//

#include <BitmovinPlayerCore/BMPAdData.h>
#include <BitmovinPlayerCore/_BMPJsonEncodable.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * Defines basic properties available for every ad type
 */
NS_SWIFT_NAME(Ad)
@protocol BMPAd <NSObject, _BMPJsonEncodable>

/**
 * Determines whether an ad is linear, i.e. playback of main content needs to be paused for the ad.
 *
 * @return Whether an ad is linear, i.e. playback of main content needs to be paused for the ad.
 */
@property (nonatomic, readonly) BOOL isLinear;

/**
 * The width of the ad.
 *
 * @return The width of the ad.
 */
@property (nonatomic) NSInteger width;

/**
 * The height of the ad.
 *
 * @return The height of the ad.
 */
@property (nonatomic) NSInteger height;

/**
 * Identifier for the ad. This might be autogenerated.
 *
 * @return The identifier for the ad. This might be autogenerated.
 */
@property (nonatomic, nullable) NSString *identifier;

/**
 * The corresponding media file url for the ad.
 *
 * @return The corresponding media file url for the ad.
 */
@property (nonatomic, nullable) NSURL *mediaFileUrl;

/**
 * The url the user should be redirected to when clicking the ad.
 *
 * @return The url the user should be redirected to when clicking the ad.
 */
@property (nonatomic, nullable) NSURL *clickThroughUrl;

/**
 * Holds various additional ad data.
 *
 * @return Various additional AdData.
 * @see AdData
 */
@property (nonatomic, nullable) id<BMPAdData> data;

/**
 * Callback to track the opening of the `clickThroughUrl` in case a custom UI is used.
 * 
 * This is only supported when using `AdSourceType.bitmovin` for the related `AdSource`.
 * When our UIs are used, this will be handled automatically and should not be called manually.
 *
 * @return Callback to track the opening of the `clickThroughUrl`.
 */
@property (nonatomic, readonly, nullable) void (^clickThroughUrlOpened)(void);
@end

NS_ASSUME_NONNULL_END
