//
// Bitmovin Player iOS SDK
// Copyright (C) 2021, Bitmovin GmbH, All Rights Reserved
//
// This source code and its use and distribution, is subject to the terms
// and conditions of the applicable license agreement.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

FOUNDATION_EXPORT NSErrorDomain const BMPBitmovinSourceErrorDomain NS_SWIFT_NAME(BitmovinSourceErrorDomain);

/**
 * This enum represents the error codes that can be associated with ``BitmovinPlayerCore/SourceErrorEvent``.
 */
typedef NS_ERROR_ENUM(BMPBitmovinSourceErrorDomain, BMPSourceErrorCode) {
    /**
     * A general source error code when a more specific error code could not be determined.
     */
    BMPSourceErrorCodeGeneral = 2001,
    /**
     * Failed to start playing the source.
     */
    BMPSourceErrorCodePlaybackFailed = 2101,
    /**
     * Downloading the playlist has failed, but no additional details are available.
     */
    BMPSourceErrorCodeManifestDownloadFailed = 2202,
    /**
     * Downloading the playlist has failed due to an invalid manifest URL.
     */
    BMPSourceErrorCodeManifestUrlInvalid = 2205,
    /**
     * Downloading the playlist has failed due to an unhandled HTTP redirect (3xx).
     * The manifest request returned an 3xx HTTP status code which could not be handled.
     */
    BMPSourceErrorCodeManifestUnhandledRedirect = 2210,
    /**
     * Downloading the playlist has failed due to a client-side HTTP error (4xx).
     * The manifest request returned an 4xx HTTP status code which is not explicitly handled with a different
     * error code.
     */
    BMPSourceErrorCodeManifestClientError = 2220,
    /**
     * Downloading the playlist has failed due to a bad request.
     * Received HTTP status code 400 - Bad Request.
     */
    BMPSourceErrorCodeManifestBadRequest = 2221,
    /**
     * Downloading the playlist has failed due to missing or invalid authentication credentials.
     * Received HTTP status code 401 - Unauthorized.
     */
    BMPSourceErrorCodeManifestNotAuthorized = 2222,
    /**
     * Downloading the playlist has failed due to insufficient permissions.
     * Received HTTP status code 403 - Forbidden.
     */
    BMPSourceErrorCodeManifestNotAllowed = 2223,
    /**
     * Downloading the playlist has failed because the requested manifest could not be found.
     * Received HTTP status code 404 - Not Found.
     */
    BMPSourceErrorCodeManifestNotFound = 2224,
    /**
     * Downloading the playlist has failed due to a general server-side issue (5xx).
     * The manifest request returned an 5xx HTTP status code which is not explicitly handled with a different
     * error code.
     */
    BMPSourceErrorCodeManifestGeneralServerError = 2230,
    /**
     * Downloading the playlist has failed due to an internal server error.
     * Received HTTP status code 500 - Internal Server Error.
     */
    BMPSourceErrorCodeManifestServerError = 2231,
    /**
     * Downloading the playlist has failed due to a bad gateway error.
     * Received HTTP status code 502 - Bad Gateway.
     */
    BMPSourceErrorCodeManifestServerGatewayError = 2232,
    /**
     * downloading the playlist has failed because the server is temporarily unavailable.
     * Received HTTP status code 503 - Service Unavailable.
     */
    BMPSourceErrorCodeManifestServerUnavailable = 2233,
    /**
     * Downloading the playlist has failed due to a gateway timeout.
     * Received HTTP status code 504 - Gateway Timeout.
     */
    BMPSourceErrorCodeManifestServerGatewayTimeout = 2234,
    /**
     * A general error indicating that the current DRM session failed for some reason.
     * The message of the according ``BitmovinPlayerCore/SourceErrorEvent`` provides more information.
     */
    BMPSourceErrorCodeDrmGeneral = 2301,
    /**
     * The required DRM configuration is missing.
     */
    BMPSourceErrorCodeDrmConfigMissing = 2302,
    /**
     * No DRM license URL provided.
     */
    BMPSourceErrorCodeNoDrmLicenseServerUrlProvided = 2303,
    /**
     * No DRM certificate URL provided.
     */
    BMPSourceErrorCodeNoDrmCertificateServerUrlProvided = 2309,
    /**
     * The response to the DRM license request failed with an invalid HTTP response code.
     * The message of the according ``BitmovinPlayerCore/SourceErrorEvent`` provides more information.
     */
    BMPSourceErrorCodeDrmLicenseRequestFailed = 2306,
    /**
     * The response to the DRM certificate request failed with an invalid HTTP response code.
     * The message of the according ``BitmovinPlayerCore/SourceErrorEvent`` provides more information.
     */
    BMPSourceErrorCodeDrmCertificateRequestFailed = 2307
} NS_SWIFT_NAME(SourceError);

NS_ASSUME_NONNULL_END
